#include "sys_config.h"
#include "typesdef.h"

#if JPG_EN

#ifndef DQT_NUM
#define DQT_NUM   12
#endif

const uint16  htable[] __attribute__ ((aligned(4))) ={
#if 1
	0x100,0x101,0x204,0x30b,0x41a,0x678,0x7f8,0x9f6, 
	0xf82,0xf83,0x30c,0x41b,0x679,0x8f6,0xaf6,0xf84, 
	0xf85,0xf86,0xf87,0xf88,0x41c,0x7f9,0x9f7,0xbf4, 
	0xf89,0xf8a,0xf8b,0xf8c,0xf8d,0xf8e,0x53a,0x8f7, 
	0xbf5,0xf8f,0xf90,0xf91,0xf92,0xf93,0xf94,0xf95, 
	0x53b,0x9f8,0xf96,0xf97,0xf98,0xf99,0xf9a,0xf9b, 
	0xf9c,0xf9d,0x67a,0xaf7,0xf9e,0xf9f,0xfa0,0xfa1, 
	0xfa2,0xfa3,0xfa4,0xfa5,0x67b,0xbf6,0xfa6,0xfa7, 
	0xfa8,0xfa9,0xfaa,0xfab,0xfac,0xfad,0x7fa,0xbf7, 
	0xfae,0xfaf,0xfb0,0xfb1,0xfb2,0xfb3,0xfb4,0xfb5, 
	0x8f8,0xec0,0xfb6,0xfb7,0xfb8,0xfb9,0xfba,0xfbb, 
	0xfbc,0xfbd,0x8f9,0xfbe,0xfbf,0xfc0,0xfc1,0xfc2, 
	0xfc3,0xfc4,0xfc5,0xfc6,0x8fa,0xfc7,0xfc8,0xfc9, 
	0xfca,0xfcb,0xfcc,0xfcd,0xfce,0xfcf,0x9f9,0xfd0, 
	0xfd1,0xfd2,0xfd3,0xfd4,0xfd5,0xfd6,0xfd7,0xfd8, 
	0x9fa,0xfd9,0xfda,0xfdb,0xfdc,0xfdd,0xfde,0xfdf, 
	0xfe0,0xfe1,0xaf8,0xfe2,0xfe3,0xfe4,0xfe5,0xfe6, 
	0xfe7,0xfe8,0xfe9,0xfea,0xfeb,0xfec,0xfed,0xfee, 
	0xfef,0xff0,0xff1,0xff2,0xff3,0xff4,0xff5,0xff6, 
	0xff7,0xff8,0xff9,0xffa,0xffb,0xffc,0xffd,0xffe, 
	0x30a,0xaf9,0xfff,0xfff,0xfff,0xfff,0xfff,0xfff, 
	0xfd0,0xfd1,0xfd2,0xfd3,0xfd4,0xfd5,0xfd6,0xfd7, 
	0x101,0x204,0x30a,0x418,0x419,0x538,0x678,0x8f4, 
	0x9f6,0xbf4,0x30b,0x539,0x7f6,0x8f5,0xaf6,0xbf5, 
	0xf88,0xf89,0xf8a,0xf8b,0x41a,0x7f7,0x9f7,0xbf6, 
	0xec2,0xf8c,0xf8d,0xf8e,0xf8f,0xf90,0x41b,0x7f8, 
	0x9f8,0xbf7,0xf91,0xf92,0xf93,0xf94,0xf95,0xf96, 
	0x53a,0x8f6,0xf97,0xf98,0xf99,0xf9a,0xf9b,0xf9c, 
	0xf9d,0xf9e,0x53b,0x9f9,0xf9f,0xfa0,0xfa1,0xfa2, 
	0xfa3,0xfa4,0xfa5,0xfa6,0x679,0xaf7,0xfa7,0xfa8, 
	0xfa9,0xfaa,0xfab,0xfac,0xfad,0xfae,0x67a,0xaf8, 
	0xfaf,0xfb0,0xfb1,0xfb2,0xfb3,0xfb4,0xfb5,0xfb6, 
	0x7f9,0xfb7,0xfb8,0xfb9,0xfba,0xfbb,0xfbc,0xfbd, 
	0xfbe,0xfbf,0x8f7,0xfc0,0xfc1,0xfc2,0xfc3,0xfc4, 
	0xfc5,0xfc6,0xfc7,0xfc8,0x8f8,0xfc9,0xfca,0xfcb, 
	0xfcc,0xfcd,0xfce,0xfcf,0xfd0,0xfd1,0x8f9,0xfd2, 
	0xfd3,0xfd4,0xfd5,0xfd6,0xfd7,0xfd8,0xfd9,0xfda, 
	0x8fa,0xfdb,0xfdc,0xfdd,0xfde,0xfdf,0xfe0,0xfe1, 
	0xfe2,0xfe3,0xaf9,0xfe4,0xfe5,0xfe6,0xfe7,0xfe8, 
	0xfe9,0xfea,0xfeb,0xfec,0xde0,0xfed,0xfee,0xfef, 
	0xff0,0xff1,0xff2,0xff3,0xff4,0xff5,0xec3,0xff6, 
	0xff7,0xff8,0xff9,0xffa,0xffb,0xffc,0xffd,0xffe, 
	0x100,0x9fa,0xfff,0xfff,0xfff,0xfff,0xfff,0xfff, 
	0xfd0,0xfd1,0xfd2,0xfd3,0xfd4,0xfd5,0xfd6,0xfd7, 
	0x100,0x202,0x203,0x204,0x205,0x206,0x30e,0x41e, 
	0x53e,0x67e,0x7fe,0x8fe,0xfff,0xfff,0xfff,0xfff, 
	0x100,0x101,0x102,0x206,0x30e,0x41e,0x53e,0x67e, 
	0x7fe,0x8fe,0x9fe,0xafe,0xfff,0xfff,0xfff,0xfff, 
#else	
	0x0001,0x0101,0x0402,0x0b03,0x1a04,0x7806,0xf807,0xf609, 
	0x820f,0x830f,0x0c03,0x1b04,0x7906,0xf608,0xf60a,0x840f, 
	0x850f,0x860f,0x870f,0x880f,0x1c04,0xf907,0xf709,0xf40b, 
	0x890f,0x8a0f,0x8b0f,0x8c0f,0x8d0f,0x8e0f,0x3a05,0xf708, 
	0xf50b,0x8f0f,0x900f,0x910f,0x920f,0x930f,0x940f,0x950f, 
	0x3b05,0xf809,0x960f,0x970f,0x980f,0x990f,0x9a0f,0x9b0f, 
	0x9c0f,0x9d0f,0x7a06,0xf70a,0x9e0f,0x9f0f,0xa00f,0xa10f, 
	0xa20f,0xa30f,0xa40f,0xa50f,0x7b06,0xf60b,0xa60f,0xa70f, 
	0xa80f,0xa90f,0xaa0f,0xab0f,0xac0f,0xad0f,0xfa07,0xf70b, 
	0xae0f,0xaf0f,0xb00f,0xb10f,0xb20f,0xb30f,0xb40f,0xb50f, 
	0xf808,0xc00e,0xb60f,0xb70f,0xb80f,0xb90f,0xba0f,0xbb0f, 
	0xbc0f,0xbd0f,0xf908,0xbe0f,0xbf0f,0xc00f,0xc10f,0xc20f, 
	0xc30f,0xc40f,0xc50f,0xc60f,0xfa08,0xc70f,0xc80f,0xc90f, 
	0xca0f,0xcb0f,0xcc0f,0xcd0f,0xce0f,0xcf0f,0xf909,0xd00f, 
	0xd10f,0xd20f,0xd30f,0xd40f,0xd50f,0xd60f,0xd70f,0xd80f, 
	0xfa09,0xd90f,0xda0f,0xdb0f,0xdc0f,0xdd0f,0xde0f,0xdf0f, 
	0xe00f,0xe10f,0xf80a,0xe20f,0xe30f,0xe40f,0xe50f,0xe60f, 
	0xe70f,0xe80f,0xe90f,0xea0f,0xeb0f,0xec0f,0xed0f,0xee0f, 
	0xef0f,0xf00f,0xf10f,0xf20f,0xf30f,0xf40f,0xf50f,0xf60f, 
	0xf70f,0xf80f,0xf90f,0xfa0f,0xfb0f,0xfc0f,0xfd0f,0xfe0f, 
	0x0a03,0xf90a,0xff0f,0xff0f,0xff0f,0xff0f,0xff0f,0xff0f, 
	0xd00f,0xd10f,0xd20f,0xd30f,0xd40f,0xd50f,0xd60f,0xd70f, 
	0x0101,0x0402,0x0a03,0x1804,0x1904,0x3805,0x7806,0xf408, 
	0xf609,0xf40b,0x0b03,0x3905,0xf607,0xf508,0xf60a,0xf50b, 
	0x880f,0x890f,0x8a0f,0x8b0f,0x1a04,0xf707,0xf709,0xf60b, 
	0xc20e,0x8c0f,0x8d0f,0x8e0f,0x8f0f,0x900f,0x1b04,0xf807, 
	0xf809,0xf70b,0x910f,0x920f,0x930f,0x940f,0x950f,0x960f, 
	0x3a05,0xf608,0x970f,0x980f,0x990f,0x9a0f,0x9b0f,0x9c0f, 
	0x9d0f,0x9e0f,0x3b05,0xf909,0x9f0f,0xa00f,0xa10f,0xa20f, 
	0xa30f,0xa40f,0xa50f,0xa60f,0x7906,0xf70a,0xa70f,0xa80f, 
	0xa90f,0xaa0f,0xab0f,0xac0f,0xad0f,0xae0f,0x7a06,0xf80a, 
	0xaf0f,0xb00f,0xb10f,0xb20f,0xb30f,0xb40f,0xb50f,0xb60f, 
	0xf907,0xb70f,0xb80f,0xb90f,0xba0f,0xbb0f,0xbc0f,0xbd0f, 
	0xbe0f,0xbf0f,0xf708,0xc00f,0xc10f,0xc20f,0xc30f,0xc40f, 
	0xc50f,0xc60f,0xc70f,0xc80f,0xf808,0xc90f,0xca0f,0xcb0f, 
	0xcc0f,0xcd0f,0xce0f,0xcf0f,0xd00f,0xd10f,0xf908,0xd20f, 
	0xd30f,0xd40f,0xd50f,0xd60f,0xd70f,0xd80f,0xd90f,0xda0f, 
	0xfa08,0xdb0f,0xdc0f,0xdd0f,0xde0f,0xdf0f,0xe00f,0xe10f, 
	0xe20f,0xe30f,0xf90a,0xe40f,0xe50f,0xe60f,0xe70f,0xe80f, 
	0xe90f,0xea0f,0xeb0f,0xec0f,0xe00d,0xed0f,0xee0f,0xef0f, 
	0xf00f,0xf10f,0xf20f,0xf30f,0xf40f,0xf50f,0xc30e,0xf60f, 
	0xf70f,0xf80f,0xf90f,0xfa0f,0xfb0f,0xfc0f,0xfd0f,0xfe0f, 
	0x0001,0xfa09,0xff0f,0xff0f,0xff0f,0xff0f,0xff0f,0xff0f, 
	0xd00f,0xd10f,0xd20f,0xd30f,0xd40f,0xd50f,0xd60f,0xd70f, 
	0x0001,0x0202,0x0302,0x0402,0x0502,0x0602,0x0e03,0x1e04, 
	0x3e05,0x7e06,0xfe07,0xfe08,0xff0f,0xff0f,0xff0f,0xff0f, 
	0x0001,0x0101,0x0201,0x0602,0x0e03,0x1e04,0x3e05,0x7e06, 
	0xfe07,0xfe08,0xfe09,0xfe0a,0xff0f,0xff0f,0xff0f,0xff0f, 

#endif
};


const uint8  dhtable[] __attribute__ ((aligned(4)))={
	0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01,  
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,  
	0x08, 0x09, 0x0a, 0x0b, 0x00, 0x02, 0x01, 0x03,  
	0x03, 0x02, 0x04, 0x03, 0x05, 0x05, 0x04, 0x04,  
	0x00, 0x00, 0x01, 0x7d, 0x01, 0x02, 0x03, 0x00,  
	0x04, 0x11, 0x05, 0x12, 0x21, 0x31, 0x41, 0x06,  
	0x13, 0x51, 0x61, 0x07, 0x22, 0x71, 0x14, 0x32,  
	0x81, 0x91, 0xa1, 0x08, 0x23, 0x42, 0xb1, 0xc1,  
	0x15, 0x52, 0xd1, 0xf0, 0x24, 0x33, 0x62, 0x72,  
	0x82, 0x09, 0x0a, 0x16, 0x17, 0x18, 0x19, 0x1a,  
	0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x34, 0x35,  
	0x36, 0x37, 0x38, 0x39, 0x3a, 0x43, 0x44, 0x45,  
	0x46, 0x47, 0x48, 0x49, 0x4a, 0x53, 0x54, 0x55,  
	0x56, 0x57, 0x58, 0x59, 0x5a, 0x63, 0x64, 0x65,  
	0x66, 0x67, 0x68, 0x69, 0x6a, 0x73, 0x74, 0x75,  
	0x76, 0x77, 0x78, 0x79, 0x7a, 0x83, 0x84, 0x85,  
	0x86, 0x87, 0x88, 0x89, 0x8a, 0x92, 0x93, 0x94,  
	0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3,  
	0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2,  
	0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba,  
	0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9,  
	0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8,  
	0xd9, 0xda, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6,  
	0xe7, 0xe8, 0xe9, 0xea, 0xf1, 0xf2, 0xf3, 0xf4,  
	0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0x00, 0x03,  
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,  
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,  
	0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,  
	0x0a, 0x0b, 0x00, 0x02, 0x01, 0x02, 0x04, 0x04,  
	0x03, 0x04, 0x07, 0x05, 0x04, 0x04, 0x00, 0x01,  
	0x02, 0x77, 0x00, 0x01, 0x02, 0x03, 0x11, 0x04,  
	0x05, 0x21, 0x31, 0x06, 0x12, 0x41, 0x51, 0x07,  
	0x61, 0x71, 0x13, 0x22, 0x32, 0x81, 0x08, 0x14,  
	0x42, 0x91, 0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33,  
	0x52, 0xf0, 0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16,  
	0x24, 0x34, 0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19,  
	0x1a, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x35, 0x36,  
	0x37, 0x38, 0x39, 0x3a, 0x43, 0x44, 0x45, 0x46,  
	0x47, 0x48, 0x49, 0x4a, 0x53, 0x54, 0x55, 0x56,  
	0x57, 0x58, 0x59, 0x5a, 0x63, 0x64, 0x65, 0x66,  
	0x67, 0x68, 0x69, 0x6a, 0x73, 0x74, 0x75, 0x76,  
	0x77, 0x78, 0x79, 0x7a, 0x82, 0x83, 0x84, 0x85,  
	0x86, 0x87, 0x88, 0x89, 0x8a, 0x92, 0x93, 0x94,  
	0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3,  
	0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2,  
	0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba,  
	0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9,  
	0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8,  
	0xd9, 0xda, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,  
	0xe8, 0xe9, 0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6,  
	0xf7, 0xf8, 0xf9, 0xfa, 

};



const char quality_tab[DQT_NUM][128] __attribute__ ((aligned(4))) = {
	{
		13,  9,   8,   13,  20,  33,  42,  51,
		9,   9,   12,  15,  21,  48,  50,  45,
		12,  10,  13,  20,  33,  47,  57,  46,
		12,  14,  18,  24,  42,  72,  66,  51,
		15,  18,  30,  46,  56,  90,  85,  63,
		20,  29,  45,  53,  67,  86,  93,  76,
		40,  53,  65,  72,  85,  100, 99,  84,
		60,  76,  78,  81,  93,  83,  85,  82,
		14,  15,  20,  39,  82,  82,  82,  82,
		15,  17,  21,  54,  82,  82,  82,  82,
		20,  21,  46,  82,  82,  82,  82,  82,
		39,  54,  82,  82,  82,  82,  82,  82,
		82,  82,  82,  82,  82,  82,  82,  82,
		82,  82,  82,  82,  82,  82,  82,  82,
		82,  82,  82,  82,  82,  82,  82,  82,
		82,  82,  82,  82,  82,  82,  82,  82
	},

	{
		//Quantizaton table 0(luminance table)	addr=0x20000  len=64  default:QT45	   
		18,  12,  11,  18,	27,  44,  57,  68,
		13,  13,  16,  21,	29,  64,  67,  61,
		16,  14,  18,  27,	44,  63,  77,  62,
		16,  19,  24,  32,	57,  97,  89,  69,
		20,  24,  41,  62,	75, 121, 114,  85,
		27,  39,  61,  71,	90, 115, 125, 102,
		54,  71,  87,  97, 114, 134, 133, 112,
		80, 102, 105, 109, 124, 111, 114, 110,
		//Quantizaton table 1 (chrominance table)  addr=0x20040  len = 64  default:QT45 	   
		19,  20,  27,	52, 110, 110, 110, 110,
		20,  23,  29,	73, 110, 110, 110, 110,
		27,  29,  62, 110, 110, 110, 110, 110,
		52,  73, 110, 110, 110, 110, 110, 110,
	   110, 110, 110, 110, 110, 110, 110, 110,
	   110, 110, 110, 110, 110, 110, 110, 110,
	   110, 110, 110, 110, 110, 110, 110, 110,
	   110, 110, 110, 110, 110, 110, 110, 110
	},

	{
		 20,  14,  13,	20,  30,  50,  64,	76,
		 15,  15,  18,	24,  33,  73,  75,	69,
		 18,  16,  20,	30,  50,  71,  86,	70,
		 18,  21,  28,	36,  64, 109, 100,	78,
		 23,  28,  46,	70,  85, 136, 129,	96,
		 30,  44,  69,	80, 101, 130, 141, 115,
		 61,  80,  98, 109, 129, 151, 150, 126,
		 90, 115, 119, 123, 140, 125, 129, 124,
		 21,  23,  30,	59, 124, 124, 124, 124,
		 23,  26,  33,	83, 124, 124, 124, 124,
		 30,  33,  70, 124, 124, 124, 124, 124,
		 59,  83, 124, 124, 124, 124, 124, 124,
		124, 124, 124, 124, 124, 124, 124, 124,
		124, 124, 124, 124, 124, 124, 124, 124,
		124, 124, 124, 124, 124, 124, 124, 124,
		124, 124, 124, 124, 124, 124, 124, 124
	},
	
	{
	  23,  16,	14,  23,  34,  57,	72,  87,
	  17,  17,	20,  27,  37,  82,	85,  78,
	  20,  18,	23,  34,  57,  81,	98,  80,
	  20,  24,	31,  41,  72, 124, 114,  88,
	  26,  31,	53,  80,  97, 155, 146, 109,
	  34,  50,	78,  91, 115, 148, 160, 131,
	  70,  91, 111, 124, 146, 172, 170, 143,
	 102, 131, 135, 139, 159, 142, 146, 141,
	   24,	26,  34,  67, 141, 141, 141, 141,
	   26,	30,  37,  94, 141, 141, 141, 141,
	   34,	37,  80, 141, 141, 141, 141, 141,
	   67,	94, 141, 141, 141, 141, 141, 141,
	  141, 141, 141, 141, 141, 141, 141, 141,
	  141, 141, 141, 141, 141, 141, 141, 141,
	  141, 141, 141, 141, 141, 141, 141, 141,
	  141, 141, 141, 141, 141, 141, 141, 141
	},
	{
	   27,	18,  17,  27,  40,	66,  85, 101,
	   20,	20,  23,  32,  43,	96, 100,  91,
	   23,	22,  27,  40,  66,	95, 115,  93,
	   23,	28,  37,  48,  85, 144, 133, 103,
	   30,	37,  61,  93, 113, 181, 171, 128,
	   40,	58,  91, 106, 134, 173, 188, 153,
	   81, 106, 129, 144, 171, 201, 199, 168,
	  120, 153, 158, 163, 186, 166, 171, 164,
	   28,	30,   40,  78, 164, 164, 164, 164,
	   30,	35,   43, 110, 164, 164, 164, 164,
	   40,	43,   93, 164, 164, 164, 164, 164,
	   78, 110, 164, 164, 164, 164, 164, 164,
	  164, 164, 164, 164, 164, 164, 164, 164,
	  164, 164, 164, 164, 164, 164, 164, 164,
	  164, 164, 164, 164, 164, 164, 164, 164,
	  164, 164, 164, 164, 164, 164, 164, 164
	},
	{
		32,  22,  20,  32,	48,  80, 102, 122,
		24,  24,  28,  38,	52, 116, 120, 110,
		28,  26,  32,  48,	80, 114, 138, 112,
		28,  34,  44,  58, 102, 174, 160, 124,
		36,  44,  74, 112, 136, 218, 206, 154,
		48,  70, 110, 128, 162, 208, 226, 184,
		98, 128, 156, 174, 206, 242, 240, 202,
	   144, 184, 190, 196, 224, 200, 206, 198,
		34,  36,  48,  94, 198, 198, 198, 198,
		36,  42,  52, 132, 198, 198, 198, 198,
		48,  52, 112, 198, 198, 198, 198, 198,
		94, 132, 198, 198, 198, 198, 198, 198,
	   198, 198, 198, 198, 198, 198, 198, 198,
	   198, 198, 198, 198, 198, 198, 198, 198,
	   198, 198, 198, 198, 198, 198, 198, 198,
	   198, 198, 198, 198, 198, 198, 198, 198
	},
	{
		39,  26,  24,  39,  58,  97, 124, 148,
		29,  29,  34,  46,  63, 141, 146, 134,
		34,  31,  39,  58,  97, 138, 168, 136,
		34,  41,  53,  70, 124, 212, 195, 151,
		43,  53,  90, 136, 165, 255, 251, 187,
		58,  85, 134, 156, 197, 253, 255, 224,
	   119, 156, 190, 212, 251, 255, 255, 246,
	   175, 224, 231, 238, 225, 243, 251, 241,
	   	41,  43,  58, 114, 241, 241, 241, 241,
		43,  51,  63, 160, 241, 241, 241, 241,
		58,  63, 136, 241, 241, 241, 241, 241,
	   114, 160, 241, 241, 241, 241, 241, 241,
	   241, 241, 241, 241, 241, 241, 241, 241,
	   241, 241, 241, 241, 241, 241, 241, 241,
	   241, 241, 241, 241, 241, 241, 241, 241,
	   241, 241, 241, 241, 241, 241, 241, 241
	},
	{
		47,  31,  29,  47,  70, 118, 151, 180,
		35,  35,  41,  56,  76, 171, 177, 163,
		41,  37,  47,  70, 118, 168, 204, 165,
		41,  49,  64,  85, 151, 255, 237, 184,
		52,  64, 109, 165, 201, 255, 255, 227,
		70, 103, 163, 190, 240, 255, 255, 255,
	   145, 190, 231, 255, 255, 255, 255, 255,
	   213, 255, 255, 255, 255, 255, 255, 255,
	    49,  52,  70, 138, 255, 255, 255, 255,
		52,  62,  76, 195, 255, 255, 255, 255,
		70,  76, 165, 255, 255, 255, 255, 255,
	   138, 195, 255, 255, 255, 255, 255, 255,
	   255, 255, 255, 255, 255, 255, 255, 255,
	   255, 255, 255, 255, 255, 255, 255, 255,
	   255, 255, 255, 255, 255, 255, 255, 255,
	   255, 255, 255, 255, 255, 255, 255, 255
	},

	{
		57,  37,  35,  57,  85,  143, 184, 219,
		42,  42,  49,  68,  92,  208, 215, 198,
		49,  45,  57,  85,  143, 204, 248, 201,
		49,  59,  78,  103, 184, 255, 255, 224,
		63,  78,  132, 201, 244, 255, 255, 255,
		85,  125, 198, 231, 255, 255, 255, 255,
		176, 231, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		59,  63,  85,  168, 255, 255, 255, 255,
		63,  75,  92,  237, 255, 255, 255, 255,
		85,  92,  201, 255, 255, 255, 255, 255,
		168, 237, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255
	},

	{
		69,  45,  42,  69,  103, 174, 224, 255,
		51,  51,  59,  82,  112, 253, 255, 241,
		59,  54,  69,  103, 174, 248, 255, 244,
		59,  71,  95,  125, 224, 255, 255, 255,
		76,  95,  160, 244, 255, 255, 255, 255,
		103, 152, 241, 255, 255, 255, 255, 255,
		214, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		71,  76,  103, 204, 255, 255, 255, 255,
		76,  91,  112, 255, 255, 255, 255, 255,
		103, 112, 244, 255, 255, 255, 255, 255,
		204, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255
	},

	{
		84,  54,  51,  84,  125, 212, 255, 255,
		62,  62,  71,  99,  136, 255, 255, 255,
		71,  65,  84,  125, 212, 255, 255, 255,
		71,  86,  115, 152, 255, 255, 255, 255,
		92,  115, 195, 255, 255, 255, 255, 255,
		125, 185, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		86,  92,  125, 248, 255, 255, 255, 255,
		92,  110, 136, 255, 255, 255, 255, 255,
		125, 136, 255, 255, 255, 255, 255, 255,
		248, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255		
	},

	{
		102, 65,  62,  102, 152, 255, 255, 255,
		75,  75,  86,  120, 165, 255, 255, 255,
		86,  79,  102, 152, 255, 255, 255, 255,
		86,  104, 140, 185, 255, 255, 255, 255,
		112, 140, 237, 255, 255, 255, 255, 255,
		152, 225, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		104, 112, 152, 255, 255, 255, 255, 255,
		112, 134, 165, 255, 255, 255, 255, 255,
		152, 165, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255,
		255, 255, 255, 255, 255, 255, 255, 255
	}
};


#if 0
char quality0[128] __attribute__ ((aligned(4)))= {
	0x08, 0x06, 0x06, 0x07, 0x06, 0x05, 0x08, 0x07, 
	0x07, 0x07, 0x09, 0x09, 0x08, 0x0A, 0x0C, 0x14, 
	0x0D, 0x0C, 0x0B, 0x0B, 0x0C, 0x19, 0x12, 0x13, 
	0x0F, 0x14, 0x1D, 0x1A, 0x1F, 0x1E, 0x1D, 0x1A, 
	0x1C, 0x1C, 0x20, 0x24, 0x2E, 0x27, 0x20, 0x22,
	0x2C, 0x23, 0x1C, 0x1C, 0x28, 0x37, 0x29, 0x2C, 
	0x30, 0x31, 0x34, 0x34, 0x34, 0x1F, 0x27, 0x39, 
	0x3D, 0x38, 0x32, 0x3C, 0x2E, 0x33, 0x34, 0x32, 
	0x09, 0x09, 0x09, 0x0C, 0x0B, 0x0C, 0x18, 0x0D, 
	0x0D, 0x18, 0x32, 0x21, 0x1C, 0x21, 0x32, 0x32, 
	0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 
	0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 
	0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 
	0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 
	0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 
	0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
};


/*QT45*/
char quality1[128] __attribute__ ((aligned(4)))= {
	//Quantizaton table 0(luminance table)	addr=0x20000  len=64  default:QT45	   
	18,  12,  11,  18,	27,  44,  57,  68,
	13,  13,  16,  21,	29,  64,  67,  61,
	16,  14,  18,  27,	44,  63,  77,  62,
	16,  19,  24,  32,	57,  97,  89,  69,
	20,  24,  41,  62,	75, 121, 114,  85,
	27,  39,  61,  71,	90, 115, 125, 102,
	54,  71,  87,  97, 114, 134, 133, 112,
	80, 102, 105, 109, 124, 111, 114, 110,
	//Quantizaton table 1 (chrominance table)  addr=0x20040  len = 64  default:QT45 	   
	19,  20,  27,	52, 110, 110, 110, 110,
	20,  23,  29,	73, 110, 110, 110, 110,
	27,  29,  62, 110, 110, 110, 110, 110,
	52,  73, 110, 110, 110, 110, 110, 110,
   110, 110, 110, 110, 110, 110, 110, 110,
   110, 110, 110, 110, 110, 110, 110, 110,
   110, 110, 110, 110, 110, 110, 110, 110,
   110, 110, 110, 110, 110, 110, 110, 110,
};

/*QT40*/
char quality2[128] __attribute__ ((aligned(4)))= {
	 20,  14,  13,  20,  30,  50,  64,  76,
	 15,  15,  18,  24,  33,  73,  75,  69,
	 18,  16,  20,  30,  50,  71,  86,  70,
	 18,  21,  28,  36,  64, 109, 100,  78,
	 23,  28,  46,  70,  85, 136, 129,  96,
	 30,  44,  69,  80, 101, 130, 141, 115,
	 61,  80,  98, 109, 129, 151, 150, 126,
	 90, 115, 119, 123, 140, 125, 129, 124,
	 21,  23,  30,	59, 124, 124, 124, 124,
	 23,  26,  33,	83, 124, 124, 124, 124,
	 30,  33,  70, 124, 124, 124, 124, 124,
	 59,  83, 124, 124, 124, 124, 124, 124,
	124, 124, 124, 124, 124, 124, 124, 124,
	124, 124, 124, 124, 124, 124, 124, 124,
	124, 124, 124, 124, 124, 124, 124, 124,
	124, 124, 124, 124, 124, 124, 124, 124,
};

/*QT35*/
char quality3[128] __attribute__ ((aligned(4)))= {
	 23,  16,  14,	23,  34,  57,  72,	87,
	 17,  17,  20,	27,  37,  82,  85,	78,
	 20,  18,  23,	34,  57,  81,  98,	80,
	 20,  24,  31,	41,  72, 124, 114,	88,
	 26,  31,  53,	80,  97, 155, 146, 109,
	 34,  50,  78,	91, 115, 148, 160, 131,
	 70,  91, 111, 124, 146, 172, 170, 143,
	102, 131, 135, 139, 159, 142, 146, 141,
	  24,  26,	34,  67, 141, 141, 141, 141,
	  26,  30,	37,  94, 141, 141, 141, 141,
	  34,  37,	80, 141, 141, 141, 141, 141,
	  67,  94, 141, 141, 141, 141, 141, 141,
	 141, 141, 141, 141, 141, 141, 141, 141,
	 141, 141, 141, 141, 141, 141, 141, 141,
	 141, 141, 141, 141, 141, 141, 141, 141,
	 141, 141, 141, 141, 141, 141, 141, 141,

};

/*QT30*/
char quality4[128] __attribute__ ((aligned(4)))= {
	 27,  18,  17,	27,  40,  66,  85, 101,
	 20,  20,  23,	32,  43,  96, 100,	91,
	 23,  22,  27,	40,  66,  95, 115,	93,
	 23,  28,  37,	48,  85, 144, 133, 103,
	 30,  37,  61,	93, 113, 181, 171, 128,
	 40,  58,  91, 106, 134, 173, 188, 153,
	 81, 106, 129, 144, 171, 201, 199, 168,
	120, 153, 158, 163, 186, 166, 171, 164,
	 28,  30,	40,  78, 164, 164, 164, 164,
	 30,  35,	43, 110, 164, 164, 164, 164,
	 40,  43,	93, 164, 164, 164, 164, 164,
	 78, 110, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
};

/*QT25*/
char quality5[128] __attribute__ ((aligned(4)))= {
	 32,  22,  20,	32,  48,  80, 102, 122,
	 24,  24,  28,	38,  52, 116, 120, 110,
	 28,  26,  32,	48,  80, 114, 138, 112,
	 28,  34,  44,	58, 102, 174, 160, 124,
	 36,  44,  74, 112, 136, 218, 206, 154,
	 48,  70, 110, 128, 162, 208, 226, 184,
	 98, 128, 156, 174, 206, 242, 240, 202,
	144, 184, 190, 196, 224, 200, 206, 198,
	 34,  36,  48,  94, 198, 198, 198, 198,
	 36,  42,  52, 132, 198, 198, 198, 198,
	 48,  52, 112, 198, 198, 198, 198, 198,
	 94, 132, 198, 198, 198, 198, 198, 198,
	198, 198, 198, 198, 198, 198, 198, 198,
	198, 198, 198, 198, 198, 198, 198, 198,
	198, 198, 198, 198, 198, 198, 198, 198,
	198, 198, 198, 198, 198, 198, 198, 198,
};

#endif




#endif
