#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "lib/video/dvp/cmos_sensor/csi_V2.h"
#include "devid.h"
#include "hal/gpio.h"
#include "osal/irq.h"
#include "osal/string.h"
#include "dev/vpp/hgvpp.h"
#include "dev/csi/hgdvp.h"
#include "lib/lcd/lcd.h"
#include "hal/jpeg.h"
#include "osal/semaphore.h"

uint8 *yuvbuf = NULL;
#if DVP_EN



#define RESET_HIGH()		{gpio_set_val(rsn,1);}

#define RESET_LOW()		    {gpio_set_val(rsn,0);}





#define IIC_CLK 120000UL

uint8 u8SensorwriteID,u8SensorreadID;
uint8 u8Addrbytnum,u8Databytnum;

static uint8 g_byDevWriteAddr;
static uint8 g_byDevReadAddr;

_Sensor_Ident_ *devSensorInit=NULL;

Vpp_stream photo_msg;
SNSER snser; 
struct dvp_device *dvp_test;
struct i2c_device *iic_test;
struct vpp_device *vpp_test;


static const _Sensor_Ident_ *devSensorInitTable[] = {

#if DEV_SENSOR_GC0308	
	&gc0308_init,
#endif

#if DEV_SENSOR_GC0309	
	&gc0309_init,
#endif

#if DEV_SENSOR_GC0311	
	&gc0311_init,
#endif

#if DEV_SENSOR_GC0312	
	&gc0312_init,
#endif

#if DEV_SENSOR_GC0328	
	&gc0328_init,
#endif

#if DEV_SENSOR_GC0329
	&gc0329_init,
#endif

#if DEV_SENSOR_BF3A03	
	&bf3a03_init,
#endif

#if DEV_SENSOR_BF3703	
	&bf3703_init,
#endif

#if DEV_SENSOR_OV2640	
	&ov2640_init,
#endif

#if DEV_SENSOR_OV7725	
	&ov7725_init,
#endif

#if DEV_SENSOR_OV7670	
	&ov7670_init,
#endif

#if DEV_SENSOR_OV7660
	&ov7660_init,
#endif

#if DEV_SENSOR_BF2013
	&bf2013_init,
#endif

#if DEV_SENSOR_XC7016_H63	
	&xc7016_h63_init,
#endif

#if DEV_SENSOR_XC7011_H63	
	&xc7011_h63_init,
#endif

#if DEV_SENSOR_XC7011_GC1054	
	&xc7011_gc1054_init,
#endif


#if DEV_SENSOR_XCG532	
	&xcg532_init,
#endif

#if DEV_SENSOR_GC2145
	&gc2145_init,
#endif

#if DEV_SENSOR_SP0718
	&sp0718_init,
#endif
	
#if DEV_SENSOR_SP0A19
	&sp0a19_init,
#endif
	
#if DEV_SENSOR_BF3720
	&bf3720_init,
#endif

#if DEV_SENSOR_NT99230
	&nt99230_init,
#endif

#if DEV_SENSOR_IOT101
	&sc101iot_init,
#endif

	NULL,
};

static const _Sensor_Adpt_ *devSensorOPTable[] = {

#if DEV_SENSOR_GC0308	
	&gc0308_cmd,
#endif

#if DEV_SENSOR_GC0309	
	&gc0309_cmd,
#endif

#if DEV_SENSOR_GC0311	
	&gc0311_cmd,
#endif

#if DEV_SENSOR_GC0312	
	&gc0312_cmd,
#endif

#if DEV_SENSOR_GC0328	
	&gc0328_cmd,
#endif

#if DEV_SENSOR_GC0329	
	&gc0329_cmd,
#endif

#if DEV_SENSOR_BF3A03	
	&bf3a03_cmd,
#endif

#if DEV_SENSOR_BF3703	
	&bf3703_cmd,
#endif

#if DEV_SENSOR_OV2640	
	&ov2640_cmd,
#endif

#if DEV_SENSOR_OV7725	
	&ov7725_cmd,
#endif

#if DEV_SENSOR_OV7670	
	&ov7670_cmd,
#endif

#if DEV_SENSOR_OV7660
	&ov7660_cmd,
#endif

#if DEV_SENSOR_BF2013
	&bf2013_cmd,
#endif

#if DEV_SENSOR_XC7016_H63
	&xc7016_h63_cmd,
#endif

#if DEV_SENSOR_XC7011_H63
	&xc7011_h63_cmd,
#endif

#if DEV_SENSOR_XC7011_GC1054	
	&xc7011_gc1054_cmd,
#endif

#if DEV_SENSOR_XCG532	
	&xcg532_cmd,
#endif

#if DEV_SENSOR_GC2145
	&gc2145_cmd,
#endif

#if DEV_SENSOR_SP0718
	&sp0718_cmd,
#endif

#if DEV_SENSOR_SP0A19
	&sp0a19_cmd,
#endif

#if DEV_SENSOR_BF3720
	&bf3720_cmd,
#endif

#if DEV_SENSOR_NT99230
	&nt99230_cmd,
#endif

#if DEV_SENSOR_IOT101
	&sc101iot_cmd,
#endif

};


#if IPF_EN
#if 1
unsigned char vpp_encode_ipf[5466] = {
	0xFF, 0xFF, 0xB4, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0x7A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x01, 
	0xE4, 0xE8, 0xFF, 0xFF, 0x87, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xF7, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 
	0x87, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xEF, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0x94, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0xE5, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0x9F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xDF, 0x01, 
	0xE4, 0xE8, 0xFF, 0xFF, 0x9F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xDC, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 
	0xA4, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xD5, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xAF, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0xCF, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xAF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xCC, 0x01, 
	0xE4, 0xE8, 0xFF, 0xFF, 0xB4, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xC5, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 
	0xBF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xBF, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xBF, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0xBC, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xC4, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xB7, 0x01, 
	0xE4, 0xE8, 0xFF, 0xFF, 0xCA, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xB4, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 
	0xCA, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xB2, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xD1, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0xA7, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xA4, 0x01, 
	0xE4, 0xE8, 0xFF, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xA2, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 
	0xDF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x9F, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xE1, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x9D, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xE1, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x9A, 0x01, 
	0xE4, 0xE8, 0xFF, 0xFF, 0xE4, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x97, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 
	0xEA, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x94, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xEA, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x92, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xEF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8C, 0x01, 
	0xE4, 0xE8, 0xFF, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8A, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 
	0xF4, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8A, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xF7, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x84, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x84, 0x01, 
	0xE4, 0xE8, 0xFF, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x82, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 
	0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x7F, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x7F, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x7C, 0x01, 
	0xE4, 0xE8, 0xFF, 0xFF, 0x04, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x7A, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 
	0x04, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x7A, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0x04, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x77, 0x01, 0xE4, 0xE8, 0xFF, 0xFF, 0x0A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x07, 0x00, 
	0xE4, 0xE8, 0xFF, 0xFF, 0x6C, 0x01, 0xA4, 0xF0, 0xFF, 0xFF, 0x0A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x74, 0x01, 0xA4, 0xF0, 0xFF, 0xFF, 0x0A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x07, 0x00, 0xA4, 0xF0, 
	0xFF, 0xFF, 0x6A, 0x01, 0x25, 0xB2, 0xFF, 0xFF, 0x0F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x04, 0x00, 
	0x25, 0xB2, 0xFF, 0xFF, 0x6A, 0x01, 0xE9, 0x15, 0xFF, 0xFF, 0x0F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x6F, 0x01, 0xE9, 0x15, 0xFF, 0xFF, 0x0F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x04, 0x00, 0xE9, 0x15, 
	0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x0F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6C, 0x01, 
	0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 
	0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 
	0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 
	0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x67, 0x01, 
	0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 
	0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 
	0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 
	0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 
	0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 
	0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 
	0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 
	0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x64, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x1A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x67, 0x01, 
	0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 
	0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 
	0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 
	0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x6A, 0x01, 0x89, 0x25, 0xFF, 0xFF, 0x14, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6D, 0x01, 
	0x89, 0x25, 0xFF, 0xFF, 0x0F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x04, 0x00, 0x89, 0x25, 0xFF, 0xFF, 
	0x6A, 0x01, 0x89, 0x1D, 0xFF, 0xFF, 0x0F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6F, 0x01, 0x89, 0x1D, 
	0xFF, 0xFF, 0x0F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x04, 0x00, 0x89, 0x1D, 0xFF, 0xFF, 0x6A, 0x01, 
	0xA7, 0x65, 0xFF, 0xFF, 0x0F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x04, 0x00, 0xA7, 0x65, 0xFF, 0xFF, 
	0x6C, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x0A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x74, 0x01, 0x41, 0xFE, 
	0xFF, 0xFF, 0x0A, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x74, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x0A, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x37, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x2F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
	0x0F, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x04, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x3A, 0x01, 0x41, 0xFE, 
	0xFF, 0xFF, 0x2F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x0F, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x04, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x27, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x57, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x1D, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x5F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x1F, 0x01, 0x41, 0xFE, 
	0xFF, 0xFF, 0x5F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x6A, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x0C, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x6F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x0F, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x6F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x07, 0x01, 0x41, 0xFE, 
	0xFF, 0xFF, 0x74, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x02, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x7C, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x02, 0x01, 0x41, 0xFE, 0xFF, 0xFF, 0x7C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xFD, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x7F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF9, 0x00, 0x41, 0xFE, 
	0xFF, 0xFF, 0x82, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xFC, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x82, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xF7, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x84, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xF5, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x87, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF7, 0x00, 0x41, 0xFE, 
	0xFF, 0xFF, 0x87, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF1, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x8D, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xEF, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x8C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xF2, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x8C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xEC, 0x00, 0x41, 0xFE, 
	0xFF, 0xFF, 0x8D, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xEF, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x8C, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xF2, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x8C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xEC, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x8F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xED, 0x00, 0x41, 0xFE, 
	0xFF, 0xFF, 0x8F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xEF, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x8F, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xEC, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x8C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xED, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0x8F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xEF, 0x00, 0x41, 0xFE, 
	0xFF, 0xFF, 0x8F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x34, 0x00, 0x41, 0xFE, 0xFF, 0xFF, 0xB7, 0x00, 
	0xC0, 0xFE, 0xFF, 0xFF, 0x8C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x3A, 0x00, 0xC0, 0xFE, 0xFF, 0xFF, 
	0xB4, 0x00, 0x31, 0x72, 0xFF, 0xFF, 0x8D, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF1, 0x00, 0x31, 0x72, 
	0xFF, 0xFF, 0x8D, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x3C, 0x00, 0x31, 0x72, 0xFF, 0xFF, 0xB2, 0x00, 
	0x59, 0x28, 0xFF, 0xFF, 0x89, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x42, 0x00, 0x59, 0x28, 0xFF, 0xFF, 
	0xAC, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x87, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF7, 0x00, 0x98, 0x38, 
	0xFF, 0xFF, 0x87, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF5, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x84, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xF7, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x82, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xFC, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x82, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF9, 0x00, 0x98, 0x38, 
	0xFF, 0xFF, 0x7D, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x74, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x0A, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x74, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x07, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x67, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x01, 0x98, 0x38, 
	0xFF, 0xFF, 0x55, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x29, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x55, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x29, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x55, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x27, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x59, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x25, 0x01, 0x98, 0x38, 
	0xFF, 0xFF, 0x59, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x22, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x5F, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x1C, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x65, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x19, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x65, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x01, 0x98, 0x38, 
	0xFF, 0xFF, 0x69, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x12, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x6F, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x0F, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x6F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x0F, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x6F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x0C, 0x01, 0x98, 0x38, 
	0xFF, 0xFF, 0x75, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x09, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x75, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x07, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x79, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x05, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x79, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x05, 0x01, 0x98, 0x38, 
	0xFF, 0xFF, 0x79, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x02, 0x01, 0x98, 0x38, 0xFF, 0xFF, 0x7F, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xFC, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x85, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xF9, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x85, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF9, 0x00, 0x98, 0x38, 
	0xFF, 0xFF, 0x85, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF7, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x89, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xF5, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x89, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xF2, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x8F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xEF, 0x00, 0x98, 0x38, 
	0xFF, 0xFF, 0x8F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xEF, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x8F, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x6F, 0x00, 0x98, 0x38, 0xFF, 0xFF, 0x7C, 0x00, 0x17, 0x38, 0xFF, 0xFF, 
	0x95, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6C, 0x00, 0x17, 0x38, 0xFF, 0xFF, 0x7C, 0x00, 0xBB, 0x13, 
	0xFF, 0xFF, 0x95, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xE9, 0x00, 0xBB, 0x13, 0xFF, 0xFF, 0x95, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x6C, 0x00, 0xBB, 0x13, 0xFF, 0xFF, 0x7A, 0x00, 0x5D, 0x05, 0xFF, 0xFF, 
	0x99, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x00, 0x5D, 0x05, 0xFF, 0xFF, 0x7A, 0x00, 0x1D, 0x05, 
	0xFF, 0xFF, 0x99, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xE5, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0x99, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xE2, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0x9F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xDF, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0x9F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xDF, 0x00, 0x1D, 0x05, 
	0xFF, 0xFF, 0x9F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xDC, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xA5, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xD9, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xA5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xD9, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xA5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xD7, 0x00, 0x1D, 0x05, 
	0xFF, 0xFF, 0xA9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xD5, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xA9, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xD5, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xA9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xD5, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xAC, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xCF, 0x00, 0x1D, 0x05, 
	0xFF, 0xFF, 0xAF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xCF, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xAF, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xCF, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xAF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xCC, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xB5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xC9, 0x00, 0x1D, 0x05, 
	0xFF, 0xFF, 0xB5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xC9, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xB5, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xC9, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xB5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xC9, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0xB5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xC7, 0x00, 0x1D, 0x05, 
	0xFF, 0xFF, 0xB9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x5A, 0x00, 0x1D, 0x05, 0xFF, 0xFF, 0x6A, 0x00, 
	0x5E, 0x05, 0xFF, 0xFF, 0xB9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xC5, 0x00, 0x5E, 0x05, 0xFF, 0xFF, 
	0xB9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x5A, 0x00, 0x5E, 0x05, 0xFF, 0xFF, 0x6A, 0x00, 0x4B, 0x6B, 
	0xFF, 0xFF, 0xB9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x5A, 0x00, 0x4B, 0x6B, 0xFF, 0xFF, 0x6A, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0xBC, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xC2, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 
	0xBC, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xBF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xBF, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0xBF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xBF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xBF, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0xBF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xBF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 
	0xBF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xBF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC2, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0xBC, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC2, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB9, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB9, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 
	0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB9, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC5, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0xB9, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB9, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB9, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 
	0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB7, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0xB5, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 
	0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0xB5, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 
	0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0xB5, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB2, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 
	0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0xAF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 
	0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0xAF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 
	0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0xAF, 0x00, 0x8D, 0x63, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x4F, 0x00, 
	0x8D, 0x63, 0xFF, 0xFF, 0x5F, 0x00, 0xAC, 0x5B, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xAF, 0x00, 0xAC, 0x5B, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x4F, 0x00, 0xAC, 0x5B, 
	0xFF, 0xFF, 0x5F, 0x00, 0x35, 0xAA, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x4F, 0x00, 
	0x35, 0xAA, 0xFF, 0xFF, 0x5F, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x54, 0xA2, 
	0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x54, 0xA2, 
	0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x54, 0xA2, 
	0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xAF, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xCF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB2, 0x00, 0x54, 0xA2, 
	0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC9, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xB5, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x54, 0xA2, 
	0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC9, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xB5, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x54, 0xA2, 
	0xFF, 0xFF, 0xC9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC9, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xB7, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xB9, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB9, 0x00, 0x54, 0xA2, 
	0xFF, 0xFF, 0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xB9, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC5, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xB9, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xB9, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xBC, 0x00, 0x54, 0xA2, 
	0xFF, 0xFF, 0xC2, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xBC, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0xC2, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x54, 0x00, 0x54, 0xA2, 0xFF, 0xFF, 0x67, 0x00, 0x55, 0xA2, 0xFF, 0xFF, 
	0xBF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x57, 0x00, 0x55, 0xA2, 0xFF, 0xFF, 0x67, 0x00, 0xC8, 0xA9, 
	0xFF, 0xFF, 0xBF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xBF, 0x00, 0xC8, 0xA9, 0xFF, 0xFF, 0xBF, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x57, 0x00, 0xC8, 0xA9, 0xFF, 0xFF, 0x67, 0x00, 0x83, 0xB1, 0xFF, 0xFF, 
	0xBF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x57, 0x00, 0x83, 0xB1, 0xFF, 0xFF, 0x6A, 0x00, 0xA4, 0xB1, 
	0xFF, 0xFF, 0xB9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xC5, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xB9, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xC5, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xB9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xC5, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xB9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xC5, 0x00, 0xA4, 0xB1, 
	0xFF, 0xFF, 0xB9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xC5, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xB9, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xC7, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xB5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xC9, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xB5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xC9, 0x00, 0xA4, 0xB1, 
	0xFF, 0xFF, 0xB5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xCC, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xB2, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xCC, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xB2, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xCC, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xAF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xCF, 0x00, 0xA4, 0xB1, 
	0xFF, 0xFF, 0xAF, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xCF, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xAF, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xD2, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xA9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xD5, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xA9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xD5, 0x00, 0xA4, 0xB1, 
	0xFF, 0xFF, 0xA9, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xD5, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xA9, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xD7, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xA5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xD9, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0xA5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xD9, 0x00, 0xA4, 0xB1, 
	0xFF, 0xFF, 0xA5, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xDC, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x9F, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xDF, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x9F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xDF, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x9F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xE2, 0x00, 0xA4, 0xB1, 
	0xFF, 0xFF, 0x99, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xE5, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x99, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xE5, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x99, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xE7, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x95, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xE9, 0x00, 0xA4, 0xB1, 
	0xFF, 0xFF, 0x95, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xE9, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x95, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xEC, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x8F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0xEF, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x8F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF2, 0x00, 0xA4, 0xB1, 
	0xFF, 0xFF, 0x8C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xF2, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x89, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xF5, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x89, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x72, 0x00, 0xA4, 0xB1, 0xFF, 0xFF, 0x84, 0x00, 0x42, 0xB9, 0xFF, 0xFF, 0x85, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x74, 0x00, 0x42, 0xB9, 0xFF, 0xFF, 0x84, 0x00, 0xD3, 0x34, 0xFF, 0xFF, 0x85, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0xF9, 0x00, 0xD3, 0x34, 0xFF, 0xFF, 0x85, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x74, 0x00, 0xD3, 0x34, 0xFF, 0xFF, 0x87, 0x00, 0x3B, 0x06, 0xFF, 0xFF, 0x7F, 0x01, 0x00, 0x00, 
	0xFF, 0xFF, 0x77, 0x00, 0x3B, 0x06, 0xFF, 0xFF, 0x8A, 0x00, 0x1A, 0x06, 0xFF, 0xFF, 0x79, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x05, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x79, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x05, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x79, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x07, 0x01, 0x1A, 0x06, 
	0xFF, 0xFF, 0x75, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x09, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x75, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x0C, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x6F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x12, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x6C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x12, 0x01, 0x1A, 0x06, 
	0xFF, 0xFF, 0x6C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x12, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x69, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x17, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x65, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x19, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x65, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x1C, 0x01, 0x1A, 0x06, 
	0xFF, 0xFF, 0x5F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x22, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x59, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x25, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x59, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x27, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x55, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x2C, 0x01, 0x1A, 0x06, 
	0xFF, 0xFF, 0x52, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x2C, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x52, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x2C, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x4F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x32, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x49, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x35, 0x01, 0x1A, 0x06, 
	0xFF, 0xFF, 0x49, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x37, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x45, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x3C, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x3F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x3F, 0x01, 0x1A, 0x06, 0xFF, 0xFF, 0x3F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x42, 0x01, 0x1A, 0x06, 
	0xFF, 0xFF, 0x39, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x9A, 0x00, 0x1A, 0x06, 0xFF, 0xFF, 0xAC, 0x00, 
	0xDD, 0x05, 0xFF, 0xFF, 0x35, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x49, 0x01, 0xDD, 0x05, 0xFF, 0xFF, 
	0x35, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x9C, 0x00, 0xDD, 0x05, 0xFF, 0xFF, 0xB2, 0x00, 0xE0, 0x07, 
	0xFF, 0xFF, 0x29, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x57, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x25, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x59, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x25, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x5C, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x1F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x62, 0x01, 0xE0, 0x07, 
	0xFF, 0xFF, 0x19, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x65, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x19, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x6A, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x0F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x72, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x09, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x75, 0x01, 0xE0, 0x07, 
	0xFF, 0xFF, 0x09, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x77, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x0D, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x69, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x1D, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x61, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x1D, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x57, 0x01, 0xE0, 0x07, 
	0xFF, 0xFF, 0x2C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x4C, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x37, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x47, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x37, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x42, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x3F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x3C, 0x01, 0xE0, 0x07, 
	0xFF, 0xFF, 0x45, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x39, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x45, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x37, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x49, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x32, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x4F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x2F, 0x01, 0xE0, 0x07, 
	0xFF, 0xFF, 0x4F, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x2C, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x55, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x27, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x59, 0x01, 0x00, 0x00, 0xFF, 0xFF, 
	0x25, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x59, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x22, 0x01, 0xE0, 0x07, 
	0xFF, 0xFF, 0x5C, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x22, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x64, 0x00, 
	0x00, 0x00, 0xE0, 0x07, 0xE0, 0x07, 0xE0, 0x07, 0xF9, 0xCF, 0xF9, 0xCF, 0xF9, 0xCF, 0xFF, 0xFF, 
	0x8C, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x04, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x62, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x1F, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x64, 0x00, 0x00, 0x00, 0xE0, 0x07, 0xE0, 0x07, 
	0xE0, 0x07, 0xF9, 0xCF, 0xF9, 0xCF, 0xF9, 0xCF, 0xFF, 0xFF, 0x8C, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
	0x04, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x62, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x1C, 0x01, 0xE0, 0x07, 
	0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 0xF9, 0xCF, 0xF9, 0xCF, 0xF9, 0xCF, 0xFF, 0xFF, 0x07, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x0C, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 
	0x62, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x1C, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x6A, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x12, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x69, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x62, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x1C, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 
	0x6A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x12, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x69, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x17, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x62, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x1A, 0x01, 
	0xE0, 0x07, 0xFF, 0xFF, 0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x1C, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 
	0x4F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x22, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x2C, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x2F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x32, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 
	0x67, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x6F, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x2C, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x2F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x32, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 
	0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8F, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8F, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 
	0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8F, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8F, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 
	0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8F, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8F, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 
	0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8F, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8F, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 
	0x6F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8F, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x67, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x19, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x6A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x94, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x65, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 
	0x6A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x94, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x62, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x1C, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x6A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x94, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x62, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x1F, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 
	0x64, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x97, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x62, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x1F, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 0x64, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x97, 0x00, 
	0xE0, 0x07, 0xFF, 0xFF, 0x62, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x1F, 0x01, 0xE0, 0x07, 0xFF, 0xFF, 
	0x64, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x97, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x62, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0x87, 0x00, 0xE0, 0x07, 0xFF, 0xFF, 0x9A, 0x00, 0xE0, 0x47, 0xFF, 0xFF, 0x5F, 0x00, 
	0x00, 0x00, 0xFF, 0xFF, 0x9C, 0x00, 0xE0, 0x47, 0xFF, 0xFF, 0x5C, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
	0x8A, 0x00, 0xE0, 0x47, 0xFF, 0xFF, 0x9C, 0x00, 0xE0, 0xFF, 0xFF, 0xFF, 0x5A, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0xA2, 0x00, 0xE0, 0xFF, 0xFF, 0xFF, 0x57, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x29, 0x01, 
	0xE0, 0xFF, 0xFF, 0xFF, 0x5A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xA2, 0x00, 0xE0, 0xFF, 0xFF, 0xFF, 
	0x57, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x8C, 0x00, 0xE0, 0xFF, 0xFF, 0xFF, 0x9F, 0x00, 0xE0, 0xF7, 
	0xFF, 0xFF, 0x57, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xA2, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x57, 0x00, 
	0x00, 0x00, 0xFF, 0xFF, 0x2F, 0x01, 0xE0, 0xF7, 0xFF, 0xFF, 0x4F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
	0xA9, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x52, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x32, 0x01, 0xE0, 0xF7, 
	0xFF, 0xFF, 0x4F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xA9, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x52, 0x00, 
	0x00, 0x00, 0xFF, 0xFF, 0x34, 0x01, 0xE0, 0xF7, 0xFF, 0xFF, 0x4A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
	0xAF, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x4C, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x3A, 0x01, 0xE0, 0xF7, 
	0xFF, 0xFF, 0x44, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x47, 0x00, 
	0x00, 0x00, 0xFF, 0xFF, 0x3C, 0x01, 0xE0, 0xF7, 0xFF, 0xFF, 0x44, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
	0xB5, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x47, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x41, 0x01, 0xE0, 0xF7, 
	0xFF, 0xFF, 0x3A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xBC, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x42, 0x00, 
	0x00, 0x00, 0xFF, 0xFF, 0x4C, 0x01, 0xE0, 0xF7, 0xFF, 0xFF, 0x2A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
	0xC7, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x3C, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x4F, 0x01, 0xE0, 0xF7, 
	0xFF, 0xFF, 0x2A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xC7, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x3C, 0x00, 
	0x00, 0x00, 0xFF, 0xFF, 0x57, 0x01, 0xE0, 0xF7, 0xFF, 0xFF, 0x1A, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
	0xD4, 0x00, 0xE0, 0xF7, 0xFF, 0xFF, 0x32, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x52, 0x02, 0xE0, 0xF7, 
	0xFF, 0xFF, 0x27, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x57, 0x02, 0xE0, 0xF7, 0xFF, 0xFF, 0x27, 0x00, 
	0x00, 0x00, 0xFF, 0xFF, 0x5F, 0x02, 0xE0, 0xF7, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
	0x2C, 0x44, 0xE0, 0xF7, 0xFF, 0xFF, 0xFF, 0x04, 0x56, 0xCA, 0xFF, 0xFF, 0x7F, 0x02, 0x1F, 0xB0, 
	0xFF, 0xFF, 0x7F, 0x57, 0x1F, 0xB8, 0xFF, 0xFF, 0x07, 0x00, 0x1F, 0xB0, 0xFF, 0xFF, 0x77, 0x02, 
	0x1F, 0xB8, 0x1E, 0xB0, 0x1E, 0xB0, 0x1E, 0xB0, 0xFF, 0xFF, 0x04, 0x00, 0x13, 0xE8, 0x1F, 0xA0, 
	0x1F, 0xA0, 0x1F, 0xA0, 0xFF, 0xFF, 0x74, 0x02, 0x1F, 0xA8, 0x1E, 0xB0, 0x1E, 0xB0, 0x1E, 0xB0, 
	0xFF, 0xFF, 0x04, 0x00, 0x13, 0xE8, 0x1F, 0xA0, 0x1F, 0xA0, 0x1F, 0xA0, 0xFF, 0xFF, 0x74, 0x02, 
	0x1F, 0xA8, 0x0E, 0xF8, 0x0E, 0xF8, 0x0E, 0xF8, 0xFF, 0xFF, 0x04, 0x00, 0x0F, 0xF8, 0xFF, 0xFF, 
	0x77, 0x02, 0x0E, 0xF8, 0xFF, 0xFF, 0x7F, 0x48, 0x10, 0xF8
};;

#else
unsigned char vpp_encode_ipf[]__attribute__ ((aligned(4)))={
	0xFF,0XFF,0XFF,0XFF,0X00,0X10,0XFF,0XFF,0X01,0X2C,0XAA,0XAA,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,
	0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,
	0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,
	0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,
	0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,
	0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,
	0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,0xFF,0XFF,0XFF,0XFF,0X00,0X80,
};

#endif
#endif

uint8 photo_lib2[48*6]__attribute__ ((aligned(4)))={
	0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x0C,0x00,0x00,0x00,
	0x00,0x00,0x0F,0x80,0x00,0x00,
	0x00,0x00,0x0F,0x00,0x00,0x00,
	0x00,0x00,0x0E,0x00,0x00,0x00,
	0x00,0x00,0x0E,0x00,0x03,0x00,
	0x00,0x00,0x0E,0x00,0x07,0x80,
	0x07,0xFF,0xFF,0xFF,0xFF,0xC0,
	0x00,0x00,0x0E,0x00,0x00,0x00,
	0x00,0x00,0x0C,0x00,0x00,0x00,
	0x00,0x00,0x0C,0x00,0x00,0x00,
	0x00,0x00,0x0C,0x00,0x00,0x00,
	0x00,0x00,0x1C,0x00,0x18,0x00,
	0x00,0x00,0x1C,0x00,0x3C,0x00,
	0x00,0xFF,0xFF,0xFF,0xFE,0x00,
	0x00,0x40,0x18,0x00,0x00,0x00,
	0x00,0x00,0x38,0x00,0x00,0x00,
	0x00,0x00,0x38,0x00,0x00,0x00,
	0x00,0x00,0x30,0x00,0x00,0xC0,
	0x00,0x00,0x70,0x00,0x01,0xE0,
	0x1F,0xFF,0xFF,0xFF,0xFF,0xF0,
	0x08,0x00,0xE0,0x08,0x00,0x00,
	0x00,0x00,0xC0,0x04,0x00,0x00,
	0x00,0x01,0xC0,0x06,0x00,0x00,
	0x00,0x03,0x82,0x03,0x00,0x00,
	0x00,0x03,0x83,0x81,0x80,0x00,
	0x00,0x07,0x03,0x81,0xC0,0x00,
	0x00,0x0E,0x03,0x00,0xE0,0x00,
	0x00,0x1C,0x03,0x00,0x70,0x00,
	0x00,0x3C,0x03,0x03,0x38,0x00,
	0x00,0x73,0x83,0x07,0x9E,0x00,
	0x00,0xE1,0xE3,0x0F,0xCF,0x80,
	0x01,0xC0,0xE3,0x1C,0x07,0xF0,
	0x03,0x80,0x63,0x60,0x03,0xFC,
	0x06,0x00,0x63,0x80,0x00,0xE0,
	0x1C,0x00,0x03,0x00,0x00,0x40,
	0x30,0x00,0x33,0x00,0x00,0x00,
	0x00,0x00,0xC3,0x3C,0x00,0x00,
	0x00,0x07,0x83,0x0F,0x80,0x00,
	0x00,0x1E,0x03,0x03,0xE0,0x00,
	0x00,0xFC,0x03,0x01,0xF0,0x00,
	0x00,0xF0,0x03,0x00,0xF0,0x00,
	0x00,0x60,0xFF,0x00,0x70,0x00,
	0x00,0x00,0x3F,0x00,0x30,0x00,
	0x00,0x00,0x0E,0x00,0x00,0x00,
	0x00,0x00,0x0C,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00
};


uint8 ele_lib[13][48]__attribute__ ((aligned(4)))= {
	//0
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x0F,0x01,0xF8,
		0x38,0xC3,0x0C,
		0x60,0x66,0x06,
		0x60,0x66,0x06,
		0x60,0x66,0x06,
		0x60,0x66,0x06,
		0x30,0xC3,0x8C,
		0x1F,0x80,0xF0,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	//1
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x01,0x00,0x70,
		0x1F,0x03,0xB0,
		0x33,0x00,0x30,
		0x03,0x00,0x30,
		0x03,0x00,0x30,
		0x03,0x00,0x30,
		0x03,0x00,0x30,
		0x03,0x00,0x30,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	//2
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x0F,0x03,0xF8,
		0x31,0xC0,0x0C,
		0x00,0xC0,0x0C,
		0x01,0xC0,0x18,
		0x03,0x00,0xE0,
		0x1C,0x03,0x00,
		0x20,0x06,0x00,
		0x7F,0xC7,0xFC,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	//3
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x1F,0x03,0xF8,
		0x21,0xC0,0x0C,
		0x00,0xC0,0x0C,
		0x01,0x81,0xF0,
		0x1F,0x80,0x0C,
		0x00,0x60,0x06,
		0x00,0x64,0x0C,
		0x7F,0xC3,0xF0,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00

	},
	//4
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x01,0x80,0x38,
		0x03,0x80,0x78,
		0x0D,0x80,0xD8,
		0x19,0x81,0x98,
		0x31,0x86,0x18,
		0xE1,0x8F,0xFE,
		0xFF,0xE0,0x18,
		0x01,0x80,0x18,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	//5
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x1F,0xC3,0xFC,
		0x30,0x03,0x00,
		0x30,0x03,0x00,
		0x3F,0x03,0xFC,
		0x01,0xE0,0x06,
		0x00,0x60,0x06,
		0x00,0x60,0x1C,
		0x3F,0xC3,0xF0,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	//6
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x07,0x80,0xFC,
		0x18,0x43,0x00,
		0x30,0x06,0x00,
		0x67,0x86,0xFC,
		0x70,0xE6,0x06,
		0x60,0x66,0x06,
		0x20,0x63,0x0C,
		0x1F,0xC0,0xF0,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	//7
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0xFF,0xEF,0xFE,
		0x00,0x40,0x0C,
		0x01,0x80,0x18,
		0x03,0x00,0x30,
		0x06,0x00,0x60,
		0x0C,0x00,0xC0,
		0x0C,0x01,0x80,
		0x18,0x01,0x80,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	//8
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x0F,0x01,0xF8,
		0x39,0xC3,0x0C,
		0x30,0xC3,0x0C,
		0x19,0x80,0xF0,
		0x3F,0xC7,0x0E,
		0x60,0x66,0x06,
		0x60,0x67,0x0E,
		0x3F,0xC0,0xF0,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},	
	//9
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x0F,0x03,0xF8,
		0x30,0xC6,0x06,
		0x60,0x66,0x06,
		0x60,0x67,0x0E,
		0x3F,0xE1,0xF6,
		0x00,0x60,0x0C,
		0x00,0xC2,0x18,
		0x3F,0x81,0xE0,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	///
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x01,0x80,0x30,
		0x03,0x00,0x30,
		0x06,0x00,0x60,
		0x06,0x00,0xC0,
		0x0C,0x01,0xC0,
		0x18,0x01,0x80,
		0x30,0x03,0x00,
		0x30,0x06,0x00,
		0x60,0x06,0x00,
		0xC0,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	//:
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x07,0x00,
		0x70,0x07,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x07,0x00,
		0x70,0x07,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},
	//NULL 
	{
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00,
		0x00,0x00,0x00
	},		
};



const _Sensor_Ident_ null_init={0x00,0x00,0x00,0x00,0x00,0x00};


/*******************************************************************************
* Function Name  : Delay_Cnt
* Description    : delay cnt nop
* Input          : nop number
* Output         : None
* Return         : None
*******************************************************************************/
extern void Delay_nopCnt(uint32 cnt);

/*******************************************************************************
* Function Name  : sensor_reset
* Description    : for sensor reset before start
* Input          : nop number
* Output         : None
* Return         : None
*******************************************************************************/
__weak void sensor_reset(void){
	uint8_t rsn,pdn;

	pdn = PIN_DVP_PDN;//get_func_io("dvp", "PDN");
	if(pdn != 255){
		gpio_iomap_output(pdn,GPIO_IOMAP_OUTPUT);
		gpio_set_val(pdn,1);
		os_sleep_ms(1);
		gpio_set_val(pdn,0);
	}


	rsn = PIN_DVP_RESET;//get_func_io("dvp", "RSN");
	if(rsn != 255){
		gpio_iomap_output(rsn,GPIO_IOMAP_OUTPUT);
	}
	else{
		return;
	}
	
	RESET_HIGH();
	os_sleep_ms(50);
	RESET_LOW();
	os_sleep_ms(200);
	RESET_HIGH();
	os_sleep_ms(50);

}


void i2c_SetSetting(struct i2c_setting *p_i2c_setting)
{
	if(!p_i2c_setting)
		return;
	
    g_byDevWriteAddr = p_i2c_setting->u8DevWriteAddr;
    g_byDevReadAddr = p_i2c_setting->u8DevReadAddr;	

	return;
}



int sensorCheckId(struct i2c_device *p_iic,const _Sensor_Ident_ *p_sensor_ident,const _Sensor_Adpt_ *p_sensor_adpt)
{
	int8 u8Buf[3];
	uint32 id= 0;
	uint32 i = 0;
	

	u8SensorwriteID = p_sensor_ident->w_cmd;
	u8SensorreadID =p_sensor_ident->r_cmd;
	u8Addrbytnum = p_sensor_ident->addr_num;
	u8Databytnum = p_sensor_ident->data_num;




	

	
	i2c_ioctl(p_iic,IIC_SET_DEVICE_ADDR,u8SensorwriteID>>1);
	//id = i2c_sensor_read(p_iic,u8Buf,p_sensor_ident->addr_num,p_sensor_ident->data_num,u8SensorwriteID,u8SensorreadID);

	if(p_sensor_adpt->preset){
		for(i=0;;i+=p_sensor_ident->data_num+p_sensor_ident->addr_num){
			if((p_sensor_adpt->preset[i]==0xFF)&&(p_sensor_adpt->preset[i+1]==0xFF)){
				os_printf("preset table num:%d\r\n",i);
				break;
			}			
			i2c_write(iic_test, (int8*)&p_sensor_adpt->preset[i],p_sensor_ident->addr_num, (int8*)&p_sensor_adpt->preset[i+p_sensor_ident->addr_num], p_sensor_ident->data_num);
		}		
	}


	u8Buf[0] = p_sensor_ident->id_reg;
	if(p_sensor_ident->addr_num == 2)
	{
		u8Buf[0] = p_sensor_ident->id_reg>>8;
		u8Buf[1] = p_sensor_ident->id_reg;
	}

	
	i2c_read(p_iic,u8Buf,p_sensor_ident->addr_num,(int8*)&id,p_sensor_ident->data_num);
	os_printf("SID: %x, %x, %x, %x,%x\r\n",id,p_sensor_ident->id,u8SensorwriteID,u8SensorreadID,p_sensor_ident->id_reg);
	if(id == p_sensor_ident->id)
		return 1;
	else
		return -1;
}


/*******************************************************************************
* Function Name  : Sensor_ReadRegister
* Description    : read sensor register
* Input          : *pbdata :sensor register addr
                   u8AddrLength:sensor register addr length
                   u8DataLength:sensor register data length
* Output         : None
* Return         : u32i2cReadResult:the result from sensor register
*******************************************************************************/
static _Sensor_Adpt_ * sensorAutoCheck(struct i2c_device *p_iic,uint8 *init_buf)
{
	uint8 i;
	_Sensor_Adpt_ * devSensor_Struct=NULL;
	for(i=0;devSensorInitTable[i] != NULL;i++)
	{		
		sensor_reset();
		if(sensorCheckId(p_iic,devSensorInitTable[i],devSensorOPTable[i])>=0)
		{
			os_printf("id =%x num:%d \n",devSensorInitTable[i]->id,i);
			devSensorInit = (_Sensor_Ident_ *) devSensorInitTable[i];
//#if CMOS_AUTO_LOAD
//			devSensor_Struct = sensor_adpt_load(devSensorInit->id,devSensorInit->w_cmd,devSensorInit->r_cmd,init_buf);
//#else
			devSensor_Struct = (_Sensor_Adpt_ *) devSensorOPTable[i];
//#endif
			break;
		}
	}
	if(devSensor_Struct == NULL)
	{
		os_printf("Er: unkown!");
		devSensorInit = (_Sensor_Ident_ *)&null_init;
		return NULL; // index 0 is test only
	}
	return devSensor_Struct;
}

volatile uint8 yuv_buf_head[16]__attribute__ ((section(".sbss")));;
#if DET_EN
//uint8 motion_detect_buf[9*1024/*((IMAGE_W+31)/32)  * ((IMAGE_H+31)/32) + 3 + 4*((IMAGE_W+31)/32)*/]__attribute__ ((aligned(4)));//加3是为了防止blk数不是word对齐
uint8 motion_detect_buf[((IMAGE_W+31)/32)  * ((IMAGE_H+31)/32) + 3 + 4*((IMAGE_W+31)/32)]__attribute__ ((aligned(4)));//加3是为了防止blk数不是word对齐
#endif

#if VPP_BUF1_EN
//volatile u8 yuvbuf1[2][(IMAGE_W/2)*8+(IMAGE_W/2)*4]__attribute__ ((aligned(4),section(".sbss")));;
uint8 *yuvbuf1 = NULL;
#endif
uint8 psram_ybuf_src[IMAGE_H*IMAGE_W+IMAGE_H*IMAGE_W/2] __attribute__ ((aligned(4),section(".psram.src")));

//uint8 psram_ubuf_src[IMAGE_H*IMAGE_W/4] __attribute__ ((aligned(4),section(".psram.src")));
//uint8 psram_vbuf_src[IMAGE_H*IMAGE_W/4] __attribute__ ((aligned(4),section(".psram.src")));


volatile uint8 psram_buf_head[16]__attribute__ ((section(".psram.src")));
#if ONLY_Y
uint8 psram_buf[IMAGE_H][IMAGE_W] __attribute__ ((aligned(4),section(".psram.src")));
#endif
uint8 psram_buf_tail[2032]__attribute__ ((section(".psram.src")));


volatile uint32 line_buf = 0;

extern volatile uint32 done_dvp;

volatile uint32 vs_isr;
 

volatile uint32 vpp_get_src = 0;



void dvp_vpp_reset()
{
	uint32 mj1_on,mj0_on;
	struct jpg_device *jpeg0_dev,*jpeg1_dev;	
	jpeg0_dev = (struct jpg_device *)dev_get(HG_JPG0_DEVID);		
	dvp_close(dvp_test);
	vpp_close(vpp_test);
	mj0_on = jpg_is_online(jpeg0_dev);
	if(mj0_on)
		jpg_close(jpeg0_dev);
	jpeg1_dev = (struct jpg_device *)dev_get(HG_JPG1_DEVID);		
	mj1_on = jpg_is_online(jpeg1_dev);
	if(mj1_on)
		jpg_close(jpeg1_dev);

	
	os_printf("fv\r\n");
	if(mj1_on)
		jpg_open(jpeg1_dev);
	if(mj0_on)
		jpg_open(jpeg0_dev);	
	vpp_open(vpp_test);
	dvp_open(dvp_test);

}


void vpp_hsie_isr(uint32 irq,uint32 image_h,uint32  param){
	//os_printf("H");
}

void vpp_vsie_isr(uint32 irq,uint32 dev,uint32 param){	
	vs_isr++;
	set_time_watermark(2022,9,1,20,1,(os_jiffies()/1000)%60);
}

void vpp_data_done(uint32 irq,uint32 dev,uint32 param){
	//os_printf("D");
}	

extern uint8_t vga_room[2][640*480+640*480/2];
volatile uint8_t vfx_open = 0;
volatile uint8_t itp_finish = 0;
volatile uint8_t vfx_pingpang = 0;
struct os_semaphore  vfx_sema;

void vpp_itp_done(uint32 irq,uint32 dev,uint32 param){
	os_printf("ITP_finish..\r\n");
	itp_finish = 1;
}


void vpp_itp_vfx_done(uint32 irq,uint32 dev,uint32 param){
	if(vfx_open){
		os_sema_up(&vfx_sema);
		vfx_pingpang++;
	}
}


void vpp_itp_error(uint32 irq,uint32 dev,uint32 param){
	os_printf("ITP_ER..\r\n");
}

void vpp_lib_error(uint32 irq,uint32 dev,uint32 param){
	dvp_vpp_reset();
	os_printf("LIB_ER..\r\n");
}
extern volatile uint32 outbuff_isr[2];
void vpp_ipf_error(uint32 irq,uint32 dev,uint32 param){
	dvp_vpp_reset();
	os_printf("IPF ERR..\r\n");
	#if JPG_EN == 1
	outbuff_isr[0] = 0xff;
	#endif
}

void vpp_md_find(uint32 irq,uint32 dev,uint32 param){
	os_printf("md fine..\r\n");
}

void dvp_line_isr(uint32 irq,uint32 image_h,uint32 param){
	
}

void dvp_fhfie_isr(uint32 irq,uint32 dev,uint32 param){
	os_printf("fh\r\n");
}

void dvp_fovie_isr(uint32 irq,uint32 dev,uint32 param){
	dvp_vpp_reset();
	os_printf("------------------------------------------------------------------------------fv\r\n");
}

void dvp_sip_isr(uint32 irq,uint32 dev,uint32 param){
	dvp_vpp_reset();
	os_printf("sip reset DVP\r\n");
}

void dvp_line_isr_test(uint32 irq,uint32 image_h,uint32 param){
	return;
}

void set_time_watermark(uint16 year,uint16 month,uint16 day,uint16 hour,uint16 min,uint16 sec){
	if(vpp_test == NULL){
		return;
	}
	vpp_set_watermark0_idx(vpp_test,0, year/1000);
	vpp_set_watermark0_idx(vpp_test,1,(year/100)%10);
	vpp_set_watermark0_idx(vpp_test,2,(year/10)%10);
	vpp_set_watermark0_idx(vpp_test,3, year%10);

	vpp_set_watermark0_idx(vpp_test,4, 10);

	vpp_set_watermark0_idx(vpp_test,5, month/10);
	vpp_set_watermark0_idx(vpp_test,6, month%10);

	vpp_set_watermark0_idx(vpp_test,7, 10);

	vpp_set_watermark0_idx(vpp_test,8, day/10);
	vpp_set_watermark0_idx(vpp_test,9, day%10);
	
	vpp_set_watermark0_idx(vpp_test,10, 12);

	vpp_set_watermark0_idx(vpp_test,11, hour/10);
	vpp_set_watermark0_idx(vpp_test,12, hour%10);
	vpp_set_watermark0_idx(vpp_test,13, 11);
	vpp_set_watermark0_idx(vpp_test,14, min/10);
	vpp_set_watermark0_idx(vpp_test,15, min%10);
	vpp_set_watermark0_idx(vpp_test,16, 11);
	vpp_set_watermark0_idx(vpp_test,17, sec/10);
	vpp_set_watermark0_idx(vpp_test,18, sec%10);
}

void vpp_put_psram(uint32 yuvbuf_addr,uint32 s_w,uint32 s_h){
	struct vpp_device *vpp_dev;
	struct scale_device *scale_dev;
	vpp_dev = (struct vpp_device *)dev_get(HG_VPP_DEVID);
	scale_dev = (struct scale_device *)dev_get(HG_SCALE1_DEVID);
	vpp_set_itp_enable(vpp_dev,0);
	scale_set_in_yaddr(scale_dev,yuvbuf_addr);
	scale_set_in_uaddr(scale_dev,yuvbuf_addr+s_w*s_h);
	scale_set_in_vaddr(scale_dev,yuvbuf_addr+s_w*s_h+s_w*s_h/4);	
	
	vpp_set_itp_y_addr(vpp_dev,yuvbuf_addr);
	vpp_set_itp_u_addr(vpp_dev,yuvbuf_addr+s_w*s_h);
	vpp_set_itp_v_addr(vpp_dev,yuvbuf_addr+s_w*s_h+s_w*s_h/4);
	vpp_set_itp_linebuf(vpp_dev,4);	
	vpp_set_itp_auto_close(vpp_dev,0);
	vpp_set_itp_enable(vpp_dev,1);	
	
}

void yuv_add_time_watermark(uint8_t *src,uint32_t w,uint32_t h,uint8_t cw,uint8_t ch,uint32_t x_s,uint32_t y_s,uint32_t year,uint8_t month,uint8_t day,uint8_t hour,uint8_t min,uint8_t sec){
	uint32_t dat_offset;
	uint8_t *ptb;
	uint8_t itk = 0;
	uint8_t jtk = 0;
	uint32_t ktk = 0;
	uint8_t  cnt = 0;
	uint8_t dnum = 0;
	uint32_t wd = 0;
	uint8_t cnum = 0;
	uint32 x_l,y_l;

	for(cnt = 0;cnt<4;cnt++){
		dat_offset = y_s*w+x_s+cnum*cw;
		if(cnt == 0){
			wd = year/1000;
		}else if(cnt == 1){
			wd = (year/100)%10;
		}else if(cnt == 2){
			wd = (year/10)%10;
		}else if(cnt == 3){
			wd = year%10;
		}

		ptb = ele_lib[wd];
		ktk = 0;
		dnum = 0;
		for(itk = 0;itk < ch;itk++){
			for(jtk = 0;jtk < cw;jtk++){
				if(((ktk%8) == 0)&&(ktk != 0)){
					dnum++;
				}
				
				if(ptb[dnum]&BIT(7-ktk%8)){
					src[dat_offset+jtk] = 0xff;
					x_l = (dat_offset+jtk)%w;  //第几列
					y_l = (dat_offset+jtk)/w;  //第几行
					y_l = y_l/2;
					x_l = x_l/2;
					y_l = y_l*(w/2)+x_l;
					src[w*h+y_l] = 0x80;
					src[w*h+w*h/4+y_l] = 0x80;
				}else{
				}
				ktk++;
			}
			dat_offset += w;
		}
		cnum++;
	}

	dat_offset = y_s*w+x_s+cnum*cw;
	ptb = ele_lib[10];    // ‘/’
	ktk = 0;
	dnum = 0;
	for(itk = 0;itk < ch;itk++){
		for(jtk = 0;jtk < cw;jtk++){
			if(((ktk%8) == 0)&&(ktk != 0)){
				dnum++;
			}
			
			if(ptb[dnum]&BIT(7-ktk%8)){
				src[dat_offset+jtk] = 0xff;
				x_l = (dat_offset+jtk)%w;  //第几列
				y_l = (dat_offset+jtk)/w;  //第几行
				y_l = y_l/2;
				x_l = x_l/2;
				y_l = y_l*(w/2)+x_l;
				src[w*h+y_l] = 0x80;
				src[w*h+w*h/4+y_l] = 0x80;				
			}else{
			}
			ktk++;
		}
		dat_offset += w;
	}
	cnum++;
	for(cnt = 0;cnt<2;cnt++){
		dat_offset = y_s*w+x_s+cnum*cw;
		if(cnt == 0){
			wd = month/10;
		}else if(cnt == 1){
			wd = month%10;
		}
	
		ptb = ele_lib[wd];
		ktk = 0;
		dnum = 0;
		for(itk = 0;itk < ch;itk++){
			for(jtk = 0;jtk < cw;jtk++){
				if(((ktk%8) == 0)&&(ktk != 0)){
					dnum++;
				}
				
				if(ptb[dnum]&BIT(7-ktk%8)){
					src[dat_offset+jtk] = 0xff;
					x_l = (dat_offset+jtk)%w;  //第几列
					y_l = (dat_offset+jtk)/w;  //第几行
					y_l = y_l/2;
					x_l = x_l/2;
					y_l = y_l*(w/2)+x_l;
					src[w*h+y_l] = 0x80;
					src[w*h+w*h/4+y_l] = 0x80;
				}else{
				}
				ktk++;
			}
			dat_offset += w;
		}
		cnum++;
	}	

	dat_offset = y_s*w+x_s+cnum*cw;
	ptb = ele_lib[10];    // ‘/’
	ktk = 0;
	dnum = 0;	
	for(itk = 0;itk < ch;itk++){
		for(jtk = 0;jtk < cw;jtk++){
			if(((ktk%8) == 0)&&(ktk != 0)){
				dnum++;
			}
			
			if(ptb[dnum]&BIT(7-ktk%8)){
				src[dat_offset+jtk] = 0xff;
				x_l = (dat_offset+jtk)%w;  //第几列
				y_l = (dat_offset+jtk)/w;  //第几行
				y_l = y_l/2;
				x_l = x_l/2;
				y_l = y_l*(w/2)+x_l;
				src[w*h+y_l] = 0x80;
				src[w*h+w*h/4+y_l] = 0x80;
			}else{
			}
			ktk++;
		}
		dat_offset += w;
	}
	cnum++;

	for(cnt = 0;cnt<2;cnt++){
		dat_offset = y_s*w+x_s+cnum*cw;
		if(cnt == 0){
			wd = day/10;
		}else if(cnt == 1){
			wd = day%10;
		}
	
		ptb = ele_lib[wd];
		ktk = 0;
		dnum = 0;
		for(itk = 0;itk < ch;itk++){
			for(jtk = 0;jtk < cw;jtk++){
				if(((ktk%8) == 0)&&(ktk != 0)){
					dnum++;
				}
				
				if(ptb[dnum]&BIT(7-ktk%8)){
					src[dat_offset+jtk] = 0xff;
					x_l = (dat_offset+jtk)%w;  //第几列
					y_l = (dat_offset+jtk)/w;  //第几行
					y_l = y_l/2;
					x_l = x_l/2;
					y_l = y_l*(w/2)+x_l;
					src[w*h+y_l] = 0x80;
					src[w*h+w*h/4+y_l] = 0x80;
				}else{
				}
				ktk++;
			}
			dat_offset += w;
		}
		cnum++;
	}	

	dat_offset = y_s*w+x_s+cnum*cw;
	ptb = ele_lib[12];    // ‘ ’
	ktk = 0;
	dnum = 0;
	for(itk = 0;itk < ch;itk++){
		for(jtk = 0;jtk < cw;jtk++){
			if(((ktk%8) == 0)&&(ktk != 0)){
				dnum++;
			}
			
			if(ptb[dnum]&BIT(7-ktk%8)){
				src[dat_offset+jtk] = 0xff;
				x_l = (dat_offset+jtk)%w;  //第几列
				y_l = (dat_offset+jtk)/w;  //第几行
				y_l = y_l/2;
				x_l = x_l/2;
				y_l = y_l*(w/2)+x_l;
				src[w*h+y_l] = 0x80;
				src[w*h+w*h/4+y_l] = 0x80;

			}else{
			}
			ktk++;
		}
		dat_offset += w;
	}
	cnum++;

	for(cnt = 0;cnt<2;cnt++){
		dat_offset = y_s*w+x_s+cnum*cw;
		if(cnt == 0){
			wd = hour/10;
		}else if(cnt == 1){
			wd = hour%10;
		}
	
		ptb = ele_lib[wd];
		ktk = 0;
		dnum = 0;		
		for(itk = 0;itk < ch;itk++){
			for(jtk = 0;jtk < cw;jtk++){
				if(((ktk%8) == 0)&&(ktk != 0)){
					dnum++;
				}
				
				if(ptb[dnum]&BIT(7-ktk%8)){
					src[dat_offset+jtk] = 0xff;
					x_l = (dat_offset+jtk)%w;  //第几列
					y_l = (dat_offset+jtk)/w;  //第几行
					y_l = y_l/2;
					x_l = x_l/2;
					y_l = y_l*(w/2)+x_l;
					src[w*h+y_l] = 0x80;
					src[w*h+w*h/4+y_l] = 0x80;

				}else{
				}
				ktk++;
			}
			dat_offset += w;
		}
		cnum++;
	}
	dat_offset = y_s*w+x_s+cnum*cw;
	ptb = ele_lib[11];    // ‘ ’
	ktk = 0;
	dnum = 0;	
	for(itk = 0;itk < ch;itk++){
		for(jtk = 0;jtk < cw;jtk++){
			if(((ktk%8) == 0)&&(ktk != 0)){
				dnum++;
			}
			
			if(ptb[dnum]&BIT(7-ktk%8)){
				src[dat_offset+jtk] = 0xff;
				x_l = (dat_offset+jtk)%w;  //第几列
				y_l = (dat_offset+jtk)/w;  //第几行
				y_l = y_l/2;
				x_l = x_l/2;
				y_l = y_l*(w/2)+x_l;
				src[w*h+y_l] = 0x80;
				src[w*h+w*h/4+y_l] = 0x80;
			}else{
			}
			ktk++;
		}
		dat_offset += w;
	}
	cnum++;	

	for(cnt = 0;cnt<2;cnt++){
		dat_offset = y_s*w+x_s+cnum*cw;
		if(cnt == 0){
			wd = min/10;
		}else if(cnt == 1){
			wd = min%10;
		}
	
		ptb = ele_lib[wd];
		ktk = 0;
		dnum = 0;		
		for(itk = 0;itk < ch;itk++){
			for(jtk = 0;jtk < cw;jtk++){
				if(((ktk%8) == 0)&&(ktk != 0)){
					dnum++;
				}
				
				if(ptb[dnum]&BIT(7-ktk%8)){
					src[dat_offset+jtk] = 0xff;
					x_l = (dat_offset+jtk)%w;  //第几列
					y_l = (dat_offset+jtk)/w;  //第几行
					y_l = y_l/2;
					x_l = x_l/2;
					y_l = y_l*(w/2)+x_l;
					src[w*h+y_l] = 0x80;
					src[w*h+w*h/4+y_l] = 0x80;
				}else{
				}
				ktk++;
			}
			dat_offset += w;
		}
		cnum++;
	}
	dat_offset = y_s*w+x_s+cnum*cw;
	ptb = ele_lib[11];    // ‘ ’
	ktk = 0;
	dnum = 0;	
	for(itk = 0;itk < ch;itk++){
		for(jtk = 0;jtk < cw;jtk++){
			if(((ktk%8) == 0)&&(ktk != 0)){
				dnum++;
			}
			
			if(ptb[dnum]&BIT(7-ktk%8)){
				src[dat_offset+jtk] = 0xff;
				x_l = (dat_offset+jtk)%w;  //第几列
				y_l = (dat_offset+jtk)/w;  //第几行
				y_l = y_l/2;
				x_l = x_l/2;
				y_l = y_l*(w/2)+x_l;
				src[w*h+y_l] = 0x80;
				src[w*h+w*h/4+y_l] = 0x80;
			}else{
			}
			ktk++;
		}
		dat_offset += w;
	}
	cnum++;	
	for(cnt = 0;cnt<2;cnt++){
		dat_offset = y_s*w+x_s+cnum*cw;
		if(cnt == 0){
			wd = sec/10;
		}else if(cnt == 1){
			wd = sec%10;
		}
	
		ptb = ele_lib[wd];
		ktk = 0;
		dnum = 0;		
		for(itk = 0;itk < ch;itk++){
			for(jtk = 0;jtk < cw;jtk++){
				if(((ktk%8) == 0)&&(ktk != 0)){
					dnum++;
				}
				
				if(ptb[dnum]&BIT(7-ktk%8)){
					src[dat_offset+jtk] = 0xff;
					x_l = (dat_offset+jtk)%w;  //第几列
					y_l = (dat_offset+jtk)/w;  //第几行
					y_l = y_l/2;
					x_l = x_l/2;
					y_l = y_l*(w/2)+x_l;
					src[w*h+y_l] = 0x80;
					src[w*h+w*h/4+y_l] = 0x80;
				}else{
				}
				ktk++;
			}
			dat_offset += w;
		}
		cnum++;
	}

	
}


struct hgdvp_hw  *dvp_watch;
bool csi_yuv_mode(){
	static _Sensor_Adpt_ *p_sensor_cmd = NULL;
	struct scale_device *scale_dev;
	struct i2c_setting i2c_setting;
	int8 idbuf[8];
	uint8_t itk=0;
	uint32 i=0;
	uint8 adr_num,dat_num;
	uint8 sen_w_cmd,sen_r_cmd,id_c = 0;	
	uint16 image_w,image_h;
	
	dvp_test = (struct dvp_device *)dev_get(HG_DVP_DEVID);
	vpp_test = (struct vpp_device *)dev_get(HG_VPP_DEVID);
	iic_test = (struct i2c_device *)dev_get(HG_I2C2_DEVID);	
	scale_dev = (struct scale_device *)dev_get(HG_SCALE1_DEVID);
 
	dvp_init(dvp_test);

//1:init iic
	os_printf("csi_test start,iic init\r\n");

	//iic_init_sensor(IIC_CLK,SENSOR_IIC);
	i2c_open(iic_test, IIC_MODE_MASTER, IIC_ADDR_7BIT, 0);
	i2c_set_baudrate(iic_test,IIC_CLK);
	i2c_ioctl(iic_test,IIC_SDA_OUTPUT_DELAY,20);	
	i2c_ioctl(iic_test,IIC_FILTERING,20);
	i2c_ioctl(iic_test,IIC_STRONG_OUTPUT,1);

	//i2c_send_stop(iic_test);
	os_printf("iic init finish,sensor reset & set sensor clk into 6M\r\n");
//2:init sensor
	dvp_set_baudrate(dvp_test,6000000); 
	os_sleep_ms(3);

	os_printf("set sensor finish ,Auto Check sensor id\r\n");
	p_sensor_cmd = snser.p_sensor_cmd = sensorAutoCheck(iic_test,NULL);
	if(p_sensor_cmd == NULL){
		return FALSE;
	}
	os_printf("Auto Check sensor id finish\r\n");
	i2c_setting.u8DevWriteAddr = p_sensor_cmd->w_cmd;
	i2c_setting.u8DevReadAddr = p_sensor_cmd->r_cmd;
	i2c_SetSetting(&i2c_setting);
	
	os_printf("mclk:%dMHz\r\n",p_sensor_cmd->mclk);
	
	
	//sensor_ClockInit(((struct hgdvp*)dvp_test)->hw,p_sensor_cmd->mclk);
	dvp_set_baudrate(dvp_test,p_sensor_cmd->mclk);

	os_printf("init:%x u8Addrbytnum:%d,u8Databytnum:%d\r\n",(uint32)p_sensor_cmd->init,u8Addrbytnum,u8Databytnum);
    if(p_sensor_cmd->init!=NULL)
	{
			
			os_printf("SENSER....init\r\n");
			for(i=0;;i+=u8Addrbytnum+u8Databytnum)
			{
				if((p_sensor_cmd->init[i]==0xFF)&&(p_sensor_cmd->init[i+1]==0xFF)){
					os_printf("init table num:%d\r\n",i);
					break;
				}
	
				if((p_sensor_cmd->init[i]==0xFE)&&(p_sensor_cmd->init[i+1]==0xFE)){
					if(p_sensor_cmd->init[i+2]==0x01){
						os_sleep_ms(100);
					}
				}
				else{
					for(itk = 0;itk < u8Addrbytnum+u8Databytnum;itk++){
						idbuf[itk] = p_sensor_cmd->init[i+itk];
					}
					i2c_write(iic_test, (int8*)&idbuf[0], u8Addrbytnum, (int8*)&idbuf[u8Addrbytnum], u8Databytnum);
					if(i==0)
					{
						os_sleep_ms(1);
					}
				}
			}		
	
			if(p_sensor_cmd->p_xc7016_adapt.sensor_init_table != NULL)
			{
				adr_num = p_sensor_cmd->p_xc7016_adapt.addr_num;
				dat_num = p_sensor_cmd->p_xc7016_adapt.data_num;
				sen_w_cmd = u8SensorwriteID;
				sen_r_cmd = u8SensorreadID;
				u8SensorwriteID = p_sensor_cmd->p_xc7016_adapt.w_cmd;
				u8SensorreadID	= p_sensor_cmd->p_xc7016_adapt.r_cmd;
				idbuf[0] = p_sensor_cmd->p_xc7016_adapt.id_reg;		
				//id_c = i2c_sensor_read(iic_test,idbuf,adr_num,dat_num,u8SensorwriteID,u8SensorreadID);
				i2c_ioctl(iic_test,IIC_SET_DEVICE_ADDR,u8SensorwriteID>>1);
				i2c_read(iic_test,idbuf,adr_num,(int8*)&id_c,dat_num);
				os_printf("\r\nchildren SID: %x %x %x\r\n",id_c,u8SensorwriteID,u8SensorreadID);			
				for(i=0;;i+=adr_num+dat_num)
				{
					if((p_sensor_cmd->p_xc7016_adapt.sensor_init_table[i]==0xFF)&&(p_sensor_cmd->p_xc7016_adapt.sensor_init_table[i+1]==0xFF)){
						os_printf("sensor table num:%d\r\n",i);
						break;
					}

					for(itk = 0;itk < adr_num+dat_num;itk++){
						idbuf[itk] = p_sensor_cmd->p_xc7016_adapt.sensor_init_table[i+itk];
					}
					i2c_write(iic_test, (int8*)&idbuf[0], adr_num, (int8*)&idbuf[adr_num], dat_num);
					if(i==0)
					{
						os_sleep_ms(1);
					}
				}	
				u8SensorwriteID = sen_w_cmd;
				u8SensorreadID	= sen_r_cmd;
				i2c_ioctl(iic_test,IIC_SET_DEVICE_ADDR,u8SensorwriteID>>1);
				for(i=0;;i+=u8Addrbytnum+u8Databytnum)
				{
					if((p_sensor_cmd->p_xc7016_adapt.bypass_off[i]==0xFF)&&(p_sensor_cmd->p_xc7016_adapt.bypass_off[i+1]==0xFF)){
						os_printf("bypass table num:%d\r\n",i);
						break;
					}
					for(itk = 0;itk < u8Addrbytnum+u8Databytnum;itk++){
						idbuf[itk] = p_sensor_cmd->p_xc7016_adapt.bypass_off[i+itk];
					}					
					i2c_write(iic_test, (int8*)&idbuf[0], u8Addrbytnum, (int8*)&idbuf[u8Addrbytnum], u8Databytnum);
					if(i==0)
					{
						os_sleep_ms(1);
					}
				}			
				
			}
			
	}
	i2c_close(iic_test);
	
	os_printf("SENSR ident ok:%d*%d\r\n",p_sensor_cmd->pixelw,p_sensor_cmd->pixelh);

#if SCEN_EN	
	image_h = p_sensor_cmd->pixelh/2;
	image_w = p_sensor_cmd->pixelw/2;
#else
	image_h = p_sensor_cmd->pixelh;
	image_w = p_sensor_cmd->pixelw;
#endif
	photo_msg.in_h  = image_h;
	photo_msg.in_w  = image_w;
	photo_msg.out0_h = image_h;
	photo_msg.out0_w = image_w;

//3:init csi

	os_printf("csi init start  --\r\n");
	os_printf("csi set size ====>%d*%d\r\n",image_w,image_h);
	if(yuvbuf == NULL){
		yuvbuf = os_malloc(p_sensor_cmd->pixelw*32+p_sensor_cmd->pixelw*32/2);
		if(yuvbuf == NULL){
			_os_printf("no room yuvbuf0\r\n");
			return FALSE;
		}
	}
	
#if SCEN_EN	
	//dvp_set_size(dvp_test,0,0,image_w*2-1,image_h*2-1);
	vpp_set_video_size(vpp_test,image_w*2,image_h*2);
#else
	os_printf("csi dvp_size_set\r\n");
	//dvp_set_size(dvp_test,0,0,image_w-1,image_h-1);
	vpp_set_video_size(vpp_test,image_w,image_h);
#endif

#if SCEN_EN	
	dvp_set_half_size(dvp_test,1);
#endif 

	//dvp_set_exchange_d5_d6(dvp_test,0);

	dvp_set_hsync_polarity(dvp_test,p_sensor_cmd->hsyn);
	dvp_set_vsync_polarity(dvp_test,p_sensor_cmd->vsyn);
	dvp_set_format(dvp_test,IMAGE_FORMAT);

	
	vpp_set_ycbcr(vpp_test,YUV_MODE);
#if     (ONLY_Y == 1)
	vpp_dis_uv_mode(vpp_test,1);
#endif

	vpp_set_threshold(vpp_test,0x00000000,0x00ffffff);

#if VPP_BUF1_EN
	if(yuvbuf1 == NULL)
		yuvbuf1 = os_malloc(p_sensor_cmd->pixelw/2*32+p_sensor_cmd->pixelw/2*16);
	if(yuvbuf1 == NULL){
		_os_printf("no room yuvbuf1\r\n");
		return FALSE;
	}

	vpp_set_buf1_count(vpp_test,8);
	vpp_set_buf1_en(vpp_test,1);
	vpp_set_buf1_shrink(vpp_test,1);
	vpp_set_buf1_y_addr(vpp_test,(uint32)yuvbuf1);
	vpp_set_buf1_u_addr(vpp_test,(uint32)yuvbuf1+(p_sensor_cmd->pixelw/2)*32);
	vpp_set_buf1_v_addr(vpp_test,(uint32)yuvbuf1+(p_sensor_cmd->pixelw/2)*32+(p_sensor_cmd->pixelw/2)*8);
	photo_msg.out1_h = image_h/2;
	photo_msg.out1_w = image_w/2;
#endif

	vpp_set_buf0_count(vpp_test,8);    //2==16+2*2 = 20

#if    (ONLY_Y == 1)
	vpp_set_buf0_y_addr(vpp_test,(uint32)psram_buf);
#else
	vpp_set_buf0_y_addr(vpp_test,(uint32)yuvbuf);
	vpp_set_buf0_u_addr(vpp_test,(uint32)yuvbuf+p_sensor_cmd->pixelw*32);
	vpp_set_buf0_v_addr(vpp_test,(uint32)yuvbuf+p_sensor_cmd->pixelw*32+p_sensor_cmd->pixelw*8);
#endif
	
	vpp_set_water0_color(vpp_test,0xff,0x80,0x80);
	vpp_set_water0_bitmap(vpp_test,(uint32)ele_lib);
	vpp_set_water0_locate(vpp_test,50,36);
	vpp_set_water0_contrast(vpp_test,0);
	vpp_set_watermark0_charsize_and_num(vpp_test,12,32,19);
	vpp_set_watermark0_mode(vpp_test,1);
	set_time_watermark(2222,22,22,22,22,22);
	vpp_set_water0_rc(vpp_test,0);


	
	vpp_set_water1_color(vpp_test,0xff,0x80,0x80);
	vpp_set_water1_bitmap(vpp_test,(uint32)photo_lib2);
	vpp_set_water1_locate(vpp_test,45,30);
	vpp_set_water1_contrast(vpp_test,0);
	vpp_set_watermark1_size(vpp_test,48,48);
	vpp_set_watermark1_mode(vpp_test,0);
	vpp_set_water1_rc(vpp_test,0);
	
	dvp_set_exchange_d5_d6(dvp_test,0);
	
	os_printf("csi IRQ init\r\n");
	dvp_request_irq(dvp_test,SII_ISR, (dvp_irq_hdl )&dvp_sip_isr,0);
	dvp_request_irq(dvp_test,FOVIE_ISR,(dvp_irq_hdl )&dvp_fovie_isr,0);

	vpp_request_irq(vpp_test,HSIE_ISR,(vpp_irq_hdl )&vpp_hsie_isr,(uint32)image_h);
	vpp_request_irq(vpp_test,VSIE_ISR,(vpp_irq_hdl )&vpp_vsie_isr,0);
	vpp_request_irq(vpp_test,SCIE_ISR,(vpp_irq_hdl )&vpp_data_done,0);
	vpp_request_irq(vpp_test,LOVIE_ISR,(vpp_irq_hdl )&vpp_lib_error,0);
	vpp_request_irq(vpp_test,IPF_OV_ISR,(vpp_irq_hdl )&vpp_ipf_error,0);	
	vpp_request_irq(vpp_test,MDPIE_ISR,(vpp_irq_hdl )&vpp_md_find,0);
	vpp_request_irq(vpp_test,ITP_OV_ISR,(vpp_irq_hdl )&vpp_itp_error,0);
	vpp_request_irq(vpp_test,ITP_DONE_ISR,(vpp_irq_hdl )&vpp_itp_done,0);
	

#if IPF_EN
	vpp_set_ifp_addr(vpp_test,(uint32_t)vpp_encode_ipf);
#endif
#if DET_EN
	vpp_set_motion_calbuf(vpp_test,motion_detect_buf);
	vpp_set_motion_range(vpp_test,1,0,IMAGE_W,IMAGE_H);	
	vpp_set_motion_blk_threshold(vpp_test,20);
	vpp_set_motion_frame_threshold(vpp_test,10);
#endif
	vpp_set_mode(vpp_test,IMAGE_FORMAT);

	// vpp_set_watermark0_enable(vpp_test,1);
	// vpp_set_watermark1_enable(vpp_test,1);
	
#if IPF_EN
//	vpp_set_ifp_en(vpp_test,1);
#endif
#if DET_EN	
	vpp_set_motion_det_enable(vpp_test,1);
#endif

#if SCALE_TO_JPG
	scale_from_vpp_to_jpg(scale_dev,yuvbuf,photo_msg.in_w,photo_msg.in_h,SCALE_WIDTH_TO_JPEG,SCALE_HIGH_TO_JPEG);
	photo_msg.out0_h = SCALE_HIGH_TO_JPEG;
	photo_msg.out0_w = SCALE_WIDTH_TO_JPEG;
#endif

	vpp_open(vpp_test);
	//dvp_open(dvp_test);
	os_printf("csi IRQ init finish,start get data\r\n");
	return TRUE;
}

bool csi_cfg(){
	bool ret;
	ret = csi_yuv_mode();
	return ret;
}

void csi_room_del(){
	if(yuvbuf){
		os_free(yuvbuf);
	}
}

bool csi_open(){



	dvp_open(dvp_test);
	return 1;
}


#endif





