#include "lib/lcd/lcd.h"


#if LCD_ST7701S_EN

#define CMD(x)    {LCD_CMD,x}
#define DAT(x)    {LCD_DAT,x}
#define DLY(x)    {DELAY_MS,x}
#define END		{LCD_TAB_END,LCD_TAB_END}


const uint8_t st7701s_register_init_tab[][2] = {
	
	CMD(0x11),
	DLY(250),

	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x13),
	
	CMD(0xEF),
	DAT(0x08),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x10),
	
	CMD(0xC0),
	DAT(0xE9),
	DAT(0x03),
	
	CMD(0xC1),
	DAT(0x11),
	DAT(0x02),
	
	CMD(0xC2),
	DAT(0x07),
	DAT(0x06),

	CMD(0xC3),
	DAT(0x80),

	
	CMD(0xCC),
	DAT(0x18),
	
	CMD(0xB0),
	DAT(0x00),
	DAT(0x0D),
	DAT(0x14),
	DAT(0x0D),
	DAT(0x10),
	DAT(0x05),
	DAT(0x02),
	DAT(0x08),
	DAT(0x08),
	DAT(0x1E),
	DAT(0x05),
	DAT(0x13),
	DAT(0x11),
	DAT(0xA3),
	DAT(0x29),
	DAT(0x18),
	
	CMD(0xB1),
	DAT(0x00),
	DAT(0x0C),
	DAT(0x14),
	DAT(0x0C),
	DAT(0x10),
	DAT(0x05),
	DAT(0x03),
	DAT(0x08),
	DAT(0x07),
	DAT(0x20),
	DAT(0x05),
	DAT(0x13),
	DAT(0x11),
	DAT(0xA4),
	DAT(0x29),
	DAT(0x18),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x11),
	
	CMD(0xB0),
	DAT(0x6C),
	
	CMD(0xB1),
	DAT(0x4D),
	
	CMD(0xB2),
	DAT(0x89),
	
	CMD(0xB3),
	DAT(0x80),
	
	CMD(0xB5),
	DAT(0x4E),
	
	CMD(0xB7),
	DAT(0x85),
	
	CMD(0xB8),
	DAT(0x20),
	
	CMD(0xB9),
	DAT(0x00),
	DAT(0x13),
	
	CMD(0xC0),
	DAT(0x09),
	
	CMD(0xC1),
	DAT(0x78),
	
	CMD(0xC2),
	DAT(0x78),
	
	CMD(0xD0),
	DAT(0x88),
	
	CMD(0xE0),
	DAT(0x00),
	DAT(0x00),
	DAT(0x02),
	
	CMD(0xE1),
	DAT(0x08),
	DAT(0x00),
	DAT(0x0A),
	DAT(0x00),
	DAT(0x07),
	DAT(0x00),
	DAT(0x09),
	DAT(0x00),
	DAT(0x00),
	DAT(0x33),
	DAT(0x33),
	
	CMD(0xE2),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	
	CMD(0xE3),
	DAT(0x00),
	DAT(0x00),
	DAT(0x33),
	DAT(0x33),
	
	CMD(0xE4),
	DAT(0x44),
	DAT(0x44),
	
	CMD(0xE5),
	DAT(0x0E),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x10),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x0A),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x0C),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	
	CMD(0xE6),
	DAT(0x00),
	DAT(0x00),
	DAT(0x33),
	DAT(0x33),
	
	CMD(0xE7),
	DAT(0x44),
	DAT(0x44),
	
	CMD(0xE8),
	DAT(0x0D),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x0F),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x09),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x0B),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	
	CMD(0xEB),
	DAT(0x02),
	DAT(0x01),
	DAT(0xE4),
	DAT(0xE4),
	DAT(0x44),
	DAT(0x00),
	DAT(0x40),
	
	CMD(0xEC),
	DAT(0x02),
	DAT(0x01),
	
	CMD(0xED),
	DAT(0xAB),
	DAT(0x89),
	DAT(0x76),
	DAT(0x54),
	DAT(0x01),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0x10),
	DAT(0x45),
	DAT(0x67),
	DAT(0x98),
	DAT(0xBA),
	
	CMD(0xEF),
	DAT(0x08),
	DAT(0x08),
	DAT(0x08),
	DAT(0x45),
	DAT(0x3F),
	DAT(0x54),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x13),
	
	CMD(0xE8),
	DAT(0x00),
	DAT(0x0E),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	
	CMD(0x11),
	DAT(0x00),
	DLY (120), 
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x13),
	
	CMD(0xE8),
	DAT(0x00),
	DAT(0x0C),
	DLY (10), 
	CMD(0xE8),
	DAT(0x00),
	DAT(0x00),
	
	CMD(0xE6),
	DAT(0x16),
	DAT(0x7C),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	
	/*
	CMD(0xFF),//bist mode
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x12),
	
	CMD(0xD1),
	DAT(0x81),
	
	CMD(0xD2),
	DAT(0x06),//bist mode 0x00列灰阶分两半 02红03绿04蓝05白边框06棋盘格07黑底白像素网格08RGB彩条
	*/
	CMD(0x3A),
	DAT(0x55),
	
	
	CMD(0x29),
	DAT(0x00),
	DLY (20), 



	END

};


lcddev_t  lcdstruct = {
    .name = "st7701s",
    .lcd_bus_type = LCD_BUS_RGB,
    .bus_width = LCD_BUS_WIDTH_16,
    .color_mode = LCD_MODE_565,
	.osd_scan_mode = LCD_ROTATE_90,
    .scan_mode = LCD_ROTATE_90,//rotate 90
    .te_mode = 0xff,//te mode, 0xff:disable
    .colrarray = 0,//0:_RGB_ 1:_RBG_,2:_GBR_,3:_GRB_,4:_BRG_,5:_BGR_
    .pclk = 20000000,
    .even_order = 0,
    .odd_order = 0,

    .screen_w = 480,
    .screen_h = 848,
    .video_x  = 0,
    .video_y  = 0,
    .video_w  = 480,
    .video_h  = 848,
	.osd_x = 0,
	.osd_y = 0,
	.osd_w = 480, // 0 : value will set to video_w  , use for 4:3 LCD +16:9 sensor show UPDOWN BLACK
	.osd_h = 848, // 0 : value will set to video_h  , use for 4:3 LCD +16:9 sensor show UPDOWN BLACK
	.init_table = st7701s_register_init_tab,

    .pclk_inv = 1,

    .vlw 			= 10,
    .vbp 			= 6,
    .vfp 			= 10,


    .hlw 			= 8,
    .hbp 			= 8,
    .hfp 			= 30,

	
	.de_inv = 0,
	.hs_inv = 1,
	.vs_inv = 1,


	.de_en  = 1,
	.vs_en	= 1,
	.hs_en	= 1,

};

#endif
