#include "lib/lcd/lcd.h"


#if LCD_GC9503V_EN

#define CMD(x)    {LCD_CMD,x}
#define DAT(x)    {LCD_DAT,x}
#define DLY(x)    {DELAY_MS,x}
#define END		{LCD_TAB_END,LCD_TAB_END}


const uint8_t gc9503v_register_init_tab[][2] = {
	
#if 1
	CMD(0x11),
	DLY(250),

	CMD(0xF0),DAT(0x55),DAT(0xaa),DAT(0x52),DAT(0x08),DAT(0x00),
	DLY(10),CMD(0xF6),DAT(0x5a),DAT(0x87),
	DLY(10),CMD(0xF0),DAT(0x55),DAT(0xaa),DAT(0x52),DAT(0x08),DAT(0x00),
	DLY(10),CMD(0xF6),DAT(0x5a),DAT(0x87),
	DLY(10),CMD(0xF6),DAT(0x5a),DAT(0x87),
	CMD(0xC1),DAT(0x3F),
	CMD(0xC2),DAT(0x0E),
	CMD(0xC6),DAT(0xF8),
	CMD(0xc9),DAT(0x10),
	CMD(0xcD),DAT(0x25),
	CMD(0x87),DAT(0x04),DAT(0x03),DAT(0x66),
	CMD(0x86),DAT(0x99),DAT(0xa3),DAT(0xa3),DAT(0x31),
	CMD(0xf8),DAT(0x8a),
	CMD(0xac),DAT(0x45),
	CMD(0xA7),DAT(0x47),
	CMD(0xA0),DAT(0xcc),
	CMD(0xa3),DAT(0x22),
	CMD(0xFd),DAT(0x28),DAT(0x3c),DAT(0x00),
	CMD(0x71),DAT(0x48),
	CMD(0x72),DAT(0x48),
	CMD(0x73),DAT(0x00),DAT(0x44),
	CMD(0x97),DAT(0xdd),
	CMD(0x83),DAT(0x93),
	CMD(0x9A),DAT(0x80),
	CMD(0x9B),DAT(0x58),
	CMD(0x82),DAT(0x36),DAT(0x36),
	CMD(0xFA),DAT(0x08),DAT(0x08),DAT(0x08),DAT(0x04),
	CMD(0xB0),DAT(0x80),DAT(0x0E),DAT(0x0E),DAT(0x14),DAT(0x04),
	CMD(0xB1),DAT(0x04),
	CMD(0x7A),DAT(0x13),DAT(0x1A),
	CMD(0x7B),DAT(0x13),DAT(0x1A),
	#if 1
	CMD(0x6D),DAT(0x1E),DAT(0x1E),DAT(0x1E),DAT(0x1D),DAT(0x00),DAT(0x07),DAT(0x01),DAT(0x1E),DAT(0x04),DAT(0x1F),DAT(0x0D),DAT(0x0F),DAT(0x09),DAT(0x0B),DAT(0x1E),DAT(0x1E),DAT(0x1E),DAT(0x1E),DAT(0x0C),DAT(0x0A),DAT(0x10),DAT(0x0E),DAT(0x1F),DAT(0x04),DAT(0x1E),DAT(0x02),DAT(0x08),DAT(0x00),DAT(0x1D),DAT(0x1E),DAT(0x1E),DAT(0x1E),
	CMD(0x60),DAT(0x38),DAT(0x0c),DAT(0x2d),DAT(0x6d),DAT(0x38),DAT(0x0b),DAT(0x2d),DAT(0x6d),
	CMD(0x61),DAT(0x18),DAT(0x02),DAT(0x2d),DAT(0x6d),DAT(0x78),DAT(0x18),DAT(0x2d),DAT(0x6d),
	CMD(0x62),DAT(0x78),DAT(0x18),DAT(0x2d),DAT(0x6d),DAT(0x18),DAT(0x02),DAT(0x2d),DAT(0x6d),
	CMD(0x63),DAT(0x38),DAT(0x0a),DAT(0x2d),DAT(0x6d),DAT(0x38),DAT(0x09),DAT(0x2d),DAT(0x6d),
	CMD(0x64),DAT(0x38),DAT(0x08),DAT(0x02),DAT(0x80),DAT(0x03),DAT(0x03),DAT(0x38),DAT(0x07),DAT(0x02),DAT(0x81),DAT(0x03),DAT(0x03),DAT(0x2d),DAT(0x6d),DAT(0x2d),DAT(0x6d),
	CMD(0x65),DAT(0x38),DAT(0x06),DAT(0x02),DAT(0x82),DAT(0x03),DAT(0x03),DAT(0x38),DAT(0x05),DAT(0x02),DAT(0x83),DAT(0x03),DAT(0x03),DAT(0x2d),DAT(0x6d),DAT(0x2d),DAT(0x6d),
	CMD(0x66),DAT(0x38),DAT(0x04),DAT(0x02),DAT(0x84),DAT(0x03),DAT(0x03),DAT(0x38),DAT(0x03),DAT(0x02),DAT(0x85),DAT(0x03),DAT(0x03),DAT(0x2d),DAT(0x6d),DAT(0x2d),DAT(0x6d),
	CMD(0x67),DAT(0x38),DAT(0x02),DAT(0x02),DAT(0x86),DAT(0x03),DAT(0x03),DAT(0x38),DAT(0x01),DAT(0x02),DAT(0x87),DAT(0x03),DAT(0x03),DAT(0x2d),DAT(0x6d),DAT(0x2d),DAT(0x6d),
	#endif 
	CMD(0x69),DAT(0x14),DAT(0x22),DAT(0x14),DAT(0x22),DAT(0x14),DAT(0x22),DAT(0x08),
	CMD(0x6b),DAT(0x07),
	#if 1
	CMD(0xD1),DAT(0x00),DAT(0x00),DAT(0x00),DAT(0x1D),DAT(0x00),DAT(0x4D),DAT(0x00),DAT(0x70),DAT(0x00),DAT(0x90),DAT(0x00),DAT(0xC3),DAT(0x00),DAT(0xE8),DAT(0x01),DAT(0x1B),DAT(0x01),DAT(0x4C),DAT(0x01),DAT(0xA2),DAT(0x01),DAT(0xE0),DAT(0x02),DAT(0x43),DAT(0x02),DAT(0x8E),DAT(0x02),DAT(0x90),DAT(0x02),DAT(0xD3),DAT(0x03),DAT(0x18),DAT(0x03),DAT(0x43),DAT(0x03),DAT(0x81),DAT(0x03),DAT(0xA4),DAT(0x03),DAT(0xBA),DAT(0x03),DAT(0xC9),DAT(0x03),DAT(0xDC),DAT(0x03),DAT(0xE7),DAT(0x03),DAT(0xF4),DAT(0x03),DAT(0xFC),DAT(0x03),DAT(0xFF),
	CMD(0xD2),DAT(0x00),DAT(0x00),DAT(0x00),DAT(0x1D),DAT(0x00),DAT(0x4D),DAT(0x00),DAT(0x70),DAT(0x00),DAT(0x90),DAT(0x00),DAT(0xC3),DAT(0x00),DAT(0xE8),DAT(0x01),DAT(0x1B),DAT(0x01),DAT(0x4C),DAT(0x01),DAT(0xA2),DAT(0x01),DAT(0xE0),DAT(0x02),DAT(0x43),DAT(0x02),DAT(0x8E),DAT(0x02),DAT(0x90),DAT(0x02),DAT(0xD3),DAT(0x03),DAT(0x18),DAT(0x03),DAT(0x43),DAT(0x03),DAT(0x81),DAT(0x03),DAT(0xA4),DAT(0x03),DAT(0xBA),DAT(0x03),DAT(0xC9),DAT(0x03),DAT(0xDC),DAT(0x03),DAT(0xE7),DAT(0x03),DAT(0xF4),DAT(0x03),DAT(0xFC),DAT(0x03),DAT(0xFF),
	CMD(0xD3),DAT(0x00),DAT(0x00),DAT(0x00),DAT(0x1D),DAT(0x00),DAT(0x4D),DAT(0x00),DAT(0x70),DAT(0x00),DAT(0x90),DAT(0x00),DAT(0xC3),DAT(0x00),DAT(0xE8),DAT(0x01),DAT(0x1B),DAT(0x01),DAT(0x4C),DAT(0x01),DAT(0xA2),DAT(0x01),DAT(0xE0),DAT(0x02),DAT(0x43),DAT(0x02),DAT(0x8E),DAT(0x02),DAT(0x90),DAT(0x02),DAT(0xD3),DAT(0x03),DAT(0x18),DAT(0x03),DAT(0x43),DAT(0x03),DAT(0x81),DAT(0x03),DAT(0xA4),DAT(0x03),DAT(0xBA),DAT(0x03),DAT(0xC9),DAT(0x03),DAT(0xDC),DAT(0x03),DAT(0xE7),DAT(0x03),DAT(0xF4),DAT(0x03),DAT(0xFC),DAT(0x03),DAT(0xFF),
	CMD(0xD4),DAT(0x00),DAT(0x00),DAT(0x00),DAT(0x1D),DAT(0x00),DAT(0x4D),DAT(0x00),DAT(0x70),DAT(0x00),DAT(0x90),DAT(0x00),DAT(0xC3),DAT(0x00),DAT(0xE8),DAT(0x01),DAT(0x1B),DAT(0x01),DAT(0x4C),DAT(0x01),DAT(0xA2),DAT(0x01),DAT(0xE0),DAT(0x02),DAT(0x43),DAT(0x02),DAT(0x8E),DAT(0x02),DAT(0x90),DAT(0x02),DAT(0xD3),DAT(0x03),DAT(0x18),DAT(0x03),DAT(0x43),DAT(0x03),DAT(0x81),DAT(0x03),DAT(0xA4),DAT(0x03),DAT(0xBA),DAT(0x03),DAT(0xC9),DAT(0x03),DAT(0xDC),DAT(0x03),DAT(0xE7),DAT(0x03),DAT(0xF4),DAT(0x03),DAT(0xFC),DAT(0x03),DAT(0xFF),
	CMD(0xD5),DAT(0x00),DAT(0x00),DAT(0x00),DAT(0x1D),DAT(0x00),DAT(0x4D),DAT(0x00),DAT(0x70),DAT(0x00),DAT(0x90),DAT(0x00),DAT(0xC3),DAT(0x00),DAT(0xE8),DAT(0x01),DAT(0x1B),DAT(0x01),DAT(0x4C),DAT(0x01),DAT(0xA2),DAT(0x01),DAT(0xE0),DAT(0x02),DAT(0x43),DAT(0x02),DAT(0x8E),DAT(0x02),DAT(0x90),DAT(0x02),DAT(0xD3),DAT(0x03),DAT(0x18),DAT(0x03),DAT(0x43),DAT(0x03),DAT(0x81),DAT(0x03),DAT(0xA4),DAT(0x03),DAT(0xBA),DAT(0x03),DAT(0xC9),DAT(0x03),DAT(0xDC),DAT(0x03),DAT(0xE7),DAT(0x03),DAT(0xF4),DAT(0x03),DAT(0xFC),DAT(0x03),DAT(0xFF),
	CMD(0xD6),DAT(0x00),DAT(0x00),DAT(0x00),DAT(0x1D),DAT(0x00),DAT(0x4D),DAT(0x00),DAT(0x70),DAT(0x00),DAT(0x90),DAT(0x00),DAT(0xC3),DAT(0x00),DAT(0xE8),DAT(0x01),DAT(0x1B),DAT(0x01),DAT(0x4C),DAT(0x01),DAT(0xA2),DAT(0x01),DAT(0xE0),DAT(0x02),DAT(0x43),DAT(0x02),DAT(0x8E),DAT(0x02),DAT(0x90),DAT(0x02),DAT(0xD3),DAT(0x03),DAT(0x18),DAT(0x03),DAT(0x43),DAT(0x03),DAT(0x81),DAT(0x03),DAT(0xA4),DAT(0x03),DAT(0xBA),DAT(0x03),DAT(0xC9),DAT(0x03),DAT(0xDC),DAT(0x03),DAT(0xE7),DAT(0x03),DAT(0xF4),DAT(0x03),DAT(0xFC),DAT(0x03),DAT(0xFF),
	#endif
	CMD(0x3A),DAT(0x66),

	DLY(200),  CMD(0x11),DAT(0x00),
	DLY(200),  CMD(0x29),DAT(0x00),
	END
#else
	CMD(0x11),
	DLY(250),

	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x13),
	
	CMD(0xEF),
	DAT(0x08),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x10),
	
	CMD(0xC0),
	DAT(0xE9),
	DAT(0x03),
	
	CMD(0xC1),
	DAT(0x11),
	DAT(0x02),
	
	CMD(0xC2),
	DAT(0x07),
	DAT(0x06),

	CMD(0xC3),
	DAT(0x00),

	
	CMD(0xCC),
	DAT(0x18),
	
	CMD(0xB0),
	DAT(0x00),
	DAT(0x0D),
	DAT(0x14),
	DAT(0x0D),
	DAT(0x10),
	DAT(0x05),
	DAT(0x02),
	DAT(0x08),
	DAT(0x08),
	DAT(0x1E),
	DAT(0x05),
	DAT(0x13),
	DAT(0x11),
	DAT(0xA3),
	DAT(0x29),
	DAT(0x18),
	
	CMD(0xB1),
	DAT(0x00),
	DAT(0x0C),
	DAT(0x14),
	DAT(0x0C),
	DAT(0x10),
	DAT(0x05),
	DAT(0x03),
	DAT(0x08),
	DAT(0x07),
	DAT(0x20),
	DAT(0x05),
	DAT(0x13),
	DAT(0x11),
	DAT(0xA4),
	DAT(0x29),
	DAT(0x18),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x11),
	
	CMD(0xB0),
	DAT(0x6C),
	
	CMD(0xB1),
	DAT(0x8D),
	
	CMD(0xB2),
	DAT(0x89),
	
	CMD(0xB3),
	DAT(0x80),
	
	CMD(0xB5),
	DAT(0x4E),
	
	CMD(0xB7),
	DAT(0x85),
	
	CMD(0xB8),
	DAT(0x20),
	
	CMD(0xB9),
	DAT(0x00),
	DAT(0x13),
	
	CMD(0xC0),
	DAT(0x09),
	
	CMD(0xC1),
	DAT(0x78),
	
	CMD(0xC2),
	DAT(0x78),
	
	CMD(0xD0),
	DAT(0x88),
	
	CMD(0xE0),
	DAT(0x00),
	DAT(0x00),
	DAT(0x02),
	
	CMD(0xE1),
	DAT(0x08),
	DAT(0x00),
	DAT(0x0A),
	DAT(0x00),
	DAT(0x07),
	DAT(0x00),
	DAT(0x09),
	DAT(0x00),
	DAT(0x00),
	DAT(0x33),
	DAT(0x33),
	
	CMD(0xE2),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	
	CMD(0xE3),
	DAT(0x00),
	DAT(0x00),
	DAT(0x33),
	DAT(0x33),
	
	CMD(0xE4),
	DAT(0x44),
	DAT(0x44),
	
	CMD(0xE5),
	DAT(0x0E),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x10),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x0A),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x0C),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	
	CMD(0xE6),
	DAT(0x00),
	DAT(0x00),
	DAT(0x33),
	DAT(0x33),
	
	CMD(0xE7),
	DAT(0x44),
	DAT(0x44),
	
	CMD(0xE8),
	DAT(0x0D),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x0F),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x09),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	DAT(0x0B),
	DAT(0x60),
	DAT(0xA0),
	DAT(0xA0),
	
	CMD(0xEB),
	DAT(0x02),
	DAT(0x01),
	DAT(0xE4),
	DAT(0xE4),
	DAT(0x44),
	DAT(0x00),
	DAT(0x40),
	
	CMD(0xEC),
	DAT(0x02),
	DAT(0x01),
	
	CMD(0xED),
	DAT(0xAB),
	DAT(0x89),
	DAT(0x76),
	DAT(0x54),
	DAT(0x01),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0xFF),
	DAT(0x10),
	DAT(0x45),
	DAT(0x67),
	DAT(0x98),
	DAT(0xBA),
	
	CMD(0xEF),
	DAT(0x08),
	DAT(0x08),
	DAT(0x08),
	DAT(0x45),
	DAT(0x3F),
	DAT(0x54),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x13),
	
	CMD(0xE8),
	DAT(0x00),
	DAT(0x0E),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	
	CMD(0x11),
	DAT(0x00),
	DLY (120), 
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x13),
	
	CMD(0xE8),
	DAT(0x00),
	DAT(0x0C),
	DLY (10), 
	CMD(0xE8),
	DAT(0x00),
	DAT(0x00),
	
	CMD(0xE6),
	DAT(0x16),
	DAT(0x7C),
	
	CMD(0xFF),
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x00),
	
	/*
	CMD(0xFF),//bist mode
	DAT(0x77),
	DAT(0x01),
	DAT(0x00),
	DAT(0x00),
	DAT(0x12),
	
	CMD(0xD1),
	DAT(0x81),
	
	CMD(0xD2),
	DAT(0x06),//bist mode 0x00列灰阶分两半 02红03绿04蓝05白边框06棋盘格07黑底白像素网格08RGB彩条
	*/
	CMD(0x3A),
	DAT(0x55),
	
	
	CMD(0x29),
	DAT(0x00),
	DLY (20), 



	END
#endif
};


lcddev_t  lcdstruct = {
    .name = "gc9503v",
    .lcd_bus_type = LCD_BUS_RGB,
    .bus_width = LCD_BUS_WIDTH_18,
    .color_mode = LCD_MODE_666,
	.osd_scan_mode = LCD_ROTATE_90,
    .scan_mode = LCD_ROTATE_90,//rotate 90  LCD_ROTATE_0
    .te_mode = 0xff,//te mode, 0xff:disable
    .colrarray = 0,//0:_RGB_ 1:_RBG_,2:_GBR_,3:_GRB_,4:_BRG_,5:_BGR_
    .pclk = 20000000,
    .even_order = 0,
    .odd_order = 0,

    .screen_w = 360,
    .screen_h = 640,
    .video_x  = 0,
    .video_y  = 0,
    .video_w  = 360,
    .video_h  = 640,
	.osd_x = 0,
	.osd_y = 0,
	.osd_w = 360, // 0 : value will set to video_w  , use for 4:3 LCD +16:9 sensor show UPDOWN BLACK
	.osd_h = 640,// 0 : value will set to video_h  , use for 4:3 LCD +16:9 sensor show UPDOWN BLACK
	.init_table = gc9503v_register_init_tab,

    .pclk_inv = 1,

    .vlw 			= 1,
    .vbp 			= 14,
    .vfp 			= 14,


    .hlw 			= 1,
    .hbp 			= 20,
    .hfp 			= 4,

	
	.de_inv = 0,
	.hs_inv = 1,
	.vs_inv = 1,


	.de_en  = 1,
	.vs_en	= 1,
	.hs_en	= 1,

};

#endif
