#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"

#if DEV_SENSOR_XC7016_H63



//XC7016_Init_IQ_regs
//XC7016_bypass_on
//h63_Init_regs[]
//XC7016_bypass_off




SENSOR_INIT_SECTION static const unsigned char XC7016_bypass_on[] = {

	0xff,0xfd,0x80,
	0xff,0xfe,0x50,
	0x00,0x4d,0x01,
	-1,-1,

};

SENSOR_INIT_SECTION static const unsigned char  XC7016_bypass_off[] = {

	0xff,0xfd,0x80,
	0xff,0xfe,0x50,
	0x00,0x4d,0x00,
	-1,-1,

};


SENSOR_INIT_SECTION static const unsigned char XC7016_IQ_InitTable[CMOS_INIT_LEN] = 
{
	                                                    
															
	0xff,0xfd, 0x80,
		
	//**,0x**********************************************************//
	//**,0x******** Step 1 system shut down !!! DONT TOUCH !!! ******//
	//**,0x**********************************************************//
	// 1,0x.1 shut down CIF  ( /*READ ONLY*/)
	0xff,0xfd, 0x80,
	0xff,0xfe, 0x20,
	0x00,0x02, 0x00,//[7]output_enable
	0x00,0x2d, 0x00,//[0]delay counter bypass
	0x00,0x2c, 0x01,//[0]delay counter clear
		
	// 1,0x.2 switch back to ref_clk ( /*READ ONLY*/)
	0xff,0xfe,0x50,
	0x00,0x20,0x02,//sys_clk
	0x00,0x21,0x08,
	0x00,0x22,0x02,//isp_clk
	0x00,0x23,0x00,
	0x00,0x24,0x01,//cclk
	0x00,0x25,0x00,
	0x00,0x26,0x02,//dvp_clk
	0x00,0x27,0x00,
	0x00,0x2c,0x01,//tve_clk
	0x00,0x2d,0x00,
	0x00,0x2e,0x00,
	0x00,0x2f,0x01,
	0x00,0x64,0x04,//pwm
	0x00,0x65,0x00,
	0x00,0x66,0x04,
	0x00,0x67,0x00,
	0x00,0x68,0x04,//adc
	0x00,0x69,0x04,
	0x00,0x6a,0x04,//coax
	0x00,0x6b,0x00,
	0x00,0x6c,0x04,//avl
	0x00,0x6d,0x00,
	0x00,0x6e,0x01,//psram
	0x00,0x6f,0x00,
		
	// 1,0x.3 reset clock  ( /*READ ONLY*/)
	0x00,0x18,0x00,
	0x00,0x19,0xf0,
	0x00,0x1a,0xff,
	0x00,0x1b,0xff,
		
	//**,0x**********************************************************//
	//**,0x******** Step 2 reconfig system !!! DONT TOUCH !!! *******//
	//**,0x**********************************************************//
	// 2,0x.1 config pll  ( /*CFG*/)
	0xff,0xfe,0x50,
	0x00,0x30,0x44,
	0x00,0x31,0x2c,
	0x00,0x32,0xb5,
	0x00,0x33,0x60,
		
	// 2,0x.2 wait pll lock  ( /*READ ONLY*/)
	0xfe,0xfe, 0xf0,
	0xfe,0xfe, 0x01,  //delay 1ms
	0xfe,0xfe, 0xf1,
		
	// 2,0x.3 config function clock ( /*CFG*/)
	0xff,0xfe,0x50,
	0x00,0x20,0x04,//sys_clk
	0x00,0x21,0x0e,
	0x00,0x22,0x02,//isp_clk
	0x00,0x23,0x06,
	0x00,0x24,0x01,//cclk
	0x00,0x25,0x00,
	0x00,0x26,0x04,//dvp_clk
	0x00,0x27,0x06,
	0x00,0x2c,0x02,//tve_clk
	0x00,0x2d,0x36,
	0x00,0x2e,0x00,
	0x00,0x2f,0x01,
	0x00,0x64,0x04,//pwm
	0x00,0x65,0x00,
	0x00,0x66,0x04,
	0x00,0x67,0x00,
	0x00,0x68,0x04,//adc
	0x00,0x69,0x14,
	0x00,0x6a,0x04,//coax
	0x00,0x6b,0x00,
	0x00,0x6c,0x04,//avl
	0x00,0x6d,0x15,
	0x00,0x6e,0x01,//psram
	0x00,0x6f,0x05,
		
	// 2,0x.4 config clock enable and reset
	//2.,0x4.1 clock and reset ( /*READ ONLY*/)
	0x00,0x1c, 0xff,
	0x00,0x1d, 0xff,
	0x00,0x1e, 0xff,
	0x00,0x1f, 0xff,
	0x00,0x18, 0x00,
	0x00,0x19, 0x00,
	0x00,0x1a, 0x00,
	0x00,0x1b, 0x00,
		
	//2.,0x4.2 i2c_speed ( /*CFG*/)
	0xff,0xfe,0x25,
	0x00,0x02,0x43,// i2c_div,	i2c_clk=sys_clk/(i2c_div*4)  default:0x43  
	0x50,0x0c,0x08,
		
	//2.,0x4.3 spi_speed ( /*CFG*/)
	0xff,0xfd,0x82,
	0xff,0xfe,0x00,
	0x00,0x04,0x08,//spi_clk_div， spi_clk=sys_clk /((spi_clk_div +1)*2) default:0x08	min:0x00
		
	//2.,0x4.4 sys_freq config ( /*CFG*/)
	//sy,0xs_freq=(sys_clk*1024)/(1000*36)
	0xff,0xfd,0x80,
	0xff,0xfe,0x14,
	0x00,0x3c,0x00,//[31:24]
	0x00,0x3d,0x0f,//[23:16]
	0x00,0x3e,0xa0,//[15:8]
	0x00,0x3f,0x00,//[7:0]
		
	// 2,0x.5 config pad  ( /*CFG*/)
	//NO,0xTE
	// 1,0x. if dac+flash function, 0x00bd=0x0e
	//	  if dvp funciotn, 0x00bd=0x11
	// 2,0x. In debug mode 0x0090[3] should be set to 1 after all setting send
	//	  In flash boot mode i2c controlled by cpu
	0xff,0xfe,0x50,
	0x00,0xbc,0x21,//[0]full pin enable, [4]uart0_port_select, [5]uart1_port_select
	0x00,0xbe,0x00,
	0x00,0xbd,0x11, //[0]dvp_data_oe, [1]psram_clkp_oe, [2]psram_clkn_oe, [3]psram_cen_oe. [4] gpio use as dvp enable
	0x00,0xbf,0x00,
	0x00,0x90,0x21,//[1:0] isp_in_mux, [3] i2c0_master_en, [4] i2c1_master_en
		
	// 2,0x.6 config dac
	0x00,0x34, 0x00,
	0x00,0x36, 0xff,
		
	0x00,0x38, 0x30,
	0x00,0x39, 0x30,
	0x00,0x3a, 0x70,
		
	0x00,0x3c, 0x04,
	0x00,0x3d, 0x03,
		
	//**,0x**********************************************************//
	//**,0x******** Step 3 config psram !!! DONT TOUCH !!! **********//
	//**,0x**********************************************************//
	// P,0xsram is not supported
		
	//**,0x******** Step 4 config isp *******************************//
	//4.,0x1-isp_set ( /*CFG*/)
	0xff,0xfe, 0x30,
	0x00,0x00, 0x01,
	0x00,0x01, 0x00,
	0x00,0x02, 0x10,
	0x00,0x03, 0x00,
	0x00,0x04, 0x10,
	0x00,0x50, 0x10,
	0x00,0x16, 0x03,
	0x00,0x1a, 0x00,
		
	0x00,0x5f, 0x04,
	0x00,0x5e, 0xff,
	0x00,0x61, 0x02,
	0x00,0x60, 0xcf,
	0x00,0x65, 0x05,
	0x00,0x64, 0x00,
	0x00,0x67, 0x02,
	0x00,0x66, 0xd0,
	0x00,0x06, 0x05,
	0x00,0x07, 0x00,
	0x00,0x08, 0x02,
	0x00,0x09, 0xd0,
	0x00,0x0a, 0x05,
	0x00,0x0b, 0x00,
	0x00,0x0c, 0x02,
	0x00,0x0d, 0xd0,
		
	//4.,0x2-vfifo ( /*CFG*/)
	0xff,0xfe,0x26,
	0x40,0x00,0xf9,
	0x60,0x01,0x14,
	0x60,0x05,0x84,
	0x60,0x08,0x09,//read start
	0x60,0x09,0xfc,
	0x60,0x06,0x0a,
	0x60,0x07,0xc8,
	0x60,0x0c,0x20,//[0]sof_clr
		
	0xff,0xfe,0x26,
	0x60,0x05,0xd4,
	0x60,0x0d,0x2f,
		
	//4.,0x3-BT1120 ( /*CFG*/)
	0xff,0xfe,0x25,
	0x60,0x00,0x1c,
	0x60,0x10,0x03,
	0x60,0x19,0x03,
	0x60,0x1a,0x03,
	0x60,0x0f,0x00,
	0x60,0x1b,0x88,
		
	0x60,0x38,0x00,
	0x60,0x39,0x00,
	0x60,0x3a,0x80,
	0x60,0x3b,0x02,
	0x60,0x44,0x18,
		
	//4.,0x4-day night ( /*READ ONLY*/)
	0xff,0xfe,0x14,
	0x06,0x3b,0xf0,//IR_MaxGainLimit
	0x06,0x3f,0x40,//IR_MinGainLimit
		
	//4.,0x10-ircut config ( /*OPT*/ /*READ ONLY*/)
	//ad,0xd ircut config parameter if used
	0xff,0xfe,0x50,
	0x02,0x02,0x40,
	0x02,0x06,0x00,
	0x02,0x01,0x00,
	0x00,0xd2,0x40,
	0x00,0xda,0x40,
	0x01,0x89,0x03,
		
	0xff,0xfe,0x14,
	0x06,0xa7,0x00,//day_night_switch_mode;  /* 0: EXT IRcut  1: INT AUTO(gain)  2:Color  3:Gray   4:mode_4 5:mode_5 */
		
	//**,0x******** Step 5 config colobar ***************************//
	//co,0xlorbar	( /*CFG*/)
	0xff,0xfe, 0x26,
	0x80,0x01, 0x00,
	0x80,0x02, 0x05,
	0x80,0x03, 0xd0,
	0x80,0x04, 0x02,
	0x80,0x05, 0x03,
	0x80,0x06, 0x1b,
	0x80,0x07, 0x1b,
	0x80,0x0f, 0x00,
	0x80,0x08, 0x50,
	0x80,0x09, 0x00,
	0x80,0x00, 0x0d,
		
	//**,0x******** Step 6 cif **************************************//
	// 6,0x.2 config cif auto counter  ( /*CFG*/)
	0xff,0xfe, 0x20,
	0x00,0x04, 0x05,
	0x00,0x05, 0x00,
	0x00,0x06, 0x02,
	0x00,0x07, 0xd0,
		
	0x00,0x00,0x00,
	0x00,0x02,0x00,
	0x00,0x0e,0x10,
	0x00,0x10,0x10,
	0x00,0x11,0x00,
	//0x,0x0020,0x50,
	//0x,0x0021,0x0f,
	//0x,0x0024,0x70,
	//0x,0x0025,0x3e,
	//0x,0x002f,0x01,
	0x00,0x2d,0x01,//delay counter bypass
	0x00,0x2c,0x01,//delay counter clear
		
	0xff,0xfe,0x14,
	0x06,0x60,0x01, //Global_Stream_On_Enable
	0x06,0x5d,0x01,//Stream_On_Delay_Enable
		
	//**,0x******** Step 7 enable psram init ************************//
	//ps,0xram check( /*OPT*/ /*READ ONLY*/)
	//0x,0xfffa,0x00,	 //keywords:check_psram
		
	//**,0x******** Step 8 config sensor*****************************//
	//co,0xnfig gpio( /*CFG*/)
	0xff,0xfe, 0x50,
	0x02,0x00, 0x04,
	0x02,0x04, 0x00,
	0x02,0x08, 0x00,
	0x02,0x02, 0x40,
	0x02,0x06, 0x00,
	0x02,0x0a, 0x00,
	0x02,0x01, 0x07,
	0x02,0x05, 0x04,
	0x02,0x09, 0x04, //GPIO_Ctr
		
	//i2,0xc bypass  ( /*READ ONLY*/)
	//0x,0xfffe,0x50,
	//0x,0x004d,0x01,
		
	//sw,0xitch i2c addr  ( /*CFG*/)
	//0x,0xffff,0xfef0,
	//0x,0xfff8,0x60,
	//0x,0xfffe,0x03,
		
	//0x,0xfff8,0x36,
	//0x,0xfffe,0x03,
	//0x,0xffff,0xfef1,
		
	//0x,0xfffd,0x80,
	//0x,0xfffe,0x50,
	//0x,0x004d,0x00,
		
	//**,0x******** Step 9 IQ setting********************************//
		
	//ad,0xd patch
	//0x,0xfffd, 0x80,
	//0x,0xfffe, 0x50,
	//0x,0x000e, 0x54,
		
	//0x,0xfffe, 0x14,
	//0x,0x0006, 0x04,
	//0x,0x0007, 0xc7,
		
	//0x,0xfffe,0x50,
	//0x,0x0137,0x99,
		
	//pa,0xtch_end
		
	0xff,0xfd,0x80,
		
	0xff,0xfe,0x30,
	0x07,0x15,0x02, //pixel_order
	0x00,0x6c,0x80,
	0x18,0x00,0x10, ////U_or_V_first
		
	//AE,0x
	0xff,0xfe,0x30,
	0x1f,0x00,0x00,
	0x1f,0x01,0x00, //win_Xstart
	0x1f,0x02,0x00,
	0x1f,0x03,0x00, //win_Ystart
	0x1f,0x04,0x05,
	0x1f,0x05,0x00, //win_width
	0x1f,0x06,0x02,
	0x1f,0x07,0xc0, //win_height
	0x1f,0x08,0x03,
	0x00,0x51,0x09,
	0x37,0x04,0x07, //dgain_ctrl
		
	//se,0xnsor
	0xff,0xfe,0x14,
	0x00,0xb8,0x80, //sensor_id
	0x00,0xb9,0x00, //i2c_mode
	0x00,0xba,0x00, //type_gain
	0x00,0xbb,0x00, //type_exp
	0x00,0xbe,0x00, //sensor_gain_mode
		
	0x00,0xc0,0x00, //exp_addr
	0x00,0xc1,0x00,
	0x00,0xc2,0x00,
	0x00,0xc3,0x02,
	0x00,0xc4,0x00,
	0x00,0xc5,0x01,
	0x00,0xc6,0x00,
	0x00,0xc7,0x00,
		
	0x00,0xc8,0x00, //exp_mask
	0x00,0xc9,0x00,
	0x00,0xca,0x00,
	0x00,0xcb,0xff,
	0x00,0xcc,0x00,
	0x00,0xcd,0xff,
	0x00,0xce,0x00,
	0x00,0xcf,0x00,
		
	0x00,0xe0,0x00, //gain_addr
	0x00,0xe1,0x00,
	0x00,0xe2,0x00,
	0x00,0xe3,0x00,
	0x00,0xe4,0x00,
	0x00,0xe5,0x00,
	0x00,0xe6,0x00,
	0x00,0xe7,0x00,
		
	0x00,0xe8,0x00, //gain_mask
	0x00,0xe9,0xff,
	0x00,0xea,0x00,
	0x00,0xeb,0x00,
	0x00,0xec,0x00,
	0x00,0xed,0x00,
	0x00,0xee,0x00,
	0x00,0xef,0x00,
		
	//Ar,0xea Weight
	0xff,0xfe,0x14,
	0x00,0x5b,0x04,
	0x00,0x5c,0x04,
	0x00,0x5d,0x04,
	0x00,0x5e,0x04,
	0x00,0x5f,0x04,
	0x00,0x60,0x04,
	0x00,0x61,0x04,
	0x00,0x62,0x04,
	0x00,0x63,0x04,
	0x00,0x64,0x04,
	0x00,0x65,0x04,
	0x00,0x66,0x04,
	0x00,0x67,0x04,
	0x00,0x68,0x04,
	0x00,0x69,0x04,
	0x00,0x6a,0x04,
	0x00,0x6b,0x04,
	0x00,0x6c,0x04,
	0x00,0x6d,0x04,
	0x00,0x6e,0x04,
	0x00,0x6f,0x04,
	0x00,0x70,0x04,
	0x00,0x71,0x04,
	0x00,0x72,0x04,
	0x00,0x73,0x04,
		
	//At,0xtention
	0x00,0x74,0x01,
	0x00,0x75,0xff,
	0x00,0x76,0xff,
	0x00,0x77,0xff,
		
	0x00,0xf2,0x01, //magnitude_en
		
	0x00,0x5a,0x01, //refresh
		
	//AE,0x Base
	0xff,0xfe,0x14,
	0x00,0x4c,0x00, //AEC_mode
	0x00,0x4d,0x01,
		
	0x00,0x7c,0x00,
	0x00,0x7d,0xa8, //day_target
		
	0x00,0x7e,0x00,
	0x00,0x7f,0x20, //min_exp
	0x00,0x80,0x00,
	0x00,0x81,0x00,
	0x00,0x82,0x2e,
	0x00,0x83,0x00, //max_exp
	0x00,0x84,0x08, //exp_shift
	0x00,0x85,0x04, //gain_shift
	0x00,0x8e,0x10,
	0x00,0x8f,0x00, //max_gain
	0x00,0x90,0x00,
	0x00,0x91,0x24, //min_gain
	0x00,0x92,0x08,
	0x00,0x93,0x00, //max_sensor_gain
		
	0x00,0xad,0x00, //flicker
	0x00,0xae,0x01,
	0x00,0xb0,0x09,
	0x00,0xb1,0xc0, //60Hz
	0x00,0xb2,0x0b,
	0x00,0xb3,0xb0, //50Hz
		
	//AE,0x speed
	0x00,0xf0,0x00, //exp_delay
	0x00,0xf1,0x00, //gain_delay
	0x00,0x27,0x01, //exp_mode
	0x00,0x28,0x01, //gain_mode
		
	0x00,0x98,0x01, //delay_frame
	0x00,0x99,0x08, //finally_thr
	0x00,0x9a,0x00,
	0x00,0x9b,0x28, //global_all_diff_thr
	0x00,0xa0,0x00,
	0x00,0xa1,0x60, //jump_luma_diff
	0x00,0xa2,0x00,
	0x00,0xa3,0x80, //luma_diff_thr_low
	0x00,0xa4,0x03,
	0x00,0xa5,0x00, //luma_diff_thr_high
	0x00,0xa6,0x00,
	0x00,0xa7,0x48, //jump_thr
	0x00,0xa8,0x00,
	0x00,0xa9,0x80, //jump_mutiple
	0x00,0xaa,0x00,
	0x00,0xab,0x80, //max_jump_ratio
	0x00,0xac,0x02, //max_jump_cnt
		
	//LE,0xNC
	0xff,0xfe,0x30,
	0x03,0xc4,0x07, //lenc_ctrl
	0x03,0xca,0x04, //lenc_ratio
	0x03,0xcb,0xcc,
	0x03,0xcc,0x08,
	0x03,0xcd,0x88,
	0x03,0xce,0x04,
	0x03,0xcf,0xcc,
	0x03,0xd0,0x04,
	0x03,0xd1,0x44,
		
	0x00,0x0e,0x00,
	0x00,0x0f,0x00,
	0x00,0x10,0x00,
	0x00,0x11,0x00,
	0x00,0x12,0x80, //lenc_skip
		
	0x03,0x00,0x16,
	0x03,0x01,0x13,
	0x03,0x02,0x0f,
	0x03,0x03,0x0b,
	0x03,0x04,0x0a,
	0x03,0x05,0x0c,
	0x03,0x06,0x0e,
	0x03,0x07,0x11,
	0x03,0x08,0x0d,
	0x03,0x09,0x09,
	0x03,0x0a,0x05,
	0x03,0x0b,0x04,
	0x03,0x0c,0x04,
	0x03,0x0d,0x04,
	0x03,0x0e,0x06,
	0x03,0x0f,0x08,
	0x03,0x10,0x07,
	0x03,0x11,0x03,
	0x03,0x12,0x01,
	0x03,0x13,0x01,
	0x03,0x14,0x00,
	0x03,0x15,0x00,
	0x03,0x16,0x02,
	0x03,0x17,0x04,
	0x03,0x18,0x04,
	0x03,0x19,0x02,
	0x03,0x1a,0x00,
	0x03,0x1b,0x00,
	0x03,0x1c,0x00,
	0x03,0x1d,0x00,
	0x03,0x1e,0x01,
	0x03,0x1f,0x02,
	0x03,0x20,0x04,
	0x03,0x21,0x02,
	0x03,0x22,0x00,
	0x03,0x23,0x00,
	0x03,0x24,0x00,
	0x03,0x25,0x00,
	0x03,0x26,0x01,
	0x03,0x27,0x02,
	0x03,0x28,0x08,
	0x03,0x29,0x04,
	0x03,0x2a,0x02,
	0x03,0x2b,0x01,
	0x03,0x2c,0x01,
	0x03,0x2d,0x01,
	0x03,0x2e,0x02,
	0x03,0x2f,0x05,
	0x03,0x30,0x0d,
	0x03,0x31,0x09,
	0x03,0x32,0x06,
	0x03,0x33,0x05,
	0x03,0x34,0x04,
	0x03,0x35,0x04,
	0x03,0x36,0x07,
	0x03,0x37,0x08,
	0x03,0x38,0x1c,
	0x03,0x39,0x13,
	0x03,0x3a,0x0f,
	0x03,0x3b,0x0b,
	0x03,0x3c,0x0a,
	0x03,0x3d,0x0c,
	0x03,0x3e,0x0e,
	0x03,0x3f,0x13,
	0x03,0x40,0x2d,
	0x03,0x41,0x25,
	0x03,0x42,0x27,
	0x03,0x43,0x23,
	0x03,0x44,0x23,
	0x03,0x45,0x26,
	0x03,0x46,0x25,
	0x03,0x47,0x2a,
	0x03,0x48,0x26,
	0x03,0x49,0x27,
	0x03,0x4a,0x23,
	0x03,0x4b,0x23,
	0x03,0x4c,0x23,
	0x03,0x4d,0x23,
	0x03,0x4e,0x26,
	0x03,0x4f,0x25,
	0x03,0x50,0x26,
	0x03,0x51,0x23,
	0x03,0x52,0x20,
	0x03,0x53,0x20,
	0x03,0x54,0x20,
	0x03,0x55,0x20,
	0x03,0x56,0x23,
	0x03,0x57,0x26,
	0x03,0x58,0x24,
	0x03,0x59,0x23,
	0x03,0x5a,0x20,
	0x03,0x5b,0x20,
	0x03,0x5c,0x20,
	0x03,0x5d,0x20,
	0x03,0x5e,0x23,
	0x03,0x5f,0x23,
	0x03,0x60,0x23,
	0x03,0x61,0x23,
	0x03,0x62,0x20,
	0x03,0x63,0x20,
	0x03,0x64,0x20,
	0x03,0x65,0x20,
	0x03,0x66,0x23,
	0x03,0x67,0x23,
	0x03,0x68,0x26,
	0x03,0x69,0x23,
	0x03,0x6a,0x20,
	0x03,0x6b,0x20,
	0x03,0x6c,0x20,
	0x03,0x6d,0x20,
	0x03,0x6e,0x23,
	0x03,0x6f,0x26,
	0x03,0x70,0x25,
	0x03,0x71,0x26,
	0x03,0x72,0x22,
	0x03,0x73,0x22,
	0x03,0x74,0x22,
	0x03,0x75,0x23,
	0x03,0x76,0x26,
	0x03,0x77,0x26,
	0x03,0x78,0x29,
	0x03,0x79,0x26,
	0x03,0x7a,0x26,
	0x03,0x7b,0x22,
	0x03,0x7c,0x23,
	0x03,0x7d,0x25,
	0x03,0x7e,0x26,
	0x03,0x7f,0x28,
	0x03,0x80,0x2d,
	0x03,0x81,0x29,
	0x03,0x82,0x28,
	0x03,0x83,0x26,
	0x03,0x84,0x25,
	0x03,0x85,0x28,
	0x03,0x86,0x28,
	0x03,0x87,0x2c,
	0x03,0x88,0x26,
	0x03,0x89,0x26,
	0x03,0x8a,0x24,
	0x03,0x8b,0x24,
	0x03,0x8c,0x24,
	0x03,0x8d,0x23,
	0x03,0x8e,0x27,
	0x03,0x8f,0x27,
	0x03,0x90,0x27,
	0x03,0x91,0x24,
	0x03,0x92,0x21,
	0x03,0x93,0x20,
	0x03,0x94,0x20,
	0x03,0x95,0x20,
	0x03,0x96,0x23,
	0x03,0x97,0x27,
	0x03,0x98,0x24,
	0x03,0x99,0x24,
	0x03,0x9a,0x20,
	0x03,0x9b,0x20,
	0x03,0x9c,0x20,
	0x03,0x9d,0x20,
	0x03,0x9e,0x23,
	0x03,0x9f,0x23,
	0x03,0xa0,0x24,
	0x03,0xa1,0x24,
	0x03,0xa2,0x20,
	0x03,0xa3,0x20,
	0x03,0xa4,0x20,
	0x03,0xa5,0x20,
	0x03,0xa6,0x23,
	0x03,0xa7,0x24,
	0x03,0xa8,0x28,
	0x03,0xa9,0x24,
	0x03,0xaa,0x21,
	0x03,0xab,0x20,
	0x03,0xac,0x20,
	0x03,0xad,0x20,
	0x03,0xae,0x23,
	0x03,0xaf,0x26,
	0x03,0xb0,0x27,
	0x03,0xb1,0x28,
	0x03,0xb2,0x24,
	0x03,0xb3,0x24,
	0x03,0xb4,0x24,
	0x03,0xb5,0x24,
	0x03,0xb6,0x27,
	0x03,0xb7,0x27,
	0x03,0xb8,0x2d,
	0x03,0xb9,0x29,
	0x03,0xba,0x29,
	0x03,0xbb,0x25,
	0x03,0xbc,0x25,
	0x03,0xbd,0x28,
	0x03,0xbe,0x29,
	0x03,0xbf,0x2c,
		
	//BL,0xC
	0xff,0xfe,0x30,
	0x00,0xa0,0x0a,
	0x00,0xa1,0x0a,
	0x00,0xa2,0x0a,
	0x00,0xa3,0x0a,
	0x07,0x1b,0x0a,
		
	//AW,0xB
	0xff,0xfe,0x14,
	0x01,0xc0,0x01, //AWB_mode
	0x01,0xc1,0x01, //AWB_fleximap_en
	0x01,0xe4,0x00,
	0x01,0xe5,0x08, //min_num
	0x01,0xe6,0x0f,
	0x01,0xe7,0xff, //max_awb_gain
	0x01,0xe8,0x04, //awb_step
	0x01,0xe9,0x80, //max_step_value
		
	0x02,0x22,0x04,
	0x02,0x23,0x00, //B_temp
	0x02,0x26,0x04,
	0x02,0x27,0x00, //G_temp
	0x02,0x2a,0x04,
	0x02,0x2b,0x00, //R_temp
		
	0x01,0xc3,0x00, //awb_move_en
	0x01,0xc6,0x00,
	0x01,0xc7,0x00, //D65:B_offset
	0x01,0xca,0x00,
	0x01,0xcb,0x00, //D65:R_offset
	0x01,0xce,0x00,
	0x01,0xcf,0x00, //CWF:B_offset
	0x01,0xd2,0x00,
	0x01,0xd3,0x00, //CWF:R_offset
	0x01,0xd6,0x00,
	0x01,0xd7,0x00, //A:B_offset
	0x01,0xda,0x00,
	0x01,0xdb,0x00, //A:R_offset
		
	0x01,0xdc,0x02,
	0x01,0xdd,0x10, //awb_color0
	0x01,0xde,0x04,
	0x01,0xdf,0xd0, //awb_color1
	0x01,0xe0,0x06,
	0x01,0xe1,0x60, //awb_color2
		
	0xff,0xfe,0x30,
	0x07,0x08,0x02,
	0x07,0x09,0xa0, //pixel_max_value
	0x07,0x0a,0x00,
	0x07,0x0b,0x0c, //pixel_min_value
		
	0x07,0x30,0x98,
	0x07,0x31,0xc8,
	0x07,0x32,0x20,
	0x07,0x33,0x30,
	0x07,0x34,0x88,
	0x07,0x35,0xc0,
	0x07,0x36,0x30,
	0x07,0x37,0x40,
	0x07,0x38,0x78,
	0x07,0x39,0xb0,
	0x07,0x3a,0x40,
	0x07,0x3b,0x50,
	0x07,0x3c,0x68,
	0x07,0x3d,0xa0,
	0x07,0x3e,0x50,
	0x07,0x3f,0x60,
	0x07,0x40,0x58,
	0x07,0x41,0x90,
	0x07,0x42,0x60,
	0x07,0x43,0x70,
	0x07,0x44,0x48,
	0x07,0x45,0x80,
	0x07,0x46,0x70,
	0x07,0x47,0x80,
	0x07,0x48,0x38,
	0x07,0x49,0x70,
	0x07,0x4a,0x80,
	0x07,0x4b,0x90,
	0x07,0x4c,0x30,
	0x07,0x4d,0x60,
	0x07,0x4e,0x90,
	0x07,0x4f,0xa0,
	0x07,0x70,0x11,
	0x07,0x71,0x11,
	0x07,0x72,0x11,
	0x07,0x73,0x11,
		
	//RA,0xW Gamma
	0xff,0xfe,0x30,
	0x09,0x00,0x00,
	0x09,0x01,0x05,
	0x09,0x02,0x0a,
	0x09,0x03,0x0f,
	0x09,0x04,0x14,
	0x09,0x05,0x1a,
	0x09,0x06,0x1f,
	0x09,0x07,0x24,
	0x09,0x08,0x29,
	0x09,0x09,0x2d,
	0x09,0x0a,0x32,
	0x09,0x0b,0x37,
	0x09,0x0c,0x3b,
	0x09,0x0d,0x3f,
	0x09,0x0e,0x44,
	0x09,0x0f,0x48,
	0x09,0x10,0x4c,
	0x09,0x11,0x4f,
	0x09,0x12,0x53,
	0x09,0x13,0x56,
	0x09,0x14,0x5a,
	0x09,0x15,0x5d,
	0x09,0x16,0x60,
	0x09,0x17,0x63,
	0x09,0x18,0x66,
	0x09,0x19,0x68,
	0x09,0x1a,0x6b,
	0x09,0x1b,0x6d,
	0x09,0x1c,0x70,
	0x09,0x1d,0x72,
	0x09,0x1e,0x74,
	0x09,0x1f,0x76,
	0x09,0x20,0x79,
	0x09,0x21,0x7d,
	0x09,0x22,0x80,
	0x09,0x23,0x84,
	0x09,0x24,0x88,
	0x09,0x25,0x8b,
	0x09,0x26,0x8e,
	0x09,0x27,0x91,
	0x09,0x28,0x95,
	0x09,0x29,0x98,
	0x09,0x2a,0x9b,
	0x09,0x2b,0x9d,
	0x09,0x2c,0xa0,
	0x09,0x2d,0xa3,
	0x09,0x2e,0xa6,
	0x09,0x2f,0xa9,
	0x09,0x30,0xac,
	0x09,0x31,0xb1,
	0x09,0x32,0xb6,
	0x09,0x33,0xbb,
	0x09,0x34,0xc0,
	0x09,0x35,0xc5,
	0x09,0x36,0xca,
	0x09,0x37,0xcf,
	0x09,0x38,0xd5,
	0x09,0x39,0xda,
	0x09,0x3a,0xdf,
	0x09,0x3b,0xe4,
	0x09,0x3c,0xea,
	0x09,0x3d,0xef,
	0x09,0x3e,0xf4,
	0x09,0x3f,0xfa,
	0x09,0x40,0xff,
		
	//RG,0xB Gamma
	0xff,0xfe,0x30,
	0x14,0x00,0x00,
	0x14,0x01,0x05,
	0x14,0x02,0x0a,
	0x14,0x03,0x0f,
	0x14,0x04,0x15,
	0x14,0x05,0x1a,
	0x14,0x06,0x1f,
	0x14,0x07,0x24,
	0x14,0x08,0x29,
	0x14,0x09,0x2e,
	0x14,0x0a,0x33,
	0x14,0x0b,0x38,
	0x14,0x0c,0x3c,
	0x14,0x0d,0x41,
	0x14,0x0e,0x45,
	0x14,0x0f,0x49,
	0x14,0x10,0x4d,
	0x14,0x11,0x51,
	0x14,0x12,0x55,
	0x14,0x13,0x58,
	0x14,0x14,0x5c,
	0x14,0x15,0x5f,
	0x14,0x16,0x62,
	0x14,0x17,0x65,
	0x14,0x18,0x68,
	0x14,0x19,0x6b,
	0x14,0x1a,0x6e,
	0x14,0x1b,0x71,
	0x14,0x1c,0x74,
	0x14,0x1d,0x76,
	0x14,0x1e,0x79,
	0x14,0x1f,0x7b,
	0x14,0x20,0x7d,
	0x14,0x21,0x82,
	0x14,0x22,0x86,
	0x14,0x23,0x8a,
	0x14,0x24,0x8e,
	0x14,0x25,0x92,
	0x14,0x26,0x95,
	0x14,0x27,0x99,
	0x14,0x28,0x9c,
	0x14,0x29,0x9f,
	0x14,0x2a,0xa3,
	0x14,0x2b,0xa6,
	0x14,0x2c,0xa9,
	0x14,0x2d,0xac,
	0x14,0x2e,0xaf,
	0x14,0x2f,0xb2,
	0x14,0x30,0xb5,
	0x14,0x31,0xba,
	0x14,0x32,0xbf,
	0x14,0x33,0xc4,
	0x14,0x34,0xc9,
	0x14,0x35,0xce,
	0x14,0x36,0xd3,
	0x14,0x37,0xd8,
	0x14,0x38,0xdc,
	0x14,0x39,0xe1,
	0x14,0x3a,0xe5,
	0x14,0x3b,0xe9,
	0x14,0x3c,0xee,
	0x14,0x3d,0xf2,
	0x14,0x3e,0xf6,
	0x14,0x3f,0xfb,
	0x14,0x40,0xff,
		
	0x14,0x50,0xf0,
	0x14,0x51,0x03,
	0x14,0x52,0x80,
	0x14,0x53,0x60,
		
	//CM,0xX
	0xff,0xfe,0x30,
	0x12,0x00,0x00,
	0x12,0x01,0xba,
	0x12,0x02,0x00,
	0x12,0x03,0x00,
	0x12,0x04,0x02,
	0x12,0x05,0x47,
	0x12,0x06,0x01,
	0x12,0x07,0xd2,
	0x12,0x08,0x01,
	0x12,0x09,0xea,
	0x12,0x0a,0x02,
	0x12,0x0b,0xdf,
	0x12,0x0c,0x00,
	0x12,0x0d,0x74,
	0x12,0x0e,0x00,
	0x12,0x0f,0x8c,
	0x12,0x10,0x02,
	0x12,0x11,0x47,
	0x12,0x12,0x03,
	0x12,0x13,0x0d,
	0x12,0x14,0x00,
	0x12,0x15,0x00,
	0x12,0x16,0x03,
	0x12,0x17,0xb1,
	0x12,0x18,0x00,
	0x12,0x19,0x74,
	0x12,0x1a,0x00,
	0x12,0x1b,0x00,
	0x12,0x1c,0x02,
	0x12,0x1d,0xa4,
	0x12,0x1e,0x02,
	0x12,0x1f,0x81,
	0x12,0x20,0x01,
	0x12,0x21,0x69,
	0x12,0x22,0x03,
	0x12,0x23,0x30,
	0x12,0x2e,0x10,
	0x12,0x2f,0x02,
	0x12,0x30,0x00,
	0x12,0x28,0x00,
	0x12,0x29,0x90,
	0x12,0x2a,0x00,
	0x12,0x2b,0xdd,
	0x12,0x2c,0x01,
	0x12,0x2d,0x33,
		
	0x12,0x31,0x03, //CMX_ctrl
	0x12,0x32,0x40,
	0x12,0x33,0x38,
	0x12,0x34,0x01,
	0x12,0x35,0x1f,
		
	//RA,0xW DNS
	0xff,0xfe,0x30,
	0x20,0x00,0x08, //s0_sigma_0
	0x20,0x01,0x08,
	0x20,0x02,0x08,
	0x20,0x03,0x08,
	0x20,0x04,0x0f,
	0x20,0x05,0x1f, //s0_sigma_5
		
	0x20,0x06,0x09, //s0_gsl_0
	0x20,0x07,0x0a,
	0x20,0x08,0x0b,
	0x20,0x09,0x0c,
	0x20,0x0a,0x0f,
	0x20,0x0b,0x12, //s0_gsl_5
		
	0x20,0x0c,0x08, //s0_rbsl_0
	0x20,0x0d,0x07,
	0x20,0x0e,0x06,
	0x20,0x0f,0x05,
	0x20,0x10,0x04,
	0x20,0x11,0x03, //s0_rbsl_5
		
	0x20,0x12,0x33, //s0_ps00
	0x20,0x13,0x33,
	0x20,0x14,0x33,
	0x20,0x15,0x33,
	0x20,0x16,0x22,
	0x20,0x17,0x11, //s0_ps05
		
	0x20,0x18,0x33, //s0_ps10
	0x20,0x19,0x33,
	0x20,0x1a,0x33,
	0x20,0x1b,0x33,
	0x20,0x1c,0x22,
	0x20,0x1d,0x11, //s0_ps15
		
	0x20,0x1e,0x33, //s0_ps20
	0x20,0x1f,0x33,
	0x20,0x20,0x33,
	0x20,0x21,0x33,
	0x20,0x22,0x22,
	0x20,0x23,0x11, //s0_ps25
		
	0x20,0x24,0x44, //s0_ps30
	0x20,0x25,0x44,
	0x20,0x26,0x33,
	0x20,0x27,0x33,
	0x20,0x28,0x22,
	0x20,0x29,0x11, //s0_ps35
		
	0x20,0x2a,0x08, //s0_pl00
	0x20,0x2b,0x08,
	0x20,0x2c,0x08,
	0x20,0x2d,0x08,
	0x20,0x2e,0x08,
	0x20,0x2f,0x08, //s0_pl05
		
	0x20,0x30,0x08, //s0_pl10
	0x20,0x31,0x08,
	0x20,0x32,0x08,
	0x20,0x33,0x08,
	0x20,0x34,0x08,
	0x20,0x35,0x08, //s0_pl15
		
	0x20,0x36,0x08, //s0_pl20
	0x20,0x37,0x08,
	0x20,0x38,0x08,
	0x20,0x39,0x08,
	0x20,0x3a,0x08,
	0x20,0x3b,0x08, //s0_pl25
		
	0x20,0x3c,0x08, //s0_pl30
	0x20,0x3d,0x08,
	0x20,0x3e,0x08,
	0x20,0x3f,0x08,
	0x20,0x40,0x08,
	0x20,0x41,0x08, //s0_pl35
		
	0x20,0x42,0x1c,
	0x20,0x44,0x10, //[4:0]:r_thre_y
	0x20,0x49,0x00, //bit[1]:dns_man_en; bit[0]:3d_para_en
		
	0xff,0xfe,0x14,
	0x08,0x19,0x12, //dns_gsl_32x
	0x08,0x1a,0x03, //dns_rbsl_32x
	0x08,0x1b,0x14,
	0x08,0x1c,0x02,
	0x08,0x1d,0x16,
	0x08,0x1e,0x01,
	0x08,0x1f,0x16,
	0x08,0x20,0x01,
	0x08,0x21,0x16, //dns_gsl_512x
	0x08,0x22,0x01, //dns_rbsl_512x
	0x08,0x23,0x01, //dns_cal_en
		
	//YU,0xV DNS
	0xff,0xfe,0x30,
	0x38,0x00,0x08, //S_sigma
	0x38,0x01,0x08,
	0x38,0x02,0x08,
	0x38,0x03,0x08,
	0x38,0x04,0x0f,
	0x38,0x05,0x1f,
		
	0x38,0x06,0x08, //S_Ysl
	0x38,0x07,0x08,
	0x38,0x08,0x08,
	0x38,0x09,0x09,
	0x38,0x0a,0x0a,
	0x38,0x0b,0x0c,
		
	0x38,0x12,0x28, //S_ps00
	0x38,0x13,0x28,
	0x38,0x14,0x28,
	0x38,0x15,0x28,
	0x38,0x16,0x28,
	0x38,0x17,0x28,
		
	0x38,0x18,0x38, //S_ps10
	0x38,0x19,0x38,
	0x38,0x1a,0x38,
	0x38,0x1b,0x38,
	0x38,0x1c,0x38,
	0x38,0x1d,0x38,
		
	0x38,0x1e,0x48, //S_ps20
	0x38,0x1f,0x48,
	0x38,0x20,0x48,
	0x38,0x21,0x48,
	0x38,0x22,0x48,
	0x38,0x23,0x48,
		
	0x38,0x24,0x58, //S_ps30
	0x38,0x25,0x58,
	0x38,0x26,0x58,
	0x38,0x27,0x58,
	0x38,0x28,0x58,
	0x38,0x29,0x58,
		
	0x38,0x2a,0x08, //S_pl00
	0x38,0x2b,0x08,
	0x38,0x2c,0x08,
	0x38,0x2d,0x08,
	0x38,0x2e,0x08,
	0x38,0x2f,0x08,
		
	0x38,0x30,0x08, //S_pl10
	0x38,0x31,0x08,
	0x38,0x32,0x08,
	0x38,0x33,0x08,
	0x38,0x34,0x08,
	0x38,0x35,0x08,
		
	0x38,0x36,0x08, //S_pl20
	0x38,0x37,0x08,
	0x38,0x38,0x08,
	0x38,0x39,0x08,
	0x38,0x3a,0x08,
	0x38,0x3b,0x08,
		
	0x38,0x3c,0x08, //S_pl30
	0x38,0x3d,0x08,
	0x38,0x3e,0x08,
	0x38,0x3f,0x08,
	0x38,0x40,0x08,
	0x38,0x41,0x08,
		
	0x38,0x42,0x01,
	0x38,0x43,0x08, //thr_y
		
	//UV,0x DNS
	0xff,0xfe,0x30,
	0x21,0x00,0x08, //l_noise_list0
	0x21,0x01,0x08,
	0x21,0x02,0x08,
	0x21,0x03,0x08,
	0x21,0x04,0x08,
	0x21,0x05,0x08,
	0x21,0x06,0x08,
	0x21,0x07,0x08,
	0x21,0x08,0x08,
	0x21,0x09,0x08,
	0x21,0x0a,0x08, //l_noise_list10
	0x21,0x0b,0x44, //uv_dns_ctrl
	0x21,0x0c,0x08, //noise_man_value
	0x21,0x18,0x01,
		
	//CI,0xP
	0xff,0xfe,0x30,
	0x0f,0x00,0x0f, //bit[7:4]:noise_y bit[3:0]:lsharp
		
	0x0f,0x02,0x00,
	0x0f,0x03,0x00,
	0x0f,0x04,0x00,
	0x0f,0x05,0x00,
	0x0f,0x06,0x00,
	0x0f,0x07,0x00,
	0x0f,0x08,0x00,
	0x0f,0x09,0x00,
	0x0f,0x0a,0x00, //min_shp
	0x0f,0x0b,0x01, //max_shp
	0x0f,0x0c,0x03, //min_detail
	0x0f,0x0d,0x03, //max_detail
	0x0f,0x0e,0x01, //min_shp_gain
	0x0f,0x0f,0x3f, //max_shp_gain
		
	0x42,0x00,0x04, //thr_0
	0x42,0x01,0x0f,
	0x42,0x02,0x5f,
	0x42,0x03,0xaf,
		
	0x42,0x04,0x00, //hgain_0
	0x42,0x05,0x40,
	0x42,0x06,0x50,
	0x42,0x07,0x50,
	0x42,0x08,0x40,
	0x42,0x09,0x10,
		
	0x41,0x00,0x07,
	0x41,0x01,0x00, //rb_low_freq_wt
	0x41,0x02,0xff, //g_low_freq_wt
	0x41,0x03,0x00,
	0x41,0x04,0x24, //dir_add_coef
	0x41,0x05,0x00,
	0x41,0x06,0x10, //dir_mul_coef
		
	//Y edge
	0xff,0xfe,0x30,
	0x36,0x00,0x34, //yedge_ctrl
	0x36,0x01,0x14, //edge_ratio
	0x36,0x02,0x00, //ydns_level_man
	0x36,0x04,0x00, //gain_list0
	0x36,0x05,0x00,
	0x36,0x06,0x00,
	0x36,0x07,0x00,
	0x36,0x08,0x00,
	0x36,0x09,0x00,
	0x36,0x0a,0x00,
	0x36,0x0b,0x00, //gain_list7
		
	0x36,0x0c,0x00,
	0x36,0x0d,0x40, //threshold_0
	0x36,0x0e,0x00,
	0x36,0x0f,0xa0,
	0x36,0x10,0x01,
	0x36,0x11,0x80,
	0x36,0x12,0x04,
	0x36,0x13,0x00,
		
	0x36,0x14,0x01, //weight_0
	0x36,0x15,0x03,
	0x36,0x16,0x01,
	0x36,0x17,0x02,
	0x36,0x18,0x01,
		
	0x36,0x19,0x10, //diff
	0x36,0x1a,0x10, //sharpen_up
	0x36,0x1b,0x0e, //sharpen_down
		
	//SC,0xA
	0xff,0xfe,0x30,
	0x3b,0x00,0x00,
	0x3b,0x01,0x80, //hue_center1 //red
	0x3b,0x02,0x20, //hue_width
	0x3b,0x03,0x38, //color_gain
		
	0x3b,0x04,0x00,
	0x3b,0x05,0xe0, //hue_center2 //green
	0x3b,0x06,0x30, //hue_width
	0x3b,0x07,0x50, //color_gain
		
	0x3b,0x08,0x01,
	0x3b,0x09,0x48, //hue_center3 //blue
	0x3b,0x0a,0x20, //hue_width
	0x3b,0x0b,0x40, //color_gain
		
	0x3b,0x0c,0x07,
	0x3b,0x0d,0xff, //off_gain
		
	0x3b,0x0e,0x07, //area_en
		
	//Ca,0xr_back_line
	0xff,0xfe,0x30,
	0x3a,0x00,0x10, //left_d1
	0x3a,0x01,0x0c,
	0x3a,0x02,0x00,
	0x3a,0x03,0x20,
	0x3a,0x04,0x00,
	0x3a,0x05,0x3c,
	0x3a,0x06,0x00,
	0x3a,0x07,0x76,
	0x3a,0x08,0x00,
	0x3a,0x09,0x64,
	0x3a,0x0a,0x02,
	0x3a,0x0b,0xa8,
		
	0x3a,0x0c,0x10, //right_d1
	0x3a,0x0d,0x0c,
	0x3a,0x0e,0x00,
	0x3a,0x0f,0x20,
	0x3a,0x10,0x00,
	0x3a,0x11,0x3c,
	0x3a,0x12,0x00,
	0x3a,0x13,0x76,
	0x3a,0x14,0x04,
	0x3a,0x15,0x9c,
	0x3a,0x16,0x02,
	0x3a,0x17,0xa8,
		
	0x3a,0x18,0x1d, //zone1_y
	0x3a,0x19,0xff, //zone1_u
	0x3a,0x1a,0x6c, //zone1_v
	0x3a,0x1b,0x96,
	0x3a,0x1c,0x2c,
	0x3a,0x1d,0x15,
	0x3a,0x1e,0xe2,
	0x3a,0x1f,0x00,
	0x3a,0x20,0x95,
	0x3a,0x21,0x4d,
	0x3a,0x22,0x55,
	0x3a,0x23,0xff,
	0x3a,0x24,0xff, //portion_en
	0x3a,0x25,0x00,
	0x3a,0x26,0x20,
	0x3a,0x27,0x00,
	0x3a,0x28,0x20,
		
	0x3a,0x29,0x02,
	0x3a,0x2a,0x80,
	0x3a,0x2b,0x02,
	0x3a,0x2c,0x58,
	0x3a,0x2d,0x10,
	0x3a,0x2e,0x28,
	0x3a,0x2f,0x1d,
	0x3a,0x30,0xff,
	0x3a,0x31,0x6c,
	0x3a,0x32,0x01, //curve_en
	0x3a,0x33,0x03,
	0x3a,0x34,0x40,
	0x3a,0x35,0x10,
		
	//rg,0xb_protect
	0xff,0xfe,0x30,
	0x17,0x12,0x00, //rgb_protect_en
	0x17,0x13,0xa0,
	0x17,0x14,0x50,
	0x17,0x15,0x87,
	0x17,0x16,0xa0,
	0x17,0x17,0x00,
	0x17,0x18,0x96,
	0x17,0x19,0xa0,
	0x17,0x1a,0xb0,
		
	//TO,0xP
	0xff,0xfe,0x14,
	0x00,0x29,0x01, //AE_enable
	0x00,0x2a,0x01, //AWB_enable
	0x00,0x2d,0x00, //IRC_enable
		
	0xff,0xfe,0x30,
	0x00,0x00,0xe7, //0x27
	0x00,0x01,0xab, //0x21
	0x00,0x02,0x17, //0x92
	0x00,0x03,0x31,
	0x00,0x04,0x90,
	0x23,0x00,0x0a,
	0x00,0x19,0x09,
	0x07,0x1c,0x0a,
	0x17,0x00,0x09,
	0x17,0x01,0x40,
	0x17,0x02,0x40,
	0x17,0x04,0x20, //contrast_ygain
	0x17,0x07,0x00, //ybright
		
	//IQ,0x switch
	0xff,0xfe,0x14,
	0x02,0x64,0x07, //switch_mode
	0x02,0x66,0x01, //sensor_blc_en
	0x02,0x68,0x00,
	0x02,0x69,0x00,//sensor_page_addr
	0x02,0x6a,0x00, //sensor_page_val
		
	0x02,0x6c,0x00,
	0x02,0x6d,0x49,//snr_blc_addr
		
	//ci,0xp_noise 0x80300f00
	0x02,0x6e,0x0f,
	0x02,0x6f,0x0f,
	0x02,0x70,0x0f,
	0x02,0x71,0x0f,
	0x02,0x72,0x0f,
	0x02,0x73,0x0f,
	0x02,0x74,0x0f,
	0x02,0x75,0x0f,
	0x02,0x76,0x0f,
	0x02,0x77,0x0f,
	0x02,0x78,0x0f,
		
	//ye,0xdge_ratio 0x80303601
	0x02,0x79,0x20,
	0x02,0x7a,0x18,
	0x02,0x7b,0x10,
	0x02,0x7c,0x0c,
	0x02,0x7d,0x0a,
	0x02,0x7e,0x08,
	0x02,0x7f,0x06,
	0x02,0x80,0x06,
	0x02,0x81,0x06,
	0x02,0x82,0x06,
	0x02,0x83,0x06,
		
	//sa,0xt_u 0x80301701
	0x02,0x84,0x60,
	0x02,0x85,0x60,
	0x02,0x86,0x55,
	0x02,0x87,0x50,
	0x02,0x88,0x48,
	0x02,0x89,0x40,
	0x02,0x8a,0x30,
	0x02,0x8b,0x20,
	0x02,0x8c,0x50,
	0x02,0x8d,0x50,
	0x02,0x8e,0x50,
		
	//sa,0xt_v 0x80301702
	0x02,0x8f,0x60,
	0x02,0x90,0x60,
	0x02,0x91,0x55,
	0x02,0x92,0x50,
	0x02,0x93,0x48,
	0x02,0x94,0x40,
	0x02,0x95,0x30,
	0x02,0x96,0x20,
	0x02,0x97,0x50,
	0x02,0x98,0x50,
	0x02,0x99,0x50,
		
	//co,0xntrast 0x80301704
	0x02,0x9a,0x22,
	0x02,0x9b,0x22,
	0x02,0x9c,0x22,
	0x02,0x9d,0x20,
	0x02,0x9e,0x20,
	0x02,0x9f,0x20,
	0x02,0xa0,0x20,
	0x02,0xa1,0x18,
	0x02,0xa2,0x18,
	0x02,0xa3,0x18,
	0x02,0xa4,0x18,
		
	//yb,0xright 0x80301707
	0x02,0xa5,0x00,
	0x02,0xa6,0x00,
	0x02,0xa7,0x00,
	0x02,0xa8,0x00,
	0x02,0xa9,0x02,
	0x02,0xaa,0x04,
	0x02,0xab,0x06,
	0x02,0xac,0x08,
	0x02,0xad,0x08,
	0x02,0xae,0x08,
	0x02,0xaf,0x08,
		
	//is,0xp_blc 0x803000a0~00a3
	0x02,0xb0,0x0a,
	0x02,0xb1,0x0a,
	0x02,0xb2,0x0a,
	0x02,0xb3,0x0a,
	0x02,0xb4,0x0a,
	0x02,0xb5,0x0a,
	0x02,0xb6,0x0a,
	0x02,0xb7,0x0a,
	0x02,0xb8,0x0a,
	0x02,0xb9,0x0a,
	0x02,0xba,0x0a,
	0x02,0xbb,0x0a,
	0x02,0xbc,0x0a,
	0x02,0xbd,0x0a,
	0x02,0xbe,0x0a,
	0x02,0xbf,0x0a,
	0x02,0xc0,0x0d,
	0x02,0xc1,0x0d,
	0x02,0xc2,0x0d,
	0x02,0xc3,0x0d,
	0x02,0xc4,0x10,
	0x02,0xc5,0x10,
	0x02,0xc6,0x10,
	0x02,0xc7,0x10,
	0x02,0xc8,0x10,
	0x02,0xc9,0x10,
	0x02,0xca,0x10,
	0x02,0xcb,0x10,
	0x02,0xcc,0x10,
	0x02,0xcd,0x10,
	0x02,0xce,0x10,
	0x02,0xcf,0x10,
	0x02,0xd0,0x10,
	0x02,0xd1,0x10,
	0x02,0xd2,0x10,
	0x02,0xd3,0x10,
	0x02,0xd4,0x10,
	0x02,0xd5,0x10,
	0x02,0xd6,0x10,
	0x02,0xd7,0x10,
	0x02,0xd8,0x10,
	0x02,0xd9,0x10,
	0x02,0xda,0x10,
	0x02,0xdb,0x10,
		
	//sn,0xr_blc_value
	0x02,0xdc,0x0a,
	0x02,0xdd,0x0a,
	0x02,0xde,0x0a,
	0x02,0xdf,0x0a,
	0x02,0xe0,0x0d,
	0x02,0xe1,0x10,
	0x02,0xe2,0x10,
	0x02,0xe3,0x10,
	0x02,0xe4,0x10,
	0x02,0xe5,0x10,
	0x02,0xe6,0x10,
		
	//av,0xg_size 0x80301f00~1f07
	0x02,0xe7,0x00, //day_mode
	0x02,0xe8,0x00,
	0x02,0xe9,0x00,
	0x02,0xea,0x00,
	0x02,0xeb,0x05,
	0x02,0xec,0x00,
	0x02,0xed,0x02,
	0x02,0xee,0xc0,
		
	0x02,0xef,0x00, //night_mode
	0x02,0xf0,0x00,
	0x02,0xf1,0x00,
	0x02,0xf2,0x00,
	0x02,0xf3,0x05,
	0x02,0xf4,0x00,
	0x02,0xf5,0x02,
	0x02,0xf6,0xc0,
		
	0x02,0xf7,0x00, //midnight_mode
	0x02,0xf8,0x00,
	0x02,0xf9,0x00,
	0x02,0xfa,0x00,
	0x02,0xfb,0x05,
	0x02,0xfc,0x00,
	0x02,0xfd,0x02,
	0x02,0xfe,0xc0,
		
	//av,0xg_weight 0x8014005b~0073
	0x02,0xff,0x04, //day_mode
	0x03,0x00,0x84,
	0x03,0x01,0x04,
	0x03,0x02,0x04,
	0x03,0x03,0x04,
	0x03,0x04,0x04,
	0x03,0x05,0x04,
	0x03,0x06,0x04,
	0x03,0x07,0x04,
	0x03,0x08,0x04,
	0x03,0x09,0x04,
	0x03,0x0a,0x04,
	0x03,0x0b,0x04,
	0x03,0x0c,0x04,
	0x03,0x0d,0x04,
	0x03,0x0e,0x04,
	0x03,0x0f,0x04,
	0x03,0x10,0x04,
	0x03,0x11,0x04,
	0x03,0x12,0x04,
	0x03,0x13,0x04,
	0x03,0x14,0x04,
	0x03,0x15,0x04,
	0x03,0x16,0x04,
	0x03,0x17,0x04,
		
	0x03,0x18,0x08, //night_mode
	0x03,0x19,0x88,
	0x03,0x1a,0x08,
	0x03,0x1b,0x08,
	0x03,0x1c,0x08,
	0x03,0x1d,0x08,
	0x03,0x1e,0x08,
	0x03,0x1f,0x08,
	0x03,0x20,0x08,
	0x03,0x21,0x08,
	0x03,0x22,0x08,
	0x03,0x23,0x08,
	0x03,0x24,0x08,
	0x03,0x25,0x08,
	0x03,0x26,0x08,
	0x03,0x27,0x08,
	0x03,0x28,0x08,
	0x03,0x29,0x08,
	0x03,0x2a,0x08,
	0x03,0x2b,0x08,
	0x03,0x2c,0x08,
	0x03,0x2d,0x08,
	0x03,0x2e,0x08,
	0x03,0x2f,0x08,
	0x03,0x30,0x08,
		
	0x03,0x31,0x06, //midnight_mode
	0x03,0x32,0x86,
	0x03,0x33,0x06,
	0x03,0x34,0x06,
	0x03,0x35,0x06,
	0x03,0x36,0x06,
	0x03,0x37,0x06,
	0x03,0x38,0x06,
	0x03,0x39,0x06,
	0x03,0x3a,0x06,
	0x03,0x3b,0x06,
	0x03,0x3c,0x06,
	0x03,0x3d,0x06,
	0x03,0x3e,0x06,
	0x03,0x3f,0x06,
	0x03,0x40,0x06,
	0x03,0x41,0x06,
	0x03,0x42,0x06,
	0x03,0x43,0x06,
	0x03,0x44,0x06,
	0x03,0x45,0x06,
	0x03,0x46,0x06,
	0x03,0x47,0x06,
	0x03,0x48,0x06,
	0x03,0x49,0x06,
		
	//sc,0xene_condition
	0x03,0x4a,0x00,
	0x03,0x4b,0x00, //area_avg_switch_h
	0x03,0x4c,0x00,
	0x03,0x4d,0xb0, //area_avg_switch_l
	0x03,0x4e,0x00,
	0x03,0x4f,0x50, //avg_switch
	0x03,0x50,0x00,
	0x03,0x51,0xf0, //gain_switch_0
	0x03,0x52,0x00,
	0x03,0x53,0xf0, //gain_switch_1
	0x03,0x54,0x03,
	0x03,0x55,0x00, //gain_switch_2
	0x03,0x56,0x03,
	0x03,0x57,0xff, //gain_switch_3
	//Ga,0xmma_mode
	0x03,0x58,0x03,
		
	//RG,0xB Gamma 0x80301400~1440
	0x03,0x59,0x00, //day_mode
	0x03,0x5a,0x05,
	0x03,0x5b,0x0a,
	0x03,0x5c,0x0f,
	0x03,0x5d,0x15,
	0x03,0x5e,0x1a,
	0x03,0x5f,0x1f,
	0x03,0x60,0x24,
	0x03,0x61,0x29,
	0x03,0x62,0x2e,
	0x03,0x63,0x33,
	0x03,0x64,0x38,
	0x03,0x65,0x3c,
	0x03,0x66,0x41,
	0x03,0x67,0x45,
	0x03,0x68,0x49,
	0x03,0x69,0x4d,
	0x03,0x6a,0x51,
	0x03,0x6b,0x55,
	0x03,0x6c,0x58,
	0x03,0x6d,0x5c,
	0x03,0x6e,0x5f,
	0x03,0x6f,0x62,
	0x03,0x70,0x65,
	0x03,0x71,0x68,
	0x03,0x72,0x6b,
	0x03,0x73,0x6e,
	0x03,0x74,0x71,
	0x03,0x75,0x74,
	0x03,0x76,0x76,
	0x03,0x77,0x79,
	0x03,0x78,0x7b,
	0x03,0x79,0x7d,
	0x03,0x7a,0x82,
	0x03,0x7b,0x86,
	0x03,0x7c,0x8a,
	0x03,0x7d,0x8e,
	0x03,0x7e,0x92,
	0x03,0x7f,0x95,
	0x03,0x80,0x99,
	0x03,0x81,0x9c,
	0x03,0x82,0x9f,
	0x03,0x83,0xa3,
	0x03,0x84,0xa6,
	0x03,0x85,0xa9,
	0x03,0x86,0xac,
	0x03,0x87,0xaf,
	0x03,0x88,0xb2,
	0x03,0x89,0xb5,
	0x03,0x8a,0xba,
	0x03,0x8b,0xbf,
	0x03,0x8c,0xc4,
	0x03,0x8d,0xc9,
	0x03,0x8e,0xce,
	0x03,0x8f,0xd3,
	0x03,0x90,0xd8,
	0x03,0x91,0xdc,
	0x03,0x92,0xe1,
	0x03,0x93,0xe5,
	0x03,0x94,0xe9,
	0x03,0x95,0xee,
	0x03,0x96,0xf2,
	0x03,0x97,0xf6,
	0x03,0x98,0xfb,
	0x03,0x99,0xff,
		
	0x03,0x9a,0x00, //night_mode
	0x03,0x9b,0x05,
	0x03,0x9c,0x0a,
	0x03,0x9d,0x0f,
	0x03,0x9e,0x15,
	0x03,0x9f,0x1a,
	0x03,0xa0,0x1f,
	0x03,0xa1,0x24,
	0x03,0xa2,0x29,
	0x03,0xa3,0x2e,
	0x03,0xa4,0x33,
	0x03,0xa5,0x38,
	0x03,0xa6,0x3c,
	0x03,0xa7,0x41,
	0x03,0xa8,0x45,
	0x03,0xa9,0x49,
	0x03,0xaa,0x4d,
	0x03,0xab,0x51,
	0x03,0xac,0x55,
	0x03,0xad,0x58,
	0x03,0xae,0x5c,
	0x03,0xaf,0x5f,
	0x03,0xb0,0x62,
	0x03,0xb1,0x65,
	0x03,0xb2,0x68,
	0x03,0xb3,0x6b,
	0x03,0xb4,0x6e,
	0x03,0xb5,0x71,
	0x03,0xb6,0x74,
	0x03,0xb7,0x76,
	0x03,0xb8,0x79,
	0x03,0xb9,0x7b,
	0x03,0xba,0x7d,
	0x03,0xbb,0x82,
	0x03,0xbc,0x86,
	0x03,0xbd,0x8a,
	0x03,0xbe,0x8e,
	0x03,0xbf,0x92,
	0x03,0xc0,0x95,
	0x03,0xc1,0x99,
	0x03,0xc2,0x9c,
	0x03,0xc3,0x9f,
	0x03,0xc4,0xa3,
	0x03,0xc5,0xa6,
	0x03,0xc6,0xa9,
	0x03,0xc7,0xac,
	0x03,0xc8,0xaf,
	0x03,0xc9,0xb2,
	0x03,0xca,0xb5,
	0x03,0xcb,0xba,
	0x03,0xcc,0xbf,
	0x03,0xcd,0xc4,
	0x03,0xce,0xc9,
	0x03,0xcf,0xce,
	0x03,0xd0,0xd3,
	0x03,0xd1,0xd8,
	0x03,0xd2,0xdc,
	0x03,0xd3,0xe1,
	0x03,0xd4,0xe5,
	0x03,0xd5,0xe9,
	0x03,0xd6,0xee,
	0x03,0xd7,0xf2,
	0x03,0xd8,0xf6,
	0x03,0xd9,0xfb,
	0x03,0xda,0xff,
		
	0x03,0xdb,0x00, //midnight_mode
	0x03,0xdc,0x05,
	0x03,0xdd,0x0b,
	0x03,0xde,0x10,
	0x03,0xdf,0x15,
	0x03,0xe0,0x1b,
	0x03,0xe1,0x20,
	0x03,0xe2,0x25,
	0x03,0xe3,0x2b,
	0x03,0xe4,0x30,
	0x03,0xe5,0x34,
	0x03,0xe6,0x39,
	0x03,0xe7,0x3e,
	0x03,0xe8,0x43,
	0x03,0xe9,0x47,
	0x03,0xea,0x4b,
	0x03,0xeb,0x50,
	0x03,0xec,0x54,
	0x03,0xed,0x57,
	0x03,0xee,0x5b,
	0x03,0xef,0x5f,
	0x03,0xf0,0x62,
	0x03,0xf1,0x66,
	0x03,0xf2,0x69,
	0x03,0xf3,0x6d,
	0x03,0xf4,0x70,
	0x03,0xf5,0x73,
	0x03,0xf6,0x76,
	0x03,0xf7,0x79,
	0x03,0xf8,0x7c,
	0x03,0xf9,0x7e,
	0x03,0xfa,0x81,
	0x03,0xfb,0x84,
	0x03,0xfc,0x88,
	0x03,0xfd,0x8d,
	0x03,0xfe,0x91,
	0x03,0xff,0x95,
	0x04,0x00,0x99,
	0x04,0x01,0x9d,
	0x04,0x02,0xa0,
	0x04,0x03,0xa4,
	0x04,0x04,0xa7,
	0x04,0x05,0xaa,
	0x04,0x06,0xad,
	0x04,0x07,0xb0,
	0x04,0x08,0xb3,
	0x04,0x09,0xb6,
	0x04,0x0a,0xb9,
	0x04,0x0b,0xbc,
	0x04,0x0c,0xc1,
	0x04,0x0d,0xc6,
	0x04,0x0e,0xcb,
	0x04,0x0f,0xcf,
	0x04,0x10,0xd4,
	0x04,0x11,0xd8,
	0x04,0x12,0xdc,
	0x04,0x13,0xe1,
	0x04,0x14,0xe5,
	0x04,0x15,0xe8,
	0x04,0x16,0xec,
	0x04,0x17,0xf0,
	0x04,0x18,0xf4,
	0x04,0x19,0xf8,
	0x04,0x1a,0xfb,
	0x04,0x1b,0xff,
		
	//RA,0xW Gamma 0x80300900~0940
	0x04,0x1c,0x00, //day_mode
	0x04,0x1d,0x05,
	0x04,0x1e,0x0a,
	0x04,0x1f,0x0f,
	0x04,0x20,0x14,
	0x04,0x21,0x1a,
	0x04,0x22,0x1f,
	0x04,0x23,0x24,
	0x04,0x24,0x29,
	0x04,0x25,0x2d,
	0x04,0x26,0x32,
	0x04,0x27,0x37,
	0x04,0x28,0x3b,
	0x04,0x29,0x3f,
	0x04,0x2a,0x44,
	0x04,0x2b,0x48,
	0x04,0x2c,0x4c,
	0x04,0x2d,0x4f,
	0x04,0x2e,0x53,
	0x04,0x2f,0x56,
	0x04,0x30,0x5a,
	0x04,0x31,0x5d,
	0x04,0x32,0x60,
	0x04,0x33,0x63,
	0x04,0x34,0x66,
	0x04,0x35,0x68,
	0x04,0x36,0x6b,
	0x04,0x37,0x6d,
	0x04,0x38,0x70,
	0x04,0x39,0x72,
	0x04,0x3a,0x74,
	0x04,0x3b,0x76,
	0x04,0x3c,0x79,
	0x04,0x3d,0x7d,
	0x04,0x3e,0x80,
	0x04,0x3f,0x84,
	0x04,0x40,0x88,
	0x04,0x41,0x8b,
	0x04,0x42,0x8e,
	0x04,0x43,0x91,
	0x04,0x44,0x95,
	0x04,0x45,0x98,
	0x04,0x46,0x9b,
	0x04,0x47,0x9d,
	0x04,0x48,0xa0,
	0x04,0x49,0xa3,
	0x04,0x4a,0xa6,
	0x04,0x4b,0xa9,
	0x04,0x4c,0xac,
	0x04,0x4d,0xb1,
	0x04,0x4e,0xb6,
	0x04,0x4f,0xbb,
	0x04,0x50,0xc0,
	0x04,0x51,0xc5,
	0x04,0x52,0xca,
	0x04,0x53,0xcf,
	0x04,0x54,0xd5,
	0x04,0x55,0xda,
	0x04,0x56,0xdf,
	0x04,0x57,0xe4,
	0x04,0x58,0xea,
	0x04,0x59,0xef,
	0x04,0x5a,0xf4,
	0x04,0x5b,0xfa,
	0x04,0x5c,0xff,
		
	0x04,0x5d,0x00, //night_mode
	0x04,0x5e,0x04,
	0x04,0x5f,0x08,
	0x04,0x60,0x0d,
	0x04,0x61,0x11,
	0x04,0x62,0x16,
	0x04,0x63,0x1a,
	0x04,0x64,0x1e,
	0x04,0x65,0x23,
	0x04,0x66,0x27,
	0x04,0x67,0x2b,
	0x04,0x68,0x2f,
	0x04,0x69,0x33,
	0x04,0x6a,0x37,
	0x04,0x6b,0x3b,
	0x04,0x6c,0x3f,
	0x04,0x6d,0x42,
	0x04,0x6e,0x46,
	0x04,0x6f,0x49,
	0x04,0x70,0x4c,
	0x04,0x71,0x4f,
	0x04,0x72,0x52,
	0x04,0x73,0x55,
	0x04,0x74,0x58,
	0x04,0x75,0x5b,
	0x04,0x76,0x5e,
	0x04,0x77,0x60,
	0x04,0x78,0x63,
	0x04,0x79,0x66,
	0x04,0x7a,0x68,
	0x04,0x7b,0x6a,
	0x04,0x7c,0x6d,
	0x04,0x7d,0x6f,
	0x04,0x7e,0x73,
	0x04,0x7f,0x77,
	0x04,0x80,0x7c,
	0x04,0x81,0x7f,
	0x04,0x82,0x83,
	0x04,0x83,0x87,
	0x04,0x84,0x8a,
	0x04,0x85,0x8e,
	0x04,0x86,0x91,
	0x04,0x87,0x94,
	0x04,0x88,0x98,
	0x04,0x89,0x9b,
	0x04,0x8a,0x9e,
	0x04,0x8b,0xa1,
	0x04,0x8c,0xa4,
	0x04,0x8d,0xa7,
	0x04,0x8e,0xad,
	0x04,0x8f,0xb2,
	0x04,0x90,0xb8,
	0x04,0x91,0xbe,
	0x04,0x92,0xc4,
	0x04,0x93,0xc9,
	0x04,0x94,0xcf,
	0x04,0x95,0xd4,
	0x04,0x96,0xda,
	0x04,0x97,0xdf,
	0x04,0x98,0xe4,
	0x04,0x99,0xea,
	0x04,0x9a,0xef,
	0x04,0x9b,0xf5,
	0x04,0x9c,0xfa,
	0x04,0x9d,0xff,
		
	0x04,0x9e,0x00, //midnight_mode
	0x04,0x9f,0x03,
	0x04,0xa0,0x06,
	0x04,0xa1,0x0a,
	0x04,0xa2,0x0d,
	0x04,0xa3,0x10,
	0x04,0xa4,0x14,
	0x04,0xa5,0x17,
	0x04,0xa6,0x1a,
	0x04,0xa7,0x1d,
	0x04,0xa8,0x21,
	0x04,0xa9,0x24,
	0x04,0xaa,0x27,
	0x04,0xab,0x2a,
	0x04,0xac,0x2e,
	0x04,0xad,0x31,
	0x04,0xae,0x34,
	0x04,0xaf,0x37,
	0x04,0xb0,0x3a,
	0x04,0xb1,0x3d,
	0x04,0xb2,0x40,
	0x04,0xb3,0x43,
	0x04,0xb4,0x46,
	0x04,0xb5,0x48,
	0x04,0xb6,0x4b,
	0x04,0xb7,0x4e,
	0x04,0xb8,0x51,
	0x04,0xb9,0x53,
	0x04,0xba,0x56,
	0x04,0xbb,0x58,
	0x04,0xbc,0x5b,
	0x04,0xbd,0x5d,
	0x04,0xbe,0x60,
	0x04,0xbf,0x64,
	0x04,0xc0,0x69,
	0x04,0xc1,0x6d,
	0x04,0xc2,0x71,
	0x04,0xc3,0x75,
	0x04,0xc4,0x79,
	0x04,0xc5,0x7d,
	0x04,0xc6,0x81,
	0x04,0xc7,0x85,
	0x04,0xc8,0x88,
	0x04,0xc9,0x8c,
	0x04,0xca,0x90,
	0x04,0xcb,0x93,
	0x04,0xcc,0x96,
	0x04,0xcd,0x9a,
	0x04,0xce,0x9d,
	0x04,0xcf,0xa4,
	0x04,0xd0,0xab,
	0x04,0xd1,0xb1,
	0x04,0xd2,0xb8,
	0x04,0xd3,0xbe,
	0x04,0xd4,0xc4,
	0x04,0xd5,0xca,
	0x04,0xd6,0xd0,
	0x04,0xd7,0xd6,
	0x04,0xd8,0xdc,
	0x04,0xd9,0xe2,
	0x04,0xda,0xe8,
	0x04,0xdb,0xee,
	0x04,0xdc,0xf4,
	0x04,0xdd,0xf9,
	0x04,0xde,0xff,
		
	//RG,0xB Gamma HF 0x80301450/1452/1453
	0x04,0xdf,0xf0, //day_mode
	0x04,0xe0,0x80,
	0x04,0xe1,0x60,
	0x04,0xe2,0xd0, //night_mode
	0x04,0xe3,0x80,
	0x04,0xe4,0x60,
	0x04,0xe5,0x80, //midnight_mode
	0x04,0xe6,0x80,
	0x04,0xe7,0x60,
		
	//Ta,0xrget_judge_table
	0x04,0xf4,0x00,
	0x04,0xf5,0x00,
	0x04,0xf6,0x02,
	0x04,0xf7,0x00, //target_judge_thr_0
	0x04,0xf8,0x00,
	0x04,0xf9,0x00,
	0x04,0xfa,0x04,
	0x04,0xfb,0x00, //target_judge_thr_1
	0x04,0xfc,0x00,
	0x04,0xfd,0x00,
	0x04,0xfe,0x08,
	0x04,0xff,0x00, //target_judge_thr_2
	0x05,0x00,0x00,
	0x05,0x01,0x00,
	0x05,0x02,0x20,
	0x05,0x03,0x00, //target_judge_thr_3
	0x05,0x04,0x00,
	0x05,0x05,0x00,
	0x05,0x06,0xe0,
	0x05,0x07,0x00, //target_judge_thr_4
	0x05,0x08,0x00,
	0x05,0x09,0x80, //target_table_0
	0x05,0x0a,0x00,
	0x05,0x0b,0x88, //target_table_1
	0x05,0x0c,0x00,
	0x05,0x0d,0x98, //target_table_2
	0x05,0x0e,0x00,
	0x05,0x0f,0xa8, //target_table_3
	0x05,0x10,0x00,
	0x05,0x11,0xb0, //target_table_4
	0x05,0x12,0x00,
	0x05,0x13,0xb8, //target_table_5
	0x05,0x14,0x00,
	0x05,0x15,0x00,
	0x05,0x16,0x24,
	0x05,0x17,0xc0, //target_cal_factor
		
	//IQ,0x switch enable
	0x04,0xec,0x03,
	0x04,0xed,0xff, //max_avg_value
	0x04,0xe8,0x0f, //frame_delay
	0x04,0xf0,0x1f, //effect_delay
		
	0x02,0x65,0x01, //target_switch_mode
	0x05,0x18,0x00, //Reserved_en
		
	0x00,0x2c,0x01, //IQ_switch_en
	0x00,0x46,0x04, //effect_iq_mode
	0x00,0x47,0x04, //effect_scene_mode
		
	//**,0x******** Step 10 stream on ********************************//
	// 1,0x0.1 config cif delay number	( /*CFG*/)
	0xff,0xfd,0x80,
	0xff,0xfe,0x14,
	//0x,0x065c,0x02,  //default delay_counter_number=0xf
		
	// 1,0x0.2 output_enable
	0xff,0xfe, 0x20,
	0x00,0x02, 0x80,//[7]cif enable
		
	//**,0x******** Step 11 tve2dvp ********************************//
	0xff,0xfe, 0x50,
	0x00,0xbd, 0x1f, 
		
	0x00,0x26, 0x04,
		
	0xff,0xfe, 0x26,
	0x60,0x05, 0xd4,
	0x60,0x0d, 0x2f,
		
	//4.,0x3-BT1120
	0xff,0xfe, 0x25,
	0x60,0x00, 0x1c,
	0x60,0x10, 0x03,
	0x60,0x19, 0x03,
	0x60,0x1a, 0x03,
	0x60,0x0f, 0x00,
	0x60,0x1b, 0x88,
		
	0x60,0x38, 0x00,
	0x60,0x39, 0x00,
	0x60,0x3a, 0x80,
	0x60,0x3b, 0x02,
	0x60,0x44, 0x18,
		
	0xff,0xfd,0x80,	
	0xff,0xfe,0x50,
	0x00,0x4d,0x01,


	-1,-1,-1,
};

SENSOR_INIT_SECTION static const unsigned char h63_Init_regs[] = {			  
	0x12,0x40,
	0x48,0x85,
	0x48,0x05,
	0x0E,0x11,
	0x0F,0x14,
	0x10,0x1E,
	0x11,0x80,
	0x0D,0xD0,
	0x5F,0x41,
	0x60,0x20,
	0x58,0x18,
	0x57,0x60,
	0x20,0xc0,
	0x21,0x03,
	0x22,0xa0,
	0x23,0x03,
	0x24,0x80,
	0x25,0xD0,
	0x26,0x22,
	0x27,0xA2,
	0x28,0x13,
	0x29,0x02,
	0x2A,0x96,
	0x2B,0x12,
	0x2C,0x00,
	0x2D,0x00,
	0x2E,0xB9,
	0x2F,0x40,
	0x41,0x84,
	0x42,0x32,
	0x46,0x00,
	0x47,0x42,
	0x76,0x40,
	0x77,0x06,
	0x80,0x01,
	0xAF,0x22,
	0xAB,0x00,
	0x9B,0x83,
	0x1D,0xff,
	0x1E,0x1f,
	0x6C,0x50,
	0x6E,0x2C,
	0x70,0x6C,
	0x71,0x6D,
	0x72,0x69,
	0x73,0x46,
	0x74,0x02,
	0x78,0x8D,
	0x89,0x01,
	0x6B,0x20,
	0x86,0x40,
	0x30,0x86,
	0x31,0x04,
	0x32,0x19,
	0x33,0x10,
	0x34,0x2A,
	0x35,0x2A,
	0x3A,0xA0,
	0x3B,0x00,
	0x3C,0x38,
	0x3D,0x41,
	0x3E,0xE0,
	0x56,0x12,
	0x59,0x46,
	0x5A,0x02,
	0x85,0x1E,
	0x8A,0x04,
	0x9C,0x61,
	0x5B,0xAC,
	0x5C,0x61,
	0x5D,0xA6,
	0x5E,0x14,
	0x64,0xE0,
	0x66,0x04,
	0x67,0x53,
	0x68,0x00,
	0x69,0x74,
	0x7A,0x60,
	0x8F,0x91,
	0xAE,0x30,
	0x13,0x81,
	0x96,0x84,
	0x4A,0x05,
	0x7E,0xCD,
	0x50,0x02,
	0x49,0x10,
	0x7B,0x4A,
	0x7C,0x0C,
	0x7F,0x56,
	0x62,0x21,
	0x90,0x00,
	0x8C,0xFF,
	0x8D,0xC7,
	0x8E,0x00,
	0x8B,0x01,
	0x0C,0x00,
	0xBB,0x11,
	0xA0,0x10,
	0x6A,0x17,
	0x65,0x34,
	0x82,0x00,
	0x19,0x20,
	0x12,0x04,
	0x48,0x85,
	0x48,0x05,


	-1,-1,

};



SENSOR_OP_SECTION const _Sensor_Adpt_ xc7016_h63_cmd= 
{
	.typ = 1, //YUV
	.pixelw = 1280,
	.pixelh= 720,
	.hsyn = 1,
	.vsyn = 0,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)XC7016_IQ_InitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = {0x6a,0x12,0x6a,0x12},
	. mclk = 24000000,
	.p_fun_adapt    = {NULL,NULL,NULL},
	.p_xc7016_adapt = {XC7016_bypass_on,XC7016_bypass_off,h63_Init_regs,0x63,0x80,0x81,0x01,0x01,0x0b},
};

const _Sensor_Ident_ xc7016_h63_init=
{
	0x12,0x36,0x37,0x02,0x01,0xfffb
};


#endif
