#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"

#if DEV_SENSOR_XC7011_H63

//XC7011_Init_IQ_regs
//XC7011_bypass_on
//h63_Init_regs[]
//XC7011_bypass_off




SENSOR_INIT_SECTION static const unsigned char XC7011_bypass_on[] = {

	0xff,0xfd,0x80,
	0xff,0xfe,0x50,
	0x00,0x4d,0x01,
	-1,-1,

};

SENSOR_INIT_SECTION static const unsigned char  XC7011_bypass_off[] = {

	0xff,0xfd,0x80,
	0xff,0xfe,0x50,
	0x00,0x4d,0x00,
	-1,-1,

};

SENSOR_INIT_SECTION static const unsigned char XC7011_IQ_InitTable[CMOS_INIT_LEN] = 
{
#if 0
	0xff,0xfd, 0x80,
	0xff,0xfe, 0x50,
	0x00,0x1c, 0xff,
	0x00,0x1d, 0xff,
	0x00,0x1e, 0xff,
	0x00,0x1f, 0xff,
	0x00,0x18, 0x00,
	0x00,0x19, 0x00,
	0x00,0x1a, 0x00,
	0x00,0x1b, 0x00,
	0x00,0xbc, 0x11,
	0x00,0xbd, 0x00,
	0x00,0xbe, 0x00,
	0x00,0xbf, 0x00,
	
	// 2.2 wait pll lock  ( /*READ ONLY*/)
	0xfe,0xfe, 0xf0,
	0xfe,0xfe, 0x01,  //delay 1ms
	0xfe,0xfe, 0xf1,
	
	0xff,0xfe, 0x50,
	0x00,0x30, 0x05,
	0x00,0x31, 0x02,
	0x00,0x32, 0x07,
	0x00,0x20, 0x01,
	0x00,0x21, 0x0E,
	0x00,0x23, 0x42,
	0x00,0x24, 0x03,
	0x00,0x25, 0x06,
	0x00,0x26, 0x01,
	0x00,0x27, 0x06,
	0x00,0x28, 0x08,
	0x00,0x29, 0x06,
	0xff,0xfe, 0x25,
	0x20,0x0b, 0x33,
	0x00,0x02, 0xc0,
	0xff,0xfe, 0x50,
	0x02,0x00, 0x03,
	0x02,0x04, 0x03,
	0x02,0x08, 0x02,
	0x02,0x08, 0x01,
	0xff,0xfd, 0x80,
	0xff,0xfe, 0x50,
	0x00,0xbc, 0x11,
	0x00,0x1b, 0x00,
	0x00,0x90, 0x29,
	0xff,0xfe, 0x20,
	0x00,0x00, 0x20,
	0x00,0x04, 0x05,
	0x00,0x05, 0x00,
	0x00,0x06, 0x02,
	0x00,0x07, 0xD0,
	0xff,0xfe, 0x26,
	0x40,0x00, 0xF9,
	0x60,0x01, 0x14,
	0x60,0x05, 0xc4,
	0x60,0x06, 0x0A,
	0x60,0x07, 0x8C,
	0x60,0x08, 0x09,
	0x60,0x09, 0xFC,
	0x80,0x00, 0x3f,
	0x80,0x01, 0x00,
	0x80,0x02, 0x05,
	0x80,0x03, 0xD0,
	0x80,0x04, 0x02,
	0x80,0x05, 0x03,
	0x80,0x06, 0x05,
	0x80,0x07, 0x99,
	0x80,0x10, 0x04,
	0x80,0x12, 0x00,
	0x80,0x13, 0x05,
	0x80,0x14, 0xD0,
	0x80,0x15, 0x02,
	0x80,0x16, 0x00,
	0x80,0x17, 0x00,
	0x80,0x18, 0x00,
	0x80,0x19, 0x00,
	0xff,0xfe, 0x30,
	0x00,0x01, 0x81,
	0x00,0x04, 0x18,
	0x00,0x06, 0x05,
	0x00,0x07, 0x00,
	0x00,0x08, 0x02,
	0x00,0x09, 0xD0,
	0x00,0x0a, 0x05,
	0x00,0x0b, 0x00,
	0x00,0x0c, 0x02,
	0x00,0x0d, 0xD0,
	0x00,0x27, 0xF1,
	0x00,0x5e, 0x04,
	0x00,0x5f, 0xFF,
	0x00,0x60, 0x02,
	0x00,0x61, 0xCF,
	0x19,0x08, 0x01,
	0x19,0x00, 0x00,
	0x19,0x01, 0x00,
	0x19,0x02, 0x00,
	0x19,0x03, 0x00,
	0x19,0x04, 0x05,
	0x19,0x05, 0x00,
	0x19,0x06, 0x02,
	0x19,0x07, 0xD0,
	0xff,0xfe, 0x30,
	0x1f,0x00, 0x00,
	0x1f,0x01, 0x00,
	0x1f,0x02, 0x00,
	0x1f,0x03, 0x00,
	0x1f,0x04, 0x05,
	0x1f,0x05, 0x00,
	0x1f,0x06, 0x02,
	0x1f,0x07, 0xd0,
	0x1f,0x08, 0x03,
	0xff,0xfe, 0x14,
	0x00,0x26, 0x01,
	0x00,0xbe, 0x60,
	0x00,0xbf, 0x00,
	0x00,0xc0, 0x06,
	0x00,0xc1, 0x02,
	0x00,0xc3, 0x00,
	0x00,0xc4, 0x00,
	0x00,0xc5, 0x02,
	0x00,0xc6, 0x00,
	0x00,0xc7, 0x01,
	0x00,0xc8, 0x00,
	0x00,0xc9, 0x00,
	0x00,0xcc, 0x00,
	0x00,0xcd, 0xff,
	0x00,0xce, 0x00,
	0x00,0xcf, 0xff,
	0x00,0xd0, 0x00,
	0x00,0xd1, 0x00,
	0x00,0xd2, 0x00,
	0x00,0xd3, 0x00,
	0x00,0xe4, 0x00,
	0x00,0xe5, 0x00,
	0x00,0xec, 0x00,
	0x00,0xed, 0xff,
	0x00,0xee, 0x00,
	0x00,0xef, 0x00,
	0x00,0xf0, 0x00,
	0x00,0xf1, 0x00,
	0x00,0xf2, 0x00,
	0x00,0xf3, 0x00,
	0xff,0xfe, 0x14,
	0x00,0xb4, 0x02,
	0x00,0xb8, 0x0f,
	0x00,0xb9, 0x00,
	0xff,0xfe, 0x14,
	0x00,0x35, 0x01,
	0x00,0xaa, 0x03,
	0x00,0xab, 0xff,
	0x00,0xba, 0x00,
	0x00,0x6a, 0x01,
	0x00,0x6b, 0x40,
	0x00,0x6c, 0x01,
	0x00,0x6d, 0xc0,
	0x00,0x73, 0x08,
	0x00,0x92, 0x32,
	0x00,0x93, 0x00,
	0xff,0xfe, 0x14,
	0x00,0x39, 0x00,
	0x00,0x60, 0x00,
	0x00,0x76, 0x01,
	0x00,0x79, 0x01,
	0x00,0x7a, 0x00,
	0x00,0x7b, 0x30,
	0x00,0x7c, 0x00,
	0x00,0x7d, 0xc0,
	0x00,0x77, 0x30,
	0x00,0x78, 0x00,
	0x00,0x7f, 0x80,
	0x00,0x87, 0x60,
	0x00,0x88, 0x02,
	0x00,0x8c, 0x03,
	0x00,0x8d, 0xc0,
	0xff,0xfe, 0x14,
	0x00,0x3f, 0x10,
	0x00,0x40, 0x10,
	0x00,0x41, 0x10,
	0x00,0x42, 0x10,
	0x00,0x43, 0x10,
	0x00,0x44, 0x10,
	0x00,0x45, 0x10,
	0x00,0x46, 0x10,
	0x00,0x47, 0x10,
	0x00,0x48, 0x10,
	0x00,0x49, 0x10,
	0x00,0x4a, 0x10,
	0x00,0x4b, 0x10,
	0x00,0x4c, 0x10,
	0x00,0x4d, 0x10,
	0x00,0x4e, 0x10,
	0x00,0x4f, 0x10,
	0x00,0x50, 0x10,
	0x00,0x51, 0x10,
	0x00,0x52, 0x10,
	0x00,0x53, 0x10,
	0x00,0x54, 0x10,
	0x00,0x55, 0x10,
	0x00,0x56, 0x10,
	0x00,0x57, 0x10,
	0x00,0x3a, 0x01,
	0xff,0xfe, 0x14,
	0x01,0x0f, 0x01,
	0x01,0x10, 0x01,
	0x01,0x12, 0x03,
	0x01,0x13, 0x03,
	0x01,0x14, 0x03,
	0x01,0x1a, 0x00,
	0x01,0x1b, 0x60,
	0x01,0x1c, 0x02,
	0x01,0x1d, 0x80,
	0x01,0x1e, 0x00,
	0x01,0x1f, 0x40,
	0x01,0x20, 0x02,
	0x01,0x21, 0xc0,
	0x00,0x62, 0x00,
	0x00,0x63, 0x60,
	0x00,0x64, 0x00,
	0x00,0x65, 0x40,
	0x00,0x66, 0x01,
	0X00,0x67, 0x00,
	0x00,0x74, 0x20,
	0x00,0x75, 0x40,
	0x00,0x6e, 0x06,
	0x00,0x6f, 0x01,
	0x01,0x2a, 0x05,
	0x01,0x2b, 0x00,
	0x01,0x2c, 0x00,
	0x01,0x2d, 0x30,
	0xff,0xfd, 0x80,
	0xff,0xfe, 0x50,
	0x00,0x0e, 0x54,
	0xff,0xfe, 0x14,
	0x00,0x06, 0x01,
	0x00,0x07, 0xef,
	0x00,0x14, 0x00,
	0x00,0x15, 0x14,
	0x00,0x16, 0x05,
	0x00,0x17, 0x8c,
	0x03,0xe0, 0x9c,
	0x03,0xe1, 0x21,
	0x03,0xe2, 0xff,
	0x03,0xe3, 0xf8,
	0x03,0xe4, 0xd4,
	0x03,0xe5, 0x01,
	0x03,0xe6, 0x48,
	0x03,0xe8, 0xd4,
	0x03,0xe9, 0x01,
	0x03,0xea, 0x50,
	0x03,0xeb, 0x04,
	0x03,0xec, 0x18,
	0x03,0xed, 0x60,
	0x03,0xef, 0x14,
	0x03,0xf0, 0xa8,
	0x03,0xf1, 0x63,
	0x03,0xf2, 0x01,
	0x03,0xf3, 0xd0,
	0x03,0xf4, 0x19,
	0x03,0xf5, 0x60,
	0x03,0xf7, 0x14,
	0x03,0xf8, 0xa9,
	0x03,0xf9, 0x6b,
	0x03,0xfa, 0x03,
	0x03,0xfb, 0xd4,
	0x03,0xfc, 0x94,
	0x03,0xfd, 0xa3,
	0x04,0x00, 0x19,
	0x04,0x01, 0xa0,
	0x04,0x03, 0x14,
	0x04,0x04, 0xa9,
	0x04,0x05, 0xad,
	0x04,0x06, 0x03,
	0x04,0x07, 0xdc,
	0x04,0x08, 0x85,
	0x04,0x09, 0x0b,
	0x04,0x0c, 0x18,
	0x04,0x0d, 0x60,
	0x04,0x0f, 0x14,
	0x04,0x10, 0xa8,
	0x04,0x11, 0x63,
	0x04,0x12, 0x02,
	0x04,0x13, 0xb0,
	0x04,0x14, 0xb8,
	0x04,0x15, 0xe5,
	0x04,0x17, 0x44,
	0x04,0x18, 0x85,
	0x04,0x19, 0x43,
	0x04,0x1c, 0x9c,
	0x04,0x1d, 0x80,
	0x04,0x1f, 0x03,
	0x04,0x20, 0x8c,
	0x04,0x21, 0xaa,
	0x04,0x23, 0x3a,
	0x04,0x24, 0x84,
	0x04,0x25, 0x6d,
	0x04,0x28, 0xe0,
	0x04,0x29, 0xe7,
	0x04,0x2a, 0x28,
	0x04,0x2b, 0x02,
	0x04,0x2c, 0x8c,
	0x04,0x2d, 0xca,
	0x04,0x2f, 0x3c,
	0x04,0x30, 0x18,
	0x04,0x31, 0xa0,
	0x04,0x33, 0x14,
	0x04,0x34, 0xa8,
	0x04,0x35, 0xa5,
	0x04,0x36, 0x03,
	0x04,0x37, 0xd8,
	0x04,0x38, 0xd4,
	0x04,0x39, 0x0b,
	0x04,0x3a, 0x18,
	0x04,0x3c, 0xe5,
	0x04,0x3d, 0xa6,
	0x04,0x3e, 0x38,
	0x04,0x40, 0x10,
	0x04,0x43, 0x03,
	0x04,0x44, 0xd4,
	0x04,0x45, 0x05,
	0x04,0x46, 0x40,
	0x04,0x48, 0xa8,
	0x04,0x49, 0xc7,
	0x04,0x4c, 0x8c,
	0x04,0x4d, 0xaa,
	0x04,0x4f, 0x3b,
	0x04,0x50, 0xe5,
	0x04,0x51, 0x66,
	0x04,0x52, 0x28,
	0x04,0x54, 0x10,
	0x04,0x57, 0x03,
	0x04,0x58, 0x15,
	0x04,0x5c, 0xa8,
	0x04,0x5d, 0xc5,
	0x04,0x60, 0xe0,
	0x04,0x61, 0x66,
	0x04,0x62, 0x18,
	0x04,0x64, 0xd4,
	0x04,0x65, 0x0d,
	0x04,0x66, 0x30,
	0x04,0x68, 0x07,
	0x04,0x69, 0xfb,
	0x04,0x6a, 0x1c,
	0x04,0x6b, 0xd1,
	0x04,0x6c, 0xe0,
	0x04,0x6d, 0x63,
	0x04,0x6e, 0x40,
	0x04,0x70, 0x9c,
	0x04,0x71, 0x60,
	0x04,0x72, 0x01,
	0x04,0x74, 0xdc,
	0x04,0x75, 0x0a,
	0x04,0x76, 0x58,
	0x04,0x77, 0xfa,
	0x04,0x78, 0xe0,
	0x04,0x79, 0x83,
	0x04,0x7a, 0x58,
	0x04,0x7b, 0x02,
	0x04,0x7c, 0x18,
	0x04,0x7d, 0xc0,
	0x04,0x7f, 0x14,
	0x04,0x80, 0xa8,
	0x04,0x81, 0xc6,
	0x04,0x82, 0x01,
	0x04,0x83, 0xe0,
	0x04,0x84, 0x94,
	0x04,0x85, 0xa6,
	0x04,0x88, 0x94,
	0x04,0x89, 0x66,
	0x04,0x8b, 0x02,
	0x04,0x8c, 0xe0,
	0x04,0x8d, 0x84,
	0x04,0x8e, 0x2b,
	0x04,0x8f, 0x06,
	0x04,0x90, 0xe1,
	0x04,0x91, 0x63,
	0x04,0x92, 0x5b,
	0x04,0x93, 0x06,
	0x04,0x94, 0xe1,
	0x04,0x95, 0x6b,
	0x04,0x96, 0x20,
	0x04,0x98, 0xb9,
	0x04,0x99, 0x6b,
	0x04,0x9b, 0x48,
	0x04,0x9c, 0xdc,
	0x04,0x9d, 0x0a,
	0x04,0x9e, 0x58,
	0x04,0x9f, 0xc4,
	0x04,0xa0, 0x85,
	0x04,0xa1, 0x21,
	0x04,0xa4, 0x85,
	0x04,0xa5, 0x41,
	0x04,0xa7, 0x04,
	0x04,0xa8, 0x44,
	0x04,0xaa, 0x48,
	0x04,0xac, 0x9c,
	0x04,0xad, 0x21,
	0x04,0xaf, 0x08,
	0x04,0xb0, 0x18,
	0x04,0xb1, 0x80,
	0x04,0xb3, 0x14,
	0x04,0xb4, 0xa8,
	0x04,0xb5, 0x84,
	0x04,0xb6, 0x02,
	0x04,0xb7, 0xcc,
	0x04,0xb8, 0x84,
	0x04,0xb9, 0x64,
	0x04,0xbc, 0xbc,
	0x04,0xbd, 0x23,
	0x04,0xbf, 0x41,
	0x04,0xc0, 0x0c,
	0x04,0xc3, 0x06,
	0x04,0xc4, 0xbc,
	0x04,0xc5, 0x23,
	0x04,0xc7, 0x3f,
	0x04,0xc8, 0x10,
	0x04,0xcb, 0x06,
	0x04,0xcc, 0x9c,
	0x04,0xcd, 0x60,
	0x04,0xcf, 0x3e,
	0x04,0xd3, 0x04,
	0x04,0xd4, 0xd4,
	0x04,0xd5, 0x04,
	0x04,0xd6, 0x18,
	0x04,0xd8, 0x9c,
	0x04,0xd9, 0x60,
	0x04,0xdb, 0x42,
	0x04,0xdc, 0xd4,
	0x04,0xdd, 0x04,
	0x04,0xde, 0x18,
	0x04,0xe0, 0x44,
	0x04,0xe2, 0x48,
	0x04,0xe4, 0x15,
	0x04,0xe8, 0x9c,
	0x04,0xe9, 0x21,
	0x04,0xea, 0xff,
	0x04,0xeb, 0xfc,
	0x04,0xec, 0xd4,
	0x04,0xed, 0x01,
	0x04,0xee, 0x48,
	0x04,0xf0, 0x19,
	0x04,0xf1, 0xa0,
	0x04,0xf3, 0x14,
	0x04,0xf4, 0xa9,
	0x04,0xf5, 0xad,
	0x04,0xf6, 0x02,
	0x04,0xf7, 0xb0,
	0x04,0xf8, 0x9d,
	0x04,0xf9, 0x60,
	0x04,0xfc, 0x84,
	0x04,0xfd, 0x6d,
	0x05,0x00, 0x84,
	0x05,0x01, 0x63,
	0x05,0x03, 0xd0,
	0x05,0x04, 0xb8,
	0x05,0x05, 0x83,
	0x05,0x07, 0x41,
	0x05,0x0b, 0x04,
	0x05,0x0c, 0xb8,
	0x05,0x0d, 0xc3,
	0x05,0x0f, 0x45,
	0x05,0x10, 0xb8,
	0x05,0x11, 0xc6,
	0x05,0x13, 0x41,
	0x05,0x14, 0xa5,
	0x05,0x15, 0x63,
	0x05,0x16, 0xff,
	0x05,0x17, 0xff,
	0x05,0x18, 0xbc,
	0x05,0x19, 0xa6,
	0x05,0x1b, 0x01,
	0x05,0x1c, 0x0f,
	0x05,0x1d, 0xff,
	0x05,0x1e, 0xff,
	0x05,0x1f, 0xfd,
	0x05,0x20, 0x9c,
	0x05,0x21, 0x6b,
	0x05,0x23, 0x01,
	0x05,0x24, 0xe0,
	0x05,0x25, 0x64,
	0x05,0x26, 0x58,
	0x05,0x27, 0x48,
	0x05,0x28, 0x9c,
	0x05,0x29, 0x63,
	0x05,0x2a, 0xff,
	0x05,0x2b, 0xf0,
	0x05,0x2c, 0xbc,
	0x05,0x2d, 0x03,
	0x05,0x30, 0x10,
	0x05,0x33, 0x0a,
	0x05,0x34, 0xa8,
	0x05,0x35, 0xe3,
	0x05,0x38, 0x84,
	0x05,0x39, 0x6d,
	0x05,0x3c, 0x94,
	0x05,0x3d, 0x63,
	0x05,0x3f, 0xfc,
	0x05,0x40, 0xe0,
	0x05,0x41, 0x63,
	0x05,0x42, 0x38,
	0x05,0x44, 0xbc,
	0x05,0x45, 0xa3,
	0x05,0x47, 0x0f,
	0x05,0x48, 0x10,
	0x05,0x4b, 0x04,
	0x05,0x4c, 0xa8,
	0x05,0x4d, 0xe3,
	0x05,0x50, 0x9c,
	0x05,0x51, 0x60,
	0x05,0x53, 0x0f,
	0x05,0x54, 0xa8,
	0x05,0x55, 0xe3,
	0x05,0x58, 0x9c,
	0x05,0x59, 0x60,
	0x05,0x5b, 0x01,
	0x05,0x5c, 0x84,
	0x05,0x5d, 0x8d,
	0x05,0x60, 0xe0,
	0x05,0x61, 0x63,
	0x05,0x62, 0x58,
	0x05,0x63, 0x08,
	0x05,0x64, 0x8c,
	0x05,0x65, 0xa4,
	0x05,0x67, 0x8b,
	0x05,0x68, 0x9d,
	0x05,0x69, 0x03,
	0x05,0x6a, 0xff,
	0x05,0x6b, 0xff,
	0x05,0x6c, 0x94,
	0x05,0x6d, 0x64,
	0x05,0x6f, 0xb0,
	0x05,0x70, 0xb8,
	0x05,0x71, 0xc8,
	0x05,0x73, 0x04,
	0x05,0x74, 0xe0,
	0x05,0x75, 0x86,
	0x05,0x76, 0x38,
	0x05,0x78, 0x07,
	0x05,0x79, 0xfb,
	0x05,0x7a, 0x19,
	0x05,0x7b, 0xb7,
	0x05,0x7c, 0xa4,
	0x05,0x7d, 0x84,
	0x05,0x7f, 0xff,
	0x05,0x80, 0x85,
	0x05,0x81, 0x21,
	0x05,0x84, 0x44,
	0x05,0x86, 0x48,
	0x05,0x88, 0x9c,
	0x05,0x89, 0x21,
	0x05,0x8b, 0x04,
	0x05,0x8c, 0x9c,
	0x05,0x8d, 0x21,
	0x05,0x8e, 0xff,
	0x05,0x8f, 0xf4,
	0x05,0x90, 0xd4,
	0x05,0x91, 0x01,
	0x05,0x92, 0x48,
	0x05,0x94, 0xd4,
	0x05,0x95, 0x01,
	0x05,0x96, 0x50,
	0x05,0x97, 0x04,
	0x05,0x98, 0xd4,
	0x05,0x99, 0x01,
	0x05,0x9a, 0x60,
	0x05,0x9b, 0x08,
	0x05,0x9c, 0xbc,
	0x05,0x9d, 0x03,
	0x05,0x9e, 0x01,
	0x05,0x9f, 0x0c,
	0x05,0xa0, 0x10,
	0x05,0xa3, 0x15,
	0x05,0xa4, 0xbc,
	0x05,0xa5, 0x43,
	0x05,0xa6, 0x01,
	0x05,0xa7, 0x0c,
	0x05,0xa8, 0x0c,
	0x05,0xab, 0x0b,
	0x05,0xac, 0xbc,
	0x05,0xad, 0x03,
	0x05,0xae, 0x01,
	0x05,0xaf, 0x05,
	0x05,0xb0, 0xbc,
	0x05,0xb1, 0x03,
	0x05,0xb2, 0x01,
	0x05,0xb3, 0x10,
	0x05,0xb4, 0x10,
	0x05,0xb7, 0x16,
	0x05,0xb8, 0xbc,
	0x05,0xb9, 0x03,
	0x05,0xba, 0x04,
	0x05,0xbb, 0x0c,
	0x05,0xbc, 0x19,
	0x05,0xbd, 0x80,
	0x05,0xbf, 0x14,
	0x05,0xc0, 0xa9,
	0x05,0xc1, 0x8c,
	0x05,0xc2, 0x03,
	0x05,0xc3, 0x18,
	0x05,0xc4, 0x0c,
	0x05,0xc7, 0x29,
	0x05,0xc8, 0x15,
	0x05,0xcf, 0x25,
	0x05,0xd0, 0x15,
	0x05,0xd4, 0x19,
	0x05,0xd5, 0x80,
	0x05,0xd7, 0x14,
	0x05,0xd8, 0xa9,
	0x05,0xd9, 0x8c,
	0x05,0xda, 0x03,
	0x05,0xdb, 0x18,
	0x05,0xdc, 0x0c,
	0x05,0xdf, 0x23,
	0x05,0xe0, 0x15,
	0x05,0xe4, 0x07,
	0x05,0xe5, 0xff,
	0x05,0xe6, 0xff,
	0x05,0xe7, 0x7f,
	0x05,0xe8, 0x15,
	0x05,0xef, 0x20,
	0x05,0xf0, 0x84,
	0x05,0xf1, 0x6c,
	0x05,0xf4, 0x19,
	0x05,0xf5, 0x80,
	0x05,0xf7, 0x14,
	0x05,0xf8, 0xa9,
	0x05,0xf9, 0x8c,
	0x05,0xfa, 0x03,
	0x05,0xfb, 0x18,
	0x05,0xfc, 0x07,
	0x05,0xfd, 0xff,
	0x05,0xfe, 0xff,
	0x05,0xff, 0xad,
	0x06,0x00, 0x15,
	0x06,0x07, 0x1a,
	0x06,0x08, 0x84,
	0x06,0x09, 0x6c,
	0x06,0x0c, 0x18,
	0x06,0x0d, 0x60,
	0x06,0x0f, 0x14,
	0x06,0x10, 0xa8,
	0x06,0x11, 0x63,
	0x06,0x12, 0x02,
	0x06,0x13, 0xb0,
	0x06,0x14, 0x19,
	0x06,0x15, 0x40,
	0x06,0x17, 0x14,
	0x06,0x18, 0xa9,
	0x06,0x19, 0x4a,
	0x06,0x1a, 0x02,
	0x06,0x1b, 0xf8,
	0x06,0x1c, 0x84,
	0x06,0x1d, 0x83,
	0x06,0x20, 0x84,
	0x06,0x21, 0xaa,
	0x06,0x24, 0x94,
	0x06,0x25, 0x64,
	0x06,0x27, 0x7e,
	0x06,0x28, 0xe4,
	0x06,0x29, 0xa3,
	0x06,0x2a, 0x28,
	0x06,0x2c, 0x10,
	0x06,0x2f, 0x04,
	0x06,0x30, 0x15,
	0x06,0x34, 0x9c,
	0x06,0x35, 0x60,
	0x06,0x37, 0x04,
	0x06,0x38, 0xd8,
	0x06,0x39, 0x04,
	0x06,0x3a, 0x18,
	0x06,0x3b, 0xd7,
	0x06,0x3c, 0x19,
	0x06,0x3d, 0x80,
	0x06,0x3f, 0x14,
	0x06,0x40, 0xa9,
	0x06,0x41, 0x8c,
	0x06,0x42, 0x03,
	0x06,0x43, 0x18,
	0x06,0x44, 0x84,
	0x06,0x45, 0x6c,
	0x06,0x48, 0x07,
	0x06,0x49, 0xfb,
	0x06,0x4a, 0x05,
	0x06,0x4b, 0xf8,
	0x06,0x4c, 0x84,
	0x06,0x4d, 0x63,
	0x06,0x4e, 0x01,
	0x06,0x4f, 0xc0,
	0x06,0x50, 0x9c,
	0x06,0x51, 0x80,
	0x06,0x52, 0xff,
	0x06,0x53, 0xf0,
	0x06,0x54, 0xe1,
	0x06,0x55, 0x6b,
	0x06,0x56, 0x20,
	0x06,0x57, 0x03,
	0x06,0x5b, 0x04,
	0x06,0x5c, 0xd4,
	0x06,0x5d, 0x0a,
	0x06,0x5e, 0x58,
	0x06,0x60, 0x07,
	0x06,0x61, 0xff,
	0x06,0x62, 0xff,
	0x06,0x63, 0xa2,
	0x06,0x64, 0x15,
	0x06,0x68, 0x84,
	0x06,0x69, 0x6c,
	0x06,0x6c, 0x9d,
	0x06,0x6d, 0x60,
	0x06,0x70, 0xd4,
	0x06,0x71, 0x03,
	0x06,0x72, 0x59,
	0x06,0x73, 0xcc,
	0x06,0x74, 0xd4,
	0x06,0x75, 0x03,
	0x06,0x76, 0x59,
	0x06,0x77, 0xc0,
	0x06,0x78, 0xd4,
	0x06,0x79, 0x03,
	0x06,0x7a, 0x59,
	0x06,0x7b, 0xc4,
	0x06,0x7c, 0xd4,
	0x06,0x7d, 0x03,
	0x06,0x7e, 0x59,
	0x06,0x7f, 0xc8,
	0x06,0x80, 0x85,
	0x06,0x81, 0x21,
	0x06,0x84, 0x85,
	0x06,0x85, 0x41,
	0x06,0x87, 0x04,
	0x06,0x88, 0x85,
	0x06,0x89, 0x81,
	0x06,0x8b, 0x08,
	0x06,0x8c, 0x44,
	0x06,0x8e, 0x48,
	0x06,0x90, 0x9c,
	0x06,0x91, 0x21,
	0x06,0x93, 0x0c,
	0x00,0x6e, 0x30,
	0x00,0x6f, 0x20,
	0x00,0x70, 0xc0,
	0xff,0xfe, 0x30,
	0x00,0x51, 0x03,
	0xff,0xfe, 0x50,
	0x01,0x37, 0x99,
	0xff,0xfe, 0x14,
	0xff,0xfe, 0x30,
	0x02,0x00, 0x11,
	0x02,0x01, 0x0d,
	0x02,0x02, 0x0c,
	0x02,0x03, 0x0c,
	0x02,0x04, 0x0d,
	0x02,0x05, 0x11,
	0x02,0x06, 0x07,
	0x02,0x07, 0x05,
	0x02,0x08, 0x04,
	0x02,0x09, 0x04,
	0x02,0x0a, 0x05,
	0x02,0x0b, 0x07,
	0x02,0x0c, 0x04,
	0x02,0x0d, 0x01,
	0x02,0x0e, 0x00,
	0x02,0x0f, 0x00,
	0x02,0x10, 0x01,
	0x02,0x11, 0x03,
	0x02,0x12, 0x03,
	0x02,0x13, 0x01,
	0x02,0x14, 0x00,
	0x02,0x15, 0x00,
	0x02,0x16, 0x00,
	0x02,0x17, 0x03,
	0x02,0x18, 0x06,
	0x02,0x19, 0x04,
	0x02,0x1a, 0x02,
	0x02,0x1b, 0x02,
	0x02,0x1c, 0x04,
	0x02,0x1d, 0x06,
	0x02,0x1e, 0x0d,
	0x02,0x1f, 0x0a,
	0x02,0x20, 0x0a,
	0x02,0x21, 0x09,
	0x02,0x22, 0x0a,
	0x02,0x23, 0x0d,
	0x02,0x24, 0x11,
	0x02,0x25, 0x12,
	0x02,0x26, 0x02,
	0x02,0x27, 0x12,
	0x02,0x28, 0x12,
	0x02,0x2a, 0x11,
	0x02,0x2b, 0x11,
	0x02,0x2c, 0x11,
	0x02,0x2d, 0x21,
	0x02,0x2e, 0x21,
	0x02,0x30, 0x01,
	0x02,0x31, 0x21,
	0x02,0x32, 0x31,
	0x02,0x33, 0x21,
	0x02,0x34, 0x21,
	0x02,0x36, 0x12,
	0x02,0x37, 0x11,
	0x02,0x38, 0x11,
	0x02,0x39, 0x21,
	0x02,0x3a, 0x22,
	0x02,0x3c, 0x22,
	0x02,0x3d, 0x12,
	0x02,0x3e, 0x22,
	0x02,0x3f, 0x12,
	0x02,0x40, 0x22,
	0x02,0x48, 0xef,
	0xff,0xfe, 0x30,
	0x02,0x4d, 0x01,
	0x02,0x4e, 0x33,
	0x02,0x4f, 0x02,
	0x02,0x50, 0x22,
	0x02,0x51, 0x01,
	0x02,0x52, 0x99,
	0x02,0x53, 0x01,
	0x02,0x54, 0x6C,
	0xff,0xfe, 0x14,
	0x00,0x27, 0x01,
	0x01,0x3c, 0x02,
	0x01,0x76, 0x06,
	0x01,0x77, 0x00,
	0x01,0x7a, 0x04,
	0x01,0x7b, 0x00,
	0x01,0x7e, 0x04,
	0x01,0x7f, 0x00,
	0x01,0x82, 0x04,
	0x01,0x83, 0x04,
	0x01,0xaa, 0x06,
	0x01,0xab, 0x00,
	0x01,0xae, 0x04,
	0x01,0xaf, 0x00,
	0x01,0xb2, 0x04,
	0x01,0xb3, 0x04,
	0xff,0xfe, 0x14,
	0x00,0x27, 0x01,
	0x01,0x3c, 0x01,
	0x01,0x3d, 0x01,
	0x01,0x3e, 0x00,
	0x01,0x70, 0x0d,
	0x01,0x71, 0xff,
	0xff,0xfe, 0x30,
	0x07,0x08, 0x03,
	0x07,0x09, 0xf0,
	0x07,0x0a, 0x00,
	0x07,0x0b, 0x0c,
	0x00,0x51, 0x03,
	0x00,0x96, 0x83,
	0x00,0x19, 0x48,
	0x07,0x1c, 0x0a,
	0xff,0xfe, 0x14,
	0x01,0x6e, 0x08,
	0xff,0xfd, 0x80,
	0xff,0xfe, 0x30,
	0x07,0x30, 0xb0,
	0x07,0x31, 0xe0,
	0x07,0x32, 0x20,
	0x07,0x33, 0x30,
	0x07,0x34, 0xa0,
	0x07,0x35, 0xd0,
	0x07,0x36, 0x30,
	0x07,0x37, 0x40,
	0x07,0x38, 0x90,
	0x07,0x39, 0xc0,
	0x07,0x3a, 0x40,
	0x07,0x3b, 0x50,
	0x07,0x3c, 0x80,
	0x07,0x3d, 0xb0,
	0x07,0x3e, 0x50,
	0x07,0x3f, 0x60,
	0x07,0x40, 0x70,
	0x07,0x41, 0xa0,
	0x07,0x42, 0x60,
	0x07,0x43, 0x70,
	0x07,0x44, 0x60,
	0x07,0x45, 0x90,
	0x07,0x46, 0x70,
	0x07,0x47, 0x80,
	0x07,0x48, 0x50,
	0x07,0x49, 0x80,
	0x07,0x4a, 0x80,
	0x07,0x4b, 0x90,
	0x07,0x4c, 0x40,
	0x07,0x4d, 0x70,
	0x07,0x4e, 0x90,
	0x07,0x4f, 0xa0,
	0x07,0x50, 0x00,
	0x07,0x51, 0x00,
	0x07,0x52, 0x00,
	0x07,0x53, 0x00,
	0x07,0x54, 0x00,
	0x07,0x55, 0x00,
	0x07,0x56, 0x00,
	0x07,0x57, 0x00,
	0x07,0x58, 0x00,
	0x07,0x59, 0x00,
	0x07,0x5a, 0x00,
	0x07,0x5b, 0x00,
	0x07,0x5c, 0x00,
	0x07,0x5d, 0x00,
	0x07,0x5e, 0x00,
	0x07,0x5f, 0x00,
	0x07,0x60, 0x00,
	0x07,0x61, 0x00,
	0x07,0x62, 0x00,
	0x07,0x63, 0x00,
	0x07,0x64, 0x00,
	0x07,0x65, 0x00,
	0x07,0x66, 0x00,
	0x07,0x67, 0x00,
	0x07,0x68, 0x00,
	0x07,0x69, 0x00,
	0x07,0x6a, 0x00,
	0x07,0x6b, 0x00,
	0x07,0x6c, 0x00,
	0x07,0x6d, 0x00,
	0x07,0x6e, 0x00,
	0x07,0x6f, 0x00,
	0x07,0x70, 0x11,
	0x07,0x71, 0x11,
	0x07,0x72, 0x11,
	0x07,0x73, 0x11,
	0x07,0x74, 0x00,
	0x07,0x75, 0x00,
	0x07,0x76, 0x00,
	0x07,0x77, 0x00,
	0xff,0xfd, 0x80,
	0xff,0xfe, 0x30,
	0x14,0x00, 0x00,
	0x14,0x01, 0x0a,
	0x14,0x02, 0x14,
	0x14,0x03, 0x1f,
	0x14,0x04, 0x29,
	0x14,0x05, 0x32,
	0x14,0x06, 0x3c,
	0x14,0x07, 0x45,
	0x14,0x08, 0x4e,
	0x14,0x09, 0x56,
	0x14,0x0a, 0x5e,
	0x14,0x0b, 0x66,
	0x14,0x0c, 0x6d,
	0x14,0x0d, 0x74,
	0x14,0x0e, 0x7b,
	0x14,0x0f, 0x80,
	0x14,0x10, 0x86,
	0x14,0x11, 0x8b,
	0x14,0x12, 0x90,
	0x14,0x13, 0x94,
	0x14,0x14, 0x98,
	0x14,0x15, 0x9c,
	0x14,0x16, 0x9f,
	0x14,0x17, 0xa2,
	0x14,0x18, 0xa5,
	0x14,0x19, 0xa7,
	0x14,0x1a, 0xaa,
	0x14,0x1b, 0xac,
	0x14,0x1c, 0xae,
	0x14,0x1d, 0xaf,
	0x14,0x1e, 0xb1,
	0x14,0x1f, 0xb2,
	0x14,0x20, 0xb4,
	0x14,0x21, 0xb7,
	0x14,0x22, 0xb9,
	0x14,0x23, 0xbb,
	0x14,0x24, 0xbd,
	0x14,0x25, 0xbf,
	0x14,0x26, 0xc1,
	0x14,0x27, 0xc2,
	0x14,0x28, 0xc4,
	0x14,0x29, 0xc5,
	0x14,0x2a, 0xc6,
	0x14,0x2b, 0xc8,
	0x14,0x2c, 0xc9,
	0x14,0x2d, 0xca,
	0x14,0x2e, 0xcb,
	0x14,0x2f, 0xcc,
	0x14,0x30, 0xcd,
	0x14,0x31, 0xce,
	0x14,0x32, 0xd0,
	0x14,0x33, 0xd1,
	0x14,0x34, 0xd3,
	0x14,0x35, 0xd4,
	0x14,0x36, 0xd6,
	0x14,0x37, 0xd8,
	0x14,0x38, 0xdb,
	0x14,0x39, 0xde,
	0x14,0x3a, 0xe1,
	0x14,0x3b, 0xe5,
	0x14,0x3c, 0xea,
	0x14,0x3d, 0xef,
	0x14,0x3e, 0xf4,
	0x14,0x3f, 0xfa,
	0x14,0x40, 0xff,
	0xff,0xfe, 0x30,
	0x12,0x00, 0x02,
	0x12,0x01, 0x00,
	0x12,0x02, 0x02,
	0x12,0x03, 0x0D,
	0x12,0x04, 0x06,
	0x12,0x05, 0x00,
	0x12,0x06, 0x04,
	0x12,0x07, 0x00,
	0x12,0x08, 0x04,
	0x12,0x09, 0xB1,
	0x12,0x0A, 0x00,
	0x12,0x0B, 0x66,
	0x12,0x0C, 0x0B,
	0x12,0x0D, 0x6A,
	0x12,0x0E, 0x03,
	0x12,0x0F, 0x99,
	0x12,0x10, 0x01,
	0x12,0x11, 0xFA,
	0x12,0x12, 0x01,
	0x12,0x13, 0xDC,
	0x12,0x14, 0x03,
	0x12,0x15, 0x83,
	0x12,0x16, 0x02,
	0x12,0x17, 0x74,
	0x12,0x18, 0x08,
	0x12,0x19, 0xC7,
	0x12,0x1A, 0x01,
	0x12,0x1B, 0x71,
	0x12,0x1C, 0x00,
	0x12,0x1D, 0xF7,
	0x12,0x1E, 0x01,
	0x12,0x1F, 0xD0,
	0x12,0x20, 0x00,
	0x12,0x21, 0x9A,
	0x12,0x22, 0x02,
	0x12,0x23, 0x0E,
	0x12,0x2e, 0x00,
	0x12,0x2F, 0x01,
	0x12,0x30, 0x00,
	0x0D,0x31, 0x03,
	0x12,0x28, 0x00,
	0x12,0x29, 0x77,
	0x12,0x2A, 0x00,
	0x12,0x2B, 0xB5,
	0x12,0x2C, 0x01,
	0x12,0x2D, 0x3C,
	0xff,0xfe, 0x30,
	0x12,0x31, 0x02,
	0xff,0xfe, 0x30,   //YEE
	0x20,0x00, 0x33,   //bit[5]Yedge en; bit[3]UV_dns_en; bit[2]pre_dns_en; bit[1]ydns_man; bit[0]uvdns_man
	0x20,0x01, 0x0f,  //edge_ratio
	0x20,0x02, 0x03, //Y_dns_level_man
	0x20,0x03, 0x03, //UV_dns_level_man
	0x20,0x04, 0x01,	//gain list0
	0x20,0x05, 0x01,
	0x20,0x06, 0x02,
	0x20,0x07, 0x03,
	0x20,0x08, 0x04,
	0x20,0x09, 0x05,
	0x20,0x0a, 0x06,
	0x20,0x0b, 0x1f,   //gain list7
	0x19,0x07, 0xd2,
	0x19,0x08, 0x01,
	0xff,0xfe, 0x30,
	0x0e,0x00, 0x14,
	0x0e,0x01, 0x04,
	0x0e,0x02, 0x08,
	0x0e,0x03, 0x0f,
	0x0e,0x04, 0x18,
	0x0e,0x05, 0x1f,
	0x0e,0x06, 0x2f,
	0x0e,0x07, 0x2f,
	0x0e,0x08, 0x38,
	0x0e,0x09, 0xff,
	0x0e,0x0a, 0x0d,
	0x0e,0x0b, 0x20,
	0xff,0xfe, 0x30,
	0x13,0x0e, 0x09,
	0x13,0x0f, 0x0d,
	0xff,0xfe, 0x30,
	0x0f,0x00, 0x66,
	0x0f,0x01, 0x00,
	0x0f,0x02, 0x00,
	0x0f,0x03, 0x00,
	0x0f,0x04, 0x00,
	0x0f,0x05, 0x00,
	0x0f,0x06, 0x00,
	0x0f,0x07, 0x00,
	0x0f,0x08, 0x00,
	0x0f,0x09, 0x00,
	0x0f,0x0a, 0x00,
	0x0f,0x0b, 0x00,
	0x0f,0x0c, 0x01,
	0x0f,0x0d, 0x0f,
	0x0f,0x0e, 0x00,
	0x0f,0x0f, 0x20,
	0xff,0xfe, 0x14,
	0x01,0x60, 0x00,
	0x01,0x62, 0x60,
	0x01,0x63, 0x58,
	0x01,0x64, 0x50,
	0x01,0x65, 0x48,
	0x01,0x66, 0x40,
	0x01,0x67, 0x40,
	0x01,0x68, 0x60,
	0x01,0x69, 0x58,
	0x01,0x6a, 0x50,
	0x01,0x6b, 0x48,
	0x01,0x6c, 0x40,
	0x01,0x6d, 0x40,
	0xff,0xfe, 0x30,
	0x00,0x00, 0xcF,
	0x00,0x01, 0xa7,
	0x00,0x03, 0xe5,
	0x07,0x1c, 0x0a,
	0x07,0x1b, 0x34,
	0x17,0x00, 0x09,
	0x17,0x01, 0x50,
	0x17,0x02, 0x50,
	0x17,0x04, 0x20,
	0x14,0x52, 0xb0,
	0x14,0x53, 0x40,
	0x00,0x13, 0x0e,
	0xff,0xfe, 0x14,
	0x00,0x27, 0x01,
#else
0xff,0xfd,0x80,
0xff,0xfe,0x50,
0x00,0x1c,0xff,
0x00,0x1d,0xff,
0x00,0x1e,0xff,
0x00,0x1f,0xff,
0x00,0x18,0x00,
0x00,0x19,0x00,
0x00,0x1a,0x00,
0x00,0x1b,0x00,
0x00,0xbc,0x11,
0x00,0xbd,0x00,
0x00,0xbe,0x00,
0x00,0xbf,0x00,

	// 2.2 wait pll lock  ( /*READ ONLY*/)
	0xfe,0xfe, 0xf0,
	0xfe,0xfe, 0x01,  //delay 1ms
	0xfe,0xfe, 0xf1,

0x00,0x30,0x09,
0x00,0x31,0x02,
0x00,0x32,0x08,
0x00,0x20,0x02,
0x00,0x21,0x0e,
0x00,0x23,0x02,
0x00,0x24,0x01,
0x00,0x25,0x00,
0x00,0x26,0x02,
0x00,0x27,0x06,
0x00,0x28,0x09,
0x00,0x29,0x06,
0xff,0xfe,0x25,
0x20,0x0b,0x33,
0x00,0x02,0x40,
0xff,0xfe,0x50,
0x02,0x00,0x03,
0x02,0x04,0x03,
0x02,0x08,0x02,
0x02,0x08,0x01,
0xff,0xfe,0x50,
0x00,0xbc,0x11,
0x00,0x1b,0x00,
0x00,0x90,0x29,
0xff,0xfe,0x20,
0x00,0x00,0x20,
0x00,0x04,0x05,
0x00,0x05,0x00,
0x00,0x06,0x02,
0x00,0x07,0xd0,
0xff,0xfe,0x26,
0x40,0x00,0xf9,
0x60,0x01,0x14,
0x60,0x05,0xc4,
0x60,0x06,0x0a,
0x60,0x07,0x8c,
0x60,0x08,0x09,
0x60,0x09,0xfc,
0x80,0x00,0x3f,
0x80,0x01,0x00,
0x80,0x02,0x05,
0x80,0x03,0xd0,
0x80,0x04,0x02,
0x80,0x05,0x03,
0x80,0x06,0x05,
0x80,0x07,0x99,
0x80,0x08,0x14,
0x80,0x10,0x04,
0x80,0x12,0x00,
0x80,0x13,0x05,
0x80,0x14,0xd0,
0x80,0x15,0x02,
0x80,0x16,0x00,
0x80,0x17,0x00,
0x80,0x18,0x00,
0x80,0x19,0x00,
0xff,0xfe,0x30,
0x00,0x01,0x01,
0x00,0x04,0x18,
0x00,0x06,0x05,
0x00,0x07,0x00,
0x00,0x08,0x02,
0x00,0x09,0xd0,
0x00,0x0a,0x05,
0x00,0x0b,0x00,
0x00,0x0c,0x02,
0x00,0x0d,0xd0,
0x00,0x27,0xf1,
0x00,0x5e,0x04,
0x00,0x5f,0xff,
0x00,0x60,0x02,
0x00,0x61,0xcf,
0x19,0x08,0x00,
0x19,0x00,0x00,
0x19,0x01,0x00,
0x19,0x02,0x00,
0x19,0x03,0x00,
0x19,0x04,0x05,
0x19,0x05,0x00,
0x19,0x06,0x02,
0x19,0x07,0xd2,
0xff,0xfd,0x80,
0xff,0xfe,0x50,
0x00,0x0e,0x54,
0xff,0xfe,0x14,
0x00,0x06,0x01,
0x00,0x07,0xef,
0x00,0x14,0x00,
0x00,0x15,0x14,
0x00,0x16,0x05,
0x00,0x17,0x8c,
0x03,0xe0,0x9c,
0x03,0xe1,0x21,
0x03,0xe2,0xff,
0x03,0xe3,0xf8,
0x03,0xe4,0xd4,
0x03,0xe5,0x01,
0x03,0xe6,0x48,
0x03,0xe8,0xd4,
0x03,0xe9,0x01,
0x03,0xea,0x50,
0x03,0xeb,0x04,
0x03,0xec,0x18,
0x03,0xed,0x60,
0x03,0xef,0x14,
0x03,0xf0,0xa8,
0x03,0xf1,0x63,
0x03,0xf2,0x01,
0x03,0xf3,0xd0,
0x03,0xf4,0x19,
0x03,0xf5,0x60,
0x03,0xf7,0x14,
0x03,0xf8,0xa9,
0x03,0xf9,0x6b,
0x03,0xfa,0x03,
0x03,0xfb,0xd4,
0x03,0xfc,0x94,
0x03,0xfd,0xa3,
0x04,0x00,0x19,
0x04,0x01,0xa0,
0x04,0x03,0x14,
0x04,0x04,0xa9,
0x04,0x05,0xad,
0x04,0x06,0x03,
0x04,0x07,0xdc,
0x04,0x08,0x85,
0x04,0x09,0x0b,
0x04,0x0c,0x18,
0x04,0x0d,0x60,
0x04,0x0f,0x14,
0x04,0x10,0xa8,
0x04,0x11,0x63,
0x04,0x12,0x02,
0x04,0x13,0xb0,
0x04,0x14,0xb8,
0x04,0x15,0xe5,
0x04,0x17,0x44,
0x04,0x18,0x85,
0x04,0x19,0x43,
0x04,0x1c,0x9c,
0x04,0x1d,0x80,
0x04,0x1f,0x03,
0x04,0x20,0x8c,
0x04,0x21,0xaa,
0x04,0x23,0x3a,
0x04,0x24,0x84,
0x04,0x25,0x6d,
0x04,0x28,0xe0,
0x04,0x29,0xe7,
0x04,0x2a,0x28,
0x04,0x2b,0x02,
0x04,0x2c,0x8c,
0x04,0x2d,0xca,
0x04,0x2f,0x3c,
0x04,0x30,0x18,
0x04,0x31,0xa0,
0x04,0x33,0x14,
0x04,0x34,0xa8,
0x04,0x35,0xa5,
0x04,0x36,0x03,
0x04,0x37,0xd8,
0x04,0x38,0xd4,
0x04,0x39,0x0b,
0x04,0x3a,0x18,
0x04,0x3c,0xe5,
0x04,0x3d,0xa6,
0x04,0x3e,0x38,
0x04,0x40,0x10,
0x04,0x43,0x03,
0x04,0x44,0xd4,
0x04,0x45,0x05,
0x04,0x46,0x40,
0x04,0x48,0xa8,
0x04,0x49,0xc7,
0x04,0x4c,0x8c,
0x04,0x4d,0xaa,
0x04,0x4f,0x3b,
0x04,0x50,0xe5,
0x04,0x51,0x66,
0x04,0x52,0x28,
0x04,0x54,0x10,
0x04,0x57,0x03,
0x04,0x58,0x15,
0x04,0x5c,0xa8,
0x04,0x5d,0xc5,
0x04,0x60,0xe0,
0x04,0x61,0x66,
0x04,0x62,0x18,
0x04,0x64,0xd4,
0x04,0x65,0x0d,
0x04,0x66,0x30,
0x04,0x68,0x07,
0x04,0x69,0xfb,
0x04,0x6a,0x1c,
0x04,0x6b,0xd1,
0x04,0x6c,0xe0,
0x04,0x6d,0x63,
0x04,0x6e,0x40,
0x04,0x70,0x9c,
0x04,0x71,0x60,
0x04,0x72,0x01,
0x04,0x74,0xdc,
0x04,0x75,0x0a,
0x04,0x76,0x58,
0x04,0x77,0xfa,
0x04,0x78,0xe0,
0x04,0x79,0x83,
0x04,0x7a,0x58,
0x04,0x7b,0x02,
0x04,0x7c,0x18,
0x04,0x7d,0xc0,
0x04,0x7f,0x14,
0x04,0x80,0xa8,
0x04,0x81,0xc6,
0x04,0x82,0x01,
0x04,0x83,0xe0,
0x04,0x84,0x94,
0x04,0x85,0xa6,
0x04,0x88,0x94,
0x04,0x89,0x66,
0x04,0x8b,0x02,
0x04,0x8c,0xe0,
0x04,0x8d,0x84,
0x04,0x8e,0x2b,
0x04,0x8f,0x06,
0x04,0x90,0xe1,
0x04,0x91,0x63,
0x04,0x92,0x5b,
0x04,0x93,0x06,
0x04,0x94,0xe1,
0x04,0x95,0x6b,
0x04,0x96,0x20,
0x04,0x98,0xb9,
0x04,0x99,0x6b,
0x04,0x9b,0x48,
0x04,0x9c,0xdc,
0x04,0x9d,0x0a,
0x04,0x9e,0x58,
0x04,0x9f,0xc4,
0x04,0xa0,0x85,
0x04,0xa1,0x21,
0x04,0xa4,0x85,
0x04,0xa5,0x41,
0x04,0xa7,0x04,
0x04,0xa8,0x44,
0x04,0xaa,0x48,
0x04,0xac,0x9c,
0x04,0xad,0x21,
0x04,0xaf,0x08,
0x04,0xb0,0x18,
0x04,0xb1,0x80,
0x04,0xb3,0x14,
0x04,0xb4,0xa8,
0x04,0xb5,0x84,
0x04,0xb6,0x02,
0x04,0xb7,0xcc,
0x04,0xb8,0x84,
0x04,0xb9,0x64,
0x04,0xbc,0xbc,
0x04,0xbd,0x23,
0x04,0xbf,0x41,
0x04,0xc0,0x0c,
0x04,0xc3,0x06,
0x04,0xc4,0xbc,
0x04,0xc5,0x23,
0x04,0xc7,0x3f,
0x04,0xc8,0x10,
0x04,0xcb,0x06,
0x04,0xcc,0x9c,
0x04,0xcd,0x60,
0x04,0xcf,0x3e,
0x04,0xd3,0x04,
0x04,0xd4,0xd4,
0x04,0xd5,0x04,
0x04,0xd6,0x18,
0x04,0xd8,0x9c,
0x04,0xd9,0x60,
0x04,0xdb,0x42,
0x04,0xdc,0xd4,
0x04,0xdd,0x04,
0x04,0xde,0x18,
0x04,0xe0,0x44,
0x04,0xe2,0x48,
0x04,0xe4,0x15,
0x04,0xe8,0x9c,
0x04,0xe9,0x21,
0x04,0xea,0xff,
0x04,0xeb,0xfc,
0x04,0xec,0xd4,
0x04,0xed,0x01,
0x04,0xee,0x48,
0x04,0xf0,0x19,
0x04,0xf1,0xa0,
0x04,0xf3,0x14,
0x04,0xf4,0xa9,
0x04,0xf5,0xad,
0x04,0xf6,0x02,
0x04,0xf7,0xb0,
0x04,0xf8,0x9d,
0x04,0xf9,0x60,
0x04,0xfc,0x84,
0x04,0xfd,0x6d,
0x05,0x00,0x84,
0x05,0x01,0x63,
0x05,0x03,0xd0,
0x05,0x04,0xb8,
0x05,0x05,0x83,
0x05,0x07,0x41,
0x05,0x0b,0x04,
0x05,0x0c,0xb8,
0x05,0x0d,0xc3,
0x05,0x0f,0x45,
0x05,0x10,0xb8,
0x05,0x11,0xc6,
0x05,0x13,0x41,
0x05,0x14,0xa5,
0x05,0x15,0x63,
0x05,0x16,0xff,
0x05,0x17,0xff,
0x05,0x18,0xbc,
0x05,0x19,0xa6,
0x05,0x1b,0x01,
0x05,0x1c,0x0f,
0x05,0x1d,0xff,
0x05,0x1e,0xff,
0x05,0x1f,0xfd,
0x05,0x20,0x9c,
0x05,0x21,0x6b,
0x05,0x23,0x01,
0x05,0x24,0xe0,
0x05,0x25,0x64,
0x05,0x26,0x58,
0x05,0x27,0x48,
0x05,0x28,0x9c,
0x05,0x29,0x63,
0x05,0x2a,0xff,
0x05,0x2b,0xf0,
0x05,0x2c,0xbc,
0x05,0x2d,0x03,
0x05,0x30,0x10,
0x05,0x33,0x0a,
0x05,0x34,0xa8,
0x05,0x35,0xe3,
0x05,0x38,0x84,
0x05,0x39,0x6d,
0x05,0x3c,0x94,
0x05,0x3d,0x63,
0x05,0x3f,0xfc,
0x05,0x40,0xe0,
0x05,0x41,0x63,
0x05,0x42,0x38,
0x05,0x44,0xbc,
0x05,0x45,0xa3,
0x05,0x47,0x0f,
0x05,0x48,0x10,
0x05,0x4b,0x04,
0x05,0x4c,0xa8,
0x05,0x4d,0xe3,
0x05,0x50,0x9c,
0x05,0x51,0x60,
0x05,0x53,0x0f,
0x05,0x54,0xa8,
0x05,0x55,0xe3,
0x05,0x58,0x9c,
0x05,0x59,0x60,
0x05,0x5b,0x01,
0x05,0x5c,0x84,
0x05,0x5d,0x8d,
0x05,0x60,0xe0,
0x05,0x61,0x63,
0x05,0x62,0x58,
0x05,0x63,0x08,
0x05,0x64,0x8c,
0x05,0x65,0xa4,
0x05,0x67,0x8b,
0x05,0x68,0x9d,
0x05,0x69,0x03,
0x05,0x6a,0xff,
0x05,0x6b,0xff,
0x05,0x6c,0x94,
0x05,0x6d,0x64,
0x05,0x6f,0xb0,
0x05,0x70,0xb8,
0x05,0x71,0xc8,
0x05,0x73,0x04,
0x05,0x74,0xe0,
0x05,0x75,0x86,
0x05,0x76,0x38,
0x05,0x78,0x07,
0x05,0x79,0xfb,
0x05,0x7a,0x19,
0x05,0x7b,0xb7,
0x05,0x7c,0xa4,
0x05,0x7d,0x84,
0x05,0x7f,0xff,
0x05,0x80,0x85,
0x05,0x81,0x21,
0x05,0x84,0x44,
0x05,0x86,0x48,
0x05,0x88,0x9c,
0x05,0x89,0x21,
0x05,0x8b,0x04,
0x05,0x8c,0x9c,
0x05,0x8d,0x21,
0x05,0x8e,0xff,
0x05,0x8f,0xf4,
0x05,0x90,0xd4,
0x05,0x91,0x01,
0x05,0x92,0x48,
0x05,0x94,0xd4,
0x05,0x95,0x01,
0x05,0x96,0x50,
0x05,0x97,0x04,
0x05,0x98,0xd4,
0x05,0x99,0x01,
0x05,0x9a,0x60,
0x05,0x9b,0x08,
0x05,0x9c,0xbc,
0x05,0x9d,0x03,
0x05,0x9e,0x01,
0x05,0x9f,0x0c,
0x05,0xa0,0x10,
0x05,0xa3,0x15,
0x05,0xa4,0xbc,
0x05,0xa5,0x43,
0x05,0xa6,0x01,
0x05,0xa7,0x0c,
0x05,0xa8,0x0c,
0x05,0xab,0x0b,
0x05,0xac,0xbc,
0x05,0xad,0x03,
0x05,0xae,0x01,
0x05,0xaf,0x05,
0x05,0xb0,0xbc,
0x05,0xb1,0x03,
0x05,0xb2,0x01,
0x05,0xb3,0x10,
0x05,0xb4,0x10,
0x05,0xb7,0x16,
0x05,0xb8,0xbc,
0x05,0xb9,0x03,
0x05,0xba,0x04,
0x05,0xbb,0x0c,
0x05,0xbc,0x19,
0x05,0xbd,0x80,
0x05,0xbf,0x14,
0x05,0xc0,0xa9,
0x05,0xc1,0x8c,
0x05,0xc2,0x03,
0x05,0xc3,0x18,
0x05,0xc4,0x0c,
0x05,0xc7,0x29,
0x05,0xc8,0x15,
0x05,0xcf,0x25,
0x05,0xd0,0x15,
0x05,0xd4,0x19,
0x05,0xd5,0x80,
0x05,0xd7,0x14,
0x05,0xd8,0xa9,
0x05,0xd9,0x8c,
0x05,0xda,0x03,
0x05,0xdb,0x18,
0x05,0xdc,0x0c,
0x05,0xdf,0x23,
0x05,0xe0,0x15,
0x05,0xe4,0x07,
0x05,0xe5,0xff,
0x05,0xe6,0xff,
0x05,0xe7,0x7f,
0x05,0xe8,0x15,
0x05,0xef,0x20,
0x05,0xf0,0x84,
0x05,0xf1,0x6c,
0x05,0xf4,0x19,
0x05,0xf5,0x80,
0x05,0xf7,0x14,
0x05,0xf8,0xa9,
0x05,0xf9,0x8c,
0x05,0xfa,0x03,
0x05,0xfb,0x18,
0x05,0xfc,0x07,
0x05,0xfd,0xff,
0x05,0xfe,0xff,
0x05,0xff,0xad,
0x06,0x00,0x15,
0x06,0x07,0x1a,
0x06,0x08,0x84,
0x06,0x09,0x6c,
0x06,0x0c,0x18,
0x06,0x0d,0x60,
0x06,0x0f,0x14,
0x06,0x10,0xa8,
0x06,0x11,0x63,
0x06,0x12,0x02,
0x06,0x13,0xb0,
0x06,0x14,0x19,
0x06,0x15,0x40,
0x06,0x17,0x14,
0x06,0x18,0xa9,
0x06,0x19,0x4a,
0x06,0x1a,0x02,
0x06,0x1b,0xf8,
0x06,0x1c,0x84,
0x06,0x1d,0x83,
0x06,0x20,0x84,
0x06,0x21,0xaa,
0x06,0x24,0x94,
0x06,0x25,0x64,
0x06,0x27,0x7e,
0x06,0x28,0xe4,
0x06,0x29,0xa3,
0x06,0x2a,0x28,
0x06,0x2c,0x10,
0x06,0x2f,0x04,
0x06,0x30,0x15,
0x06,0x34,0x9c,
0x06,0x35,0x60,
0x06,0x37,0x04,
0x06,0x38,0xd8,
0x06,0x39,0x04,
0x06,0x3a,0x18,
0x06,0x3b,0xd7,
0x06,0x3c,0x19,
0x06,0x3d,0x80,
0x06,0x3f,0x14,
0x06,0x40,0xa9,
0x06,0x41,0x8c,
0x06,0x42,0x03,
0x06,0x43,0x18,
0x06,0x44,0x84,
0x06,0x45,0x6c,
0x06,0x48,0x07,
0x06,0x49,0xfb,
0x06,0x4a,0x05,
0x06,0x4b,0xf8,
0x06,0x4c,0x84,
0x06,0x4d,0x63,
0x06,0x4e,0x01,
0x06,0x4f,0xc0,
0x06,0x50,0x9c,
0x06,0x51,0x80,
0x06,0x52,0xff,
0x06,0x53,0xf0,
0x06,0x54,0xe1,
0x06,0x55,0x6b,
0x06,0x56,0x20,
0x06,0x57,0x03,
0x06,0x5b,0x04,
0x06,0x5c,0xd4,
0x06,0x5d,0x0a,
0x06,0x5e,0x58,
0x06,0x60,0x07,
0x06,0x61,0xff,
0x06,0x62,0xff,
0x06,0x63,0xa2,
0x06,0x64,0x15,
0x06,0x68,0x84,
0x06,0x69,0x6c,
0x06,0x6c,0x9d,
0x06,0x6d,0x60,
0x06,0x70,0xd4,
0x06,0x71,0x03,
0x06,0x72,0x59,
0x06,0x73,0xcc,
0x06,0x74,0xd4,
0x06,0x75,0x03,
0x06,0x76,0x59,
0x06,0x77,0xc0,
0x06,0x78,0xd4,
0x06,0x79,0x03,
0x06,0x7a,0x59,
0x06,0x7b,0xc4,
0x06,0x7c,0xd4,
0x06,0x7d,0x03,
0x06,0x7e,0x59,
0x06,0x7f,0xc8,
0x06,0x80,0x85,
0x06,0x81,0x21,
0x06,0x84,0x85,
0x06,0x85,0x41,
0x06,0x87,0x04,
0x06,0x88,0x85,
0x06,0x89,0x81,
0x06,0x8b,0x08,
0x06,0x8c,0x44,
0x06,0x8e,0x48,
0x06,0x90,0x9c,
0x06,0x91,0x21,
0x06,0x93,0x0c,
0x00,0x6e,0x30,
0x00,0x6f,0x20,
0x00,0x70,0xc0,
0xff,0xfe,0x50,
0x01,0x37,0x99,
0xff,0xfe,0x30,
0x1f,0x00,0x00,
0x1f,0x01,0x00,
0x1f,0x02,0x00,
0x1f,0x03,0x10,
0x1f,0x04,0x05,
0x1f,0x05,0x00,
0x1f,0x06,0x02,
0x1f,0x07,0xb0,
0xff,0xfe,0x14,
0x00,0x26,0x01,
0x00,0xbe,0x80,
0x00,0xbf,0x00,
0x00,0xc0,0x06,
0x00,0xc1,0x02,
0x00,0xc3,0x00,
0x00,0xc4,0x00,
0x00,0xc5,0x02,
0x00,0xc6,0x00,
0x00,0xc7,0x01,
0x00,0xc8,0x00,
0x00,0xc9,0x00,
0x00,0xcc,0x00,
0x00,0xcd,0xff,
0x00,0xce,0x00,
0x00,0xcf,0xff,
0x00,0xd0,0x00,
0x00,0xd1,0x00,
0x00,0xd2,0x00,
0x00,0xd3,0x00,
0x00,0xe4,0x00,
0x00,0xe5,0x00,
0x00,0xec,0x00,
0x00,0xed,0xff,
0x00,0xee,0x00,
0x00,0xef,0x00,
0x00,0xf0,0x00,
0x00,0xf1,0x00,
0x00,0xf2,0x00,
0x00,0xf3,0x00,
0xff,0xfe,0x14,
0x00,0xb4,0x02,
0x00,0xb8,0x0a,
0x00,0xb9,0x20,
0xff,0xfe,0x14,
0x00,0x35,0x01,
0x00,0xaa,0x03,
0x00,0xab,0x00,
0x00,0xba,0x01,
0x00,0xbb,0x03,
0x00,0xbc,0x0a,
0x00,0xbd,0x20,
0x00,0x6a,0x01,
0x00,0x6b,0x40,
0x00,0x6c,0x01,
0x00,0x6d,0xc0,
0x00,0x73,0x08,
0x00,0x92,0x32,
0x00,0x93,0xa0,
0x00,0x8e,0x00,
0x00,0x8f,0x20,
0xff,0xfe,0x14,
0x00,0x39,0x00,
0x00,0x60,0x00,
0x00,0x76,0x01,
0x00,0x79,0x01,
0x00,0x7a,0x00,
0x00,0x7b,0x30,
0x00,0x7c,0x00,
0x00,0x7d,0xc0,
0x00,0x77,0x30,
0x00,0x78,0x01,
0x00,0x7f,0x80,
0x00,0x87,0x60,
0x00,0x88,0x02,
0x00,0x8c,0x03,
0x00,0x8d,0xc0,
0x00,0x3f,0x10,
0x00,0x40,0x10,
0x00,0x41,0x10,
0x00,0x42,0x10,
0x00,0x43,0x10,
0x00,0x44,0x10,
0x00,0x45,0x10,
0x00,0x46,0x10,
0x00,0x47,0x10,
0x00,0x48,0x10,
0x00,0x49,0x10,
0x00,0x4a,0x10,
0x00,0x4b,0x10,
0x00,0x4c,0x10,
0x00,0x4d,0x10,
0x00,0x4e,0x10,
0x00,0x4f,0x10,
0x00,0x50,0x10,
0x00,0x51,0x10,
0x00,0x52,0x10,
0x00,0x53,0x10,
0x00,0x54,0x10,
0x00,0x55,0x10,
0x00,0x56,0x10,
0x00,0x57,0x10,
0x00,0x3a,0x01,
0xff,0xfe,0x14,
0x01,0x0f,0x01,
0x01,0x10,0x01,
0x01,0x12,0x03,
0x01,0x13,0x03,
0x01,0x14,0x03,
0x01,0x1a,0x00,
0x01,0x1b,0x60,
0x01,0x1c,0x02,
0x01,0x1d,0x80,
0x01,0x1e,0x00,
0x01,0x1f,0x40,
0x01,0x20,0x02,
0x01,0x21,0xc0,
0x00,0x62,0x00,
0x00,0x63,0x60,
0x00,0x64,0x00,
0x00,0x65,0x40,
0x00,0x66,0x01,
0x00,0x67,0x00,
0x00,0x74,0x20,
0x00,0x75,0x40,
0x00,0x6e,0x06,
0x00,0x6f,0x01,
0x01,0x2a,0x05,
0x01,0x2b,0x00,
0x01,0x2c,0x00,
0x01,0x2d,0x30,
0xff,0xfe,0x30,
0x02,0x00,0x11,
0x02,0x01,0x0d,
0x02,0x02,0x0c,
0x02,0x03,0x0c,
0x02,0x04,0x0d,
0x02,0x05,0x11,
0x02,0x06,0x07,
0x02,0x07,0x05,
0x02,0x08,0x04,
0x02,0x09,0x04,
0x02,0x0a,0x05,
0x02,0x0b,0x07,
0x02,0x0c,0x04,
0x02,0x0d,0x01,
0x02,0x0e,0x00,
0x02,0x0f,0x00,
0x02,0x10,0x01,
0x02,0x11,0x03,
0x02,0x12,0x03,
0x02,0x13,0x01,
0x02,0x14,0x00,
0x02,0x15,0x00,
0x02,0x16,0x00,
0x02,0x17,0x03,
0x02,0x18,0x06,
0x02,0x19,0x04,
0x02,0x1a,0x02,
0x02,0x1b,0x02,
0x02,0x1c,0x04,
0x02,0x1d,0x06,
0x02,0x1e,0x0d,
0x02,0x1f,0x0a,
0x02,0x20,0x0a,
0x02,0x21,0x09,
0x02,0x22,0x0a,
0x02,0x23,0x0d,
0x02,0x24,0x11,
0x02,0x25,0x12,
0x02,0x26,0x02,
0x02,0x27,0x12,
0x02,0x28,0x12,
0x02,0x2a,0x11,
0x02,0x2b,0x11,
0x02,0x2c,0x11,
0x02,0x2d,0x21,
0x02,0x2e,0x21,
0x02,0x30,0x01,
0x02,0x31,0x21,
0x02,0x32,0x31,
0x02,0x33,0x21,
0x02,0x34,0x21,
0x02,0x36,0x12,
0x02,0x37,0x11,
0x02,0x38,0x11,
0x02,0x39,0x21,
0x02,0x3a,0x22,
0x02,0x3c,0x22,
0x02,0x3d,0x12,
0x02,0x3e,0x22,
0x02,0x3f,0x12,
0x02,0x40,0x22,
0x02,0x48,0xef,
0xff,0xfe,0x30,
0x02,0x4d,0x01,
0x02,0x4e,0x33,
0x02,0x4f,0x02,
0x02,0x50,0x22,
0x02,0x51,0x01,
0x02,0x52,0x99,
0x02,0x53,0x01,
0x02,0x54,0x6c,
0xff,0xfe,0x14,
0x00,0x27,0x01,
0x01,0x3c,0x02,
0x01,0x76,0x06,
0x01,0x77,0x00,
0x01,0x7a,0x04,
0x01,0x7b,0x00,
0x01,0x7e,0x04,
0x01,0x7f,0x00,
0x01,0x82,0x04,
0x01,0x83,0x04,
0x01,0xaa,0x06,
0x01,0xab,0x00,
0x01,0xae,0x04,
0x01,0xaf,0x00,
0x01,0xb2,0x04,
0x01,0xb3,0x04,
0xff,0xfe,0x14,
0x00,0x27,0x01,
0x01,0x3c,0x01,
0x01,0x3d,0x01,
0x01,0x3e,0x00,
0x01,0x70,0x0d,
0x01,0x71,0xff,
0xff,0xfe,0x30,
0x07,0x08,0x03,
0x07,0x09,0xa0,
0x07,0x0a,0x00,
0x07,0x0b,0x0c,
0x00,0x51,0x03,
0x00,0x96,0x83,
0x00,0x19,0x48,
0x07,0x1c,0x0a,
0xff,0xfe,0x14,
0x01,0x6e,0x08,
0xff,0xfe,0x30,
0x07,0x30,0x88,
0x07,0x31,0xb4,
0x07,0x32,0x40,
0x07,0x33,0x4d,
0x07,0x34,0x78,
0x07,0x35,0x97,
0x07,0x36,0x59,
0x07,0x37,0x68,
0x07,0x38,0x55,
0x07,0x39,0x6d,
0x07,0x3a,0x65,
0x07,0x3b,0x80,
0x07,0x3c,0x70,
0x07,0x3d,0x92,
0x07,0x3e,0x49,
0x07,0x3f,0x5b,
0x07,0x40,0x64,
0x07,0x41,0x90,
0x07,0x42,0x60,
0x07,0x43,0x7d,
0x07,0x44,0x00,
0x07,0x45,0x00,
0x07,0x46,0x00,
0x07,0x47,0x00,
0x07,0x48,0x00,
0x07,0x49,0x00,
0x07,0x4a,0x00,
0x07,0x4b,0x00,
0x07,0x4c,0x00,
0x07,0x4d,0x00,
0x07,0x4e,0x00,
0x07,0x4f,0x00,
0x07,0x50,0x00,
0x07,0x51,0x00,
0x07,0x52,0x00,
0x07,0x53,0x00,
0x07,0x54,0x00,
0x07,0x55,0x00,
0x07,0x56,0x00,
0x07,0x57,0x00,
0x07,0x58,0x00,
0x07,0x59,0x00,
0x07,0x5a,0x00,
0x07,0x5b,0x00,
0x07,0x5c,0x00,
0x07,0x5d,0x00,
0x07,0x5e,0x00,
0x07,0x5f,0x00,
0x07,0x60,0x00,
0x07,0x61,0x00,
0x07,0x62,0x00,
0x07,0x63,0x00,
0x07,0x64,0x00,
0x07,0x65,0x00,
0x07,0x66,0x00,
0x07,0x67,0x00,
0x07,0x68,0x00,
0x07,0x69,0x00,
0x07,0x6a,0x00,
0x07,0x6b,0x00,
0x07,0x6c,0x00,
0x07,0x6d,0x00,
0x07,0x6e,0x00,
0x07,0x6f,0x00,
0x07,0x70,0x22,
0x07,0x71,0x21,
0x07,0x72,0x10,
0x07,0x73,0x00,
0x07,0x74,0x00,
0x07,0x75,0x00,
0x07,0x76,0x00,
0x07,0x77,0x00,
0xff,0xfd,0x80,
0xff,0xfd,0x80,
0xff,0xfe,0x30,
0x14,0x00,0x00,
0x14,0x01,0x04,
0x14,0x02,0x09,
0x14,0x03,0x0d,
0x14,0x04,0x12,
0x14,0x05,0x17,
0x14,0x06,0x1b,
0x14,0x07,0x20,
0x14,0x08,0x26,
0x14,0x09,0x2b,
0x14,0x0a,0x31,
0x14,0x0b,0x36,
0x14,0x0c,0x3c,
0x14,0x0d,0x41,
0x14,0x0e,0x47,
0x14,0x0f,0x4c,
0x14,0x10,0x51,
0x14,0x11,0x56,
0x14,0x12,0x5a,
0x14,0x13,0x5f,
0x14,0x14,0x63,
0x14,0x15,0x67,
0x14,0x16,0x6a,
0x14,0x17,0x6e,
0x14,0x18,0x72,
0x14,0x19,0x75,
0x14,0x1a,0x78,
0x14,0x1b,0x7b,
0x14,0x1c,0x7e,
0x14,0x1d,0x81,
0x14,0x1e,0x84,
0x14,0x1f,0x86,
0x14,0x20,0x89,
0x14,0x21,0x8d,
0x14,0x22,0x92,
0x14,0x23,0x96,
0x14,0x24,0x99,
0x14,0x25,0x9d,
0x14,0x26,0xa0,
0x14,0x27,0xa3,
0x14,0x28,0xa6,
0x14,0x29,0xa8,
0x14,0x2a,0xaa,
0x14,0x2b,0xad,
0x14,0x2c,0xaf,
0x14,0x2d,0xb1,
0x14,0x2e,0xb3,
0x14,0x2f,0xb5,
0x14,0x30,0xb7,
0x14,0x31,0xbb,
0x14,0x32,0xbf,
0x14,0x33,0xc4,
0x14,0x34,0xc8,
0x14,0x35,0xcd,
0x14,0x36,0xd1,
0x14,0x37,0xd6,
0x14,0x38,0xda,
0x14,0x39,0xdf,
0x14,0x3a,0xe3,
0x14,0x3b,0xe8,
0x14,0x3c,0xed,
0x14,0x3d,0xf1,
0x14,0x3e,0xf6,
0x14,0x3f,0xfb,
0x14,0x40,0xff,
0x14,0x52,0x6e,
0x14,0x53,0x10,
0x14,0x54,0xff,
0x12,0x00,0x04,		//DAY
0x12,0x01,0xDB,		
0x12,0x02,0x00,		
0x12,0x03,0x5E,		
0x12,0x04,0x02,		
0x12,0x05,0x56,		
0x12,0x06,0x01,		
0x12,0x07,0x77,		
0x12,0x08,0x00,		
0x12,0x09,0xF0,		
0x12,0x0A,0x03,		
0x12,0x0B,0x12,		
0x12,0x0C,0x09,		//ALIGHT
0x12,0x0D,0xCC,		
0x12,0x0E,0x00,		
0x12,0x0F,0x1E,		
0x12,0x10,0x01,		
0x12,0x11,0x13,		
0x12,0x12,0x01,		
0x12,0x13,0xF9,		
0x12,0x14,0x01,		
0x12,0x15,0x09,		
0x12,0x16,0x01,		
0x12,0x17,0x7D,		
0x12,0x18,0x05,		//CWF
0x12,0x19,0xCF,		
0x12,0x1A,0x00,		
0x12,0x1B,0x3F,		
0x12,0x1C,0x01,		
0x12,0x1D,0xA0,		
0x12,0x1E,0x01,		
0x12,0x1F,0xEC,		
0x12,0x20,0x00,		
0x12,0x21,0x88,		
0x12,0x22,0x04,		
0x12,0x23,0x70,		
0x12,0x2e,0x00,		//sign
0x12,0x2F,0x00,		
0x12,0x30,0x00,		
0xD3,0x1,0x003,		
0x12,0x28,0x00,		
0x12,0x29,0x66,		
0x12,0x2A,0x00,		
0x12,0x2B,0x66,		
0x12,0x2C,0x00,		
0x12,0x2D,0xEC,				
0xff,0xfe,0x30,
0x12,0x31,0x02,
0xff,0xfe,0x30,//YEE
0x20,0x00,0x33,//bit[5]Yedgeen;bit[3]UV_dns_en;bit[2]pre_dns_en;bit[1]ydns_man;bit[0]uvdns_man
0x20,0x01,0x0f,//edge_ratio
0x20,0x02,0x01,//Y_dns_level_man
0x20,0x03,0x01,//UV_dns_level_man
0x20,0x04,0x01,//gainlist0
0x20,0x05,0x01,
0x20,0x06,0x02,
0x20,0x07,0x03,
0x20,0x08,0x04,
0x20,0x09,0x05,
0x20,0x0a,0x06,
0x20,0x0b,0x1f,//gainlist7
0x19,0x07,0xd2,
0x19,0x08,0x01,
0xff,0xfe,0x30,
0x0e,0x00,0x14,
0x0e,0x01,0x04,
0x0e,0x02,0x08,
0x0e,0x03,0x0f,
0x0e,0x04,0x18,
0x0e,0x05,0x1f,
0x0e,0x06,0x2f,
0x0e,0x07,0x2f,
0x0e,0x08,0x38,
0x0e,0x09,0xff,
0x0e,0x0a,0x0d,
0x0e,0x0b,0x20,
0xff,0xfe,0x30,
0x13,0x0e,0x09,
0x13,0x0f,0x0d,
0xff,0xfe,0x30,
0x0f,0x00,0xaf,
0x0f,0x01,0x00,
0x0f,0x02,0x00,
0x0f,0x03,0x00,
0x0f,0x04,0x00,
0x0f,0x05,0x00,
0x0f,0x06,0x00,
0x0f,0x07,0x00,
0x0f,0x08,0x00,
0x0f,0x09,0x00,
0x0f,0x0a,0x0f,
0x0f,0x0b,0x0f,
0x0f,0x0c,0x0f,
0x0f,0x0d,0x0f,
0x0f,0x0e,0x00,
0x0f,0x0f,0x20,
0xff,0xfe,0x14,
0x01,0x60,0x00,
0x01,0x62,0x60,
0x01,0x63,0x58,
0x01,0x64,0x50,
0x01,0x65,0x48,
0x01,0x66,0x40,
0x01,0x67,0x40,
0x01,0x68,0x60,
0x01,0x69,0x58,
0x01,0x6a,0x50,
0x01,0x6b,0x48,
0x01,0x6c,0x40,
0x01,0x6d,0x40,
0xff,0xfe,0x30,
0x00,0x00,0x7F,
0x00,0x01,0xa7,
0x00,0x03,0xe5,
0x07,0x1c,0x0a,
0x17,0x00,0x09,
0x17,0x01,0xa0,
0x17,0x02,0xd0,
0x17,0x04,0x25,
0x14,0x52,0xb0,
0x14,0x53,0x40,
0x00,0x13,0x0e,
0x00,0x13,0x10,
0x07,0x1b,0x50,
0x07,0x1c,0x0a,
0x17,0x00,0x09,
0x17,0x01,0x40,
0x17,0x02,0x40,
0x17,0x04,0x24,
0x17,0x07,0x00,
0xff,0xfe,0x14,
0x00,0x27,0x01,
           
0xff,0xfe,0x50,
0x00,0x4d,0x01,


#endif
	//bypass on
	0xff,0xfd, 0x80,
	0xff,0xfe, 0x50,
	0x00,0x4d, 0x01,


	-1,-1,-1,
};


SENSOR_INIT_SECTION static const unsigned char h63_7011_Init_regs[] = {			  
	0x12,0x44,
	0x48,0x85,
	0x48,0x05,
	0x0E,0x12,
	0x0F,0x14,
	0x10,0x28,
	0x11,0x80,
	0x0D,0xD0,
	0x5F,0x42,
	0x60,0x2B,
	0x58,0x18,
	0x57,0x60,
	0x20,0x60,
	0x21,0x03,
	0x22,0xEE,
	0x23,0x02,
	0x24,0x80,
	0x25,0xD0,
	0x26,0x22,
	0x27,0xF0,
	0x28,0x15,
	0x29,0x02,
	0x2A,0xE6,
	0x2B,0x12,
	0x2C,0x00,
	0x2D,0x00,
	0x2E,0xBA,
	0x2F,0x40,
	0x41,0x84,
	0x42,0x32,
	0x46,0x00,
	0x47,0x42,
	0x76,0x40,
	0x77,0x06,
	0x80,0x01,
	0xAF,0x22,
	0x1D,0xFF,
	0x1E,0x1F,
	0x6C,0xC0,
	0x30,0x86,
	0x31,0x04,
	0x32,0x19,
	0x33,0x10,
	0x34,0x2A,
	0x35,0x2A,
	0x3A,0xA0,
	0x3B,0x00,
	0x3C,0x38,
	0x3D,0x41,
	0x3E,0xE0,
	0x56,0x12,
	0x59,0x46,
	0x5A,0x02,
	0x85,0x1E,
	0x8A,0x04,
	0x9C,0x61,
	0x5B,0xAC,
	0x5C,0x61,
	0x5D,0xA6,
	0x5E,0x14,
	0x64,0xE0,
	0x66,0x04,
	0x67,0x53,
	0x68,0x00,
	0x69,0x74,
	0x7A,0x60,
	0x8F,0x91,
	0xAE,0x30,
	0x13,0x81,
	0x96,0x84,
	0x4A,0x05,
	0x7E,0xCD,
	0x50,0x02,
	0x49,0x10,
	0x7B,0x4A,
	0x7C,0x0C,
	0x7F,0x56,
	0x62,0x21,
	0x90,0x00,
	0x8C,0xFF,
	0x8D,0xC7,
	0x8E,0x00,
	0x8B,0x01,
	0x0C,0x00,
	0xBB,0x11,
	0xA0,0x10,
	0x6A,0x17,
	0x65,0x34,
	0x82,0x00,
	0x19,0x20,
	0x12,0x04,
	0x48,0x85,
	0x48,0x05,



	-1,-1,

};

SENSOR_OP_SECTION const _Sensor_Adpt_ xc7011_h63_cmd= 
{
	.typ = 1, //YUV
	.pixelw = 1280,
	.pixelh= 720,
	.hsyn = 1,
	.vsyn = 0,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)XC7011_IQ_InitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = {0x6a,0x12,0x6a,0x12},
	. mclk = 24000000,
	.p_fun_adapt    = {NULL,NULL,NULL},
	.p_xc7016_adapt = {XC7011_bypass_on,XC7011_bypass_off,h63_7011_Init_regs,0x63,0x80,0x81,0x01,0x01,0x0b},
};

const _Sensor_Ident_ xc7011_h63_init=
{
	0x70,0x36,0x37,0x02,0x01,0xfffb
};


#endif
