#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"

#if DEV_SENSOR_XC7011_GC1054

//XC7011_Init_IQ_regs
//XC7011_bypass_on
//h63_Init_regs[]
//XC7011_bypass_off




SENSOR_INIT_SECTION static const unsigned char XC7011_bypass_on[] = {

	0xff,0xfd,0x80,
	0xff,0xfe,0x50,
	0x00,0x4d,0x01,
	-1,-1,

};

SENSOR_INIT_SECTION static const unsigned char  XC7011_bypass_off[] = {

	0xff,0xfd,0x80,
	0xff,0xfe,0x50,
	0x00,0x4d,0x00,
	-1,-1,

};

SENSOR_INIT_SECTION static const unsigned char XC7011_IQ_InitTable[CMOS_INIT_LEN] = 
{
    0xff,0xfd, 0x80,
    0xff,0xfe, 0x50,
    0x00,0x1c, 0xff,       
    0x00,0x1d, 0xff,  
    0x00,0x1e, 0xff,  
    0x00,0x1f, 0xff,  //clk en
    0x00,0x18, 0x00,         
    0x00,0x19, 0x00,  
    0x00,0x1a, 0x00,  
    0x00,0x1b, 0x00,   // reset
    0x00,0xbc, 0x11,        
    0x00,0xbd, 0x00,  
    0x00,0xbe, 0x00,  
    0x00,0xbf, 0x00,  
	// 2.2 wait pll lock  ( /*READ ONLY*/)
	0xfe,0xfe, 0xf0,
	0xfe,0xfe, 0x01,  //delay 1ms
	0xfe,0xfe, 0xf1,
	    
    0x00,0x30, 0x09, //
    0x00,0x32, 0x0c,
    0x00,0x27, 0x06,
    0x00,0x26, 0x01,
    0x00,0x21, 0x0e,
    0x00,0x20, 0x02,
    0xff,0xfe, 0x50,
    0x00,0x28, 0x08,
    0x00,0x29, 0x06,
    0xff,0xfe, 0x25,   
    0x20,0x0b, 0x33,  //de-glitch
    0x00,0x02, 0x40,
    0xff,0xfe, 0x50,
    0x02,0x00, 0x03,
    0x02,0x04, 0x03,
    0x02,0x08, 0x02,
    0x02,0x08, 0x01,
    0xff,0xfd, 0x80, //datapath start
    0xff,0xfe, 0x50,
    0x00,0xbc, 0x11,
    0x00,0x1b, 0x00,
    0x00,0x90, 0x29,
    0xff,0xfe, 0x20,
    0x00,0x00, 0x20,
    0x00,0x04, 0x05,
    0x00,0x05, 0x00,
    0x00,0x06, 0x02,
    0x00,0x07, 0xD0,
    0xff,0xfe, 0x26,
    0x40,0x00, 0xF9,
    0x60,0x01, 0x14,
    0x60,0x05, 0xc4,
    0x60,0x06, 0x0A,
    0x60,0x07, 0x8C,
    0x60,0x08, 0x09,
    0x60,0x09, 0xFC,
    0x80,0x00, 0x3f,
    0x80,0x01, 0x00,
    0x80,0x02, 0x05,
    0x80,0x03, 0xD0,
    0x80,0x04, 0x02,
    0x80,0x05, 0x03,
    0x80,0x06, 0x05,
    0x80,0x07, 0x99,
    0x80,0x10, 0x04,
    0x80,0x12, 0x00,
    0x80,0x13, 0x05,
    0x80,0x14, 0xD0,
    0x80,0x15, 0x02,
    0x80,0x16, 0x00,
    0x80,0x17, 0x00,
    0x80,0x18, 0x00,
    0x80,0x19, 0x00,
    0xff,0xfe, 0x30,
    0x00,0x01, 0x81,
    0x00,0x04, 0x18,
    0x00,0x06, 0x05,
    0x00,0x07, 0x00,
    0x00,0x08, 0x02,
    0x00,0x09, 0xD0,
    0x00,0x0a, 0x05,
    0x00,0x0b, 0x00,
    0x00,0x0c, 0x02,
    0x00,0x0d, 0xD0,
    0x00,0x27, 0xF1,
    0x00,0x5e, 0x04,
    0x00,0x5f, 0xFF,
    0x00,0x60, 0x02,
    0x00,0x61, 0xCF,
    0x19,0x08, 0x01,
    0x19,0x00, 0x00,
    0x19,0x01, 0x00,
    0x19,0x02, 0x00,
    0x19,0x03, 0x00,
    0x19,0x04, 0x05,
    0x19,0x05, 0x00,
    0x19,0x06, 0x02,
    0x19,0x07, 0xD0,  //datapath end
        
    //iq,0x部分
    0xff,0xfe, 0x14,
    0x00,0x26, 0x01,
    0x00,0xbe, 0x42,  	//camera i2c id
    0x00,0xbf, 0x00,  	//camera i2c bits     
    0x00,0xc0, 0x05,  	//sensor type gain
    0x00,0xc1, 0x02,  	//sensor type exposure
    0x00,0xc3, 0x00,    //sensor mode select
    0x00,0xc4, 0x00,  //write camera exposure variable [15:12]
    0x00,0xc5, 0x03,
    0x00,0xc6, 0x00,  //write camera exposure variable [11:4]
    0x00,0xc7, 0x04,
    0x00,0xcc, 0x00,  //camera exposure addr mask 1
    0x00,0xcd, 0xff,      
    0x00,0xce, 0x00,  //camera exposure addr mask 2
    0x00,0xcf, 0xff,
    0x00,0xe4, 0x00,  //camera gain addr
    0x00,0xe5, 0xb6,
    0x00,0xe6, 0x00,  //camera gain addr
    0x00,0xe7, 0xb1,
    0x00,0xe8, 0x00,  //camera gain addr
    0x00,0xe9, 0xb2,
    0x00,0xec, 0x00,  //camera gain addr mask 1
    0x00,0xed, 0xff,
    0x00,0xee, 0x00,  //camera gain addr mask 2
    0x00,0xef, 0xff,
    0x00,0xf0, 0x00,  //camera gain addr mask 3
    0x00,0xf1, 0xff,
    0x00,0xb4, 0x02,    // banding mode
    0x00,0xb8, 0x0e,    // banding  exposure lines
    0x00,0xb9, 0x80, 
    0x00,0x35, 0x01,
    0xff,0xfe, 0x14, 
    0x00,0xaa, 0x01,
    0x00,0xab, 0x7f,  //017f //max gain
    0x00,0xba, 0x00,    //low light mode
    0x00,0x6a, 0x01,   
    0x00,0x6b, 0x40,  //0140 //night target
    0x00,0x6c, 0x01,
    0x00,0x6d, 0xb0,  //0120 //day target  
    0x00,0x73, 0x08,   //AttAvgReviseDiff
    0xff,0xfe, 0x14, 
    0x00,0x39, 0x00,    //DETECT enable
    0x00,0x60, 0x00,    //smart mode 03
    0x00,0x76, 0x01,     // delay frame
    0x00,0x79, 0x01,
    0x00,0x7a, 0x00,    
    0x00,0x7b, 0x30,		//1. threshold low
    0x00,0x7c, 0x00,   
    0x00,0x7d, 0x30,   //2. threshold high
    0x00,0x77, 0x1f,    //3. finally thr
    0x00,0x78, 0x01,    //total speed
    0x00,0x7f, 0x80,  // jump threshold
    0x00,0x87, 0x60,  // jump ratio
    0x00,0x88, 0x02,  // jump times
    0x00,0x8c, 0x02,
    0x00,0x8d, 0x30,
    0x00,0x8e, 0x00,  
    0x00,0x8f, 0x20,  
    0x00,0x92, 0x02, 
    0x00,0x93, 0xd0,
    0x01,0x10, 0x01,
    0x01,0x12, 0x03,   //Att Detect Speed
    0x01,0x13, 0x03,    
    0x01,0x14, 0x03,		// below or above cnt
    0x01,0x1a, 0x00,
    0x01,0x1b, 0x60,   //day min attention  avg thr
    0x01,0x1c, 0x02,
    0x01,0x1d, 0x80,   //day max attention  avg thr
    0x01,0x1e, 0x00,
    0x01,0x1f, 0x40,   //day min avg thr
    0x01,0x20, 0x02,
    0x01,0x21, 0xc0,   //day max avg thr
    0x00,0x62, 0x00,
    0x00,0x63, 0x60,    // D-N
    0x00,0x64, 0x00,
    0x00,0x65, 0x40,    // N-D
    0x00,0x66, 0x01,
    0X00,0x67, 0x00,    //dark thr
    0x00,0x74, 0x20,    //diff ratio low
    0x00,0x75, 0x40,    //diff ratio high 
    0x00,0x6e, 0x06,     //magnituede offset
    0x00,0x6f, 0x01,     //magnituede MIN
    0x01,0x2a, 0x05,   //variance thr promote luma
    0x01,0x2b, 0x00,
    0x01,0x2c, 0x00,   //variance ratio
    0x01,0x2d, 0x30,
    0xff,0xfd, 0x80,
    0xff,0xfe, 0x50,
    0x00,0x0e, 0x54,
    0xff,0xfe, 0x14,
    0x00,0x06, 0x02,
    0x00,0x07, 0x61,
    0x00,0x14, 0x00,
    0x00,0x15, 0x14,
    0x00,0x16, 0x07,
    0x00,0x17, 0x54,
    0x03,0xd4, 0x9c,
    0x03,0xd5, 0x21,
    0x03,0xd6, 0xff,
    0x03,0xd7, 0xf4,
    0x03,0xd8, 0xd4,
    0x03,0xd9, 0x01,
    0x03,0xda, 0x48,
    0x03,0xdc, 0xd4,
    0x03,0xdd, 0x01,
    0x03,0xde, 0x50,
    0x03,0xdf, 0x04,
    0x03,0xe0, 0xd4,
    0x03,0xe1, 0x01,
    0x03,0xe2, 0x60,
    0x03,0xe3, 0x08,
    0x03,0xe4, 0x18,
    0x03,0xe5, 0x60,
    0x03,0xe7, 0x14,
    0x03,0xe8, 0xa8,
    0x03,0xe9, 0x63,
    0x03,0xea, 0x01,
    0x03,0xeb, 0xd0,
    0x03,0xec, 0x19,
    0x03,0xed, 0x80,
    0x03,0xef, 0x14,
    0x03,0xf0, 0xa9,
    0x03,0xf1, 0x8c,
    0x03,0xf2, 0x02,
    0x03,0xf3, 0xb0,
    0x03,0xf4, 0x94,
    0x03,0xf5, 0x63,
    0x03,0xf8, 0x84,
    0x03,0xf9, 0xac,
    0x03,0xfc, 0x19,
    0x03,0xfd, 0xa0,
    0x03,0xff, 0x14,
    0x04,0x00, 0xa9,
    0x04,0x01, 0xad,
    0x04,0x02, 0x11,
    0x04,0x04, 0xb8,
    0x04,0x05, 0xc3,
    0x04,0x07, 0x44,
    0x04,0x08, 0x19,
    0x04,0x09, 0x60,
    0x04,0x0b, 0x14,
    0x04,0x0c, 0xa9,
    0x04,0x0d, 0x6b,
    0x04,0x0e, 0x11,
    0x04,0x0f, 0x08,
    0x04,0x10, 0x8c,
    0x04,0x11, 0x85,
    0x04,0x13, 0x3c,
    0x04,0x14, 0x85,
    0x04,0x15, 0x0d,
    0x04,0x18, 0x19,
    0x04,0x19, 0xe0,
    0x04,0x1b, 0x14,
    0x04,0x1c, 0xa9,
    0x04,0x1d, 0xef,
    0x04,0x1e, 0x11,
    0x04,0x1f, 0x04,
    0x04,0x20, 0x8c,
    0x04,0x21, 0x65,
    0x04,0x23, 0x3a,
    0x04,0x24, 0x84,
    0x04,0x25, 0xeb,
    0x04,0x28, 0xe0,
    0x04,0x29, 0x66,
    0x04,0x2a, 0x18,
    0x04,0x2b, 0x02,
    0x04,0x2c, 0xd4,
    0x04,0x2d, 0x0f,
    0x04,0x2e, 0x40,
    0x04,0x30, 0xe5,
    0x04,0x31, 0xa4,
    0x04,0x32, 0x18,
    0x04,0x34, 0x10,
    0x04,0x37, 0x03,
    0x04,0x38, 0xd4,
    0x04,0x39, 0x0d,
    0x04,0x3a, 0x38,
    0x04,0x3c, 0xa8,
    0x04,0x3d, 0x83,
    0x04,0x40, 0x8c,
    0x04,0x41, 0x65,
    0x04,0x43, 0x3b,
    0x04,0x44, 0xe5,
    0x04,0x45, 0x64,
    0x04,0x46, 0x18,
    0x04,0x48, 0x10,
    0x04,0x4b, 0x03,
    0x04,0x4c, 0x15,
    0x04,0x50, 0xa8,
    0x04,0x51, 0x83,
    0x04,0x54, 0x19,
    0x04,0x55, 0x40,
    0x04,0x57, 0x14,
    0x04,0x58, 0xa9,
    0x04,0x59, 0x4a,
    0x04,0x5a, 0x01,
    0x04,0x5b, 0xe0,
    0x04,0x5c, 0x94,
    0x04,0x5d, 0xc5,
    0x04,0x5f, 0xfa,
    0x04,0x60, 0x94,
    0x04,0x61, 0x6a,
    0x04,0x64, 0xe4,
    0x04,0x65, 0xa3,
    0x04,0x66, 0x30,
    0x04,0x68, 0x10,
    0x04,0x6b, 0x0f,
    0x04,0x6c, 0x15,
    0x04,0x70, 0x94,
    0x04,0x71, 0xa5,
    0x04,0x73, 0xfc,
    0x04,0x74, 0xe0,
    0x04,0x75, 0x63,
    0x04,0x76, 0x30,
    0x04,0x77, 0x02,
    0x04,0x78, 0xe0,
    0x04,0x79, 0x63,
    0x04,0x7a, 0x2b,
    0x04,0x7b, 0x06,
    0x04,0x7c, 0xb8,
    0x04,0x7d, 0x63,
    0x04,0x7f, 0x44,
    0x04,0x80, 0xa4,
    0x04,0x81, 0x63,
    0x04,0x82, 0xff,
    0x04,0x83, 0xff,
    0x04,0x84, 0xbc,
    0x04,0x85, 0xa3,
    0x04,0x87, 0x80,
    0x04,0x88, 0x0c,
    0x04,0x8b, 0x09,
    0x04,0x8c, 0xe4,
    0x04,0x8d, 0xa3,
    0x04,0x8e, 0x20,
    0x04,0x90, 0x10,
    0x04,0x93, 0x0b,
    0x04,0x94, 0x15,
    0x04,0x98, 0x9c,
    0x04,0x99, 0x60,
    0x04,0x9f, 0x0a,
    0x04,0xa0, 0xd4,
    0x04,0xa1, 0x0b,
    0x04,0xa2, 0x18,
    0x04,0xa7, 0x08,
    0x04,0xa8, 0xd4,
    0x04,0xa9, 0x0b,
    0x04,0xaa, 0x20,
    0x04,0xac, 0x9c,
    0x04,0xad, 0x60,
    0x04,0xaf, 0x80,
    0x04,0xb0, 0xe4,
    0x04,0xb1, 0xa3,
    0x04,0xb2, 0x20,
    0x04,0xb4, 0x0f,
    0x04,0xb5, 0xff,
    0x04,0xb6, 0xff,
    0x04,0xb7, 0xf9,
    0x04,0xb8, 0x15,
    0x04,0xbc, 0xe0,
    0x04,0xbd, 0x64,
    0x04,0xbe, 0x18,
    0x04,0xbf, 0x02,
    0x04,0xc0, 0xd4,
    0x04,0xc1, 0x0b,
    0x04,0xc2, 0x18,
    0x04,0xc4, 0x84,
    0x04,0xc5, 0x8b,
    0x04,0xc8, 0x84,
    0x04,0xc9, 0x6d,
    0x04,0xcc, 0x84,
    0x04,0xcd, 0xaf,
    0x04,0xd0, 0xe0,
    0x04,0xd1, 0x64,
    0x04,0xd2, 0x18,
    0x04,0xd4, 0x9c,
    0x04,0xd5, 0x80,
    0x04,0xd7, 0x03,
    0x04,0xd8, 0x07,
    0x04,0xd9, 0xfb,
    0x04,0xda, 0x1c,
    0x04,0xdb, 0xb5,
    0x04,0xdc, 0xe0,
    0x04,0xdd, 0x63,
    0x04,0xde, 0x28,
    0x04,0xe0, 0x84,
    0x04,0xe1, 0xcc,
    0x04,0xe4, 0x9c,
    0x04,0xe5, 0x60,
    0x04,0xe6, 0x01,
    0x04,0xe8, 0xdc,
    0x04,0xe9, 0x06,
    0x04,0xea, 0x58,
    0x04,0xeb, 0xfe,
    0x04,0xec, 0xe0,
    0x04,0xed, 0xa3,
    0x04,0xee, 0x58,
    0x04,0xef, 0x02,
    0x04,0xf0, 0x94,
    0x04,0xf1, 0x8a,
    0x04,0xf4, 0x94,
    0x04,0xf5, 0x6a,
    0x04,0xf7, 0x02,
    0x04,0xf8, 0xe0,
    0x04,0xf9, 0x85,
    0x04,0xfa, 0x23,
    0x04,0xfb, 0x06,
    0x04,0xfc, 0xe1,
    0x04,0xfd, 0x63,
    0x04,0xfe, 0x5b,
    0x04,0xff, 0x06,
    0x05,0x00, 0xe1,
    0x05,0x01, 0x6b,
    0x05,0x02, 0x20,
    0x05,0x04, 0xb9,
    0x05,0x05, 0x6b,
    0x05,0x07, 0x48,
    0x05,0x08, 0xdc,
    0x05,0x09, 0x06,
    0x05,0x0a, 0x58,
    0x05,0x0b, 0xc4,
    0x05,0x0c, 0x85,
    0x05,0x0d, 0x21,
    0x05,0x10, 0x85,
    0x05,0x11, 0x41,
    0x05,0x13, 0x04,
    0x05,0x14, 0x85,
    0x05,0x15, 0x81,
    0x05,0x17, 0x08,
    0x05,0x18, 0x44,
    0x05,0x1a, 0x48,
    0x05,0x1c, 0x9c,
    0x05,0x1d, 0x21,
    0x05,0x1f, 0x0c,
    0x05,0x20, 0x18,
    0x05,0x21, 0x80,
    0x05,0x23, 0x14,
    0x05,0x24, 0xa8,
    0x05,0x25, 0x84,
    0x05,0x26, 0x02,
    0x05,0x27, 0xcc,
    0x05,0x28, 0x84,
    0x05,0x29, 0x64,
    0x05,0x2c, 0xbc,
    0x05,0x2d, 0x23,
    0x05,0x2f, 0x41,
    0x05,0x30, 0x0c,
    0x05,0x33, 0x06,
    0x05,0x34, 0xbc,
    0x05,0x35, 0x23,
    0x05,0x37, 0x3f,
    0x05,0x38, 0x10,
    0x05,0x3b, 0x06,
    0x05,0x3c, 0x9c,
    0x05,0x3d, 0x60,
    0x05,0x3f, 0x3e,
    0x05,0x43, 0x04,
    0x05,0x44, 0xd4,
    0x05,0x45, 0x04,
    0x05,0x46, 0x18,
    0x05,0x48, 0x9c,
    0x05,0x49, 0x60,
    0x05,0x4b, 0x42,
    0x05,0x4c, 0xd4,
    0x05,0x4d, 0x04,
    0x05,0x4e, 0x18,
    0x05,0x50, 0x44,
    0x05,0x52, 0x48,
    0x05,0x54, 0x15,
    0x05,0x58, 0x9c,
    0x05,0x59, 0x21,
    0x05,0x5a, 0xff,
    0x05,0x5b, 0xf0,
    0x05,0x5c, 0xd4,
    0x05,0x5d, 0x01,
    0x05,0x5e, 0x48,
    0x05,0x60, 0xd4,
    0x05,0x61, 0x01,
    0x05,0x62, 0x50,
    0x05,0x63, 0x04,
    0x05,0x64, 0xd4,
    0x05,0x65, 0x01,
    0x05,0x66, 0x60,
    0x05,0x67, 0x08,
    0x05,0x68, 0xd4,
    0x05,0x69, 0x01,
    0x05,0x6a, 0x70,
    0x05,0x6b, 0x0c,
    0x05,0x6c, 0x19,
    0x05,0x6d, 0xc0,
    0x05,0x6f, 0x14,
    0x05,0x70, 0xa9,
    0x05,0x71, 0xce,
    0x05,0x72, 0x02,
    0x05,0x73, 0xb0,
    0x05,0x74, 0x84,
    0x05,0x75, 0x6e,
    0x05,0x78, 0x84,
    0x05,0x79, 0x63,
    0x05,0x7b, 0xd0,
    0x05,0x7c, 0xb8,
    0x05,0x7d, 0x63,
    0x05,0x7f, 0x01,
    0x05,0x80, 0xbc,
    0x05,0x81, 0x43,
    0x05,0x83, 0x3f,
    0x05,0x84, 0x10,
    0x05,0x87, 0x04,
    0x05,0x88, 0x9c,
    0x05,0x89, 0xa3,
    0x05,0x8a, 0xff,
    0x05,0x8b, 0xc0,
    0x05,0x8c, 0x9c,
    0x05,0x8d, 0x60,
    0x05,0x8f, 0x40,
    0x05,0x90, 0x9c,
    0x05,0x91, 0xa3,
    0x05,0x92, 0xff,
    0x05,0x93, 0xc0,
    0x05,0x94, 0xbc,
    0x05,0x95, 0x45,
    0x05,0x97, 0x1a,
    0x05,0x98, 0x10,
    0x05,0x9b, 0x05,
    0x05,0x9c, 0x9c,
    0x05,0x9d, 0xa3,
    0x05,0x9e, 0xff,
    0x05,0x9f, 0xa5,
    0x05,0xa0, 0xa5,
    0x05,0xa1, 0x43,
    0x05,0xa2, 0xff,
    0x05,0xa3, 0xfe,
    0x05,0xa7, 0x48,
    0x05,0xa8, 0x9d,
    0x05,0xa9, 0x80,
    0x05,0xac, 0xbc,
    0x05,0xad, 0x45,
    0x05,0xaf, 0x24,
    0x05,0xb0, 0x10,
    0x05,0xb3, 0x09,
    0x05,0xb4, 0x9c,
    0x05,0xb5, 0x83,
    0x05,0xb6, 0xff,
    0x05,0xb7, 0x80,
    0x05,0xb8, 0xb8,
    0x05,0xb9, 0x63,
    0x05,0xbb, 0x06,
    0x05,0xbc, 0x9c,
    0x05,0xbd, 0x80,
    0x05,0xbf, 0x5b,
    0x05,0xc0, 0x9d,
    0x05,0xc1, 0x80,
    0x05,0xc3, 0x01,
    0x05,0xc4, 0x07,
    0x05,0xc5, 0xfb,
    0x05,0xc6, 0x1c,
    0x05,0xc7, 0x7a,
    0x05,0xc8, 0x15,
    0x05,0xcf, 0x3e,
    0x05,0xd0, 0xa5,
    0x05,0xd1, 0x4b,
    0x05,0xd2, 0xff,
    0x05,0xd3, 0xff,
    0x05,0xd4, 0xbc,
    0x05,0xd5, 0x44,
    0x05,0xd7, 0x35,
    0x05,0xd8, 0x0c,
    0x05,0xdb, 0x09,
    0x05,0xdc, 0x9d,
    0x05,0xdd, 0x80,
    0x05,0xdf, 0x02,
    0x05,0xe0, 0x9c,
    0x05,0xe1, 0x83,
    0x05,0xe2, 0xff,
    0x05,0xe3, 0x4a,
    0x05,0xe4, 0xbc,
    0x05,0xe5, 0x44,
    0x05,0xe7, 0x4b,
    0x05,0xe8, 0x10,
    0x05,0xeb, 0x08,
    0x05,0xec, 0x9c,
    0x05,0xed, 0x80,
    0x05,0xef, 0xb6,
    0x05,0xf0, 0xb8,
    0x05,0xf1, 0x63,
    0x05,0xf3, 0x06,
    0x05,0xf4, 0x03,
    0x05,0xf5, 0xff,
    0x05,0xf6, 0xff,
    0x05,0xf7, 0xf4,
    0x05,0xf8, 0x9d,
    0x05,0xf9, 0x80,
    0x05,0xfb, 0x03,
    0x05,0xfc, 0xb8,
    0x05,0xfd, 0x63,
    0x05,0xff, 0x0f,
    0x06,0x03, 0x31,
    0x06,0x04, 0xb9,
    0x06,0x05, 0x43,
    0x06,0x07, 0x50,
    0x06,0x08, 0x9c,
    0x06,0x09, 0x83,
    0x06,0x0a, 0xfe,
    0x06,0x0b, 0xfe,
    0x06,0x0c, 0xbc,
    0x06,0x0d, 0x44,
    0x06,0x0f, 0x6e,
    0x06,0x10, 0x0c,
    0x06,0x13, 0x09,
    0x06,0x14, 0x9c,
    0x06,0x15, 0x80,
    0x06,0x16, 0x01,
    0x06,0x17, 0x02,
    0x06,0x18, 0x9c,
    0x06,0x19, 0x83,
    0x06,0x1a, 0xfe,
    0x06,0x1b, 0x8f,
    0x06,0x1c, 0xbc,
    0x06,0x1d, 0x44,
    0x06,0x1f, 0x92,
    0x06,0x20, 0x10,
    0x06,0x23, 0x08,
    0x06,0x24, 0x9c,
    0x06,0x25, 0x80,
    0x06,0x26, 0x01,
    0x06,0x27, 0x71,
    0x06,0x28, 0xb8,
    0x06,0x29, 0x63,
    0x06,0x2b, 0x06,
    0x06,0x2c, 0x03,
    0x06,0x2d, 0xff,
    0x06,0x2e, 0xff,
    0x06,0x2f, 0xe6,
    0x06,0x30, 0x9d,
    0x06,0x31, 0x80,
    0x06,0x33, 0x05,
    0x06,0x34, 0xb8,
    0x06,0x35, 0x63,
    0x06,0x37, 0x06,
    0x06,0x38, 0x03,
    0x06,0x39, 0xff,
    0x06,0x3a, 0xff,
    0x06,0x3b, 0xe3,
    0x06,0x3c, 0x9d,
    0x06,0x3d, 0x80,
    0x06,0x3f, 0x04,
    0x06,0x40, 0x9c,
    0x06,0x41, 0x83,
    0x06,0x42, 0xfd,
    0x06,0x43, 0xfc,
    0x06,0x44, 0xbc,
    0x06,0x45, 0x44,
    0x06,0x47, 0xdd,
    0x06,0x48, 0x10,
    0x06,0x4b, 0x05,
    0x06,0x4c, 0x9c,
    0x06,0x4d, 0x80,
    0x06,0x4e, 0x02,
    0x06,0x4f, 0x04,
    0x06,0x50, 0xb8,
    0x06,0x51, 0x63,
    0x06,0x53, 0x06,
    0x06,0x54, 0x03,
    0x06,0x55, 0xff,
    0x06,0x56, 0xff,
    0x06,0x57, 0xdc,
    0x06,0x58, 0x9d,
    0x06,0x59, 0x80,
    0x06,0x5b, 0x06,
    0x06,0x5c, 0x9c,
    0x06,0x5d, 0x83,
    0x06,0x5e, 0xfd,
    0x06,0x5f, 0x1e,
    0x06,0x60, 0xbc,
    0x06,0x61, 0x44,
    0x06,0x62, 0x01,
    0x06,0x63, 0x25,
    0x06,0x64, 0x10,
    0x06,0x67, 0x05,
    0x06,0x68, 0x9c,
    0x06,0x69, 0x80,
    0x06,0x6a, 0x02,
    0x06,0x6b, 0xe2,
    0x06,0x6c, 0xb8,
    0x06,0x6d, 0x63,
    0x06,0x6f, 0x06,
    0x06,0x70, 0x03,
    0x06,0x71, 0xff,
    0x06,0x72, 0xff,
    0x06,0x73, 0xd5,
    0x06,0x74, 0x9d,
    0x06,0x75, 0x80,
    0x06,0x77, 0x07,
    0x06,0x78, 0x9c,
    0x06,0x79, 0x83,
    0x06,0x7a, 0xfb,
    0x06,0x7b, 0xf8,
    0x06,0x7c, 0xbc,
    0x06,0x7d, 0x44,
    0x06,0x7e, 0x01,
    0x06,0x7f, 0xca,
    0x06,0x80, 0x10,
    0x06,0x83, 0x05,
    0x06,0x84, 0x9c,
    0x06,0x85, 0x80,
    0x06,0x86, 0x04,
    0x06,0x87, 0x08,
    0x06,0x88, 0xb8,
    0x06,0x89, 0x63,
    0x06,0x8b, 0x06,
    0x06,0x8c, 0x03,
    0x06,0x8d, 0xff,
    0x06,0x8e, 0xff,
    0x06,0x8f, 0xce,
    0x06,0x90, 0x9d,
    0x06,0x91, 0x80,
    0x06,0x93, 0x08,
    0x06,0x94, 0x9c,
    0x06,0x95, 0x83,
    0x06,0x96, 0xfa,
    0x06,0x97, 0x2d,
    0x06,0x98, 0xbc,
    0x06,0x99, 0x44,
    0x06,0x9a, 0x02,
    0x06,0x9b, 0x50,
    0x06,0x9c, 0x10,
    0x06,0x9f, 0x06,
    0x06,0xa0, 0x15,
    0x06,0xa4, 0xb8,
    0x06,0xa5, 0x63,
    0x06,0xa7, 0x06,
    0x06,0xa8, 0x9c,
    0x06,0xa9, 0x80,
    0x06,0xaa, 0x05,
    0x06,0xab, 0xd3,
    0x06,0xac, 0x03,
    0x06,0xad, 0xff,
    0x06,0xae, 0xff,
    0x06,0xaf, 0xc6,
    0x06,0xb0, 0x9d,
    0x06,0xb1, 0x80,
    0x06,0xb3, 0x09,
    0x06,0xb4, 0xb8,
    0x06,0xb5, 0x63,
    0x06,0xb7, 0x06,
    0x06,0xb8, 0x9c,
    0x06,0xb9, 0x80,
    0x06,0xba, 0x08,
    0x06,0xbb, 0x24,
    0x06,0xbc, 0x03,
    0x06,0xbd, 0xff,
    0x06,0xbe, 0xff,
    0x06,0xbf, 0xc2,
    0x06,0xc0, 0x9d,
    0x06,0xc1, 0x80,
    0x06,0xc3, 0x0a,
    0x06,0xc4, 0x84,
    0x06,0xc5, 0x6e,
    0x06,0xc8, 0x18,
    0x06,0xc9, 0x80,
    0x06,0xcb, 0x14,
    0x06,0xcc, 0xa8,
    0x06,0xcd, 0x84,
    0x06,0xce, 0x11,
    0x06,0xcf, 0x0c,
    0x06,0xd0, 0x8c,
    0x06,0xd1, 0xa3,
    0x06,0xd3, 0x8b,
    0x06,0xd4, 0x8c,
    0x06,0xd5, 0x84,
    0x06,0xd8, 0x07,
    0x06,0xd9, 0xfb,
    0x06,0xda, 0x19,
    0x06,0xdb, 0x5f,
    0x06,0xdc, 0x9c,
    0x06,0xdd, 0x60,
    0x06,0xdf, 0xfe,
    0x06,0xe0, 0x84,
    0x06,0xe1, 0x6e,
    0x06,0xe4, 0xa8,
    0x06,0xe5, 0x8c,
    0x06,0xe8, 0x8c,
    0x06,0xe9, 0xa3,
    0x06,0xeb, 0x8b,
    0x06,0xec, 0x07,
    0x06,0xed, 0xfb,
    0x06,0xee, 0x19,
    0x06,0xef, 0x5a,
    0x06,0xf0, 0x94,
    0x06,0xf1, 0x63,
    0x06,0xf3, 0xb0,
    0x06,0xf4, 0x84,
    0x06,0xf5, 0x6e,
    0x06,0xf8, 0xb8,
    0x06,0xf9, 0x8a,
    0x06,0xfb, 0x46,
    0x06,0xfc, 0x8c,
    0x06,0xfd, 0xa3,
    0x06,0xff, 0x8b,
    0x07,0x00, 0x07,
    0x07,0x01, 0xfb,
    0x07,0x02, 0x19,
    0x07,0x03, 0x55,
    0x07,0x04, 0x94,
    0x07,0x05, 0x63,
    0x07,0x07, 0xb2,
    0x07,0x08, 0xb8,
    0x07,0x09, 0x6a,
    0x07,0x0b, 0x02,
    0x07,0x0c, 0x84,
    0x07,0x0d, 0xce,
    0x07,0x10, 0xa4,
    0x07,0x11, 0x83,
    0x07,0x13, 0xfc,
    0x07,0x14, 0x8c,
    0x07,0x15, 0xa6,
    0x07,0x17, 0x8b,
    0x07,0x18, 0x07,
    0x07,0x19, 0xfb,
    0x07,0x1a, 0x19,
    0x07,0x1b, 0x4f,
    0x07,0x1c, 0x94,
    0x07,0x1d, 0x66,
    0x07,0x1f, 0xb4,
    0x07,0x20, 0x84,
    0x07,0x21, 0x6e,
    0x07,0x24, 0x18,
    0x07,0x25, 0x80,
    0x07,0x27, 0x14,
    0x07,0x28, 0xa8,
    0x07,0x29, 0x84,
    0x07,0x2a, 0x11,
    0x07,0x2b, 0x0d,
    0x07,0x2c, 0x8c,
    0x07,0x2d, 0xa3,
    0x07,0x2f, 0x8b,
    0x07,0x30, 0x8c,
    0x07,0x31, 0x84,
    0x07,0x34, 0x07,
    0x07,0x35, 0xfb,
    0x07,0x36, 0x19,
    0x07,0x37, 0x48,
    0x07,0x38, 0x9c,
    0x07,0x39, 0x60,
    0x07,0x3b, 0xfe,
    0x07,0x3c, 0x85,
    0x07,0x3d, 0x21,
    0x07,0x40, 0x85,
    0x07,0x41, 0x41,
    0x07,0x43, 0x04,
    0x07,0x44, 0x85,
    0x07,0x45, 0x81,
    0x07,0x47, 0x08,
    0x07,0x48, 0x85,
    0x07,0x49, 0xc1,
    0x07,0x4b, 0x0c,
    0x07,0x4c, 0x44,
    0x07,0x4e, 0x48,
    0x07,0x50, 0x9c,
    0x07,0x51, 0x21,
    0x07,0x53, 0x10,
    0x07,0x54, 0x9c,
    0x07,0x55, 0x21,
    0x07,0x56, 0xff,
    0x07,0x57, 0xf4,
    0x07,0x58, 0xd4,
    0x07,0x59, 0x01,
    0x07,0x5a, 0x48,
    0x07,0x5c, 0xd4,
    0x07,0x5d, 0x01,
    0x07,0x5e, 0x50,
    0x07,0x5f, 0x04,
    0x07,0x60, 0xd4,
    0x07,0x61, 0x01,
    0x07,0x62, 0x60,
    0x07,0x63, 0x08,
    0x07,0x64, 0xbc,
    0x07,0x65, 0x03,
    0x07,0x66, 0x01,
    0x07,0x67, 0x0c,
    0x07,0x68, 0x10,
    0x07,0x6b, 0x15,
    0x07,0x6c, 0xbc,
    0x07,0x6d, 0x43,
    0x07,0x6e, 0x01,
    0x07,0x6f, 0x0c,
    0x07,0x70, 0x0c,
    0x07,0x73, 0x0b,
    0x07,0x74, 0xbc,
    0x07,0x75, 0x03,
    0x07,0x76, 0x01,
    0x07,0x77, 0x05,
    0x07,0x78, 0xbc,
    0x07,0x79, 0x03,
    0x07,0x7a, 0x01,
    0x07,0x7b, 0x10,
    0x07,0x7c, 0x10,
    0x07,0x7f, 0x16,
    0x07,0x80, 0xbc,
    0x07,0x81, 0x03,
    0x07,0x82, 0x04,
    0x07,0x83, 0x0c,
    0x07,0x84, 0x19,
    0x07,0x85, 0x80,
    0x07,0x87, 0x14,
    0x07,0x88, 0xa9,
    0x07,0x89, 0x8c,
    0x07,0x8a, 0x03,
    0x07,0x8b, 0x18,
    0x07,0x8c, 0x0c,
    0x07,0x8f, 0x29,
    0x07,0x90, 0x15,
    0x07,0x97, 0x25,
    0x07,0x98, 0x15,
    0x07,0x9c, 0x19,
    0x07,0x9d, 0x80,
    0x07,0x9f, 0x14,
    0x07,0xa0, 0xa9,
    0x07,0xa1, 0x8c,
    0x07,0xa2, 0x03,
    0x07,0xa3, 0x18,
    0x07,0xa4, 0x0c,
    0x07,0xa7, 0x23,
    0x07,0xa8, 0x15,
    0x07,0xac, 0x07,
    0x07,0xad, 0xff,
    0x07,0xae, 0xff,
    0x07,0xaf, 0x0a,
    0x07,0xb0, 0x15,
    0x07,0xb7, 0x20,
    0x07,0xb8, 0x84,
    0x07,0xb9, 0x6c,
    0x07,0xbc, 0x19,
    0x07,0xbd, 0x80,
    0x07,0xbf, 0x14,
    0x07,0xc0, 0xa9,
    0x07,0xc1, 0x8c,
    0x07,0xc2, 0x03,
    0x07,0xc3, 0x18,
    0x07,0xc4, 0x07,
    0x07,0xc5, 0xff,
    0x07,0xc6, 0xff,
    0x07,0xc7, 0x57,
    0x07,0xc8, 0x15,
    0x07,0xcf, 0x1a,
    0x07,0xd0, 0x84,
    0x07,0xd1, 0x6c,
    0x07,0xd4, 0x18,
    0x07,0xd5, 0x60,
    0x07,0xd7, 0x14,
    0x07,0xd8, 0xa8,
    0x07,0xd9, 0x63,
    0x07,0xda, 0x02,
    0x07,0xdb, 0xb0,
    0x07,0xdc, 0x19,
    0x07,0xdd, 0x40,
    0x07,0xdf, 0x14,
    0x07,0xe0, 0xa9,
    0x07,0xe1, 0x4a,
    0x07,0xe2, 0x02,
    0x07,0xe3, 0xf8,
    0x07,0xe4, 0x84,
    0x07,0xe5, 0x83,
    0x07,0xe8, 0x84,
    0x07,0xe9, 0xaa,
    0x07,0xec, 0x94,
    0x07,0xed, 0x64,
    0x07,0xef, 0x7e,
    0x07,0xf0, 0xe4,
    0x07,0xf1, 0xa3,
    0x07,0xf2, 0x28,
    0x07,0xf4, 0x10,
    0x07,0xf7, 0x04,
    0x07,0xf8, 0x15,
    0x07,0xfc, 0x9c,
    0x07,0xfd, 0x60,
    0x07,0xff, 0x04,
    0x08,0x00, 0xd8,
    0x08,0x01, 0x04,
    0x08,0x02, 0x18,
    0x08,0x03, 0xd7,
    0x08,0x04, 0x19,
    0x08,0x05, 0x80,
    0x08,0x07, 0x14,
    0x08,0x08, 0xa9,
    0x08,0x09, 0x8c,
    0x08,0x0a, 0x03,
    0x08,0x0b, 0x18,
    0x08,0x0c, 0x84,
    0x08,0x0d, 0x6c,
    0x08,0x10, 0x07,
    0x08,0x11, 0xfb,
    0x08,0x12, 0x05,
    0x08,0x13, 0x86,
    0x08,0x14, 0x84,
    0x08,0x15, 0x63,
    0x08,0x16, 0x01,
    0x08,0x17, 0xc0,
    0x08,0x18, 0x9c,
    0x08,0x19, 0x80,
    0x08,0x1a, 0xff,
    0x08,0x1b, 0xf0,
    0x08,0x1c, 0xe1,
    0x08,0x1d, 0x6b,
    0x08,0x1e, 0x20,
    0x08,0x1f, 0x03,
    0x08,0x23, 0x04,
    0x08,0x24, 0xd4,
    0x08,0x25, 0x0a,
    0x08,0x26, 0x58,
    0x08,0x28, 0x07,
    0x08,0x29, 0xff,
    0x08,0x2a, 0xff,
    0x08,0x2b, 0x4c,
    0x08,0x2c, 0x15,
    0x08,0x30, 0x84,
    0x08,0x31, 0x6c,
    0x08,0x34, 0x9d,
    0x08,0x35, 0x60,
    0x08,0x38, 0xd4,
    0x08,0x39, 0x03,
    0x08,0x3a, 0x59,
    0x08,0x3b, 0xcc,
    0x08,0x3c, 0xd4,
    0x08,0x3d, 0x03,
    0x08,0x3e, 0x59,
    0x08,0x3f, 0xc0,
    0x08,0x40, 0xd4,
    0x08,0x41, 0x03,
    0x08,0x42, 0x59,
    0x08,0x43, 0xc4,
    0x08,0x44, 0xd4,
    0x08,0x45, 0x03,
    0x08,0x46, 0x59,
    0x08,0x47, 0xc8,
    0x08,0x48, 0x85,
    0x08,0x49, 0x21,
    0x08,0x4c, 0x85,
    0x08,0x4d, 0x41,
    0x08,0x4f, 0x04,
    0x08,0x50, 0x85,
    0x08,0x51, 0x81,
    0x08,0x53, 0x08,
    0x08,0x54, 0x44,
    0x08,0x56, 0x48,
    0x08,0x58, 0x9c,
    0x08,0x59, 0x21,
    0x08,0x5b, 0x0c,
    0xff,0xfe, 0x50,
    0x01,0x37, 0x99,
    0xff,0xfe, 0x14,
    0x11,0x0d, 0x00,
    0x11,0x0d, 0x00,
    0x11,0x0c, 0x01,
    0xff,0xfe, 0x30,
    0x00,0x6c, 0x00,
    0x18,0x00, 0x10,
    0x14,0x50, 0x6e,
    0x14,0x51, 0x00,
    0x14,0x52, 0x6e,
    0x14,0x53, 0x4e,	
    0xff,0xfe, 0x14,
    0xff,0xfe, 0x14,
    0x00,0x26, 0x01,
    0x00,0xbe, 0x42,  	//camera i2c id  未修改
    0x00,0xbf, 0x00,  	//camera i2c bits     
    0x00,0xc0, 0x05,  	//sensor type gain
    0x00,0xc1, 0x02,  	//sensor type exposure
    0x00,0x77, 0x30,       //[7:0]finally_thr; 最终稳定区间    
    0x00,0x7a, 0x00,       //[15:8] thr_l;
    0x00,0x7b, 0x60,       //[7:0] thr_l;
    0x00,0x76, 0x03,       //[7:0] nDelayFrame; 多帧处理区间延时帧数
    0x00,0x7c, 0x00,       //[15:8] thr_h; 
    0x00,0x7d, 0x80,       //[7:0] thr_h; 
    0x01,0x10, 0x00,  //gain delay frame
    0xff,0xfe, 0x30,
    0x00,0x51, 0x03,
    0xff,0xfe, 0x30,  //AVG  
    0x1f,0x00, 0x00,         
    0x1f,0x01, 0x00,         
    0x1f,0x02, 0x00,         
    0x1f,0x03, 0x00,         
    0x1f,0x04, 0x05,         
    0x1f,0x05, 0x00,         
    0x1f,0x06, 0x02,         
    0x1f,0x07, 0xd0,         
    0x1f,0x08, 0x03, 
    0xff,0xfe, 0x14,
    0x00,0x3f, 0x10,
    0x00,0x40, 0x10,
    0x00,0x41, 0x10,
    0x00,0x42, 0x10,
    0x00,0x43, 0x10,
    0x00,0x44, 0x10,
    0x00,0x45, 0x10,
    0x00,0x46, 0x10,
    0x00,0x47, 0x10,
    0x00,0x48, 0x10,
    0x00,0x49, 0x10,
    0x00,0x4a, 0x10,
    0x00,0x4b, 0x10,
    0x00,0x4c, 0x10,
    0x00,0x4d, 0x10,
    0x00,0x4e, 0x10,
    0x00,0x4f, 0x10,
    0x00,0x50, 0x10,
    0x00,0x51, 0x10,
    0x00,0x52, 0x10,
    0x00,0x53, 0x10,
    0x00,0x54, 0x10,
    0x00,0x55, 0x10,
    0x00,0x56, 0x10,
    0x00,0x57, 0x10,
    0x00,0x3a, 0x01,
    0xff,0xfe, 0x14,  
    0x00,0x6c, 0x01,   
    0x00,0x6d, 0xb0,   
    0x00,0xaa, 0x03,
    0x00,0xab, 0xff,
    0x00,0xac, 0x00,
    0x00,0xad, 0x35,//mingain
    0x00,0x92, 0x2d,
    0x00,0x93, 0x00,//max expo
    0x00,0xb4, 0x02,//banding
    0x00,0xb8, 0x21,
    0x00,0xb9, 0x80,
    0xff,0xfe, 0x50,
    0x00,0x30, 0x05,
    0x00,0x31, 0x02,
    0x00,0x32, 0x06,
    0x00,0x20, 0x01,
    0x00,0x21, 0x0E,
    0x00,0x23, 0x42,
    0x00,0x24, 0x03,
    0x00,0x25, 0x06,
    0x00,0x26, 0x01,
    0x00,0x27, 0x06,
    0x00,0x28, 0x08,
    0x00,0x29, 0x06,
    0xff,0xfe, 0x14,
    0xff,0xfe, 0x14,
    0x00,0x27, 0x01,
    0x01,0x3c, 0x02,
    0x01,0x76, 0x06,
    0x01,0x77, 0x00,
    0x01,0x7a, 0x04,
    0x01,0x7b, 0x00,
    0x01,0x7e, 0x04,
    0x01,0x7f, 0x00,
    0x01,0x82, 0x04,
    0x01,0x83, 0x04,
    0x01,0xaa, 0x06,
    0x01,0xab, 0x00,
    0x01,0xae, 0x04,
    0x01,0xaf, 0x00,
    0x01,0xb2, 0x04,
    0x01,0xb3, 0x04,
    0xff,0xfe, 0x14,
    0x00,0x27, 0x01,
    0x01,0x3c, 0x01,
    0x01,0x3d, 0x01,
    0x01,0x3e, 0x00,
    0x01,0x70, 0x0f,
    0x01,0x71, 0xff,
    0xff,0xfe, 0x30,
    0x07,0x08, 0x03,
    0x07,0x09, 0xf0,
    0x07,0x0a, 0x00,
    0x07,0x0b, 0x0c,
    0x00,0x51, 0x03,
    0x00,0x96, 0x83,
    0x00,0x19, 0x48,
    0x07,0x1c, 0x1a,
    0xff,0xfe, 0x14,
    0x01,0x6e, 0x08,
    0xff,0xfd, 0x80,
    0xff,0xfe, 0x30,
    0x00,0x00, 0xcf,
    0x00,0x01, 0x83,
    0x00,0x03, 0xe5,
    0x07,0x30, 0x73,
    0x07,0x31, 0x9f,
    0x07,0x32, 0x42,
    0x07,0x33, 0x52,
    0x07,0x34, 0x60,
    0x07,0x35, 0x9a,
    0x07,0x36, 0x48,
    0x07,0x37, 0x68,
    0x07,0x38, 0x4c,
    0x07,0x39, 0x76,
    0x07,0x3a, 0x60,
    0x07,0x3b, 0x96,
    0x07,0x3c, 0x72,
    0x07,0x3d, 0xaf,
    0x07,0x3e, 0x64,
    0x07,0x3f, 0x90,
    0x07,0x40, 0x00,
    0x07,0x41, 0x00,
    0x07,0x42, 0x00,
    0x07,0x43, 0x00,
    0x07,0x44, 0x00,
    0x07,0x45, 0x00,
    0x07,0x46, 0x00,
    0x07,0x47, 0x00,
    0x07,0x48, 0x00,
    0x07,0x49, 0x00,
    0x07,0x4a, 0x00,
    0x07,0x4b, 0x00,
    0x07,0x4c, 0x00,
    0x07,0x4d, 0x00,
    0x07,0x4e, 0x00,
    0x07,0x4f, 0x00,
    0x07,0x50, 0x00,
    0x07,0x51, 0x00,
    0x07,0x52, 0x00,
    0x07,0x53, 0x00,
    0x07,0x54, 0x00,
    0x07,0x55, 0x00,
    0x07,0x56, 0x00,
    0x07,0x57, 0x00,
    0x07,0x58, 0x00,
    0x07,0x59, 0x00,
    0x07,0x5a, 0x00,
    0x07,0x5b, 0x00,
    0x07,0x5c, 0x00,
    0x07,0x5d, 0x00,
    0x07,0x5e, 0x00,
    0x07,0x5f, 0x00,
    0x07,0x60, 0x00,
    0x07,0x61, 0x00,
    0x07,0x62, 0x00,
    0x07,0x63, 0x00,
    0x07,0x64, 0x00,
    0x07,0x65, 0x00,
    0x07,0x66, 0x00,
    0x07,0x67, 0x00,
    0x07,0x68, 0x00,
    0x07,0x69, 0x00,
    0x07,0x6a, 0x00,
    0x07,0x6b, 0x00,
    0x07,0x6c, 0x00,
    0x07,0x6d, 0x00,
    0x07,0x6e, 0x00,
    0x07,0x6f, 0x00,
    0x07,0x70, 0x22,
    0x07,0x71, 0x21,
    0x07,0x72, 0x00,
    0x07,0x73, 0x00,
    0x07,0x74, 0x00,
    0x07,0x75, 0x00,
    0x07,0x76, 0x00,
    0x07,0x77, 0x00,
    0xff,0xfe, 0x14,
    0x00,0x27, 0x01,
    0xff,0xfd, 0x80,
    0xff,0xfe, 0x30,
    0x14,0x00, 0x00,
    0x14,0x01, 0x05,
    0x14,0x02, 0x0a,
    0x14,0x03, 0x0f,
    0x14,0x04, 0x15,
    0x14,0x05, 0x1a,
    0x14,0x06, 0x1f,
    0x14,0x07, 0x24,
    0x14,0x08, 0x29,
    0x14,0x09, 0x2e,
    0x14,0x0a, 0x32,
    0x14,0x0b, 0x37,
    0x14,0x0c, 0x3c,
    0x14,0x0d, 0x40,
    0x14,0x0e, 0x45,
    0x14,0x0f, 0x49,
    0x14,0x10, 0x4e,
    0x14,0x11, 0x52,
    0x14,0x12, 0x56,
    0x14,0x13, 0x5a,
    0x14,0x14, 0x5e,
    0x14,0x15, 0x62,
    0x14,0x16, 0x65,
    0x14,0x17, 0x69,
    0x14,0x18, 0x6c,
    0x14,0x19, 0x6f,
    0x14,0x1a, 0x73,
    0x14,0x1b, 0x76,
    0x14,0x1c, 0x79,
    0x14,0x1d, 0x7c,
    0x14,0x1e, 0x7e,
    0x14,0x1f, 0x81,
    0x14,0x20, 0x84,
    0x14,0x21, 0x89,
    0x14,0x22, 0x8d,
    0x14,0x23, 0x92,
    0x14,0x24, 0x96,
    0x14,0x25, 0x9a,
    0x14,0x26, 0x9d,
    0x14,0x27, 0xa1,
    0x14,0x28, 0xa4,
    0x14,0x29, 0xa7,
    0x14,0x2a, 0xaa,
    0x14,0x2b, 0xad,
    0x14,0x2c, 0xaf,
    0x14,0x2d, 0xb2,
    0x14,0x2e, 0xb4,
    0x14,0x2f, 0xb6,
    0x14,0x30, 0xb8,
    0x14,0x31, 0xbc,
    0x14,0x32, 0xc0,
    0x14,0x33, 0xc4,
    0x14,0x34, 0xc8,
    0x14,0x35, 0xcc,
    0x14,0x36, 0xd0,
    0x14,0x37, 0xd4,
    0x14,0x38, 0xd8,
    0x14,0x39, 0xdd,
    0x14,0x3a, 0xe1,
    0x14,0x3b, 0xe6,
    0x14,0x3c, 0xeb,
    0x14,0x3d, 0xf0,
    0x14,0x3e, 0xf5,
    0x14,0x3f, 0xfa,
    0x14,0x40, 0xff,
    0xff,0xfe, 0x30,
    0x12,0x00, 0x07,	
    0x12,0x01, 0x76,
    0x12,0x02, 0x00,	
    0x12,0x03, 0x40,
    0x12,0x04, 0x02,	
    0x12,0x05, 0x69,
    0x12,0x06, 0x01,	
    0x12,0x07, 0xFF,
    0x12,0x08, 0x01,	
    0x12,0x09, 0x06,	
    0x12,0x0A, 0x00,	
    0x12,0x0B, 0xA8,
    0x12,0x0C, 0x0A,	
    0x12,0x0D, 0xE7,
    0x12,0x0E, 0x00,	
    0x12,0x0F, 0xF1,
    0x12,0x10, 0x01,	
    0x12,0x11, 0x2F,
    0x12,0x12, 0x02,	
    0x12,0x13, 0xEF,
    0x12,0x14, 0x01,	
    0x12,0x15, 0xFC,
    0x12,0x16, 0x01,	
    0x12,0x17, 0x66,
    0x12,0x18, 0x07,	
    0x12,0x19, 0xEB,
    0x12,0x1A, 0x01,	
    0x12,0x1B, 0x6C,
    0x12,0x1C, 0x01,	
    0x12,0x1D, 0xBC,
    0x12,0x1E, 0x03,	
    0x12,0x1F, 0xFF,
    0x12,0x20, 0x01,	
    0x12,0x21, 0xFF,
    0x12,0x22, 0x05,	
    0x12,0x23, 0x10,
    0x12,0x2e, 0x02,	
    0x12,0x2F, 0x01,	
    0x12,0x30, 0x02,	
    0x12,0x28, 0x00,	
    0x12,0x29, 0x58,
    0x12,0x2A, 0x00,	
    0x12,0x2B, 0x96,
    0x12,0x2C, 0x00,	
    0x12,0x2D, 0xEC,
    0xff,0xfe, 0x30,
    0x12,0x31, 0x02,
    0xff,0xfe, 0x30,
    0x20,0x00, 0x3f,
    0x20,0x01, 0x08,
    0x20,0x02, 0x07,
    0x20,0x03, 0x02,
    0x20,0x04, 0x01,
    0x20,0x05, 0x01,
    0x20,0x06, 0x02,
    0x20,0x07, 0x03,
    0x20,0x08, 0x04,
    0x20,0x09, 0x05,
    0x20,0x0a, 0x06,
    0x20,0x0b, 0x1f,
    0x19,0x07, 0xd2,
    0x19,0x08, 0x01,
    0xff,0xfe, 0x30,
    0x0e,0x00, 0x34,
    0x0e,0x01, 0x00,
    0x0e,0x02, 0x00,
    0x0e,0x03, 0x10,
    0x0e,0x04, 0x30,
    0x0e,0x05, 0x30,
    0x0e,0x06, 0x68,
    0x0e,0x07, 0x68,
    0x0e,0x08, 0xa0,
    0x0e,0x09, 0x3f,
    0x0e,0x0a, 0x04,
    0x0e,0x0b, 0x00,
    0xff,0xfe, 0x30,
    0x13,0x0e, 0x08,
    0x13,0x0f, 0x08,
    0xff,0xfe, 0x30,
    0x0f,0x00, 0x00,
    0x0f,0x01, 0x00,
    0x0f,0x02, 0x00,
    0x0f,0x03, 0x00,
    0x0f,0x04, 0x00,
    0x0f,0x05, 0x00,
    0x0f,0x06, 0x00,
    0x0f,0x07, 0x00,
    0x0f,0x08, 0x00,
    0x0f,0x09, 0x00,
    0x0f,0x0a, 0x01,
    0x0f,0x0b, 0x01,
    0x0f,0x0c, 0x00,
    0x0f,0x0d, 0x00,
    0x0f,0x0e, 0x01,
    0x0f,0x0f, 0x0f,
    0xff,0xfe, 0x14,
    0x01,0x60, 0x00,
    0x01,0x62, 0x40,
    0x01,0x63, 0x38,
    0x01,0x64, 0x30,
    0x01,0x65, 0x2c,
    0x01,0x66, 0x28,
    0x01,0x67, 0x24,
    0x01,0x68, 0x44,
    0x01,0x69, 0x3c,
    0x01,0x6a, 0x34,
    0x01,0x6b, 0x30,
    0x01,0x6c, 0x2c,
    0x01,0x6d, 0x28,
    0xff,0xfe, 0x14,
    0x01,0x60, 0x00,
    0xff,0xfe, 0x30,
    0x00,0x00, 0x4f,
    0x00,0x01, 0x87,
    0x00,0x03, 0xe5,
    0x00,0x13, 0x08,
    0x07,0x1c, 0x0a,
    0x17,0x00, 0x09,
    0x17,0x01, 0xa8,
    0x17,0x02, 0xb0,
    0x17,0x04, 0x22,
    0xff,0xfe, 0x14,
    0x00,0x27, 0x01,
    0xff,0xfe, 0x30,
    0x00,0x00, 0x4f,
    0x13,0x0e, 0x08,
    0x13,0x0f, 0x00,
    0x0e,0x00, 0x34, 
    0x0e,0x0a, 0x00, 
    0x0e,0x0b, 0xff, 
    0x20,0x00, 0x3f,
    0x20,0x01, 0x12,
    0x14,0x51, 0x78,
    0x14,0x52, 0x70,
    0x14,0x53, 0xff,
    0x17,0x01, 0x48,
    0x17,0x02, 0x48,
    0x17,0x04, 0x22,


	//bypass on
	0xff,0xfd, 0x80,
	0xff,0xfe, 0x50,
	0x00,0x4d, 0x01,


	-1,-1,-1,
};


SENSOR_INIT_SECTION static const unsigned char gc1054_7011_Init_regs[] = {			  
	0xf2, 0x00,
	 0xf6, 0x00,
	 0xfc, 0x04,
	 0xf7, 0x01,
	 0xf8, 0x0b,
	 0xf9, 0x00,
	 0xfa, 0x80,
	 0xfc, 0x0e,
	 0xfe, 0x00,
	 0x03, 0x02,
	 0x04, 0xa3,
	 0x05, 0x01,
	 0x06, 0xcf,
	 0x07, 0x00,
	 0x08, 0x06,
	 0x09, 0x00,
	 0x0a, 0x04,
	 0x0b, 0x00,
	 0x0c, 0x00,
	 0x0d, 0x02,
	 0x0e, 0xd4,
	 0x0f, 0x05,
	 0x10, 0x08,
	 0x17, 0xc0,
	 0x18, 0x02,
	 0x19, 0x08,
	 0x1a, 0x18,
	 0x1e, 0x50,
	 0x1f, 0x80,
	 0x21, 0x30,
	 0x23, 0xf8,
	 0x25, 0x10,
	 0x28, 0x20,
	 0x34, 0x08,
	 0x3c, 0x10,
	 0x3d, 0x0e,
	 0xcc, 0x8e,
	 0xcd, 0x9a,
	 0xcf, 0x70,
	 0xd0, 0xab,
	 0xd1, 0xc5,
	 0xd2, 0xed,
	 0xd8, 0x3c,
	 0xd9, 0x7a,
	 0xda, 0x12,
	 0xdb, 0x50,
	 0xde, 0x0c,
	 0xe3, 0x60,
	 0xe4, 0x78,
	 0xfe, 0x01,
	 0xe3, 0x01,
	 0xe6, 0x10,
	 0xfe, 0x01,
	 0x80, 0x50,
	 0x88, 0x23,
	 0x89, 0x03,
	 0x90, 0x01,
	 0x92, 0x01,
	 0x94, 0x02,
	 0x95, 0x02,
	 0x96, 0xd0,
	 0x97, 0x05,
	 0x98, 0x00,
	 0xfe, 0x01,
	 0x40, 0x22,
	 0x43, 0x03,
	 0x4e, 0x3c,
	 0x4f, 0x00,
	 0x60, 0x00,
	 0x61, 0x80,
	 0xfe, 0x01,
	 0xb0, 0x48,
	 0xb1, 0x01,
	 0xb2, 0x00,
	 0xb6, 0x00,
	 0xfe, 0x02,
	 0x01, 0x00,
	 0x02, 0x01,
	 0x03, 0x02,
	 0x04, 0x03,
	 0x05, 0x04,
	 0x06, 0x05,
	 0x07, 0x06,
	 0x08, 0x0e,
	 0x09, 0x16,
	 0x0a, 0x1e,
	 0x0b, 0x36,
	 0x0c, 0x3e,
	 0x0d, 0x56,
	 0xfe, 0x02,
	 0xb0, 0x00,
	 0xb1, 0x00,
	 0xb2, 0x00,
	 0xb3, 0x11,
	 0xb4, 0x22,
	 0xb5, 0x54,
	 0xb6, 0xb8,
	 0xb7, 0x60,
	 0xb9, 0x00,
	 0xba, 0xc0,
	 0xc0, 0x20,
	 0xc1, 0x2d,
	 0xc2, 0x40,
	 0xc3, 0x5b,
	 0xc4, 0x80,
	 0xc5, 0xb5,
	 0xc6, 0x00,
	 0xc7, 0x6a,
	 0xc8, 0x00,
	 0xc9, 0xd4,
	 0xca, 0x00,
	 0xcb, 0xa8,
	 0xcc, 0x00,
	 0xcd, 0x50,
	 0xce, 0x00,
	 0xcf, 0xa1,
	 0xfe, 0x02,
	 0x54, 0xf7,
	 0x55, 0xf0,
	 0x56, 0x00,
	 0x57, 0x00,
	 0x58, 0x00,
	 0x5a, 0x04,
	 0xfe, 0x04,
	 0x81, 0x8a,
	 0xfe, 0x03,
	 0x01, 0x00,
	 0x02, 0x00,
	 0x03, 0x00,
	 0x10, 0x11,
	 0x15, 0x00,
	 0x40, 0x01,
	 0x41, 0x00,
	 0xfe, 0x00,
	 0xf2, 0x0f,



	-1,-1,

};

SENSOR_OP_SECTION const _Sensor_Adpt_ xc7011_gc1054_cmd= 
{
	.typ = 1, //YUV
	.pixelw = 1280,
	.pixelh= 720,
	.hsyn = 1,
	.vsyn = 0,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)XC7011_IQ_InitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = {0x6a,0x12,0x6a,0x12},
	. mclk = 24000000,
	.p_fun_adapt    = {NULL,NULL,NULL},
	.p_xc7016_adapt = {XC7011_bypass_on,XC7011_bypass_off,gc1054_7011_Init_regs,0x54,0x42,0x43,0x01,0x01,0xf1},
};

const _Sensor_Ident_ xc7011_gc1054_init=
{
	0x70,0x36,0x37,0x02,0x01,0xfffb
};


#endif
