#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"

#if DEV_SENSOR_SP0A19




SENSOR_INIT_SECTION static const unsigned char SP0A19InitTable[CMOS_INIT_LEN]= 
{	

//SP0A19 ini
	  0xfd,0x00,
		  
	  0x32,0x00,
	  0x0f,0x2f,
	  0x10,0x2e,
	  0x11,0x00,
	  0x12,0x18,
	  0x13,0x2f,
	  0x14,0x00,
	  0x15,0x3f,
	  0x16,0x00,
	  0x17,0x18,
	  0x25,0x40,
	  0x1a,0x0b,

	  0x1e,0xb ,
	  0x20,0x3f, // add
	  0x21,0x13, // 0x0c 24
	  0x22,0x19,
	  0x26,0x1a,
	  0x27,0xab,
	  0x28,0xfd,
	  0x30,0x00,
	  0x31,0x00,//0x10
	  0xfb,0x33, // 0x33
	  0x1f,0x08,
		
	//Blacklevel
	  0xfd,0x00,
	  0x65,0x00,//blue_suboffset
	  0x66,0x00,//red_suboffset
	  0x67,0x00,//gr_suboffset
	  0x68,0x00,//gb_suboffset
	  0x45,0x00,
	  0x46,0x0f,
//ae setting 24M 22+50
  0xfd , 0x00,
  0x03 , 0x01,
  0x04 , 0x74,
  0x06 , 0x32,
  0x09 , 0x00,
  0x0a , 0x76,
  0xf0 , 0x7c,
  0xf1 , 0x00,
  0xfd , 0x01,
  0x90 , 0x04,
  0x92 , 0x01,
  0x98 , 0x7c,
  0x99 , 0x00,
  0x9a , 0x01,
  0x9b , 0x00,
	  
	//Status
	  0xfd,0x01,
	  0xce,0xc8,
	  0xcf,0x04,
	  0xd0,0xc8,
	  0xd1,0x04, 
	  
	  0xfd,0x01,
	  0xc4,0x56,//70
	  0xc5,0x8f,//74
	  0xca,0x30,
	  0xcb,0x45,
	  0xcc,0x70,//rpc_heq_low
	  0xcd,0x48,//rpc_heq_dummy
	  0xfd,0x00,

	  //lsc  for st 
	  0xfd,0x01,
	  0x35,0x15,
	  0x36,0x15, //20
	  0x37,0x15,
	  0x38,0x15,
	  0x39,0x15,
	  0x3a,0x15, //15
	  0x3b,0x13,
	  0x3c,0x15,
	  0x3d,0x15,
	  0x3e,0x15, //12
	  0x3f,0x15,
	  0x40,0x18,
	  0x41,0x00,
	  0x42,0x04,
	  0x43,0x04,
	  0x44,0x00,
	  0x45,0x00,
	  0x46,0x00,
	  0x47,0x00,
	  0x48,0x00,
	  0x49,0xfd,
	  0x4a,0x00,
	  0x4b,0x00,
	  0x4c,0xfd,
	  0xfd,0x00,

	//awb 1
	  0xfd,0x01,
	  0x28,0xc5,
	  0x29,0x9b,
	//0x10,0x08,
	//0x11,0x14,	
	//0x12,0x14,
	  0x2e,0x02,	
	  0x2f,0x16,
	  0x17,0x17,
	  0x18,0x19,	//0x29	 0813
	  0x19,0x45,	

	//0x1a,0x9e,//a1,a5   
	//0x1b,0xae,//b0,9a
	//0x33,0xef,
	  0x2a,0xef,
	  0x2b,0x15,

	  //awb2
	  0xfd,0x01,
	  0x73,0x80,
	  0x1a,0x80,
	  0x1b,0x80, 
	//d65
	  0x65,0xd5, //d6
	  0x66,0xfa, //f0
	  0x67,0x72, //7a
	  0x68,0x8a, //9a
	//indoor
	  0x69,0xc6, //ab
	  0x6a,0xee, //ca
	  0x6b,0x94, //a3
	  0x6c,0xab, //c1
	//f 
	  0x61,0x7a, //82
	  0x62,0x98, //a5
	  0x63,0xc5, //d6
	  0x64,0xe6, //ec
	  //cwf
	  0x6d,0xb9, //a5
	  0x6e,0xde, //c2
	  0x6f,0xb2, //a7
	  0x70,0xd5, //c5
	 
	//skin detect
	 0xfd,0x01,
	 0x08,0x15,
	 0x09,0x04,
	 0x0a,0x20,
	 0x0b,0x12,
	 0x0c,0x27,
	 0x0d,0x06,
	 0x0f,0x63,//0x5f	0813

	   //BPC_grad
	  0xfd,0x00,
	  0x79,0xf0,
	  0x7a,0x80,  //f0
	  0x7b,0x80, //f0 
	  0x7c,0x20,//f0	
	  
	//smooth
	  0xfd,0x00,

	  //
	  0x57,0x08, //raw_dif_thr_outdoor
	  0x58,0x0c, //raw_dif_thr_normal
	  0x56,0x0e, //raw_dif_thr_dummy
	  0x59,0x12, //raw_dif_thr_lowlight
		//GrGb
	  0x89,0x08, //raw_grgb_thr_outdoor 
	  0x8a,0x0c, //raw_grgb_thr_normal	
	  0x9c,0x0e, //raw_grgb_thr_dummy	
	  0x9d,0x12, //raw_grgb_thr_lowlight
		//Gr\Gb
	  0x81,0xe0, //raw_gflt_fac_outdoor
	  0x82,0x80, //raw_gflt_fac_normal
	  0x83,0x40, //raw_gflt_fac_dummy
	  0x84,0x20, //raw_gflt_fac_lowlight
		//GrGb
	  0x85,0xe0, //raw_gf_fac_outdoor  
	  0x86,0x80, //raw_gf_fac_normal  
	  0x87,0x40, //raw_gf_fac_dummy   
	  0x88,0x20, //raw_gf_fac_lowlight
		//
	  0x5a,0xff,  //raw_rb_fac_outdoor
	  0x5b,0xe0,  //raw_rb_fac_normal
	  0x5c,0x80,  //raw_rb_fac_dummy
	  0x5d,0x20,  //raw_rb_fac_lowlight
	  
	//sharpen 
	  0xfd,0x01, 
	  0xe2,0x50, //sharpen_y_base
	  0xe4,0xa0, //sharpen_y_max

	  0xe5,0x08, //rangek_neg_outdoor  //0x08
	  0xd3,0x08, //rangek_pos_outdoor	//0x08
	  0xd7,0x08, //range_base_outdoor	//0x08
	 
	  0xe6,0x0a, //rangek_neg_normal   // 0x08
	  0xd4,0x0a, //rangek_pos_normal   // 0x08
	  0xd8,0x0a, //range_base_normal   // 0x08
	  
	  0xe7,0x12, //rangek_neg_dummy   // 0x10
	  0xd5,0x12, //rangek_pos_dummy   // 0x10
	  0xd9,0x12, //range_base_dummy    // 0x10
		
	  0xd2,0x15, //rangek_neg_lowlight
	  0xd6,0x15, //rangek_pos_lowlight
	  0xda,0x15, //range_base_lowlight
	 
	  0xe8,0x20,  //sharp_fac_pos_outdoor  // 0x35
	  0xec,0x2c,  //sharp_fac_neg_outdoor
	  0xe9,0x20,  //sharp_fac_pos_nr	  // 0x35
	  0xed,0x2c,  //sharp_fac_neg_nr
	  0xea,0x18,  //sharp_fac_pos_dummy   // 0x30
	  0xef,0x1c,  //sharp_fac_neg_dummy   // 0x20
	  0xeb,0x15,  //sharp_fac_pos_low
	  0xf0,0x18,  //sharp_fac_neg_low 
	  
	//CCM
	  0xfd,0x01,
	  0xa0,0x66,
	  0xa1,0x00,
	  0xa2,0x19,
	  0xa3,0xf3,  // 0xf6
	  0xa4,0x8e,  // 0x99
	  0xa5,0x00,  // 0xf2
	  0xa6,0x00,  // 0x0d
	  0xa7,0xe6,   // 0xda
	  0xa8,0x9a,//0xa0 0813  // 0x98
	  0xa9,0x00,
	  0xaa,0x03,  // 0x33
	  0xab,0x0c,
	  0xfd,0x00,

			//gamma  
	  0xfd,0x00,
	  0x8b,0x0 ,  // 00,0 ,0 
	  0x8c,0xC ,  // 0f,C ,11
	  0x8d,0x19,  // 1e,19,19
	  0x8e,0x2C,  // 3d,2C,28
	  0x8f,0x49,  // 6c,49,46
	  0x90,0x61,  // 92,61,61
	  0x91,0x77,  // aa,77,78
	  0x92,0x8A,  // b9,8A,8A
	  0x93,0x9B,  // c4,9B,9B
	  0x94,0xA9,  // cf,A9,A9
	  0x95,0xB5,  // d4,B5,B5
	  0x96,0xC0,  // da,C0,C0
	  0x97,0xCA,  // e0,CA,CA
	  0x98,0xD4,  // e4,D4,D4
	  0x99,0xDD,  // e8,DD,DD
	  0x9a,0xE6,  // ec,E6,E6
	  0x9b,0xEF,  // f1,EF,EF
	  0xfd,0x01,  // 01,01,01
	  0x8d,0xF7,  // f7,F7,F7
	  0x8e,0xFF,  // ff,FF,FF		 
	  0xfd,0x00,  //

	   //rpc
	  0xfd,0x00, 
	  0xe0,0x4c, //  4c,44,4c,3e,3c,3a,38,rpc_1base_max
	  0xe1,0x3c, //  3c,36,3c,30,2e,2c,2a,rpc_2base_max
	  0xe2,0x34, //  34,2e,34,2a,28,26,26,rpc_3base_max
	  0xe3,0x2e, //  2e,2a,2e,26,24,22,rpc_4base_max
	  0xe4,0x2e, //  2e,2a,2e,26,24,22,rpc_5base_max
	  0xe5,0x2c, //  2c,28,2c,24,22,20,rpc_6base_max
	  0xe6,0x2c, //  2c,28,2c,24,22,20,rpc_7base_max
	  0xe8,0x2a, //  2a,26,2a,22,20,20,1e,rpc_8base_max
	  0xe9,0x2a, //  2a,26,2a,22,20,20,1e,rpc_9base_max 
	  0xea,0x2a, //  2a,26,2a,22,20,20,1e,rpc_10base_max
	  0xeb,0x28, //  28,24,28,20,1f,1e,1d,rpc_11base_max
	  0xf5,0x28, //  28,24,28,20,1f,1e,1d,rpc_12base_max
	  0xf6,0x28, //  28,24,28,20,1f,1e,1d,rpc_13base_max	

	//ae min gain  
	  0xfd,0x01,
	  0x94,0xa0,  //rpc_max_indr
	  0x95,0x28,   // 1e rpc_min_indr 
	  0x9c,0xa0,  //rpc_max_outdr
	  0x9d,0x28,  //rpc_min_outdr	 
	//ae target
	  0xfd,0x00, 
	  0xed,0x84, //80 
	  0xf7,0x80, //7c 
	  0xf8,0x78, //70 
	  0xec,0x74, //6c  
	  
	  0xef,0x7c, //99
	  0xf9,0x78, //90
	  0xfa,0x70, //80
	  0xee,0x6c, //78

		
	//gray detect
	  0xfd,0x01,
	  0x30,0x40,
	  //add 0813 
	  0x31,0x70,
	  0x32,0x40,
	  0x33,0xef,
	  0x34,0x05,
	  0x4d,0x2f,
	  0x4e,0x20,
	  0x4f,0x16,

	//lowlight lum
	  0xfd,0x00, //
	  0xb2,0x10, //lum_limit  // 0x10
	  0xb3,0x1f, //lum_set
	  0xb4,0x30, //black_vt  // 0x20
	  0xb5,0x45, //white_vt

	//saturation
	  0xfd,0x00, 
	  0xbe,0xff, 
	  0xbf,0x01, 
	  0xc0,0xff, 
	  0xc1,0xd8, 
	  0xd3,0x80, //0x78
	  0xd4,0x80, //0x78
	  0xd6,0x70, //0x78 	   0xd7,0x60, //0x78
	  0xd7,0x60,

	//HEQ
	  0xfd,0x00, 
	  0xdc,0x00, 
	  0xdd,0x80, //0x80 0813  // 0x78
	  0xde,0xb8, //80  0x88  0813
	  0xdf,0x80, 
	   
	//func enable
	  0xfd,0x00,  
	  0x32,0x15,  //0x0d
	  0x34,0x76,  //16
	  0x35,0x40,  //yuv 00
	  0x33,0xef,  
	  0x5f,0x51, 
	  0x1b,0xc ,
	  0x1C,0x28,

   
-1,-1};



SENSOR_OP_SECTION const _Sensor_Adpt_ sp0a19_cmd= 
{	
	.typ = 1, //YUV
	.pixelw = 640,
	.pixelh= 480,
	.hsyn = 1,
	.vsyn = 1,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)SP0A19InitTable,
	.rotate_adapt = {0},
	.hvb_adapt = {0x80,0x0a,0x80,0x0a},
	. mclk = 24000000,
	.p_fun_adapt = {NULL,NULL,NULL},
	.p_xc7016_adapt = {NULL},	
};

const _Sensor_Ident_ sp0a19_init=
{
	0xA6,0x42,0x43,0x01,0x01,0x02
};


#endif


