#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"

#if DEV_SENSOR_OV7670


SENSOR_INIT_SECTION static const unsigned char OV7670InitTable[CMOS_INIT_LEN]= 
{
#if 1
	0x12,0x80,
	0x09,0x10,
	0xc1,0x7f,
	0x11,0x80,
	0x3a,0x0c,
	0x3d,0xc0,
	0x12,0x02,
	0x15,0x40,
	0x17,0x13,
	0x18,0x01,
	0x32,0xbf,
	0x19,0x02,
	0x1a,0x7a,
	0x03,0x0a,
	0x0c,0x00,
	0x3e,0x00,
	0x70,0x3a,
	0x71,0x35,
	0x72,0x11,
	0x73,0xf0,
	0xa2,0x02,
	0x7a,0x20,
	0x7b,0x03,
	0x7c,0x0a,
	0x7d,0x1a,
	0x7e,0x3f,
	0x7f,0x4e,
	0x80,0x5b,
	0x81,0x68,
	0x82,0x75,
	0x83,0x7f,
	0x84,0x89,
	0x85,0x9a,
	0x86,0xa6,
	0x87,0xbd,
	0x88,0xd3,
	0x89,0xe8,
	0x13,0xe0,
	0x00,0x00,
	0x10,0x00,
	0x0d,0x40,
	0x14,0x28,
	0xa5,0x02,
	0xab,0x02,
	0x24,0x68,
	0x25,0x58,
	0x26,0xc2,
	0x9f,0x78,
	0xa0,0x68,
	0xa1,0x03,
	0xa6,0xd8,
	0xa7,0xd8,
	0xa8,0xf0,
	0xa9,0x90,
	0xaa,0x14,
	0x13,0xe5,
	0x0e,0x61,
	0x0f,0x4b,
	0x16,0x02,
	0x1e,0x07,
	0x21,0x02,
	0x22,0x91,
	0x29,0x07,
	0x33,0x0b,
	0x35,0x0b,
	0x37,0x1d,
	0x38,0x71,
	0x39,0x2a,
	0x3c,0x78,
	0x4d,0x40,
	0x4e,0x20,
	0x69,0x00,
	0x6b,0x0a,
	0x74,0x10,
	0x8d,0x4f,
	0x8e,0x00,
	0x8f,0x00,
	0x90,0x00,
	0x91,0x00,
	0x96,0x00,
	0x9a,0x80,
	0xb0,0x84,
	0xb1,0x0c,
	0xb2,0x0e,
	0xb3,0x82,
	0xb8,0x0a,
	0x43,0x0a,
	0x44,0xf2,
	0x45,0x39,
	0x46,0x62,
	0x47,0x3d,
	0x48,0x55,
	0x59,0x83,
	0x5a,0x0d,
	0x5b,0xcd,
	0x5c,0x8c,
	0x5d,0x77,
	0x5e,0x16,
	0x6c,0x0a,
	0x6d,0x65,
	0x6e,0x11,
	0x6f,0x9e,
	0x6a,0x40,
	0x01,0x56,
	0x02,0x44,
	0x13,0xe7,
	0x4f,0x88,
	0x50,0x8b,
	0x51,0x04,
	0x52,0x11,
	0x53,0x8c,
	0x54,0x9d,
	0x55,0x00,
	0x56,0x40,
	0x57,0x80,
	0x58,0x9a,
	0x41,0x08,
	0x3f,0x00,
	0x75,0x04,
	0x76,0x60,
	0x4c,0x00,
	0x77,0x01,
	0x3d,0xc2,
	0x4b,0x09,
	0xc9,0x30,
	0x41,0x38,
	0x56,0x40,
	0x34,0x11,
	0x3b,0x12,
	0xa4,0x88,
	0x96,0x00,
	0x97,0x30,
	0x98,0x20,
	0x99,0x30,
	0x9a,0x84,
	0x9b,0x29,
	0x9c,0x03,
	0x9d,0x99,
	0x9e,0x7f,
	0x78,0x04,
	0x79,0x01,
	0xc8,0xf0,
	0x79,0x0f,
	0xc8,0x00,
	0x79,0x10,
	0xc8,0x7e,
	0x79,0x0a,
	0xc8,0x80,
	0x79,0x0b,
	0xc8,0x01,
	0x79,0x0c,
	0xc8,0x0f,
	0x79,0x0d,
	0xc8,0x20,
	0x79,0x09,
	0xc8,0x80,
	0x79,0x02,
	0xc8,0xc0,
	0x79,0x03,
	0xc8,0x40,
	0x79,0x05,
	0xc8,0x30,
	0x79,0x26,
	0x62,0x00,
	0x63,0x00,
	0x64,0x06,
	0x65,0x00,
	0x66,0x05,
	0x94,0x05,
	0x95,0x09,
	0x2a,0x10,
	0x2b,0xc2,
	0x15,0x02,
	0x3a,0x04,
	0x3d,0xc3,
	0x19,0x03,
	0x1a,0x7b,
	0x2a,0x00,
	0x2b,0x00,
	0x18,0x01,
	0x66,0x05,
	0x62,0x10,
	0x63,0x0b,
	0x65,0x07,
	0x64,0x0f,
	0x94,0x0e,
	0x95,0x10,
	0x4f,0x87,
	0x50,0x68,
	0x51,0x1e,
	0x52,0x15,
	0x53,0x7c,
	0x54,0x91,
	0x58,0x1e,
	0x41,0x38,
	0x76,0xe0,
	0x24,0x40,
	0x25,0x38,
	0x26,0x91,
	0x7a,0x09,
	0x7b,0x0c,
	0x7c,0x16,
	0x7d,0x28,
	0x7e,0x48,
	0x7f,0x57,
	0x80,0x64,
	0x81,0x71,
	0x82,0x7e,
	0x83,0x89,
	0x84,0x94,
	0x85,0xa8,
	0x86,0xba,
	0x87,0xd7,
	0x88,0xec,
	0x89,0xf9,
	0x09,0x00,         
	-1,-1
#else
		  0x12, 0x80,
		  //udelay(20000,
		  0x11, 0x00,
		  0x92, 0x66,
		  0x93, 0x00,
		  0x9d, 0x4c,
		  0x9e, 0x3f,
		  0x3b, 0x0a,
		  0x13, 0xf0,
		  0x10, 0x00,
		  0x00, 0x00,
	  //  0x00, 0xff, // modified by me
	  //  0x07, 0x3f, // added by me
		  0x01, 0x80,
		  0x02, 0x80,
		  0x13, 0xf5,
		  //
		  0x12, 0x00,
		  0x04, 0x00,
		  0x18, 0x01,
		  0x17, 0x13,
		  0x32, 0x92,
		  0x19, 0x02,
		  0x1a, 0x7a,
		  0x03, 0x00,
		  //
		  0x0e, 0x84,
		  0x0f, 0x62,
		  0x15, 0x02,
		  0x16, 0x02,
		  0x1b, 0x01,
		  0x1e, 0x01,
		  0x29, 0x3c,
		  0x33, 0x00,
		  0x34, 0x07,
		  0x35, 0x84,
		  0x36, 0x00,
		  0x38, 0x13,
		  0x39, 0x43,
		  0x3a, 0x00,
		  0x3c, 0x6c,
		  0x3d, 0x90,
		  0x3f, 0x29,
		  0x40, 0xc1,
		  0x41, 0x20,
		  0x6b, 0x0a,
		  0xa1, 0xc8,
		  //
		  0x69, 0x80,
		  0x43, 0xf0,
		  0x44, 0x10,
		  0x45, 0x78,
		  0x46, 0xa8,
		  0x47, 0x60,
		  0x48, 0x80,
		  0x59, 0xba,
		  0x5a, 0x9a,
		  0x5b, 0x22,
		  0x5c, 0xb9,
		  0x5d, 0x9b,
		  0x5e, 0x10,
		  0x5f, 0xe0,
		  0x60, 0x85,
		  0x61, 0x60,
		  0x9f, 0x9d,
		  0xa0, 0xa0,
		  //
		  0x4f, 0x66,
		  0x50, 0x6b,
		  0x51, 0x05,
		  0x52, 0x19,
		  0x53, 0x40,
		  0x54, 0x59,
		  0x55, 0x40,
		  0x56, 0x40,
		  0x57, 0x40,
		  0x58, 0x0d,
		  //
		  0x8b, 0xcc,
		  0x8c, 0xcc,
		  0x8d, 0xcf,
		  //
		  0x6c, 0x40,
		  0x6d, 0x30,
		  0x6e, 0x4b,
		  0x6f, 0x60,
		  0x70, 0x70,
		  0x71, 0x70,
		  0x72, 0x70,
		  0x73, 0x70,
		  0x74, 0x60,
		  0x75, 0x60,
		  0x76, 0x50,
		  0x77, 0x48,
		  0x78, 0x3a,
		  0x79, 0x2e,
		  0x7a, 0x28,
		  0x7b, 0x22,
		  0x7c, 0x04,
		  0x7d, 0x07,
		  0x7e, 0x10,
		  0x7f, 0x28,
		  0x80, 0x36,
		  0x81, 0x44,
		  0x82, 0x52,
		  0x83, 0x60,
		  0x84, 0x6c,
		  0x85, 0x78,
		  0x86, 0x8c,
		  0x87, 0x9e,
		  0x88, 0xbb,
		  0x89, 0xd2,
		  0x8a, 0xe6,
		  //
		  0x14, 0x1a,
		  0x24, 0x78,
		  0x25, 0x6c,
		  0x62, 0x00,
		  0x63, 0x00,
		  0x64, 0x18,
		  0x65, 0x30,
		  0x66, 0x05,
		  0x94, 0x18,
		  0x95, 0x1c,
		  //udelay(8000,
		  0x13, 0xf7,


	 -1,-1,

#endif
};

extern struct i2c_device *iic_test;


static void OV7670_rotate(uint32 r)
{
	unsigned char buf[2];
	buf[0] = 0x1e;
	buf[1] = (r<<4)|0x07;
//	sensor_iic_enable();
//	sensor_iic_info();

	//i2c_sensor_write(iic_test,buf,1,1,0x42,0x43);
	//i2c_write(iic_test,(int8 *)&t[i][0],1,(int8 *)&t[i][1],1);
	i2c_write(iic_test,(int8 *)buf,1,(int8 *)&buf[1],1);
//   sensor_iic_diable();	
}



uint32 OV7670_hvblank(int8 dh,int8 dv)
{
	uint32 i;
#define HBLANK_BASE	0//0xb0UL//0x80UL//0xb0UL
#define VBLANK_BASE	0//0x20UL//0x0AUL//0x20UL
	int32 h = (int32)HBLANK_BASE + dh; if(h < 0) h = 0;
	int32 v = (int32)VBLANK_BASE + dv; if(v < 0) v = 0;
	const uint8 t[][2] = {
		{0x2A,(h >> 8)<<4},//HB[11:8]
		{0x2B,h & 0xff},//HB[7:0]
		{0x2D,v & 0xff},//VB[11:8]
		{0x2E,v >> 8},//VB[7:0]
	};
	
	for(i=0;i<4;i++)
		//i2c_sensor_write(iic_test,(u8 *)&t[i][0],1,1,0x42,0x43);
		i2c_write(iic_test,(int8 *)&t[i][0],1,(int8 *)&t[i][1],1);

	return (h<<16)|v;
}

SENSOR_OP_SECTION const _Sensor_Adpt_ ov7670_cmd = 
{
	.typ = 1, //YUV
	.pixelw = 640,
	.pixelh= 480,
	.hsyn = 1,
	.vsyn = 1,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)OV7670InitTable,
	.rotate_adapt = {0},
	.hvb_adapt = {0,0,0,0},
	. mclk = 4000000,
	.p_fun_adapt = {OV7670_rotate,OV7670_hvblank,NULL},
	.p_xc7016_adapt = {NULL},	
};


const _Sensor_Ident_ ov7670_init=
{
	0x76,0x42,0x43,0x01,0x01,0x0a
};


#endif

