#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"


#if DEV_SENSOR_GC0329


SENSOR_INIT_SECTION static const unsigned char GC0329InitTable[CMOS_INIT_LEN]=
{
	
	0xfe,0x80,
	0xfc,0x12,
	0xfc,0x12,
	0xfe,0x00,
	0xf0,0x07,
	0xf1,0x01,
	
	0x73,0x90,
	0x74,0x80,
	0x75,0x80,
	0x76,0x94,
	
	//0x42,0x00,
	//0x77,0x57,//AWB_R_gain
	//0x78,0x4d,//AWB_G_gain
	//0x79,0x45,//AWB_B_gain
	//0x42,0xfc,
	
	////////////////////analog////////////////////
	0xfc,0x16,
	
	0x0a,0x00,
	0x0c,0x00,
	0x17,0x14,//0x17
	
	0x19,0x05,
	0x1b,0x24,
	0x1c,0x04,
	0x1e,0x00,
	0x1f,0xc0,
	0x20,0x00,
	0x21,0x48,
	0x23,0x22,
	0x24,0x16,
	
	
	////////////////////blk////////////////////
	0x26,0xf7,
	0x32,0x04,
	0x33,0x20,
	0x34,0x20,
	0x35,0x20,
	0x36,0x20,
	
	////////////////////ISPBLOCKENABLE////////////////////
	0x40,0xff,
	0x41,0x00,
	0x42,0xfe,//0xfe
	0x46,0x03,   
	0x4b,0xcb,
	0x4d,0x01,
	0x4f,0x01,
	0x70,0x60,//48	
	
	//0xb0,0x00,
	//0xbc,0x00,
	//0xbd,0x00,
	//0xbe,0x00,
	
	////////////////////DNDD////////////////////
	0x80,0xe7,
	0x82,0x1f,
	0x83,0x03,
	0x87,0x4a,
	
	////////////////////ASDE////////////////////
	0xfe,0x01,
	0x18,0x22,
	0xfe,0x00,
	0x9c,0x0a,
	0xa4,0x50,
	0xa5,0x21,
	0xa7,0x35,
	0xdd,0x54,
	0x95,0x65,
	
	
	////////////////////RGBgamma////////////////////
	0xfe,0x00,
	0xbf,0x06,
	0xc0,0x14,
	0xc1,0x27,
	0xc2,0x3b,
	0xc3,0x4f,
	0xc4,0x62,
	0xc5,0x72,
	0xc6,0x8d,
	0xc7,0xa4,
	0xc8,0xb8,
	0xc9,0xc9,
	0xca,0xd6,
	0xcb,0xe0,
	0xcc,0xe8,
	0xcd,0xf4,
	0xce,0xfc,
	0xcf,0xff,
	
	//////////////////CC///////////////////
	0xfe,0x00,
	0xb3,0x44,
	0xb4,0xfd,
	0xb5,0x02,
	0xb6,0xfa,
	0xb7,0x48,
	0xb8,0xf0,
	
	//skin
	//0xb3,0x3c,
	//0xb4,0xFF,
	//0xb5,0x03,
	//0xb6,0x01,
	//0xb7,0x3f,
	//0xb8,0xF3,
	
	0x19,0x05,
	0x20,0x01,
	0x22,0xba,
	0x21,0x48,
	
	////////////////////YCP////////////////////
	0xfe,0x00,
	0xd1,0x2d,
	0xd2,0x2e,
	
	////////////////////AEC////////////////////
	0xfe,0x01,
	0x10,0x40,
	0x11,0xa1,
	0x12,0x07,
	0x13,0x40,
	0x17,0x88,
	0x21,0xb0,
	0x22,0x48,
	0x3c,0x95,
	0x3d,0x50,
	0x3e,0x48,
	
		////////////////////AWB////////////////////
#if 0//main
		0xfe,0x01,
		0x06,0x12,
		0x07,0x06,
		0x08,0x9c,
		0x09,0xee,
		0x50,0xfc,
		0x51,0x28,
		0x52,0x10,
		0x53,0x20,
		0x54,0x12,
		0x55,0x16,
		0x56,0x30,
		0x58,0x60,
		0x59,0x08,
		0x5a,0x02,
		0x5b,0x63,
		0x5c,0x35,
		0x5d,0x72,
		0x5e,0x11,
		0x5f,0x40,
		0x60,0x40,
		0x61,0xc8,
		0x62,0xa0,
		0x63,0x40,
		0x64,0x50,
		0x65,0x98,
		0x66,0xfa,
		0x67,0x80,
		0x68,0x70,
		0x69,0x80,
		0x6a,0x40,
		0x6b,0x39,
		0x6c,0x30,
		0x6d,0x60,
		0x6e,0x41,
		0x70,0x50,//AWB_C_number_limit
		0x71,0x00,//AWB_C_weight_mode
		0x72,0x10,
		0x73,0x00,////AWB_uplow_luma_value
		0x74,0x40,
		0x75,0x58,	
		0x76,0x24,
		0x77,0x40,
		0x78,0x20,
		0x79,0x60,
		0x7a,0x58,
		0x7b,0x20,
		0x7c,0x30,
		0x7d,0x35,
		0x7e,0x10,
		0x7f,0x08,
		0x80,0x60,
		0x81,0x50,
		0x82,0x42,
		0x83,0x40,
		0x84,0x40,
		0x85,0x40,
	
#elif0//sub
		0xfe,0x01,
		0x06,0x16,
		0x07,0x06,
		0x08,0x98,
		0x09,0xee,
		0x50,0xfc,
		0x51,0x20,
		0x52,0x1b,//0b
		0x53,0x10,//20
		0x54,0x10,//40
		0x55,0x10,
		0x56,0x20,
		0x57,0xa0,
		0x58,0xa0,
		0x59,0x28,
		0x5a,0x02,
		0x5b,0x63,
		0x5c,0x04,//34
		0x5d,0x73,
		0x5e,0x11,
		0x5f,0x40,
		0x60,0x40,
		0x61,0xc8,//d8//c8
		0x62,0xa0,///88//A0
		0x63,0x40,
		0x64,0x40,//37
		0x65,0xd0,
		0x66,0xfa,
		0x67,0x70,
		0x68,0x58,
		0x69,0xa5,//85jaambo
		0x6a,0x40,
		0x6b,0x39,
		0x6c,0x18,
		0x6d,0x28,
		0x6e,0x41,
		0x70,0x40,
		0x71,0x00,
		0x72,0x10,
		0x73,0x30,//awboutdoor-th
		0x80,0x60,
		0x81,0x50,
		0x82,0x42,
		0x83,0x40,
		0x84,0x40,
		0x85,0x40,
		0x86,0x40,
		0x87,0x40,
		0x88,0xfe,
		0x89,0xa0,
		0x74,0x40,
		0x75,0x58,
		0x76,0x24,
		0x77,0x40,
		0x78,0x20,
		0x79,0x60,
		0x7a,0x58,
		0x7b,0x20,
		0x7c,0x30,
		0x7d,0x35,
		0x7e,0x10,
		0x7f,0x08,
#else
	0xfe,0x01,
	0x06,0x06,
	0x07,0x06,
	0x08,0xa6,
	0x09,0xee,
	
	0x50,0x00,
	0x51,0x28,
	0x52,0x28,
	0x53,0x1d,
	0x54,0x1d,
	0x55,0x20,
	0x56,0x20,
	//0x57,0x00,
	0x58,0x60,
	0x59,0x28,
	0x5a,0x30,
	0x5b,0x63,
	0x5c,0x34,
	0x5d,0x73,//0x73
	0x5e,0x11,
	0x5f,0x40,
	
	0x60,0x40,
	0x61,0xc8,
	0x62,0xa0,
	0x63,0x40,
	0x64,0x50,
	0x65,0x98,
	0x66,0xfa,
	0x67,0x70,
	0x68,0x58,
	0x69,0x78,
	0x6a,0x40,
	0x6b,0x39,
	0x6c,0x40,
	0x6d,0x80,
	0x6e,0x41,
	
	0x70,0x50,//AWB_C_number_limit
	0x71,0x00,//AWB_C_weight_mode
	0x72,0x10,
	0x73,0x00,
	0x74,0x32,
	0x75,0x40,
	0x76,0x30,
	0x77,0x48,
	0x7a,0x50,
	0x7b,0x20,
	0x80,0x4a,
	0x81,0x43,
	0x82,0x43,
	0x83,0x40,
	0x84,0x40,
	0x85,0x40,
#endif
	
	
	////////////////////CC-AWB////////////////////
	0xd0,0x00,
	0xd2,0x2c,
	0xd3,0x80,
	
	///////////////////ABS///////////////////////
	0x9c,0x02,
	0x9d,0x10,
	
	///////////////////LSC//////////////////////
	////forxuye062dlenssetting
	0xfe,0x01,
	0xa0,0x00,
	0xa1,0x3c,
	0xa2,0x50,
	0xa3,0x00,
	0xa8,0x0f,
	0xa9,0x08,
	0xaa,0x00,
	0xab,0x04,
	0xac,0x00,
	0xad,0x07,
	0xae,0x0e,
	0xaf,0x00,
	0xb0,0x00,
	0xb1,0x09,
	0xb2,0x00,
	0xb3,0x00,
	0xb4,0x31,
	0xb5,0x19,
	0xb6,0x24,
	0xba,0x3a,
	0xbb,0x24,
	0xbc,0x2a,
	0xc0,0x17,
	0xc1,0x13,
	0xc2,0x17,
	0xc6,0x21,
	0xc7,0x1c,
	0xc8,0x1c,
	0xb7,0x00,
	0xb8,0x00,
	0xb9,0x00,
	0xbd,0x00,
	0xbe,0x00,
	0xbf,0x00,
	0xc3,0x00,
	0xc4,0x00,
	0xc5,0x00,
	0xc9,0x00,
	0xca,0x00,
	0xcb,0x00,
	0xa4,0x00,
	0xa5,0x00,
	0xa6,0x00,
	0xa7,0x00,
	
	
	0xfe,0x00,
	0x05,0x00,	
	0x06,0x6a,
	0x07,0x00,
	0x08,0x0c,
	0xfe,0x01,
	0x29,0x00,//anti-flickerstep[11:8]
	0x2a,0x96,//anti-flickerstep[7:0]//78
	0x2b,0x01,//explevel025fps//01
	0x2c,0x68,//78
	0x2d,0x01,//explevel120fps
	0x2e,0x68,
	0x2f,0x01,//explevel216.7fps
	0x30,0x68,
	0x31,0x01,//explevel3
	0x32,0x68,
	0x33,0x10,
	//0xfe,0x00,
	
	
	
	0xfe,0x00,
	0x0d,0x01,
	0x0e,0xe8,
	//0x0e,0x6C,/*changewin_heightfrom488to364*/
	0x0f,0x02,
	0x10,0x88,/*win_width644*/
	0x09,0x00,
	0x0a,0x00,
	0x0b,0x00,
	0x0c,0x04,/*colstart4*/
	0x16,0x00,
	//crop
	0x50,0x01,
#if 1
	///cropwindow
	0x51,0x00,	
	0x52,0x04,	///y
	0x53,0x00,	
	0x54,0x04,	///x
	
	
	0x55,0x01,	
	0x56,0xe0,	///360
	0x57,0x02,	
	0x58,0x80,	//640
#endif
	
	
	
	0xfe,0x00,
	////////////////////asde///////////////////
	0xa0,0xaf,
	0xa2,0xff,
	
	0x44,0xa2,


-1,-1};


SENSOR_INIT_SECTION static const unsigned char GC0329prewriteInitTable[CMOS_INIT_LEN]={
	0xfc,0x16,
	-1,-1
};


SENSOR_OP_SECTION const _Sensor_Adpt_ gc0329_cmd= 
{
	.typ = 1, //YUV
	.pixelw = 640,
	.pixelh= 480,
	.hsyn = 1,
	.vsyn = 1,
	.rduline = 0,//
	.rawwide = 1,//10bits
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)GC0329InitTable,
	.preset =(uint8 *)GC0329prewriteInitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = {0x6a,0x12,0x6a,0x12},
	. mclk = 24000000,
	.p_fun_adapt = {NULL,NULL,NULL},
	.p_xc7016_adapt = {NULL},	
};

const _Sensor_Ident_ gc0329_init=
{
	0xC0,0x62,0x63,0x01,0x01,0x00
};








#endif
