#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"


#if DEV_SENSOR_GC0328


SENSOR_INIT_SECTION static const unsigned char GC0328InitTable[CMOS_INIT_LEN]={

/*
	0x01,// [7:0]:driver type,0x01:sensor whith ISP; 0x02:ISP; 0x03:sensor whithout isp;	
	
	0x01,0x6E,0x36,0x00,// [7:0]:XCLK(BE)
	0x00,0x01,0x86,0xA0,// [7:0]:BAUDRATE(BE)
	
	0x00,//	[7:0]:chip_ID_addr>>8,when AddrByteNum == 2; 0 when  AddrByteNum == 1
	0xf0,// [7:0]:chip_ID_addr
	0x00,// [7:0]:chip_ID  
	0x9d,//
	0x00,0x00,0x00,0x00,//resverd
	
	0x02,0x80,//image_width
	0x01,0xE0,//image_height
	0x43,// [7:0]:read ID
	0x42,// [7:0]:write ID
	0x01,//	[7:0]:AddrByteNum ; 
	0x01,// [7:0]:DataByteNum
	
	0x04,// [2:0]:ldo_config_para
	0x01,// [7:0]:ID nums
*/
     


	//0x05 , 0x00, //hb [11:8]
	//0x06 , 0xde,//0xde,//hb [7:0]
	//0x07 , 0x00,//vb [11:8]

    0xFE,0x80,
    0xFE,0x80,
    0xFC,0x16,
    0xFC,0x16,
    0xFC,0x16,
    0xFC,0x16,
    0xF1,0x00,
    0xF2,0x00,
    0xFE,0x00,
    0x4F,0x00,
    0x03,0x00,
    0x04,0xC0,
    0x42,0x00,
    0x77,0x5A,
    0x78,0x40,
    0x79,0x56,
    0xFE,0x00,
    0x0D,0x01,
    0x0E,0xE8,
    0x0F,0x02,
    0x10,0x88,
    0x09,0x00,
    0x0A,0x00,
    0x0B,0x00,
    0x0C,0x00,
    0x16,0x00,
    0x17,0x14,
    0x18,0x0E,
    0x19,0x06,
    0x1B,0x48,
    0x1F,0xC8,
    0x20,0x01,
    0x21,0x78,
    0x22,0xB0,   
    0x23,0x04,	//GC0328C=0x04 GC0328=0x06
    0x24,0x16,
    0x26,0x00,
    0x50,0x01,
    0x70,0x45,
    0x05,0x00,
    0x06,0xDE,
    0x07,0x00,	//CHEN 0X00
    0x08,0xA7,	//CHEN 0XA7 0x00A7=20fps; 0x0186=15fps
    0xFE,0x01,
    0x29,0x00,
    0x2A,0x83,
    0x2B,0x02,
    0x2C,0x8F,
    0x2D,0x02,
    0x2E,0x8F,
    0x2F,0x02,
    0x30,0x8F,
    0x31,0x02,
    0x32,0x8F,
    0xFE,0x00,
    0xFE,0x01,
    0x50,0x00,
    0x4F,0x00,
    0x4C,0x01,
    0x4F,0x00,
    0x4F,0x00,
    0x4F,0x00,
    0x4F,0x00,
    0x4F,0x00,
    0x4D,0x30,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4D,0x40,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4D,0x50,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4D,0x60,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4D,0x70,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4F,0x01,
    0x50,0x88,
    0xFE,0x00,
    0xFE,0x00,
    0x27,0xB7,
    0x28,0x7F,
    0x29,0x20,
    0x33,0x20,
    0x34,0x20,
    0x35,0x20,
    0x36,0x20,
    0x32,0x08,
    0x3B,0x00,
    0x3C,0x00,
    0x3D,0x00,
    0x3E,0x00,
    0x47,0x00,
    0x48,0x00,
    0x40,0x7F,
    0x41,0x26,
    0x42,0xFB,
    0x44,0x02,
    0x45,0x00,
    0x46,0x03,
    0x4F,0x01,
    0x4B,0x01,
    0x50,0x01,
    0x7E,0x0A,
    0x7F,0x03,
    0x81,0x15,
    0x82,0x90,
    0x83,0x02,
    0x84,0xE5,
    0x90,0x2C,
    0x92,0x02,
    0x94,0x02,
    0x95,0x35,
    0xD1,0x24,
    0xD2,0x24,
    0xD3,0x40,
    0xDD,0xD3,
    0xDE,0x38,
    0xE4,0x88,
    0xE5,0x40,
    0xD7,0x0E,
    0xFE,0x00,
    0xBF,0x0E,
    0xC0,0x1C,
    0xC1,0x34,
    0xC2,0x48,
    0xC3,0x5A,
    0xC4,0x6E,
    0xC5,0x80,
    0xC6,0x9C,
    0xC7,0xB4,
    0xC8,0xC7,
    0xC9,0xD7,
    0xCA,0xE3,
    0xCB,0xED,
    0xCC,0xF2,
    0xCD,0xF8,
    0xCE,0xFD,
    0xCF,0xFF,
    0xFE,0x00,
    0x63,0x00,
    0x64,0x05,
    0x65,0x0B,
    0x66,0x19,
    0x67,0x2E,
    0x68,0x40,
    0x69,0x54,
    0x6A,0x66,
    0x6B,0x86,
    0x6C,0xA7,
    0x6D,0xC6,
    0x6E,0xE4,
    0x6F,0xFF,
    0xFE,0x01,
    0x18,0x02,
    0xFE,0x00,
    0x97,0x30,
    0x98,0x00,
    0x9B,0x60,
    0x9C,0x60,
    0xA4,0x50,
    0xA8,0x80,
    0xAA,0x40,
    0xA2,0x23,
    0xAD,0x28,
    0xFE,0x01,
    0x9C,0x00,
    0x9E,0xC0,
    0x9F,0x40,
    0xFE,0x01,
    0x08,0xA0,
    0x09,0xE8,
    0x10,0x08,
    0x11,0x21,
    0x12,0x11,
    0x13,0x45,
    0x15,0xFC,
    0x18,0x02,
    0x21,0xF0,
    0x22,0x60,
    0x23,0x30,
    0x25,0x00,
    0x24,0x14,
    0x3D,0x80,
    0x3E,0x40,
    0xFE,0x01,
    0x51,0x88,
    0x52,0x12,
    0x53,0x80,
    0x54,0x60,
    0x55,0x01,
    0x56,0x02,
    0x58,0x00,
    0x5B,0x02,
    0x5E,0xA4,
    0x5F,0x8A,
    0x61,0xDC,
    0x62,0xDC,
    0x70,0xFC,
    0x71,0x10,
    0x72,0x10,
    0x73,0x20,
    0x74,0x20,
    0x75,0x01,
    0x76,0x00,
    0x77,0x40,
    0x78,0x70,
    0x79,0x00,
    0x7B,0x00,
    0x7C,0x71,
    0x7D,0x00,
    0x80,0x70,
    0x81,0x58,
    0x82,0x98,
    0x83,0x60,
    0x84,0x58,
    0x85,0x50,
    0xFE,0x00,
    0xFE,0x01,
    0xC0,0x10,
    0xC1,0x0C,
    0xC2,0x0A,
    0xC6,0x0E,
    0xC7,0x0B,
    0xC8,0x0A,
    0xBA,0x26,
    0xBB,0x1C,
    0xBC,0x1D,
    0xB4,0x23,
    0xB5,0x1C,
    0xB6,0x1A,
    0xC3,0x00,
    0xC4,0x00,
    0xC5,0x00,
    0xC9,0x00,
    0xCA,0x00,
    0xCB,0x00,
    0xBD,0x00,
    0xBE,0x00,
    0xBF,0x00,
    0xB7,0x07,
    0xB8,0x05,
    0xB9,0x05,
    0xA8,0x07,
    0xA9,0x06,
    0xAA,0x00,
    0xAB,0x04,
    0xAC,0x00,
    0xAD,0x02,
    0xAE,0x0D,
    0xAF,0x05,
    0xB0,0x00,
    0xB1,0x07,
    0xB2,0x03,
    0xB3,0x00,
    0xA4,0x00,
    0xA5,0x00,
    0xA6,0x00,
    0xA7,0x00,
    0xA1,0x3C,
    0xA2,0x50,
    0xFE,0x00,
    0xB1,0x12,
    0xB2,0xF5,
    0xB3,0xFE,
    0xB4,0xE0,
    0xB5,0x15,
    0xB6,0xC8,
    0xFE,0x01,
    0x50,0x00,
    0xFE,0x01,
    0x4F,0x00,
    0x4C,0x01,
    0x4F,0x00,
    0x4F,0x00,
    0x4F,0x00,
    0x4D,0x34,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x02,
    0x4E,0x02,
    0x4D,0x44,
    0x4E,0x04,
    0x4E,0x04,
    0x4E,0x04,
    0x4D,0x53,
    0x4E,0x08,
    0x4E,0x08,
    0x4E,0x04,
    0x4E,0x04,
    0x4D,0x65,
    0x4E,0x04,
    0x4D,0x73,
    0x4E,0x20,
    0x4D,0x83,
    0x4E,0x20,
    0x4F,0x01,
    0x50,0x88,
    0xFE,0x00,
    0xF1,0x07,
    0xF2,0x01,	
-1,-1,};

extern struct i2c_device *iic_test;

static void GC0328_rotate(uint32 r)
{
	int8 buf[2];
	buf[0] = 0x17;		//0',180'
	buf[1] = 0x14|(r<<0);
	//Sensor_WriteRegister(SENSOR_IIC,buf,1,1);
	//i2c_sensor_write(iic_test,buf,1,1,0x42,0x43);
	//i2c_write(iic_test,(int8 *)&t[i][0],1,(int8 *)&t[i][1],1);
	i2c_write(iic_test,buf,1,&buf[1],1);

}



uint32 GC0328_hvblank(int8 dh,int8 dv)
{
#define HBLANK_BASE	0xdeUL
#define VBLANK_BASE	0x24UL
	uint32 i;
	int32 h = (int32)HBLANK_BASE + dh; if(h < 0) h = 0;
	int32 v = (int32)VBLANK_BASE + dv; if(v < 0) v = 0;
	const uint8 t[][2] = {
		{0x05,h >> 8},//HB[11:8]
		{0x06,h & 0xff},//HB[7:0]
		{0x07,v >> 8},//VB[11:8]
		{0x08,v & 0xff},//VB[7:0]
	};
	
	for(i=0;i<4;i++)	
		i2c_write(iic_test,(int8 *)&t[i][0],1,(int8 *)&t[i][1],1);
	
	return (h<<16)|v;
}

SENSOR_OP_SECTION const _Sensor_Adpt_ gc0328_cmd = 
{
	.typ = 1, //YUV
	.pixelw = 640,
	.pixelh= 480,
	.hsyn = 1,
	.vsyn = 1,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)GC0328InitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = 0x6a,0x12,0x6a,0x12,
	. mclk = 24000000,
	.p_fun_adapt = {GC0328_rotate,GC0328_hvblank,NULL},
	//.p_xc7016_adapt = NULL,	
};

const _Sensor_Ident_ gc0328_init={

	0x9d,0x42,0x43,0x01,0x01,0xf0
};



#endif


