#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"


#if DEV_SENSOR_GC0312

SENSOR_INIT_SECTION static const unsigned char GC0312InitTable[CMOS_INIT_LEN]=
{
0xfe,0xf0,
0xfe,0xf0,
0xfe,0x00,
0xfc,0x0e ,
0xfc,0x0e ,
0xf2,0x08 ,
0xf3,0x00,// output_disable 
0xf7,0x1b ,
0xf8,0x03 ,
0xf9,0x0e ,
0xfa,0x11,

#if 1
	/////////////////////////////////////////////////
	/////////////////  CISCTL reg	/////////////////
	/////////////////////////////////////////////////
0x00,0x2f,
0x01,0x0f,
0x02,0x04,
0x03,0x03,
0x04,0x50,
0x09,0x00,
0x0a,0x00,
0x0b,0x00,
0x0c,0x04,
0x0d,0x01,
0x0e,0xe8,
0x0f,0x02,
0x10,0x88,
0x16,0x00,
0x17,0x14,
0x18,0x1a,
0x19,0x14,
0x1b,0x48,
0x1c,0x1c,
0x1e,0x6b,
0x1f,0x28,
0x20,0x8b,//89 travis 20140801
0x21,0x49,
0x22,0xb0,
0x23,0x04,
0x24,0x16,
0x34,0x20,
	
	/////////////////////////////////////////////////
	////////////////////   BLK	 ////////////////////
	/////////////////////////////////////////////////
0x26,0x23,
0x28,0xff,
0x29,0x00,
0x32,0x00,
0x33,0x10 ,
0x37,0x20,
0x38,0x10,
0x47,0x80,
0x4e,0x66,
0xa8,0x02,
0xa9,0x80,
	
	/////////////////////////////////////////////////
	//////////////////	ISP reg   ///////////////////
	/////////////////////////////////////////////////
0x40,0xff,
0x41,0x21,
0x42,0xcf,
0x44,0x02,
0x45,0xa8 ,
0x46,0x02 ,
0x4a,0x11,
0x4b,0x01,
0x4c,0x20,
0x4d,0x05,
0x4f,0x01,
0x50,0x01,
0x55,0x01,
0x56,0xe0,
0x57,0x02,
0x58,0x80,
	
	/////////////////////////////////////////////////
	///////////////////   GAIN   ////////////////////
	/////////////////////////////////////////////////
0x70,0x70,
0x5a,0x84,
0x5b,0xc9,
0x5c,0xed,
0x77,0x74,
0x78,0x70, //0x40,
0x79,0x5f,
	
	///////////////////////////////////////////////// 
	///////////////////   DNDD  /////////////////////
	///////////////////////////////////////////////// 
0x82,0x14 ,
0x83,0x0b,
0x89,0xf0,
	
	///////////////////////////////////////////////// 
	//////////////////   EEINTP  ////////////////////
	///////////////////////////////////////////////// 
0x8f,0xaa ,
0x90,0x8c ,
0x91,0x90,
0x92,0x03 ,
0x93,0x03 ,
0x94,0x05 ,
0x95,0x65 ,
0x96,0xf0 ,
	
	///////////////////////////////////////////////// 
	/////////////////////  ASDE  ////////////////////
	///////////////////////////////////////////////// 
0xfe,0x00,
                                       
0x9a,0x20,
0x9b,0x80,
0x9c,0x40,
0x9d,0x80,
	                               
0xa1,0x30,
 0xa2,0x32,
0xa4,0x80,//30 travis 20140929
0xa5,0x28,//30 travis 20140929
0xaa,0x30,//10 travis 20140929 				
0xac,0x22,
	 
	/////////////////////////////////////////////////
	///////////////////   GAMMA   ///////////////////
	/////////////////////////////////////////////////
/*0xfe,0x00,//default
0xbf,0x08,
0xc0,0x16,
0xc1,0x28,
0xc2,0x41,
0xc3,0x5a,
0xc4,0x6c,
0xc5,0x7a,
0xc6,0x96,
0xc7,0xac,
0xc8,0xbc,
0xc9,0xc9,
0xca,0xd3,
0xcb,0xdd,
0xcc,0xe5,
0xcd,0xf1,
0xce,0xfa,
0xcf,0xff,*/
////big gammmar///////////////////////////////
 
0xfe,0x00,//big gamma
0xbf,0x08,
0xc0,0x1d,
0xc1,0x34,
0xc2,0x4b,
0xc3,0x60,
0xc4,0x73,
0xc5,0x85,
0xc6,0x9f,
0xc7,0xb5,
0xc8,0xc7,
0xc9,0xd5,
0xca,0xe0,
0xcb,0xe7,
0xcc,0xec,
0xcd,0xf4,
0xce,0xfa,
0xcf,0xff,
	



	/////////////////////////////////////////////////
	///////////////////   YCP  //////////////////////
	/////////////////////////////////////////////////
0xd0,0x40,
0xd1,0x34,
0xd2,0x34,
0xd3,0x40,
0xd6,0xf2,
0xd7,0x1b,
0xd8,0x18,
0xdd,0x03,
	
	/////////////////////////////////////////////////
	////////////////////   AEC   ////////////////////
	/////////////////////////////////////////////////
0xfe,0x01,
0x05,0x30,
0x06,0x75,
0x07,0x40,
0x08,0xb0,
0x0a,0x85, //0xc5,
0x0b,0x11,
0x0c,0x00,
0x12,0x52,
0x13,0x78, //0x75,
0x18,0x67,//0X95
0x19,0x67,//0X96
0x1f,0x20,
0x20,0xc0,
0x3e,0x40,
0x3f,0x57,
0x40,0x7d,
0x03,0x60,
0x44,0x02,
	
	/////////////////////////////////////////////////
	////////////////////   AWB   ////////////////////
	/////////////////////////////////////////////////
0xfe,0x01,
0x1c,0x91,
0x21,0x15,
0x50,0x80,
0x56,0x04,
0x59,0x08,
0x5b,0x02,
0x61,0x8d,
0x62,0xa7,
0x63,0xd0,
0x65,0x06,
0x66,0x06,
0x67,0x84,
0x69,0x08,
0x6a,0x25,
0x6b,0x01,
0x6c,0x00,//00
0x6d,0x02,
0x6e,0xf0,
0x6f,0x80,//80
0x76,0x80,
0x78,0xaf,
0x79,0x75,
0x7a,0x40,
0x7b,0x50,	
0x7c,0x0c,
	

0x90,0xc9,//stable AWB 
0x91,0xbe,
0x92,0xe2,
0x93,0xc9,
0x95,0x1b,
0x96,0xe2,
0x97,0x49,
0x98,0x1b,
0x9a,0x49,
0x9b,0x1b,
0x9c,0xc3,
0x9d,0x49,
0x9f,0xc7,
0xa0,0xc8,
0xa1,0x00,
0xa2,0x00,
0x86,0x00,
0x87,0x00,
0x88,0x00,
0x89,0x00,
0xa4,0xb9,
0xa5,0xa0,
0xa6,0xba,
0xa7,0x92,
0xa9,0xba,
0xaa,0x80,
0xab,0x9d,
0xac,0x7f,
0xae,0xbb,
0xaf,0x9d,
0xb0,0xc8,
0xb1,0x97,
0xb3,0xb7,
0xb4,0x7f,
0xb5,0x00,
0xb6,0x00,
0x8b,0x00,
0x8c,0x00,
0x8d,0x00,
0x8e,0x00,
0x94,0x55,
0x99,0xa6,
0x9e,0xaa,
0xa3,0x0a,
0x8a,0x00,
0xa8,0x55,
0xad,0x55,
0xb2,0x55,
0xb7,0x05,
0x8f,0x00,
0xb8,0xcb,
0xb9,0x9b,	
//default  awb/////////////////////
/*	 
0xa4,0xb9, //default AWB
0xa5,0xa0,
0x90,0xc9, 
0x91,0xbe,                                 
0xa6,0xb8, 
0xa7,0x95, 
0x92,0xe6, 
0x93,0xca,                                
0xa9,0xbc, 
0xaa,0x95, 
0x95,0x23, 
0x96,0xe7,                                  
0xab,0x9d, 
0xac,0x80,
0x97,0x43, 
0x98,0x24,                                
0xae,0xb7, 
0xaf,0x9e, 
0x9a,0x43,
0x9b,0x24,                                 
0xb0,0xc8, 
0xb1,0x97,
0x9c,0xc4, 
0x9d,0x44,                               
0xb3,0xb7, 
0xb4,0x7f,
0x9f,0xc7,
0xa0,0xc8,                               
0xb5,0x00, 
0xb6,0x00,
0xa1,0x00,
0xa2,0x00,                         
0x86,0x60,
0x87,0x08,
0x88,0x00,
0x89,0x00,
0x8b,0xde,
0x8c,0x80,
0x8d,0x00,
0x8e,0x00,                               
0x94,0x55,
0x99,0xa6,
0x9e,0xaa,
0xa3,0x0a,
0x8a,0x0a,
0xa8,0x55,
0xad,0x55,
0xb2,0x55,
0xb7,0x05,
0x8f,0x05,                              
0xb8,0xcc,
0xb9,0x9a,
*/ 
	/////////////////////////////////////////////////
	////////////////////   CC    ////////////////////
	/////////////////////////////////////////////////
0xfe,0x01,
	
0xd0,0x38,//skin red
0xd1,0x00,
0xd2,0x02,
0xd3,0x04,
0xd4,0x38,
0xd5,0x12,	
0xd6,0x30,
0xd7,0x00,
0xd8,0x0a,
0xd9,0x16,
0xda,0x39,
0xdb,0xf8,

	/////////////////////////////////////////////////
	////////////////////   LSC   ////////////////////
	/////////////////////////////////////////////////
0xfe,0x01,
0xc1,0x3c,
0xc2,0x50,
0xc3,0x00,
0xc4,0x40,
0xc5,0x30,
0xc6,0x30,
0xc7,0x10,
0xc8,0x00,
0xc9,0x00,
0xdc,0x20,
0xdd,0x10,
0xdf,0x00,
0xde,0x00,
	
	/////////////////////////////////////////////////
	///////////////////  Histogram	/////////////////
	/////////////////////////////////////////////////
0x01,0x10,
0x0b,0x31,
0x0e,0x50,
0x0f,0x0f,
0x10,0x6e,
0x12,0xa0,
0x15,0x60,
0x16,0x60,
0x17,0xe0,
	
	/////////////////////////////////////////////////
	//////////////	Measure Window	  ///////////////
	/////////////////////////////////////////////////
0xcc,0x0c ,
0xcd,0x10,
0xce,0xa0,
0xcf,0xe6,
	
	/////////////////////////////////////////////////
	/////////////////	dark sun   //////////////////
	/////////////////////////////////////////////////
0x45,0xf7,
0x46,0xff,
0x47,0x15,
0x48,0x03 ,
0x4f,0x60,

	//////////////////banding//////////////////////
0xfe,0x00 ,
0x05,0x02,
0x06,0x2c,//HB
0x07,0x00,
0x08,0x40,//VB
	
0xfe,0x01,
0x25,0x00 ,  //anti-flicker step [11:8]
0x26,0x6a,   //anti-flicker step [7:0]

0x27,0x01, //
0x28,0xe0, 
0x29,0x02,//
0x2a,0xa0,
0x2b,0x03,//
0x2c,0xc0,
0x2d,0x04,//
0x2e,0x80,
0x3c,0x00,
0x3D,0x20, //
0xfe,0x00,
#else //for test
0x03,0x03,
0x04,0xff,
#endif
	
	/////////////////////////////////////////////////
	/////////////////////  DVP   ////////////////////
	/////////////////////////////////////////////////
0xfe,0x03,
0x01,0x00,
0x02,0x00,
0x10,0x00,
0x15,0x00,
0xfe,0x00,
	///////////////////OUTPUT//////////////////////
0xf3,0xff, // output_enable
-1,-1
};

extern struct i2c_device *iic_test;

static void GC0312_rotate(uint32 r)
{
	unsigned char buf[2];
	buf[0] = 0x14;		//0',180'
	buf[1] = 0x10|(r<<0);
	//Sensor_WriteRegister(SENSOR_IIC,buf,1,1);
	//i2c_sensor_write(iic_test,buf,1,1,0x42,0x43);
	i2c_write(iic_test,(int8 *)buf,1,(int8 *)&buf[1],1);

}



uint32 GC0312_hvblank(int8 dh,int8 dv)
{
#define HBLANK_BASE	0xdeUL
#define VBLANK_BASE	0x24UL
		uint32 i;
		int32 h = (int32)HBLANK_BASE + dh; if(h < 0) h = 0;
		int32 v = (int32)VBLANK_BASE + dv; if(v < 0) v = 0;
		const uint8 t[][2] = {
			{0x01,h & 0xff},//0x6a//0xde //HB[7:0]
			{0x02,v & 0xff},  //0x0c //VB[7:0]
			{0x0f,((v >> 8)<<4)|(h >> 8)} //{0x0f,0x00}, //VB/HB [11:8]
		};
	//for(i=0;i<3;i++)
		//Sensor_WriteRegister(SENSOR_IIC,(u8 *)&t[i][0],1,1);
	for(i=0;i<3;i++)	
		i2c_write(iic_test,(int8 *)&t[i][0],1,(int8 *)&t[i][1],1);

	return (h<<16)|v;
}

SENSOR_OP_SECTION const _Sensor_Adpt_ gc0312_cmd= 
{
	.typ = 1, //YUV
	.pixelw = 640,
	.pixelh= 480,
	.hsyn = 1,
	.vsyn = 0,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)GC0312InitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = {0xde,0x24,0xde,0x24},
	. mclk = 24000000,
	.p_fun_adapt = {GC0312_rotate,GC0312_hvblank,NULL},

};

const _Sensor_Ident_ gc0312_init=
{
	0x10,0x42,0x43,0x01,0x01,0xf1
};



#endif


