#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"


#if DEV_SENSOR_GC0311


SENSOR_INIT_SECTION static const unsigned char GC0311InitTable[CMOS_INIT_LEN]=
{
	0xfe,0xf0,
	0xfe,0xf0,
	0xfe,0xf0,
	0xfc,0x16,//clockenable
	0xfc,0x16,//clockenable
	
	0x42,0x00,
	0x4f,0x01,
	0x03,0x02,
	0x04,0x88,
	
	0x26,0x00,
	0x29,0x40,//[7]black_compress_en,[6:0]global_offset
	0x2a,0x30,
	0x2b,0x30,
	0x2c,0x30,
	0x2d,0x30,
	
	0x77,0x54,//AWB_R_gain
	0x78,0x40,//AWB_G_gain
	0x79,0x4a,//AWB_B_gain
	
	
	0x73,0x80,
	0x74,0x82,
	0x75,0x82,
	0x76,0x82,
	
	////////////BLK/////////////////////
	////////////////////////////////////////////////
	0x26,0xf7,//[
	0x28,0x7f,//BLKvaluelimit
	0x32,0x00,
	0x33,0x20,//offset_ratio_G1
	0x34,0x20,//offset_ratio_G2
	0x35,0x20,//offsetratio_R
	0x36,0x20,//offsetratio_B
	0x3b,0x08,
	0x3c,0x08,
	0x3d,0x08,
	0x3e,0x08,
	
	/////////////CISCTL/////////////////////////////
	0xfe,0x00,//Pageselect
	//////windowsetting/////
	0x0d,0x01,//8cis_win_height
	0x0e,0xe8,//7:0cis_win_height
	0x0f,0x02,//9:8cis_win_width
	0x10,0x88,//7:0cis_win_width
	0x09,0x00,//row_start
	0x0a,0x00,
	0x0b,0x00,//col_start
	0x0c,0x04,
	//crop
	0x50,0x01,
#if 1
	///cropwindow
	0x51,0x00,
	0x52,0x00,///y
	0x53,0x00,
	0x54,0x00,///x
	
	
	0x55,0x01,
	0x56,0xe0,///360
	0x57,0x02,
	0x58,0x80,//640
#endif
	/////////////////banding////////////////
	0x05,0x01,
	0x06,0x32,//Hb
	0x07,0x00,
	0x08,0x0c,//VB
	0xfe,0x01,//VB
	0x29,0x00,
	0x2a,0x78,//step
	0x2b,0x01,
	0x2c,0x68,//25fps
	0x2d,0x01,
	0x2e,0x68,//25fps
	0x2f,0x01,
	0x30,0x68,//25fps
	0x31,0x01,
	0x32,0x68,//25fps
	0x33,0x20,
	0xfe,0x00,
	
	0x17,0x14,//[1]updown,[0]mirror1417
	0x19,0x04,
	0x1f,0x08,
	0x20,0x01,
	0x21,0x48,
	0x1b,0x48,//fordecreaseFPN
	0x22,0xba,
	0x23,0x06,//0720140113lanking
	0x24,0x16,//PADdriver
	
	//globalgainforrange
	0x70,0x50,//58
	
	////////////////////////////////////////////////
	////////////blockenable/////////////
	////////////////////////////////////////////////
	0x40,0xff,
	0x41,0x2e,
	0x42,0xf9,
	0x44,0xa2,//yuv
	0x46,0x03,//sync_mode
	0x4d,0x01,
	0x4f,0x01,
	
	
	//DN&EEINTP
#if 1
	0x7e,0x08,
	0x7f,0xc3,
	0x80,0x01,//f7
	0x81,0x30,//fe
	0x82,0xf0,//f0
	0x83,0x01,//02
	0x84,0x02,
	0x89,0x22,
	0x90,0x2c,
	0x92,0x02,
	0x94,0x02,
	0x95,0x48,//边缘
#else
	0x7e,0x0a,
	0x7f,0x03,
	0x80,0x27,//20140915
	0x81,0x15,
	0x82,0x90,
	0x83,0x02,
	0x84,0x23,//0xe5
	0x90,0x2c,
	0x92,0x02,
	0x94,0x02,
	0x95,0x35,
	
#endif
	/////////////////////ASDE////////////////
	0x9a,0x20,//YoffsetLimit
	0x9c,0x86,
	0xa4,0x50,
	0xa7,0xf0,//40travis20160127
	0xaa,0x60,
	0xa2,0x45,
	
	////////////////Ygamma////////////////
	//////////////////////////////////////////
#if 0
	0xfe,0x00,
	0x63,0x00,
	0x64,0x04,
	0x65,0x09,
	0x66,0x17,
	0x67,0x2b,
	0x68,0x3d,
	0x69,0x4f,
	0x6a,0x5f,
	0x6b,0x82,
	0x6c,0xa2,
	0x6d,0xc5,
	0x6e,0xe5,
	0x6f,0xff,
#else
	0xfe,0x00,
	0x63,0x00,
	0x64,0x05,
	0x65,0x0b,
	0x66,0x19,
	0x67,0x2e,
	0x68,0x40,
	0x69,0x54,
	0x6a,0x66,
	0x6b,0x86,
	0x6c,0xa7,
	0x6d,0xc6,
	0x6e,0xe4,
	0x6f,0xff,
#endif
	0xfe,0x00,
	
	////////////////RGBgamma//////////////
	///////////////////////////////////////
	/*
	0xfe,0x00,
	0xbf,0x0b,
	0xc0,0x17,
	0xc1,0x2a,
	0xc2,0x41,
	0xc3,0x54,
	0xc4,0x66,
	0xc5,0x74,
	0xc6,0x8c,
	0xc7,0xa3,
	0xc8,0xb5,
	0xc9,0xc4,
	0xca,0xd0,
	0xcb,0xdb,
	0xcc,0xe5,
	0xcd,0xf0,
	0xce,0xf7,
	0xcf,0xff,*/
	0xfe,0x00,
	0xbf,0x0b,
	0xc0,0x16,
	0xc1,0x29,
	0xc2,0x3c,
	0xc3,0x4f,
	0xc4,0x5f,
	0xc5,0x6f,
	0xc6,0x8a,
	0xc7,0x9f,
	0xc8,0xb4,
	0xc9,0xc6,
	0xca,0xd3,
	0xcb,0xdd,
	0xcc,0xe5,
	0xcd,0xf1,
	0xce,0xfa,
	0xcf,0xff,
	
	///YUVmaxtrix////
	0xb0,0x13,
	0xb1,0x1f,//1f
	0xb2,0x0e,
	0xb3,0xf5,
	0xb4,0xe5,
	0xb5,0x26,
	0xb6,0x20,
	0xb7,0xde,
	0xb8,0x02,
	/////////////YCP//////////////
	////////////////////////////
	0xd1,0x2c,
	0xd2,0x2c,
	0xd3,0x3c,//对比度
	0xdd,0x38,
	0xed,0x00,
	
	0xde,0x34,//autogray_mode
	0xe4,0x00,
	0xe5,0x40,
	
	//luma_div
	0xfe,0x01,
	0x18,0x21,
	
	///////////MEANSUREWINDOW////////
	0x08,0xa4,
	0x09,0xf0,
	
	//////////////////AEC///////////////////////
	0xfe,0x01,
	0x10,0x08,//08//18//[7]low_light_mode,[6]measure_point
	0x11,0x11,//[6:4]veryN
	0x12,0x00,//90beforeGamma,shouldsetbit[7]as0
	0x13,0x41,//Ytarget
	0x15,0xfe,//fc//highrange
	0x16,0xd8,//AECignore
	0x17,0x98,//AECignoreen
	0x1a,0x61,//SLOWmargin
	0x18,0x21,//LUMA
	0x21,0xc0,//auto_post_gain
	0x22,0x60,//autopregain
	
	
	//////////////////AWB////////////////////
	
	0x06,0x10,
	0x08,0xa0,
	
	0x50,0xfe,
	0x51,0x05,
	0x52,0x28,
	0x53,0x05,
	0x54,0x10,
	0x55,0x20,
	0x56,0x16,//AWBCmax
	0x57,0x10,
	0x58,0xf2,
	0x59,0x10,
	0x5a,0x10,
	0x5b,0xf0,
	0x5e,0xe8,
	0x5f,0x20,
	0x60,0x20,
	0x61,0xe0,
	
	0x62,0x03,
	0x63,0x30,
	0x64,0xc0,
	0x65,0xd0,
	0x66,0x20,
	0x67,0x00,//80//AWB_outdoor_mode
	
	0x6d,0x90,
	0x6e,0x40,
	0x6f,0x08,
	0x70,0x10,
	0x71,0x62,
	0x72,0x24,
	0x73,0x71,
	0x74,0x10,
	
	0x75,0x40,
	0x76,0x40,
	0x77,0xc9,
	0x78,0x9c,
	
	0x79,0x18,
	0x7a,0x40,
	0x7b,0xb0,
	0x7c,0xf5,
	
	0x81,0x70,
	0x82,0x58,
	0x83,0x78,
	
	0x8a,0xf8,
	0x8b,0xf4,
	0x8c,0x0a,
	0x8d,0x00,
	0x8e,0x00,
	0x8f,0x00,
	0x90,0x12,
	0xfe,0x00,
	
	////////////////SPIreciver////////////////
	0xad,0x00,
	//////////////////LSC///////////////////////
	0xfe,0x01,
	0xc0,0x1e,
	0xc1,0x18,
	0xc2,0x17,
	0xc6,0x1e,
	0xc7,0x18,
	0xc8,0x17,
	0xba,0x30,
	0xbb,0x25,
	0xbc,0x20,
	0xb4,0x30,
	0xb5,0x25,
	0xb6,0x20,
	0xc3,0x00,
	0xc4,0x00,
	0xc5,0x00,
	0xc9,0x00,
	0xca,0x00,
	0xcb,0x00,
	0xbd,0x00,
	0xbe,0x00,
	0xbf,0x00,
	0xb7,0x00,
	0xb8,0x00,
	0xb9,0x00,
	0xa8,0x0f,
	0xa9,0x05,
	0xaa,0x00,
	0xab,0x0f,
	0xac,0x05,
	0xad,0x00,
	0xae,0x0f,
	0xaf,0x05,
	0xb0,0x00,
	0xb1,0x0f,
	0xb2,0x05,
	0xb3,0x00,
	0xa4,0x00,
	0xa5,0x00,
	0xa6,0x00,
	0xa7,0x00,
	0xa1,0x3c,
	0xa2,0x50,
	0xfe,0x00,
	
	0x50,0x01,//crop
	0xfe,0x01,
	0x9c,0x00,
	0x9e,0xc0,
	0x9f,0x40,
	
	0xfe,0x00,
	0x42,0xfb,
	
	0xf1,0x07,//outputenable
	0xf2,0x01,//outputenableDVPorSPI

-1,-1};



SENSOR_OP_SECTION const _Sensor_Adpt_ gc0311_cmd= 
{
	.typ = 1, //YUV
	.pixelw = 640,
	.pixelh= 480,
	.hsyn = 1,
	.vsyn = 1,
	.rduline = 0,//
	.rawwide = 1,//10bits
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)GC0311InitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = {0x6a,0x12,0x6a,0x12},
	. mclk = 24000000,
	.p_fun_adapt = {NULL,NULL,NULL},
	.p_xc7016_adapt = {NULL},
};

const _Sensor_Ident_ gc0311_init=
{
	0xBB,0x66,0x67,0x01,0x01,0xf0
};








#endif
