#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"


#if DEV_SENSOR_GC0309


SENSOR_INIT_SECTION static const unsigned char GC0309InitTable[CMOS_INIT_LEN]=
{
0xFE,0x80,
0xFE,0x00,
0x1A,0x26,
0xD2,0x10,
0x22,0x55,
0x5A,0x56,
0x5B,0x40,
0x5C,0x4A,
0x22,0x57,
0xE2,0x00,
0xE3,0x64,
0x03,0x01,
0x04,0x2C,
0xE4,0x02,
0xE5,0x8F,
0xE6,0x02,
0xE7,0x8F,
0xE8,0x02,
0xE9,0x8F,
0xEA,0x05,
0xEB,0xDC,
0x05,0x00,
0x06,0x00,
0x07,0x00,
0x08,0x00,
0x09,0x01,
0x0A,0xE8,
0x0B,0x02,
0x0C,0x88,
0x0D,0x02,
0x0E,0x02,
0x10,0x26,
0x11,0x0D,
0x12,0x2A,
0x13,0x00,
0x14,0x10,
0x15,0x0A,
0x16,0x05,
0x17,0x01,
0x1B,0x03,
0x1C,0x49,
0x1D,0x98,
0x1E,0x20,
0x1F,0x3F,
0x20,0xFF,
0x21,0xF8,
0x24,0xA2,
0x25,0x0F,
0x26,0x03,
0x2F,0x01,
0x30,0xF7,
0x31,0x60,
0x32,0x00,
0x39,0x04,
0x3A,0x20,
0x3B,0x20,
0x3C,0x02,
0x3D,0x02,
0x3E,0x02,
0x3F,0x02,
0x50,0x24,
0x53,0x82,
0x54,0x80,
0x55,0x80,
0x56,0x82,
0x8B,0x22,
0x8C,0x20,
0x8D,0x20,
0x8E,0x10,
0x8F,0x10,
0x90,0x10,
0x91,0x3C,
0x92,0x50,
0x5D,0x12,
0x5E,0x1A,
0x5F,0x24,
0x60,0x07,
0x61,0x0E,
0x62,0x0C,
0x64,0x03,
0x66,0xE8,
0x67,0x86,
0x68,0xA2,
0x69,0x20,
0x6A,0x0F,
0x6B,0x00,
0x6C,0x53,
0x6D,0x83,
0x6E,0xAC,
0x6F,0xAC,
0x70,0x15,
0x71,0x43,
0x72,0xDC,
0x73,0x80,
0x74,0x02,
0x75,0x3F,
0x76,0x02,
0x77,0x54,
0x78,0x88,
0x79,0x81,
0x7A,0x81,
0x7B,0x22,
0x7C,0xFF,
0x93,0x48,
0x94,0x00,
0x95,0x05,
0x96,0xE8,
0x97,0x40,
0x98,0xF8,
0x9C,0x00,
0x9D,0x00,
0x9E,0x00,
0xB0,0x40,
0xB1,0x40,
0xB2,0x30,
0xB3,0x40,
0xB4,0x80,
0xB8,0x20,
0xBE,0x36,
0xBF,0x00,
0xD0,0xCB,
0xD1,0x10,
0xD3,0x5A,
0xD5,0xF2,
0xD6,0x16,
0xDB,0x92,
0xDC,0xA5,
0xDF,0x23,
0xD9,0x00,
0xDA,0x00,
0xE0,0x09,
0xEC,0x20,
0xED,0x04,
0xEE,0xA0,
0xEF,0x40,
0x9F,0x0E,
0xA0,0x1C,
0xA1,0x34,
0xA2,0x48,
0xA3,0x5A,
0xA4,0x6B,
0xA5,0x7B,
0xA6,0x95,
0xA7,0xAB,
0xA8,0xBF,
0xA9,0xCE,
0xAA,0xD9,
0xAB,0xE4,
0xAC,0xEC,
0xAD,0xF7,
0xAE,0xFD,
0xAF,0xFF,
0xC0,0x00,
0xC1,0x0B,
0xC2,0x15,
0xC3,0x27,
0xC4,0x39,
0xC5,0x49,
0xC6,0x5A,
0xC7,0x6A,
0xC8,0x89,
0xC9,0xA8,
0xCA,0xC6,
0xCB,0xE3,
0xCC,0xFF,
0xF0,0x02,
0xF1,0x01,
0xF2,0x00,
0xF3,0x30,
0xF7,0x04,
0xF8,0x02,
0xF9,0x9F,
0xFA,0x78,
0xFE,0x01,
0x00,0xF5,
0x02,0x1A,
0x0A,0xA0,
0x0B,0x60,
0x0C,0x08,
0x0E,0x4C,
0x0F,0x39,
0x11,0x3F,
0x12,0x72,
0x13,0x13,
0x14,0x42,
0x15,0x43,
0x16,0xC2,
0x17,0xA8,
0x18,0x18,
0x19,0x40,
0x1A,0xD0,
0x1B,0xF5,
0x70,0x40,
0x71,0x58,
0x72,0x30,
0x73,0x48,
0x74,0x20,
0x75,0x60,
0xFE,0x00,
0xD2,0x90,
0xFE,0x00,
0x22,0x55,
0x57,0x80,
0x58,0x78,
0x59,0x78,
0x5A,0x55,
0x5B,0x45,
0x5C,0x3A,
0xB0,0x50,
0xB1,0x40,
0xB2,0x46,
0xD3,0x6A,

-1,-1};

extern struct i2c_device *iic_test;

static void GC0309_rotate(uint32 r)
{
	unsigned char buf[2];
	buf[0] = 0x14;		//0',180'
	buf[1] = 0x10|(r<<0);
	//Sensor_WriteRegister(SENSOR_IIC,buf,1,1);
	//i2c_sensor_write(iic_test,buf,1,1,0x42,0x43);
	i2c_write(iic_test,(int8 *)buf,1,(int8 *)&buf[1],1);

}



uint32 GC0309_hvblank(int8 dh,int8 dv)
{
#define HBLANK_BASE	0xdeUL
#define VBLANK_BASE	0x24UL
		uint32 i;
		int32 h = (int32)HBLANK_BASE + dh; if(h < 0) h = 0;
		int32 v = (int32)VBLANK_BASE + dv; if(v < 0) v = 0;
		const uint8 t[][2] = {
			{0x01,h & 0xff},//0x6a//0xde //HB[7:0]
			{0x02,v & 0xff},  //0x0c //VB[7:0]
			{0x0f,((v >> 8)<<4)|(h >> 8)} //{0x0f,0x00}, //VB/HB [11:8]
		};
	//for(i=0;i<3;i++)
		//Sensor_WriteRegister(SENSOR_IIC,(u8 *)&t[i][0],1,1);
	for(i=0;i<3;i++)	
		i2c_write(iic_test,(int8 *)&t[i][0],1,(int8 *)&t[i][1],1);

	return (h<<16)|v;
}

SENSOR_OP_SECTION const _Sensor_Adpt_ gc0309_cmd= 
{
	.typ = 1, //YUV
	.pixelw = 640,
	.pixelh= 480,
	.hsyn = 1,
	.vsyn = 1,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)GC0309InitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = {0xde,0x24,0xde,0x24},
	. mclk = 24000000,
	.p_fun_adapt = {GC0309_rotate,GC0309_hvblank,NULL},
	.p_xc7016_adapt = {NULL},

};

const _Sensor_Ident_ gc0309_init=
{
	0xa0,0x42,0x43,0x01,0x01,0x00
};



#endif


