#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"


#if DEV_SENSOR_BF3A03


SENSOR_INIT_SECTION static const unsigned char bf3a03InitTable[CMOS_INIT_LEN]=
{
	0x12,0x80,
	0x09,0x78,//0x7d,//55
	0x15,0x32,
	0x1e,0x40,		// 0x40 is 0' , 0x70 is 180'
	0x06,0x78,
	0x21,0x00,//0x00
	0x3e,0x37,
	0x29,0x2b,
	0x27,0x98,
	0x16,0x2f,//0x25
	0x20,0x64,//0x00
	0xd2,0x18,
	0x11,0x1c,//0x10
	0x2f,0x4e,//0x4e
	0x1b,0x09,
	0x3a,0x00,
	0x4a,0x98,//0x98 //VB相关
	0x12,0x00,
	0x13,0x08,
	0x01,0x14,
	0x02,0x20,
	0x8c,0x02,
	0x8d,0x4c,
	0x87,0x16,
	0x13,0x07,
	0x35,0x46,
	0x65,0x38,
	0x66,0x42,
	0x70,0x0f,
	0x3b,0x00,
	0x71,0x0c,
	0x73,0x29,
	0x75,0x88,
	0x76,0xd8,
	0x77,0x0a,
	0x78,0xff,
	0x79,0x14,
	0x7a,0x24,
	0x9e,0x04,
	0x7d,0x2a,
	0x39,0xa0,
	0x3f,0xa0,
	0x90,0x20,
	0x5f,0x04,//0x00
	0x40,0x22,
	0x41,0x23,
	0x42,0x28,
	0x43,0x25,
	0x44,0x1d,
	0x45,0x17,
	0x46,0x13,
	0x47,0x12,
	0x48,0x10,
	0x49,0x0d,
	0x4b,0x0b,
	0x4c,0x0b,
	0x4e,0x09,
	0x4f,0x07,
	0x50,0x06,
	0x13,0x07,
	0x24,0x60, //50xz
	0x97,0x40,
	0x25,0x88,
	0x81,0xff, //00
	0x82,0x18,
	0x83,0x30,
	0x84,0x20,
	0x85,0x38,
	0x86,0x90, //88 xz
	0x94,0x62, //42 xz //82
	0x80,0x92,
	0x98,0x8a,
	0x89,0x35,
	0x8a,0x4c,//0x75,//93
	0x8b,0x40,//0x62,//7a
	0x8e,0x2c,
	0x8f,0x82,
	//0x2a,0x00,	//HBH
	//0x2b,0x00,//0x20//HBL hb = 0x100
	//0x92,0x09,//DM_LNL
	//0x93,0x00,//DM_LNH
	//0xe3,0x09,
	//0xe4,0x00,
	0x5a,0xec,
	0x51,0x90,
	0x52,0x10,
	0x53,0x8d,
	0x54,0x88,
	0x57,0x82,
	0x58,0x8d,
	0x5a,0x7c,
	0x51,0x80,
	0x52,0x04,
	0x53,0x8d,
	0x54,0x88,
	0x57,0x82,
	0x58,0x8d,
	0x5a,0x6c,
	0x51,0x90,
	0x52,0x0a,
	0x53,0x84,
	0x54,0x05,
	0x57,0x05,
	0x58,0x87,
	0xb0,0xa0,
	0xb1,0x26,
	0xb2,0x1c,
	0xb4,0xfd,
	0xb0,0x30,
	0xb1,0xb8,
	0xb2,0xa0,
	0xb4,0xf1,
	0x3c,0x40,
	0x56,0x48,
	0x4d,0x40,
	0x59,0x40,
	0xb4,0xf1,//e1
	0x56,0x40,
	0x6a,0x81,//81
	0x23,0x33,//33
	0xa2,0x04,
	0xa3,0x20,
	0xa4,0x08,
	0xa5,0x26,
	0xa7,0x18,
	0xa8,0x17,
	0xa9,0x14,
	0xaa,0x14,
	0xab,0x16,
	0xac,0x44,
	0xad,0xf0,
	0xae,0x57,
	0xc5,0x66,
	0xc7,0x38,
	0xc8,0x08,
	0xc9,0x16,
	0xd3,0x09,
	0xd4,0x15,
	0xd0,0x00,
	0x35,0x38,
	0x65,0x38,
	0x66,0x38,
	0x96,0xf5,
	0x9f,0xf4,
	0xd1,0x00,
	0xcc,0x77,
0xcd,0x7b,
0xce,0x82,
0xcf,0x98,
0xc3,0xa0,
-1,-1};

extern struct i2c_device *iic_test;

static void bf3a03_rotate(uint32 r)
{
	unsigned char buf[2];
	buf[0] = 0x1e;
	buf[1] = 0x40|(r<<4);
	//Sensor_WriteRegister(SENSOR_IIC,buf,1,1);
	//i2c_sensor_write(iic_test,buf,1,1,0xdc,0xdd);
	//i2c_write(iic_test,(int8 *)&t[i][0],1,(int8 *)&t[i][1],1);
	i2c_write(iic_test,(int8 *)buf,1,(int8 *)&buf[1],1);

}



uint32 bf3a03_hvblank(int8 dh,int8 dv)
{
#define HBLANK_BASE	0x100UL
#define VBLANK_BASE	0x09UL
		uint32 i;
		int32 h = (int32)HBLANK_BASE + dh; if(h < 0) h = 0;
		int32 v = (int32)VBLANK_BASE + dv; if(v < 0) v = 0;
		const uint8 t[][2] = {
			{0x2a,(h >> 8) << 4 },
			{0x2b,h & 0xff},
			{0x92,v & 0xff},
			{0x93,v >> 8},
			{0xe3,0x09},
			{0xe4,0},
		};

	for(i=0;i<6;i++)
		i2c_write(iic_test,(int8 *)&t[i][0],1,(int8 *)&t[i][1],1);

	return (h<<16)|v;
}

SENSOR_OP_SECTION const _Sensor_Adpt_ bf3a03_cmd= 
{
	.typ = 1, //YUV
	.pixelw = 640,
	.pixelh= 480,
	.hsyn = 1,
	.vsyn = 1,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)bf3a03InitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = {0xde,0x24,0xde,0x24},
	. mclk = 24000000,
	.p_fun_adapt = {bf3a03_rotate,bf3a03_hvblank,NULL},
	.p_xc7016_adapt = {NULL},

};

const _Sensor_Ident_ bf3a03_init=
{
	0x3a,0xdc,0xdd,0x01,0x01,0xfc,//bf3
};



#endif

