#include "sys_config.h"
#include "typesdef.h"
#include "lib/video/dvp/cmos_sensor/csi.h"
#include "tx_platform.h"
#include "list.h"
#include "dev.h"
#include "hal/i2c.h"



#if DEV_SENSOR_BF2013


SENSOR_INIT_SECTION static const unsigned char bf2013InitTable[CMOS_INIT_LEN]=
{
	0x12,0x00,
	0x09,0x01,
	0x15,0x02,
	0x3A,0x00,
	0x12,0x00,
	0x1E,0x00,
	0x13,0x00,
	0x01,0x14,
	0x02,0x21,
	0x8C,0x01,
	0x8D,0xCB,
	0x87,0x20,
	0x1B,0x80,
	0x11,0xE0,
	0x2B,0x20,
	0x92,0x40,
	0x06,0xE0,
	0x29,0x54,
	0xEB,0x30,
	0xBB,0x20,
	0xF5,0x21,
	0xE1,0x3C,
	0x16,0x01,
	0xE0,0x0B,
	0x2F,0xF6,
	0x1F,0x20,
	0x22,0x20,
	0x26,0x20,
	0x33,0x20,
	0x34,0x08,
	0x35,0x50,
	0x65,0x4A,
	0x66,0x48,
	0x36,0x05,
	0x37,0x7B,
	0x38,0x46,
	0x9B,0xF6,
	0x9C,0x46,
	0xBC,0x01,
	0xBD,0xF6,
	0xBE,0x46,
	0x70,0x6F,
	0x72,0x6B,
	0x73,0x2F,
	0x74,0x27,
	0x77,0x90,
	0x79,0x48,
	0x7A,0x1E,
	0x7B,0x30,
	0x24,0xA3,
	0x25,0xB3,
	0x55,0x18,
	0x80,0x7F,
	0x81,0x02,
	0x82,0x14,
	0x83,0x23,
	0x9A,0x23,
	0x84,0x1A,
	0x85,0x20,
	0x86,0x20,
	0x89,0x02,
	0x8A,0x64,
	0x8B,0x02,
	0x8E,0x02,
	0x8F,0xFD,
	0x94,0x0A,
	0x96,0xA6,
	0x97,0x0C,
	0x98,0x1A,
	0x9D,0x93,
	0x9E,0x7A,
	0x3B,0x60,
	0x3C,0x08,
	0x39,0x80,
	0x3F,0x7F,
	0x40,0x9B,
	0x41,0x88,
	0x42,0x6E,
	0x43,0x59,
	0x44,0x4D,
	0x45,0x45,
	0x46,0x3E,
	0x47,0x39,
	0x48,0x35,
	0x49,0x31,
	0x4B,0x2E,
	0x4C,0x2B,
	0x4E,0x26,
	0x4F,0x22,
	0x50,0x1F,
	0x51,0x0E,
	0x52,0x16,
	0x53,0x07,
	0x54,0x1A,
	0x57,0x9D,
	0x58,0x82,
	0x59,0x71,
	0x5A,0x8D,
	0x5B,0x1C,
	0x5C,0x0E,
	0x5D,0x95,
	0x60,0x24,
	0x6A,0x81,
	0x23,0x77,
	0xA0,0x03,
	0xA1,0x31,
	0xA2,0x05,
	0xA3,0x10,
	0xA4,0x20,
	0xA5,0x2C,
	0xA6,0x06,
	0xA7,0x80,
	0xA8,0x7E,
	0xA9,0x20,
	0xAA,0x20,
	0xAB,0x20,
	0xAC,0x3C,
	0xAD,0xF0,
	0xAE,0x80,
	0xAF,0x00,
	0xC5,0x18,
	0xC6,0x00,
	0xC7,0x20,
	0xC8,0x18,
	0xC9,0x20,
	0xCA,0x17,
	0xCB,0x1F,
	0xCC,0x40,
	0xCD,0x58,
	0xEE,0x4C,
	0xB0,0xE0,
	0xB1,0x90,
	0xB2,0x90,
	0xB3,0x88,
	0x56,0x64,
	0x13,0x07,

	-1,-1
			//switch direction
			//0x1e,0x30,//00:normal	10:IMAGE_V_MIRROR	 

};

extern struct i2c_device *iic_test;


static void bf2013_rotate(uint32 r)
{
	unsigned char buf[2];
	buf[0] = 0x1e;
	//buf[1] = Sensor_ReadRegister(buf,u8AddrLength,u8DataLength);
	//buf[1] &=~(3<<4);
	buf[1] = (r<<4)|0x00;
	//i2c_sensor_write(iic_test,buf,1,1,0x42,0x43);
	i2c_write(iic_test,(int8 *)buf,1,(int8 *)&buf[1],1);

}



uint32 bf2013_hvblank(int8 dh,int8 dv)
{
#define HBLANK_BASE	0x00UL
#define VBLANK_BASE	0x00UL
		uint32 i;
		int32 h = (int32)HBLANK_BASE + dh; if(h < 0) h = 0;
		int32 v = (int32)VBLANK_BASE + dv; if(v < 0) v = 0;
		const uint8 t[][2] = {
			{0x2a,(h >> 8) << 4 },
			{0x2b,h & 0xff},
			{0x92,v & 0xff},
			{0x93,v >> 8},
			{0xe3,0x00},
			{0xe4,0},
		};


	for(i=0;i<6;i++)
		i2c_write(iic_test,(int8 *)&t[i][0],1,(int8 *)&t[i][1],1);
		//i2c_sensor_write(iic_test,(uint8 *)&t[i][0],1,1,0x42,0x43);


	return (h<<16)|v;
}

SENSOR_OP_SECTION const _Sensor_Adpt_ bf2013_cmd= 
{
	.typ = 1, //YUV
	.pixelw = 640,
	.pixelh= 480,
	.hsyn = 1,
	.vsyn = 1,
	.rduline = 0,//
	.rawwide = 1,//10bit
	.colrarray = 2,//0:_RGRG_ 1:_GRGR_,2:_BGBG_,3:_GBGB_
	.init = (uint8 *)bf2013InitTable,
	.rotate_adapt = {0},
	//.hvb_adapt = {0xde,0x24,0xde,0x24},
	. mclk = 24000000,
	.p_fun_adapt = {bf2013_rotate,bf2013_hvblank,NULL},
	.p_xc7016_adapt = {NULL},

};

const _Sensor_Ident_ bf2013_init=
{
	0x37,0xdc,0xdd,0x01,0x01,0xfc,//bf3
};



#endif

