#include "sys_config.h"
#include "typesdef.h"
#include "list.h"
#include "dev.h"
#include "devid.h"
#include "string.h"
#include "osal/task.h"
#include "osal/string.h"
#include "sonic_process.h"
#include "magic_sound.h"

uint8_t delaySamples_table[500] = {
    0x20,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
    0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x24,0x24,0x24,
    0x24,0x24,0x24,0x24,0x24,0x24,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x26,0x26,0x26,0x26,0x26,0x26,
    0x26,0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x28,0x28,0x28,0x28,0x28,0x28,0x29,0x29,0x29,0x29,0x29,0x29,
    0x2a,0x2a,0x2a,0x2a,0x2a,0x2b,0x2b,0x2b,0x2b,0x2b,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2d,0x2d,0x2d,0x2d,
    0x2e,0x2e,0x2e,0x2e,0x2e,0x2f,0x2f,0x2f,0x2f,0x2f,0x30,0x30,0x30,0x30,0x31,0x31,0x31,0x31,0x31,0x32,
    0x32,0x32,0x32,0x33,0x33,0x33,0x33,0x34,0x34,0x34,0x34,0x35,0x35,0x35,0x35,0x36,0x36,0x36,0x36,0x37,
    0x37,0x37,0x37,0x38,0x38,0x38,0x38,0x39,0x39,0x39,0x39,0x3a,0x3a,0x3a,0x3a,0x3b,0x3b,0x3b,0x3c,0x3c,
    0x3c,0x3c,0x3d,0x3d,0x3d,0x3d,0x3e,0x3e,0x3e,0x3f,0x3f,0x3f,0x3f,0x40,0x40,0x40,0x41,0x41,0x41,0x41,
    0x42,0x42,0x42,0x43,0x43,0x43,0x43,0x44,0x44,0x44,0x45,0x45,0x45,0x45,0x46,0x46,0x46,0x47,0x47,0x47,
    0x48,0x48,0x48,0x48,0x49,0x49,0x49,0x4a,0x4a,0x4a,0x4a,0x4b,0x4b,0x4b,0x4c,0x4c,0x4c,0x4d,0x4d,0x4d,
    0x4d,0x4e,0x4e,0x4e,0x4f,0x4f,0x4f,0x50,0x50,0x50,0x51,0x51,0x51,0x51,0x52,0x52,0x52,0x53,0x53,0x53,
    0x54,0x54,0x54,0x54,0x55,0x55,0x55,0x56,0x56,0x56,0x57,0x57,0x57,0x57,0x58,0x58,0x58,0x59,0x59,0x59,
    0x59,0x5a,0x5a,0x5a,0x5b,0x5b,0x5b,0x5c,0x5c,0x5c,0x5c,0x5d,0x5d,0x5d,0x5e,0x5e,0x5e,0x5e,0x5f,0x5f,
    0x5f,0x60,0x60,0x60,0x60,0x61,0x61,0x61,0x62,0x62,0x62,0x62,0x63,0x63,0x63,0x64,0x64,0x64,0x64,0x65,
    0x65,0x65,0x65,0x66,0x66,0x66,0x67,0x67,0x67,0x67,0x68,0x68,0x68,0x68,0x69,0x69,0x69,0x69,0x6a,0x6a,
    0x6a,0x6a,0x6b,0x6b,0x6b,0x6b,0x6c,0x6c,0x6c,0x6c,0x6d,0x6d,0x6d,0x6d,0x6e,0x6e,0x6e,0x6e,0x6f,0x6f,
    0x6f,0x6f,0x70,0x70,0x70,0x70,0x70,0x71,0x71,0x71,0x71,0x72,0x72,0x72,0x72,0x72,0x73,0x73,0x73,0x73,
    0x73,0x74,0x74,0x74,0x74,0x75,0x75,0x75,0x75,0x75,0x75,0x76,0x76,0x76,0x76,0x76,0x77,0x77,0x77,0x77,
    0x77,0x78,0x78,0x78,0x78,0x78,0x78,0x79,0x79,0x79,0x79,0x79,0x79,0x7a,0x7a,0x7a,0x7a,0x7a,0x7a,0x7a,
    0x7b,0x7b,0x7b,0x7b,0x7b,0x7b,0x7b,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7d,0x7d,0x7d,0x7d,0x7d,
    0x7d,0x7d,0x7d,0x7d,0x7e,0x7e,0x7e,0x7e,0x7e,0x7e,0x7e,0x7e,0x7e,0x7e,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,
    0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80
};

#define SETW32TOW16(a)  (a>32767)?32767:(a<-32768)?-32768:a   

magicSound *magicSound_init(uint32_t samplerate, uint8_t channel, uint32_t size)
{
    magicSound *magic_sound = (magicSound*)custom_malloc(sizeof(magicSound));
    if(!magic_sound) {
        os_printf("%s %dmagicSound_init err\n",__FUNCTION__,__LINE__);
        return NULL;
    }
    magic_sound->sonic_s = sonicStream_init(samplerate,channel,1.0,1.0);
	os_printf("magic_sound->sonic_s:%x\n",magic_sound->sonic_s);
    if(!magic_sound->sonic_s) {
        os_printf("%s line:%d magicSound_init err\n",__FUNCTION__,__LINE__);
        custom_free(magic_sound);
        magic_sound = NULL;
        return NULL;        
    }
#ifdef PSRAM_HEAP   
    magic_sound->buf = (int16_t*)custom_zalloc_psram(size+320);
#else
    magic_sound->buf = (int16_t*)custom_zalloc(size+320);
#endif
    if(!magic_sound->buf) {
        os_printf("%s line:%d magicSound_init err\n",__FUNCTION__,__LINE__);
        sonicStream_deinit(magic_sound->sonic_s);
        magic_sound->sonic_s = NULL;
        custom_free(magic_sound);
        magic_sound = NULL;
        return NULL;                
    }
    magic_sound->samplerate = samplerate;
    magic_sound->channel = channel;
    magic_sound->new_type = original_sound;
    magic_sound->current_type = original_sound;
	return magic_sound;
}

void magicSound_set_type(magicSound *magic_sound, magicSound_type type)
{
    if(!magic_sound) {
        os_printf("magicSound_set_type err!\n");
        return;
    }
    magic_sound->new_type = type;
}

void magicSound_process(magicSound *magic_sound, int16_t *buf, uint32_t samples)
{
    static float pitch = 1.0f;
    static uint16_t table_index = 0;
    uint8_t delaySamples = 0;
    int16_t delay_data = 0;
    int16_t back_data = 0;
    int32_t temp32 = 0;
	
    if(!magic_sound)
        return;
    if(magic_sound->new_type != magic_sound->current_type) {
		os_printf("change magic sound type,current:%d new:%d\n",magic_sound->current_type,magic_sound->new_type);
        switch(magic_sound->new_type) {
            case 0: pitch = 1.0f; break;
            case 1: pitch = 1.3f; break;
            case 2: pitch = 0.9f; break;
            case 3: pitch = 1.5f; break;
            case 4: pitch = 0.7f; break;
            case 5: pitch = 1.2f; break; 
            default: break;
        }
		sonic_flush_stream(magic_sound->sonic_s);
		sonicStream_deinit(magic_sound->sonic_s);
		magic_sound->sonic_s = sonicStream_init(magic_sound->samplerate,magic_sound->channel,1.0,pitch);
		magic_sound->current_type = magic_sound->new_type;
    }
    os_memcpy(magic_sound->buf+160,buf,samples<<1);
    if(magic_sound->current_type == alien_sound) {
		
        for(uint32_t i=0; i<160; i++) {
            if(table_index < 500)
                delaySamples = delaySamples_table[table_index];
            else
                delaySamples = delaySamples_table[999-table_index];
            temp32 = (magic_sound->buf[(i + 160 - delaySamples)]+magic_sound->buf[(i + 160)])>>1;
            buf[i] = SETW32TOW16(temp32);
            table_index = (table_index+1)%1000;
        }
	
        os_memcpy(magic_sound->buf,magic_sound->buf+160,320);   
    }
    else if(magic_sound->current_type == robot_sound) {
		delaySamples = 80;
        for(uint32_t i=0; i<160; i++) {
			delay_data = magic_sound->buf[(i + 160 - delaySamples)];
			back_data = delay_data;
            temp32 = ((magic_sound->buf[160+i]>>1)+delay_data)>>1;
            buf[i] = SETW32TOW16(temp32);
            temp32 = ((magic_sound->buf[160+i]>>1)+(back_data<<2)/5);
			magic_sound->buf[160+i] = SETW32TOW16(temp32);
        }
        os_memcpy(magic_sound->buf,magic_sound->buf+160,320);        
    }

    sonicStream_input_data(magic_sound->sonic_s, buf, samples);
    sonicStream_output_data(magic_sound->sonic_s, buf, samples);
}        
