/*
 * Copyright (C) 2015-2017 Alibaba Group Holding Limited
 */

#ifndef K_API_H
#define K_API_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stddef.h>
#include <stdint.h>
#include <string.h>
#include <k_config.h>
#include <k_default_config.h>
#include <k_types.h>
#include <k_err.h>
#include <k_critical.h>
#include <k_sys.h>
#include <k_bitmap.h>
#include <k_list.h>
#include <k_obj.h>
#include <k_sched.h>
#include <k_task.h>
#include <k_ringbuf.h>
#include <k_queue.h>
#include <k_buf_queue.h>
#include <k_sem.h>
#include <k_task_sem.h>
#include <k_mutex.h>
#include <k_timer.h>
#include <k_time.h>
#include <k_event.h>
#include <k_stats.h>
#include <k_mm_debug.h>
#include <k_mm_blk.h>
#include <k_mm_region.h>
#include <k_mm.h>
#include <k_workqueue.h>
#include <k_internal.h>
#include <k_trace.h>
#include <k_soc.h>
#include <k_hook.h>
#include <port.h>
#include <k_endian.h>
#include <k_fifo.h>

#ifndef __at_section
#define __at_section(sec) __attribute__((section(sec)))
#endif

#ifndef __bobj
#define __bobj
#endif

#ifndef __init
#define __init
#endif

extern void assert_internal(const char *__function, unsigned int __line, const char *__assertion);

#ifdef __cplusplus
}
#endif

#endif /* K_API_H */

